<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_PreLoteEscaneo.xml */
/* Generado: 2021-06-26 00:00:03 */

/* Busqueda de registros de la tabla SR_PreLoteEscaneo. */
abstract class BaseSR_PreLoteEscaneoFN extends SR_PreLoteEscaneoBN
{
    /* Declaracion de constantes */
    const MovimientoDetalleId = "SR_PreLoteEscaneo.MovimientoDetalleId";
    const Secuencia = "SR_PreLoteEscaneo.Secuencia";
    const Lote = "SR_PreLoteEscaneo.Lote";
    const Cantidad = "SR_PreLoteEscaneo.Cantidad";
    const Fecha = "SR_PreLoteEscaneo.Fecha";
    const Comentario = "SR_PreLoteEscaneo.Comentario";
    const UsuarioRegistro = "SR_PreLoteEscaneo.UsuarioRegistro";
    const FechaRegistro = "SR_PreLoteEscaneo.FechaRegistro";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_PreLoteEscaneo.MovimientoDetalleId AS MovimientoDetalleId, ";
        $s_SQLQuery .= "SR_PreLoteEscaneo.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "SR_PreLoteEscaneo.Lote AS Lote, ";
        $s_SQLQuery .= "SR_PreLoteEscaneo.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "SR_PreLoteEscaneo.Fecha AS Fecha, ";
        $s_SQLQuery .= "SR_PreLoteEscaneo.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_PreLoteEscaneo.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_PreLoteEscaneo.FechaRegistro AS FechaRegistro ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_PreLoteEscaneoBN */
    public function setByBN( SR_PreLoteEscaneoBN $o_SR_PreLoteEscaneoBN )
    {
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getMovimientoDetalleId() ) )
        {
            $this->setMovimientoDetalleId( $o_SR_PreLoteEscaneoBN->getMovimientoDetalleId() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_SR_PreLoteEscaneoBN->getSecuencia() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getLote() ) )
        {
            $this->setLote( $o_SR_PreLoteEscaneoBN->getLote() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getCantidad() ) )
        {
            $this->setCantidad( $o_SR_PreLoteEscaneoBN->getCantidad() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getFecha() ) )
        {
            $this->setFecha( $o_SR_PreLoteEscaneoBN->getFecha() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_PreLoteEscaneoBN->getComentario() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_PreLoteEscaneoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_PreLoteEscaneoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_PreLoteEscaneoBN->getFechaRegistro() );
        }
    }

    /**
    * @return SR_PreLoteEscaneoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_MovimientoDetalleId, $i_Secuencia )
    {
        if( is_null( $i_MovimientoDetalleId ) ){ $i_MovimientoDetalleId = -1; } 
        if( is_null( $i_Secuencia ) ){ $i_Secuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_PreLoteEscaneo ";
        $s_SQLQuery .= "WHERE MovimientoDetalleId = ".$i_MovimientoDetalleId." ";
        $s_SQLQuery .= "AND Secuencia = ".$i_Secuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_PreLoteEscaneoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_PreLoteEscaneoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_PreLoteEscaneoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getMovimientoDetalleId() ) ) $s_SQLQuery .= "SR_PreLoteEscaneo.MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "SR_PreLoteEscaneo.Secuencia = ".$this->getSecuencia()." AND ";
        if ( !is_null( $this->getLote() ) ) $s_SQLQuery .= "SR_PreLoteEscaneo.Lote = '".$this->getLote()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "SR_PreLoteEscaneo.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getFecha() ) ) $s_SQLQuery .= "SR_PreLoteEscaneo.Fecha = '".$this->getFecha()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_PreLoteEscaneo.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_PreLoteEscaneo.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_PreLoteEscaneo.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_PreLoteEscaneo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_PreLoteEscaneoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_PreLoteEscaneo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_PreLoteEscaneoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_PreLoteEscaneoBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_PreLoteEscaneoBN[] = $o_SR_PreLoteEscaneoBN;
            }
        }
        return $a_SR_PreLoteEscaneoBN;
    }

    /* Devuelve un objeto SR_PreLoteEscaneoBN desde un objeto propel */
    public function insertObjectBN( $a_SR_PreLoteEscaneo )
    {
        $o_SR_PreLoteEscaneoBN = new SR_PreLoteEscaneoBN();
        if ( !is_null( $a_SR_PreLoteEscaneo['MovimientoDetalleId'] ) ) $o_SR_PreLoteEscaneoBN->setMovimientoDetalleId( ( integer ) $a_SR_PreLoteEscaneo['MovimientoDetalleId'] );
        if ( !is_null( $a_SR_PreLoteEscaneo['Secuencia'] ) ) $o_SR_PreLoteEscaneoBN->setSecuencia( ( integer ) $a_SR_PreLoteEscaneo['Secuencia'] );
        if ( !is_null( $a_SR_PreLoteEscaneo['Lote'] ) ) $o_SR_PreLoteEscaneoBN->setLote( $a_SR_PreLoteEscaneo['Lote'] );
        if ( !is_null( $a_SR_PreLoteEscaneo['Cantidad'] ) ) $o_SR_PreLoteEscaneoBN->setCantidad( ( float ) $a_SR_PreLoteEscaneo['Cantidad'] );
        if ( !is_null( $a_SR_PreLoteEscaneo['Fecha'] ) ) $o_SR_PreLoteEscaneoBN->setFecha( utilTimestamp::getTimestamp( $a_SR_PreLoteEscaneo['Fecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_PreLoteEscaneo['Comentario'] ) ) $o_SR_PreLoteEscaneoBN->setComentario( $a_SR_PreLoteEscaneo['Comentario'] );
        if ( !is_null( $a_SR_PreLoteEscaneo['UsuarioRegistro'] ) ) $o_SR_PreLoteEscaneoBN->setUsuarioRegistro( $a_SR_PreLoteEscaneo['UsuarioRegistro'] );
        if ( !is_null( $a_SR_PreLoteEscaneo['FechaRegistro'] ) ) $o_SR_PreLoteEscaneoBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_PreLoteEscaneo['FechaRegistro'], "Y-m-d H:i:s" ) );
        return $o_SR_PreLoteEscaneoBN;
    }
}
?>