<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_MovimientoDetalle.xml */
/* Generado: 2021-06-26 00:00:03 */

/* Busqueda de registros de la tabla SR_MovimientoDetalle. */
abstract class BaseSR_MovimientoDetalleFN extends SR_MovimientoDetalleBN
{
    /* Declaracion de constantes */
    const MovimientoDetalleId = "SR_MovimientoDetalle.MovimientoDetalleId";
    const MovimientoId = "SR_MovimientoDetalle.MovimientoId";
    const ProductoId = "SR_MovimientoDetalle.ProductoId";
    const IdLote = "SR_MovimientoDetalle.IdLote";
    const Cantidad = "SR_MovimientoDetalle.Cantidad";
    const CantidadEscaneada = "SR_MovimientoDetalle.CantidadEscaneada";
    const InicioEscaneo = "SR_MovimientoDetalle.InicioEscaneo";
    const FinEscaneo = "SR_MovimientoDetalle.FinEscaneo";
    const PorSerie = "SR_MovimientoDetalle.PorSerie";
    const UsuarioRegistro = "SR_MovimientoDetalle.UsuarioRegistro";
    const FechaRegistro = "SR_MovimientoDetalle.FechaRegistro";
    const UsuarioActualizacion = "SR_MovimientoDetalle.UsuarioActualizacion";
    const FechaActualizacion = "SR_MovimientoDetalle.FechaActualizacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_MovimientoDetalle.MovimientoDetalleId AS MovimientoDetalleId, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.MovimientoId AS MovimientoId, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.ProductoId AS ProductoId, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.IdLote AS IdLote, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.CantidadEscaneada AS CantidadEscaneada, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.InicioEscaneo AS InicioEscaneo, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.FinEscaneo AS FinEscaneo, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.PorSerie AS PorSerie, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.UsuarioActualizacion AS UsuarioActualizacion, ";
        $s_SQLQuery .= "SR_MovimientoDetalle.FechaActualizacion AS FechaActualizacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_MovimientoDetalleBN */
    public function setByBN( SR_MovimientoDetalleBN $o_SR_MovimientoDetalleBN )
    {
        if ( !is_null( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() ) )
        {
            $this->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_MovimientoDetalleBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_MovimientoDetalleBN->getProductoId() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getIdLote() ) )
        {
            $this->setIdLote( $o_SR_MovimientoDetalleBN->getIdLote() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getCantidad() ) )
        {
            $this->setCantidad( $o_SR_MovimientoDetalleBN->getCantidad() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getCantidadEscaneada() ) )
        {
            $this->setCantidadEscaneada( $o_SR_MovimientoDetalleBN->getCantidadEscaneada() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getInicioEscaneo() ) )
        {
            $this->setInicioEscaneo( $o_SR_MovimientoDetalleBN->getInicioEscaneo() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getFinEscaneo() ) )
        {
            $this->setFinEscaneo( $o_SR_MovimientoDetalleBN->getFinEscaneo() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getPorSerie() ) )
        {
            $this->setPorSerie( $o_SR_MovimientoDetalleBN->getPorSerie() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_MovimientoDetalleBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_MovimientoDetalleBN->getFechaRegistro() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getUsuarioActualizacion() ) )
        {
            $this->setUsuarioActualizacion( $o_SR_MovimientoDetalleBN->getUsuarioActualizacion() );
        }
        if ( !is_null( $o_SR_MovimientoDetalleBN->getFechaActualizacion() ) )
        {
            $this->setFechaActualizacion( $o_SR_MovimientoDetalleBN->getFechaActualizacion() );
        }
    }

    /**
    * @return SR_MovimientoDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_MovimientoDetalleId )
    {
        if( is_null( $i_MovimientoDetalleId ) ){ $i_MovimientoDetalleId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_MovimientoDetalle ";
        $s_SQLQuery .= "WHERE MovimientoDetalleId = ".$i_MovimientoDetalleId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_MovimientoDetalleBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_MovimientoDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_MovimientoDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getMovimientoDetalleId() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND ";
        if ( !is_null( $this->getMovimientoId() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.MovimientoId = ".$this->getMovimientoId()." AND ";
        if ( !is_null( $this->getProductoId() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.ProductoId = '".$this->getProductoId()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getCantidadEscaneada() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.CantidadEscaneada = ".$this->getCantidadEscaneada()." AND ";
        if ( !is_null( $this->getInicioEscaneo() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.InicioEscaneo = '".$this->getInicioEscaneo()."' AND ";
        if ( !is_null( $this->getFinEscaneo() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.FinEscaneo = '".$this->getFinEscaneo()."' AND ";
        if ( !is_null( $this->getPorSerie() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.PorSerie = '".$this->getPorSerie()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioActualizacion() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.UsuarioActualizacion = '".$this->getUsuarioActualizacion()."' AND ";
        if ( !is_null( $this->getFechaActualizacion() ) ) $s_SQLQuery .= "SR_MovimientoDetalle.FechaActualizacion = '".$this->getFechaActualizacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_MovimientoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_MovimientoDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_MovimientoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_MovimientoDetalleBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_MovimientoDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_MovimientoDetalleBN[] = $o_SR_MovimientoDetalleBN;
            }
        }
        return $a_SR_MovimientoDetalleBN;
    }

    /* Devuelve un objeto SR_MovimientoDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_SR_MovimientoDetalle )
    {
        $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
        if ( !is_null( $a_SR_MovimientoDetalle['MovimientoDetalleId'] ) ) $o_SR_MovimientoDetalleBN->setMovimientoDetalleId( ( integer ) $a_SR_MovimientoDetalle['MovimientoDetalleId'] );
        if ( !is_null( $a_SR_MovimientoDetalle['MovimientoId'] ) ) $o_SR_MovimientoDetalleBN->setMovimientoId( ( integer ) $a_SR_MovimientoDetalle['MovimientoId'] );
        if ( !is_null( $a_SR_MovimientoDetalle['ProductoId'] ) ) $o_SR_MovimientoDetalleBN->setProductoId( $a_SR_MovimientoDetalle['ProductoId'] );
        if ( !is_null( $a_SR_MovimientoDetalle['IdLote'] ) ) $o_SR_MovimientoDetalleBN->setIdLote( $a_SR_MovimientoDetalle['IdLote'] );
        if ( !is_null( $a_SR_MovimientoDetalle['Cantidad'] ) ) $o_SR_MovimientoDetalleBN->setCantidad( ( integer ) $a_SR_MovimientoDetalle['Cantidad'] );
        if ( !is_null( $a_SR_MovimientoDetalle['CantidadEscaneada'] ) ) $o_SR_MovimientoDetalleBN->setCantidadEscaneada( ( integer ) $a_SR_MovimientoDetalle['CantidadEscaneada'] );
        if ( !is_null( $a_SR_MovimientoDetalle['InicioEscaneo'] ) ) $o_SR_MovimientoDetalleBN->setInicioEscaneo( utilTimestamp::getTimestamp( $a_SR_MovimientoDetalle['InicioEscaneo'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_MovimientoDetalle['FinEscaneo'] ) ) $o_SR_MovimientoDetalleBN->setFinEscaneo( utilTimestamp::getTimestamp( $a_SR_MovimientoDetalle['FinEscaneo'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_MovimientoDetalle['PorSerie'] ) ) $o_SR_MovimientoDetalleBN->setPorSerie( $a_SR_MovimientoDetalle['PorSerie'] );
        if ( !is_null( $a_SR_MovimientoDetalle['UsuarioRegistro'] ) ) $o_SR_MovimientoDetalleBN->setUsuarioRegistro( $a_SR_MovimientoDetalle['UsuarioRegistro'] );
        if ( !is_null( $a_SR_MovimientoDetalle['FechaRegistro'] ) ) $o_SR_MovimientoDetalleBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_MovimientoDetalle['FechaRegistro'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_MovimientoDetalle['UsuarioActualizacion'] ) ) $o_SR_MovimientoDetalleBN->setUsuarioActualizacion( $a_SR_MovimientoDetalle['UsuarioActualizacion'] );
        if ( !is_null( $a_SR_MovimientoDetalle['FechaActualizacion'] ) ) $o_SR_MovimientoDetalleBN->setFechaActualizacion( utilTimestamp::getTimestamp( $a_SR_MovimientoDetalle['FechaActualizacion'], "Y-m-d H:i:s" ) );
        return $o_SR_MovimientoDetalleBN;
    }
}
?>