<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_LoteEscaneo.xml */
/* Generado: 2021-06-26 00:00:03 */

/* Busqueda de registros de la tabla SR_LoteEscaneo. */
abstract class BaseSR_LoteEscaneoFN extends SR_LoteEscaneoBN
{
    /* Declaracion de constantes */
    const MovimientoDetalleId = "SR_LoteEscaneo.MovimientoDetalleId";
    const Secuencia = "SR_LoteEscaneo.Secuencia";
    const Lote = "SR_LoteEscaneo.Lote";
    const Cantidad = "SR_LoteEscaneo.Cantidad";
    const Fecha = "SR_LoteEscaneo.Fecha";
    const Comentario = "SR_LoteEscaneo.Comentario";
    const UsuarioRegistro = "SR_LoteEscaneo.UsuarioRegistro";
    const FechaRegistro = "SR_LoteEscaneo.FechaRegistro";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_LoteEscaneo.MovimientoDetalleId AS MovimientoDetalleId, ";
        $s_SQLQuery .= "SR_LoteEscaneo.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "SR_LoteEscaneo.Lote AS Lote, ";
        $s_SQLQuery .= "SR_LoteEscaneo.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "SR_LoteEscaneo.Fecha AS Fecha, ";
        $s_SQLQuery .= "SR_LoteEscaneo.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_LoteEscaneo.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_LoteEscaneo.FechaRegistro AS FechaRegistro ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_LoteEscaneoBN */
    public function setByBN( SR_LoteEscaneoBN $o_SR_LoteEscaneoBN )
    {
        if ( !is_null( $o_SR_LoteEscaneoBN->getMovimientoDetalleId() ) )
        {
            $this->setMovimientoDetalleId( $o_SR_LoteEscaneoBN->getMovimientoDetalleId() );
        }
        if ( !is_null( $o_SR_LoteEscaneoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_SR_LoteEscaneoBN->getSecuencia() );
        }
        if ( !is_null( $o_SR_LoteEscaneoBN->getLote() ) )
        {
            $this->setLote( $o_SR_LoteEscaneoBN->getLote() );
        }
        if ( !is_null( $o_SR_LoteEscaneoBN->getCantidad() ) )
        {
            $this->setCantidad( $o_SR_LoteEscaneoBN->getCantidad() );
        }
        if ( !is_null( $o_SR_LoteEscaneoBN->getFecha() ) )
        {
            $this->setFecha( $o_SR_LoteEscaneoBN->getFecha() );
        }
        if ( !is_null( $o_SR_LoteEscaneoBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_LoteEscaneoBN->getComentario() );
        }
        if ( !is_null( $o_SR_LoteEscaneoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_LoteEscaneoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_LoteEscaneoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_LoteEscaneoBN->getFechaRegistro() );
        }
    }

    /**
    * @return SR_LoteEscaneoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_MovimientoDetalleId, $i_Secuencia )
    {
        if( is_null( $i_MovimientoDetalleId ) ){ $i_MovimientoDetalleId = -1; } 
        if( is_null( $i_Secuencia ) ){ $i_Secuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_LoteEscaneo ";
        $s_SQLQuery .= "WHERE MovimientoDetalleId = ".$i_MovimientoDetalleId." ";
        $s_SQLQuery .= "AND Secuencia = ".$i_Secuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_LoteEscaneoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_LoteEscaneoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_LoteEscaneoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getMovimientoDetalleId() ) ) $s_SQLQuery .= "SR_LoteEscaneo.MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "SR_LoteEscaneo.Secuencia = ".$this->getSecuencia()." AND ";
        if ( !is_null( $this->getLote() ) ) $s_SQLQuery .= "SR_LoteEscaneo.Lote = '".$this->getLote()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "SR_LoteEscaneo.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getFecha() ) ) $s_SQLQuery .= "SR_LoteEscaneo.Fecha = '".$this->getFecha()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_LoteEscaneo.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_LoteEscaneo.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_LoteEscaneo.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_LoteEscaneo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_LoteEscaneoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_LoteEscaneo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_LoteEscaneoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_LoteEscaneoBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_LoteEscaneoBN[] = $o_SR_LoteEscaneoBN;
            }
        }
        return $a_SR_LoteEscaneoBN;
    }

    /* Devuelve un objeto SR_LoteEscaneoBN desde un objeto propel */
    public function insertObjectBN( $a_SR_LoteEscaneo )
    {
        $o_SR_LoteEscaneoBN = new SR_LoteEscaneoBN();
        if ( !is_null( $a_SR_LoteEscaneo['MovimientoDetalleId'] ) ) $o_SR_LoteEscaneoBN->setMovimientoDetalleId( ( integer ) $a_SR_LoteEscaneo['MovimientoDetalleId'] );
        if ( !is_null( $a_SR_LoteEscaneo['Secuencia'] ) ) $o_SR_LoteEscaneoBN->setSecuencia( ( integer ) $a_SR_LoteEscaneo['Secuencia'] );
        if ( !is_null( $a_SR_LoteEscaneo['Lote'] ) ) $o_SR_LoteEscaneoBN->setLote( $a_SR_LoteEscaneo['Lote'] );
        if ( !is_null( $a_SR_LoteEscaneo['Cantidad'] ) ) $o_SR_LoteEscaneoBN->setCantidad( ( float ) $a_SR_LoteEscaneo['Cantidad'] );
        if ( !is_null( $a_SR_LoteEscaneo['Fecha'] ) ) $o_SR_LoteEscaneoBN->setFecha( utilTimestamp::getTimestamp( $a_SR_LoteEscaneo['Fecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_LoteEscaneo['Comentario'] ) ) $o_SR_LoteEscaneoBN->setComentario( $a_SR_LoteEscaneo['Comentario'] );
        if ( !is_null( $a_SR_LoteEscaneo['UsuarioRegistro'] ) ) $o_SR_LoteEscaneoBN->setUsuarioRegistro( $a_SR_LoteEscaneo['UsuarioRegistro'] );
        if ( !is_null( $a_SR_LoteEscaneo['FechaRegistro'] ) ) $o_SR_LoteEscaneoBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_LoteEscaneo['FechaRegistro'], "Y-m-d H:i:s" ) );
        return $o_SR_LoteEscaneoBN;
    }
}
?>