<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_GuiaRemisionH.xml */
/* Generado: 2021-10-07 16:57:38 */

/* Busqueda de registros de la tabla SR_GuiaRemisionH. */
abstract class BaseSR_GuiaRemisionHFN extends SR_GuiaRemisionHBN
{
    /* Declaracion de constantes */
    const GuiaRemisionId = "SR_GuiaRemisionH.GuiaRemisionId";
    const IdCompania = "SR_GuiaRemisionH.IdCompania";
    const IdSucursal = "SR_GuiaRemisionH.IdSucursal";
    const TipoGuia = "SR_GuiaRemisionH.TipoGuia";
    const GuiaSerie = "SR_GuiaRemisionH.GuiaSerie";
    const GuiaNumero = "SR_GuiaRemisionH.GuiaNumero";
    const GuiaFecha = "SR_GuiaRemisionH.GuiaFecha";
    const FechaIniTraslado = "SR_GuiaRemisionH.FechaIniTraslado";
    const IdProyecto = "SR_GuiaRemisionH.IdProyecto";
    const OrdenTipoComercialId = "SR_GuiaRemisionH.OrdenTipoComercialId";
    const ReferenciaParentId = "SR_GuiaRemisionH.ReferenciaParentId";
    const ReferenciaParentNum = "SR_GuiaRemisionH.ReferenciaParentNum";
    const ReferenciaIdTipoDocumento = "SR_GuiaRemisionH.ReferenciaIdTipoDocumento";
    const ReferenciaTipo = "SR_GuiaRemisionH.ReferenciaTipo";
    const ReferenciaNumero = "SR_GuiaRemisionH.ReferenciaNumero";
    const ReferenciaNumeroDocumento = "SR_GuiaRemisionH.ReferenciaNumeroDocumento";
    const MovimientoId = "SR_GuiaRemisionH.MovimientoId";
    const MovimientoDetId = "SR_GuiaRemisionH.MovimientoDetId";
    const FechaInicioAlq = "SR_GuiaRemisionH.FechaInicioAlq";
    const FechaFinAlq = "SR_GuiaRemisionH.FechaFinAlq";
    const EmpresaTipoDoc = "SR_GuiaRemisionH.EmpresaTipoDoc";
    const EmpresaNumDoc = "SR_GuiaRemisionH.EmpresaNumDoc";
    const EmpresaInfoAdicional = "SR_GuiaRemisionH.EmpresaInfoAdicional";
    const EmpresaDireccion = "SR_GuiaRemisionH.EmpresaDireccion";
    const ClienteNombre = "SR_GuiaRemisionH.ClienteNombre";
    const ClienteTipoDocumento = "SR_GuiaRemisionH.ClienteTipoDocumento";
    const ClienteNumDocumento = "SR_GuiaRemisionH.ClienteNumDocumento";
    const DepartamentoOrigen = "SR_GuiaRemisionH.DepartamentoOrigen";
    const ProvinciaOrigen = "SR_GuiaRemisionH.ProvinciaOrigen";
    const DistritoOrigen = "SR_GuiaRemisionH.DistritoOrigen";
    const DireccionOrigen = "SR_GuiaRemisionH.DireccionOrigen";
    const DepartamentoDestino = "SR_GuiaRemisionH.DepartamentoDestino";
    const ProvinciaDestino = "SR_GuiaRemisionH.ProvinciaDestino";
    const DistritoDestino = "SR_GuiaRemisionH.DistritoDestino";
    const DireccionDestino = "SR_GuiaRemisionH.DireccionDestino";
    const IdVehiculo = "SR_GuiaRemisionH.IdVehiculo";
    const IdChofer = "SR_GuiaRemisionH.IdChofer";
    const MotivoTrasladoId = "SR_GuiaRemisionH.MotivoTrasladoId";
    const Comentario = "SR_GuiaRemisionH.Comentario";
    const IdTipoDocumento = "SR_GuiaRemisionH.IdTipoDocumento";
    const IdNumeroDocumento = "SR_GuiaRemisionH.IdNumeroDocumento";
    const IdTransaccion = "SR_GuiaRemisionH.IdTransaccion";
    const MensajeException = "SR_GuiaRemisionH.MensajeException";
    const Estado = "SR_GuiaRemisionH.Estado";
    const EstadoDevolucion = "SR_GuiaRemisionH.EstadoDevolucion";
    const EstadoSunat = "SR_GuiaRemisionH.EstadoSunat";
    const TipoDeComprobante = "SR_GuiaRemisionH.TipoDeComprobante";
    const Enlace = "SR_GuiaRemisionH.Enlace";
    const AceptadaPorSunat = "SR_GuiaRemisionH.AceptadaPorSunat";
    const SunatDescription = "SR_GuiaRemisionH.SunatDescription";
    const SunatNote = "SR_GuiaRemisionH.SunatNote";
    const SunatResponsecode = "SR_GuiaRemisionH.SunatResponsecode";
    const SunatSoapError = "SR_GuiaRemisionH.SunatSoapError";
    const PdfZipBase64 = "SR_GuiaRemisionH.PdfZipBase64";
    const XmlZipBase64 = "SR_GuiaRemisionH.XmlZipBase64";
    const CdrZipBase64 = "SR_GuiaRemisionH.CdrZipBase64";
    const EnlaceDelPdf = "SR_GuiaRemisionH.EnlaceDelPdf";
    const EnlaceDelXml = "SR_GuiaRemisionH.EnlaceDelXml";
    const EnlaceDelCdr = "SR_GuiaRemisionH.EnlaceDelCdr";
    const ErrorsResponse = "SR_GuiaRemisionH.ErrorsResponse";
    const ErrorsCodigo = "SR_GuiaRemisionH.ErrorsCodigo";
    const FechaRegistro = "SR_GuiaRemisionH.FechaRegistro";
    const UsuarioRegistro = "SR_GuiaRemisionH.UsuarioRegistro";
    const FechaModificacion = "SR_GuiaRemisionH.FechaModificacion";
    const UsuarioModificacion = "SR_GuiaRemisionH.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_GuiaRemisionH.GuiaRemisionId AS GuiaRemisionId, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.TipoGuia AS TipoGuia, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.GuiaSerie AS GuiaSerie, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.GuiaNumero AS GuiaNumero, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.GuiaFecha AS GuiaFecha, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.FechaIniTraslado AS FechaIniTraslado, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.OrdenTipoComercialId AS OrdenTipoComercialId, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaParentId AS ReferenciaParentId, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaParentNum AS ReferenciaParentNum, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaIdTipoDocumento AS ReferenciaIdTipoDocumento, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaTipo AS ReferenciaTipo, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaNumero AS ReferenciaNumero, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaNumeroDocumento AS ReferenciaNumeroDocumento, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.MovimientoId AS MovimientoId, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.MovimientoDetId AS MovimientoDetId, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.FechaInicioAlq AS FechaInicioAlq, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.FechaFinAlq AS FechaFinAlq, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EmpresaTipoDoc AS EmpresaTipoDoc, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EmpresaNumDoc AS EmpresaNumDoc, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EmpresaInfoAdicional AS EmpresaInfoAdicional, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EmpresaDireccion AS EmpresaDireccion, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ClienteNombre AS ClienteNombre, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ClienteTipoDocumento AS ClienteTipoDocumento, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ClienteNumDocumento AS ClienteNumDocumento, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.DepartamentoOrigen AS DepartamentoOrigen, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ProvinciaOrigen AS ProvinciaOrigen, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.DistritoOrigen AS DistritoOrigen, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.DireccionOrigen AS DireccionOrigen, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.DepartamentoDestino AS DepartamentoDestino, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ProvinciaDestino AS ProvinciaDestino, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.DistritoDestino AS DistritoDestino, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.DireccionDestino AS DireccionDestino, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.IdVehiculo AS IdVehiculo, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.IdChofer AS IdChofer, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.MotivoTrasladoId AS MotivoTrasladoId, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.IdTransaccion AS IdTransaccion, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.MensajeException AS MensajeException, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.Estado AS Estado, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EstadoDevolucion AS EstadoDevolucion, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EstadoSunat AS EstadoSunat, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.TipoDeComprobante AS TipoDeComprobante, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.Enlace AS Enlace, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.AceptadaPorSunat AS AceptadaPorSunat, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.SunatDescription AS SunatDescription, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.SunatNote AS SunatNote, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.SunatResponsecode AS SunatResponsecode, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.SunatSoapError AS SunatSoapError, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.PdfZipBase64 AS PdfZipBase64, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.XmlZipBase64 AS XmlZipBase64, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.CdrZipBase64 AS CdrZipBase64, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EnlaceDelPdf AS EnlaceDelPdf, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EnlaceDelXml AS EnlaceDelXml, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.EnlaceDelCdr AS EnlaceDelCdr, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ErrorsResponse AS ErrorsResponse, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.ErrorsCodigo AS ErrorsCodigo, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SR_GuiaRemisionH.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_GuiaRemisionHBN */
    public function setByBN( SR_GuiaRemisionHBN $o_SR_GuiaRemisionHBN )
    {
        if ( !is_null( $o_SR_GuiaRemisionHBN->getGuiaRemisionId() ) )
        {
            $this->setGuiaRemisionId( $o_SR_GuiaRemisionHBN->getGuiaRemisionId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SR_GuiaRemisionHBN->getIdCompania() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SR_GuiaRemisionHBN->getIdSucursal() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getTipoGuia() ) )
        {
            $this->setTipoGuia( $o_SR_GuiaRemisionHBN->getTipoGuia() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getGuiaSerie() ) )
        {
            $this->setGuiaSerie( $o_SR_GuiaRemisionHBN->getGuiaSerie() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getGuiaNumero() ) )
        {
            $this->setGuiaNumero( $o_SR_GuiaRemisionHBN->getGuiaNumero() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getGuiaFecha() ) )
        {
            $this->setGuiaFecha( $o_SR_GuiaRemisionHBN->getGuiaFecha() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaIniTraslado() ) )
        {
            $this->setFechaIniTraslado( $o_SR_GuiaRemisionHBN->getFechaIniTraslado() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_SR_GuiaRemisionHBN->getIdProyecto() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getOrdenTipoComercialId() ) )
        {
            $this->setOrdenTipoComercialId( $o_SR_GuiaRemisionHBN->getOrdenTipoComercialId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaParentId() ) )
        {
            $this->setReferenciaParentId( $o_SR_GuiaRemisionHBN->getReferenciaParentId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaParentNum() ) )
        {
            $this->setReferenciaParentNum( $o_SR_GuiaRemisionHBN->getReferenciaParentNum() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaIdTipoDocumento() ) )
        {
            $this->setReferenciaIdTipoDocumento( $o_SR_GuiaRemisionHBN->getReferenciaIdTipoDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_GuiaRemisionHBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_GuiaRemisionHBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getReferenciaNumeroDocumento() ) )
        {
            $this->setReferenciaNumeroDocumento( $o_SR_GuiaRemisionHBN->getReferenciaNumeroDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_GuiaRemisionHBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getMovimientoDetId() ) )
        {
            $this->setMovimientoDetId( $o_SR_GuiaRemisionHBN->getMovimientoDetId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaInicioAlq() ) )
        {
            $this->setFechaInicioAlq( $o_SR_GuiaRemisionHBN->getFechaInicioAlq() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaFinAlq() ) )
        {
            $this->setFechaFinAlq( $o_SR_GuiaRemisionHBN->getFechaFinAlq() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEmpresaTipoDoc() ) )
        {
            $this->setEmpresaTipoDoc( $o_SR_GuiaRemisionHBN->getEmpresaTipoDoc() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEmpresaNumDoc() ) )
        {
            $this->setEmpresaNumDoc( $o_SR_GuiaRemisionHBN->getEmpresaNumDoc() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEmpresaInfoAdicional() ) )
        {
            $this->setEmpresaInfoAdicional( $o_SR_GuiaRemisionHBN->getEmpresaInfoAdicional() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEmpresaDireccion() ) )
        {
            $this->setEmpresaDireccion( $o_SR_GuiaRemisionHBN->getEmpresaDireccion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getClienteNombre() ) )
        {
            $this->setClienteNombre( $o_SR_GuiaRemisionHBN->getClienteNombre() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getClienteTipoDocumento() ) )
        {
            $this->setClienteTipoDocumento( $o_SR_GuiaRemisionHBN->getClienteTipoDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getClienteNumDocumento() ) )
        {
            $this->setClienteNumDocumento( $o_SR_GuiaRemisionHBN->getClienteNumDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDepartamentoOrigen() ) )
        {
            $this->setDepartamentoOrigen( $o_SR_GuiaRemisionHBN->getDepartamentoOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getProvinciaOrigen() ) )
        {
            $this->setProvinciaOrigen( $o_SR_GuiaRemisionHBN->getProvinciaOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDistritoOrigen() ) )
        {
            $this->setDistritoOrigen( $o_SR_GuiaRemisionHBN->getDistritoOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDireccionOrigen() ) )
        {
            $this->setDireccionOrigen( $o_SR_GuiaRemisionHBN->getDireccionOrigen() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDepartamentoDestino() ) )
        {
            $this->setDepartamentoDestino( $o_SR_GuiaRemisionHBN->getDepartamentoDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getProvinciaDestino() ) )
        {
            $this->setProvinciaDestino( $o_SR_GuiaRemisionHBN->getProvinciaDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDistritoDestino() ) )
        {
            $this->setDistritoDestino( $o_SR_GuiaRemisionHBN->getDistritoDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getDireccionDestino() ) )
        {
            $this->setDireccionDestino( $o_SR_GuiaRemisionHBN->getDireccionDestino() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdVehiculo() ) )
        {
            $this->setIdVehiculo( $o_SR_GuiaRemisionHBN->getIdVehiculo() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdChofer() ) )
        {
            $this->setIdChofer( $o_SR_GuiaRemisionHBN->getIdChofer() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getMotivoTrasladoId() ) )
        {
            $this->setMotivoTrasladoId( $o_SR_GuiaRemisionHBN->getMotivoTrasladoId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_GuiaRemisionHBN->getComentario() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_SR_GuiaRemisionHBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_SR_GuiaRemisionHBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getIdTransaccion() ) )
        {
            $this->setIdTransaccion( $o_SR_GuiaRemisionHBN->getIdTransaccion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getMensajeException() ) )
        {
            $this->setMensajeException( $o_SR_GuiaRemisionHBN->getMensajeException() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEstado() ) )
        {
            $this->setEstado( $o_SR_GuiaRemisionHBN->getEstado() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEstadoDevolucion() ) )
        {
            $this->setEstadoDevolucion( $o_SR_GuiaRemisionHBN->getEstadoDevolucion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEstadoSunat() ) )
        {
            $this->setEstadoSunat( $o_SR_GuiaRemisionHBN->getEstadoSunat() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getTipoDeComprobante() ) )
        {
            $this->setTipoDeComprobante( $o_SR_GuiaRemisionHBN->getTipoDeComprobante() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEnlace() ) )
        {
            $this->setEnlace( $o_SR_GuiaRemisionHBN->getEnlace() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getAceptadaPorSunat() ) )
        {
            $this->setAceptadaPorSunat( $o_SR_GuiaRemisionHBN->getAceptadaPorSunat() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getSunatDescription() ) )
        {
            $this->setSunatDescription( $o_SR_GuiaRemisionHBN->getSunatDescription() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getSunatNote() ) )
        {
            $this->setSunatNote( $o_SR_GuiaRemisionHBN->getSunatNote() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getSunatResponsecode() ) )
        {
            $this->setSunatResponsecode( $o_SR_GuiaRemisionHBN->getSunatResponsecode() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getSunatSoapError() ) )
        {
            $this->setSunatSoapError( $o_SR_GuiaRemisionHBN->getSunatSoapError() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getPdfZipBase64() ) )
        {
            $this->setPdfZipBase64( $o_SR_GuiaRemisionHBN->getPdfZipBase64() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getXmlZipBase64() ) )
        {
            $this->setXmlZipBase64( $o_SR_GuiaRemisionHBN->getXmlZipBase64() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getCdrZipBase64() ) )
        {
            $this->setCdrZipBase64( $o_SR_GuiaRemisionHBN->getCdrZipBase64() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEnlaceDelPdf() ) )
        {
            $this->setEnlaceDelPdf( $o_SR_GuiaRemisionHBN->getEnlaceDelPdf() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEnlaceDelXml() ) )
        {
            $this->setEnlaceDelXml( $o_SR_GuiaRemisionHBN->getEnlaceDelXml() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getEnlaceDelCdr() ) )
        {
            $this->setEnlaceDelCdr( $o_SR_GuiaRemisionHBN->getEnlaceDelCdr() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getErrorsResponse() ) )
        {
            $this->setErrorsResponse( $o_SR_GuiaRemisionHBN->getErrorsResponse() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getErrorsCodigo() ) )
        {
            $this->setErrorsCodigo( $o_SR_GuiaRemisionHBN->getErrorsCodigo() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_GuiaRemisionHBN->getFechaRegistro() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_GuiaRemisionHBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_GuiaRemisionHBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionHBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_GuiaRemisionHBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SR_GuiaRemisionHBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_GuiaRemisionId )
    {
        if( is_null( $s_GuiaRemisionId ) ){ $s_GuiaRemisionId = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_GuiaRemisionH ";
        $s_SQLQuery .= "WHERE GuiaRemisionId = '".$s_GuiaRemisionId."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_GuiaRemisionHBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_GuiaRemisionHBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_GuiaRemisionHBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getGuiaRemisionId() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.GuiaRemisionId = '".$this->getGuiaRemisionId()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getTipoGuia() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.TipoGuia = '".$this->getTipoGuia()."' AND ";
        if ( !is_null( $this->getGuiaSerie() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.GuiaSerie = '".$this->getGuiaSerie()."' AND ";
        if ( !is_null( $this->getGuiaNumero() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.GuiaNumero = '".$this->getGuiaNumero()."' AND ";
        if ( !is_null( $this->getGuiaFecha() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.GuiaFecha = '".$this->getGuiaFecha()."' AND ";
        if ( !is_null( $this->getFechaIniTraslado() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.FechaIniTraslado = '".$this->getFechaIniTraslado()."' AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getOrdenTipoComercialId() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.OrdenTipoComercialId = ".$this->getOrdenTipoComercialId()." AND ";
        if ( !is_null( $this->getReferenciaParentId() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaParentId = ".$this->getReferenciaParentId()." AND ";
        if ( !is_null( $this->getReferenciaParentNum() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaParentNum = '".$this->getReferenciaParentNum()."' AND ";
        if ( !is_null( $this->getReferenciaIdTipoDocumento() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaIdTipoDocumento = '".$this->getReferenciaIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaTipo() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaTipo = '".$this->getReferenciaTipo()."' AND ";
        if ( !is_null( $this->getReferenciaNumero() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaNumero = '".$this->getReferenciaNumero()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroDocumento() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ReferenciaNumeroDocumento = '".$this->getReferenciaNumeroDocumento()."' AND ";
        if ( !is_null( $this->getMovimientoId() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.MovimientoId = ".$this->getMovimientoId()." AND ";
        if ( !is_null( $this->getMovimientoDetId() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.MovimientoDetId = ".$this->getMovimientoDetId()." AND ";
        if ( !is_null( $this->getFechaInicioAlq() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.FechaInicioAlq = '".$this->getFechaInicioAlq()."' AND ";
        if ( !is_null( $this->getFechaFinAlq() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.FechaFinAlq = '".$this->getFechaFinAlq()."' AND ";
        if ( !is_null( $this->getEmpresaTipoDoc() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EmpresaTipoDoc = '".$this->getEmpresaTipoDoc()."' AND ";
        if ( !is_null( $this->getEmpresaNumDoc() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EmpresaNumDoc = '".$this->getEmpresaNumDoc()."' AND ";
        if ( !is_null( $this->getEmpresaInfoAdicional() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EmpresaInfoAdicional = '".$this->getEmpresaInfoAdicional()."' AND ";
        if ( !is_null( $this->getEmpresaDireccion() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EmpresaDireccion = '".$this->getEmpresaDireccion()."' AND ";
        if ( !is_null( $this->getClienteNombre() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ClienteNombre = '".$this->getClienteNombre()."' AND ";
        if ( !is_null( $this->getClienteTipoDocumento() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ClienteTipoDocumento = '".$this->getClienteTipoDocumento()."' AND ";
        if ( !is_null( $this->getClienteNumDocumento() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ClienteNumDocumento = '".$this->getClienteNumDocumento()."' AND ";
        if ( !is_null( $this->getDepartamentoOrigen() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.DepartamentoOrigen = '".$this->getDepartamentoOrigen()."' AND ";
        if ( !is_null( $this->getProvinciaOrigen() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ProvinciaOrigen = '".$this->getProvinciaOrigen()."' AND ";
        if ( !is_null( $this->getDistritoOrigen() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.DistritoOrigen = '".$this->getDistritoOrigen()."' AND ";
        if ( !is_null( $this->getDireccionOrigen() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.DireccionOrigen = '".$this->getDireccionOrigen()."' AND ";
        if ( !is_null( $this->getDepartamentoDestino() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.DepartamentoDestino = '".$this->getDepartamentoDestino()."' AND ";
        if ( !is_null( $this->getProvinciaDestino() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ProvinciaDestino = '".$this->getProvinciaDestino()."' AND ";
        if ( !is_null( $this->getDistritoDestino() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.DistritoDestino = '".$this->getDistritoDestino()."' AND ";
        if ( !is_null( $this->getDireccionDestino() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.DireccionDestino = '".$this->getDireccionDestino()."' AND ";
        if ( !is_null( $this->getIdVehiculo() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.IdVehiculo = ".$this->getIdVehiculo()." AND ";
        if ( !is_null( $this->getIdChofer() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.IdChofer = ".$this->getIdChofer()." AND ";
        if ( !is_null( $this->getMotivoTrasladoId() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.MotivoTrasladoId = '".$this->getMotivoTrasladoId()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getIdTransaccion() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.IdTransaccion = '".$this->getIdTransaccion()."' AND ";
        if ( !is_null( $this->getMensajeException() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.MensajeException = '".$this->getMensajeException()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getEstadoDevolucion() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EstadoDevolucion = '".$this->getEstadoDevolucion()."' AND ";
        if ( !is_null( $this->getEstadoSunat() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EstadoSunat = '".$this->getEstadoSunat()."' AND ";
        if ( !is_null( $this->getTipoDeComprobante() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.TipoDeComprobante = ".$this->getTipoDeComprobante()." AND ";
        if ( !is_null( $this->getEnlace() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.Enlace = '".$this->getEnlace()."' AND ";
        if ( !is_null( $this->getAceptadaPorSunat() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.AceptadaPorSunat = '".$this->getAceptadaPorSunat()."' AND ";
        if ( !is_null( $this->getSunatDescription() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.SunatDescription = '".$this->getSunatDescription()."' AND ";
        if ( !is_null( $this->getSunatNote() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.SunatNote = '".$this->getSunatNote()."' AND ";
        if ( !is_null( $this->getSunatResponsecode() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.SunatResponsecode = '".$this->getSunatResponsecode()."' AND ";
        if ( !is_null( $this->getSunatSoapError() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.SunatSoapError = '".$this->getSunatSoapError()."' AND ";
        if ( !is_null( $this->getPdfZipBase64() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.PdfZipBase64 = '".$this->getPdfZipBase64()."' AND ";
        if ( !is_null( $this->getXmlZipBase64() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.XmlZipBase64 = '".$this->getXmlZipBase64()."' AND ";
        if ( !is_null( $this->getCdrZipBase64() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.CdrZipBase64 = '".$this->getCdrZipBase64()."' AND ";
        if ( !is_null( $this->getEnlaceDelPdf() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EnlaceDelPdf = '".$this->getEnlaceDelPdf()."' AND ";
        if ( !is_null( $this->getEnlaceDelXml() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EnlaceDelXml = '".$this->getEnlaceDelXml()."' AND ";
        if ( !is_null( $this->getEnlaceDelCdr() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.EnlaceDelCdr = '".$this->getEnlaceDelCdr()."' AND ";
        if ( !is_null( $this->getErrorsResponse() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ErrorsResponse = '".$this->getErrorsResponse()."' AND ";
        if ( !is_null( $this->getErrorsCodigo() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.ErrorsCodigo = '".$this->getErrorsCodigo()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SR_GuiaRemisionH.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_GuiaRemisionH WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_GuiaRemisionHBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_GuiaRemisionH WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_GuiaRemisionHBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_GuiaRemisionHBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_GuiaRemisionHBN[] = $o_SR_GuiaRemisionHBN;
            }
        }
        return $a_SR_GuiaRemisionHBN;
    }

    /* Devuelve un objeto SR_GuiaRemisionHBN desde un objeto propel */
    public function insertObjectBN( $a_SR_GuiaRemisionH )
    {
        $o_SR_GuiaRemisionHBN = new SR_GuiaRemisionHBN();
        if ( !is_null( $a_SR_GuiaRemisionH['GuiaRemisionId'] ) ) $o_SR_GuiaRemisionHBN->setGuiaRemisionId( $a_SR_GuiaRemisionH['GuiaRemisionId'] );
        if ( !is_null( $a_SR_GuiaRemisionH['IdCompania'] ) ) $o_SR_GuiaRemisionHBN->setIdCompania( ( integer ) $a_SR_GuiaRemisionH['IdCompania'] );
        if ( !is_null( $a_SR_GuiaRemisionH['IdSucursal'] ) ) $o_SR_GuiaRemisionHBN->setIdSucursal( ( integer ) $a_SR_GuiaRemisionH['IdSucursal'] );
        if ( !is_null( $a_SR_GuiaRemisionH['TipoGuia'] ) ) $o_SR_GuiaRemisionHBN->setTipoGuia( $a_SR_GuiaRemisionH['TipoGuia'] );
        if ( !is_null( $a_SR_GuiaRemisionH['GuiaSerie'] ) ) $o_SR_GuiaRemisionHBN->setGuiaSerie( $a_SR_GuiaRemisionH['GuiaSerie'] );
        if ( !is_null( $a_SR_GuiaRemisionH['GuiaNumero'] ) ) $o_SR_GuiaRemisionHBN->setGuiaNumero( $a_SR_GuiaRemisionH['GuiaNumero'] );
        if ( !is_null( $a_SR_GuiaRemisionH['GuiaFecha'] ) ) $o_SR_GuiaRemisionHBN->setGuiaFecha( utilTimestamp::getTimestamp( $a_SR_GuiaRemisionH['GuiaFecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_GuiaRemisionH['FechaIniTraslado'] ) ) $o_SR_GuiaRemisionHBN->setFechaIniTraslado( utilTimestamp::getTimestamp( $a_SR_GuiaRemisionH['FechaIniTraslado'], "Y-m-d" ) );
        if ( !is_null( $a_SR_GuiaRemisionH['IdProyecto'] ) ) $o_SR_GuiaRemisionHBN->setIdProyecto( ( integer ) $a_SR_GuiaRemisionH['IdProyecto'] );
        if ( !is_null( $a_SR_GuiaRemisionH['OrdenTipoComercialId'] ) ) $o_SR_GuiaRemisionHBN->setOrdenTipoComercialId( ( integer ) $a_SR_GuiaRemisionH['OrdenTipoComercialId'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ReferenciaParentId'] ) ) $o_SR_GuiaRemisionHBN->setReferenciaParentId( ( integer ) $a_SR_GuiaRemisionH['ReferenciaParentId'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ReferenciaParentNum'] ) ) $o_SR_GuiaRemisionHBN->setReferenciaParentNum( $a_SR_GuiaRemisionH['ReferenciaParentNum'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ReferenciaIdTipoDocumento'] ) ) $o_SR_GuiaRemisionHBN->setReferenciaIdTipoDocumento( $a_SR_GuiaRemisionH['ReferenciaIdTipoDocumento'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ReferenciaTipo'] ) ) $o_SR_GuiaRemisionHBN->setReferenciaTipo( $a_SR_GuiaRemisionH['ReferenciaTipo'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ReferenciaNumero'] ) ) $o_SR_GuiaRemisionHBN->setReferenciaNumero( $a_SR_GuiaRemisionH['ReferenciaNumero'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ReferenciaNumeroDocumento'] ) ) $o_SR_GuiaRemisionHBN->setReferenciaNumeroDocumento( $a_SR_GuiaRemisionH['ReferenciaNumeroDocumento'] );
        if ( !is_null( $a_SR_GuiaRemisionH['MovimientoId'] ) ) $o_SR_GuiaRemisionHBN->setMovimientoId( ( integer ) $a_SR_GuiaRemisionH['MovimientoId'] );
        if ( !is_null( $a_SR_GuiaRemisionH['MovimientoDetId'] ) ) $o_SR_GuiaRemisionHBN->setMovimientoDetId( ( integer ) $a_SR_GuiaRemisionH['MovimientoDetId'] );
        if ( !is_null( $a_SR_GuiaRemisionH['FechaInicioAlq'] ) ) $o_SR_GuiaRemisionHBN->setFechaInicioAlq( utilTimestamp::getTimestamp( $a_SR_GuiaRemisionH['FechaInicioAlq'], "Y-m-d" ) );
        if ( !is_null( $a_SR_GuiaRemisionH['FechaFinAlq'] ) ) $o_SR_GuiaRemisionHBN->setFechaFinAlq( utilTimestamp::getTimestamp( $a_SR_GuiaRemisionH['FechaFinAlq'], "Y-m-d" ) );
        if ( !is_null( $a_SR_GuiaRemisionH['EmpresaTipoDoc'] ) ) $o_SR_GuiaRemisionHBN->setEmpresaTipoDoc( $a_SR_GuiaRemisionH['EmpresaTipoDoc'] );
        if ( !is_null( $a_SR_GuiaRemisionH['EmpresaNumDoc'] ) ) $o_SR_GuiaRemisionHBN->setEmpresaNumDoc( $a_SR_GuiaRemisionH['EmpresaNumDoc'] );
        if ( !is_null( $a_SR_GuiaRemisionH['EmpresaInfoAdicional'] ) ) $o_SR_GuiaRemisionHBN->setEmpresaInfoAdicional( $a_SR_GuiaRemisionH['EmpresaInfoAdicional'] );
        if ( !is_null( $a_SR_GuiaRemisionH['EmpresaDireccion'] ) ) $o_SR_GuiaRemisionHBN->setEmpresaDireccion( $a_SR_GuiaRemisionH['EmpresaDireccion'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ClienteNombre'] ) ) $o_SR_GuiaRemisionHBN->setClienteNombre( $a_SR_GuiaRemisionH['ClienteNombre'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ClienteTipoDocumento'] ) ) $o_SR_GuiaRemisionHBN->setClienteTipoDocumento( $a_SR_GuiaRemisionH['ClienteTipoDocumento'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ClienteNumDocumento'] ) ) $o_SR_GuiaRemisionHBN->setClienteNumDocumento( $a_SR_GuiaRemisionH['ClienteNumDocumento'] );
        if ( !is_null( $a_SR_GuiaRemisionH['DepartamentoOrigen'] ) ) $o_SR_GuiaRemisionHBN->setDepartamentoOrigen( $a_SR_GuiaRemisionH['DepartamentoOrigen'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ProvinciaOrigen'] ) ) $o_SR_GuiaRemisionHBN->setProvinciaOrigen( $a_SR_GuiaRemisionH['ProvinciaOrigen'] );
        if ( !is_null( $a_SR_GuiaRemisionH['DistritoOrigen'] ) ) $o_SR_GuiaRemisionHBN->setDistritoOrigen( $a_SR_GuiaRemisionH['DistritoOrigen'] );
        if ( !is_null( $a_SR_GuiaRemisionH['DireccionOrigen'] ) ) $o_SR_GuiaRemisionHBN->setDireccionOrigen( $a_SR_GuiaRemisionH['DireccionOrigen'] );
        if ( !is_null( $a_SR_GuiaRemisionH['DepartamentoDestino'] ) ) $o_SR_GuiaRemisionHBN->setDepartamentoDestino( $a_SR_GuiaRemisionH['DepartamentoDestino'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ProvinciaDestino'] ) ) $o_SR_GuiaRemisionHBN->setProvinciaDestino( $a_SR_GuiaRemisionH['ProvinciaDestino'] );
        if ( !is_null( $a_SR_GuiaRemisionH['DistritoDestino'] ) ) $o_SR_GuiaRemisionHBN->setDistritoDestino( $a_SR_GuiaRemisionH['DistritoDestino'] );
        if ( !is_null( $a_SR_GuiaRemisionH['DireccionDestino'] ) ) $o_SR_GuiaRemisionHBN->setDireccionDestino( $a_SR_GuiaRemisionH['DireccionDestino'] );
        if ( !is_null( $a_SR_GuiaRemisionH['IdVehiculo'] ) ) $o_SR_GuiaRemisionHBN->setIdVehiculo( ( integer ) $a_SR_GuiaRemisionH['IdVehiculo'] );
        if ( !is_null( $a_SR_GuiaRemisionH['IdChofer'] ) ) $o_SR_GuiaRemisionHBN->setIdChofer( ( integer ) $a_SR_GuiaRemisionH['IdChofer'] );
        if ( !is_null( $a_SR_GuiaRemisionH['MotivoTrasladoId'] ) ) $o_SR_GuiaRemisionHBN->setMotivoTrasladoId( $a_SR_GuiaRemisionH['MotivoTrasladoId'] );
        if ( !is_null( $a_SR_GuiaRemisionH['Comentario'] ) ) $o_SR_GuiaRemisionHBN->setComentario( $a_SR_GuiaRemisionH['Comentario'] );
        if ( !is_null( $a_SR_GuiaRemisionH['IdTipoDocumento'] ) ) $o_SR_GuiaRemisionHBN->setIdTipoDocumento( $a_SR_GuiaRemisionH['IdTipoDocumento'] );
        if ( !is_null( $a_SR_GuiaRemisionH['IdNumeroDocumento'] ) ) $o_SR_GuiaRemisionHBN->setIdNumeroDocumento( $a_SR_GuiaRemisionH['IdNumeroDocumento'] );
        if ( !is_null( $a_SR_GuiaRemisionH['IdTransaccion'] ) ) $o_SR_GuiaRemisionHBN->setIdTransaccion( $a_SR_GuiaRemisionH['IdTransaccion'] );
        if ( !is_null( $a_SR_GuiaRemisionH['MensajeException'] ) ) $o_SR_GuiaRemisionHBN->setMensajeException( $a_SR_GuiaRemisionH['MensajeException'] );
        if ( !is_null( $a_SR_GuiaRemisionH['Estado'] ) ) $o_SR_GuiaRemisionHBN->setEstado( $a_SR_GuiaRemisionH['Estado'] );
        if ( !is_null( $a_SR_GuiaRemisionH['EstadoDevolucion'] ) ) $o_SR_GuiaRemisionHBN->setEstadoDevolucion( $a_SR_GuiaRemisionH['EstadoDevolucion'] );
        if ( !is_null( $a_SR_GuiaRemisionH['EstadoSunat'] ) ) $o_SR_GuiaRemisionHBN->setEstadoSunat( $a_SR_GuiaRemisionH['EstadoSunat'] );
        if ( !is_null( $a_SR_GuiaRemisionH['TipoDeComprobante'] ) ) $o_SR_GuiaRemisionHBN->setTipoDeComprobante( ( integer ) $a_SR_GuiaRemisionH['TipoDeComprobante'] );
        if ( !is_null( $a_SR_GuiaRemisionH['Enlace'] ) ) $o_SR_GuiaRemisionHBN->setEnlace( $a_SR_GuiaRemisionH['Enlace'] );
        if ( !is_null( $a_SR_GuiaRemisionH['AceptadaPorSunat'] ) ) $o_SR_GuiaRemisionHBN->setAceptadaPorSunat( $a_SR_GuiaRemisionH['AceptadaPorSunat'] );
        if ( !is_null( $a_SR_GuiaRemisionH['SunatDescription'] ) ) $o_SR_GuiaRemisionHBN->setSunatDescription( $a_SR_GuiaRemisionH['SunatDescription'] );
        if ( !is_null( $a_SR_GuiaRemisionH['SunatNote'] ) ) $o_SR_GuiaRemisionHBN->setSunatNote( $a_SR_GuiaRemisionH['SunatNote'] );
        if ( !is_null( $a_SR_GuiaRemisionH['SunatResponsecode'] ) ) $o_SR_GuiaRemisionHBN->setSunatResponsecode( $a_SR_GuiaRemisionH['SunatResponsecode'] );
        if ( !is_null( $a_SR_GuiaRemisionH['SunatSoapError'] ) ) $o_SR_GuiaRemisionHBN->setSunatSoapError( $a_SR_GuiaRemisionH['SunatSoapError'] );
        if ( !is_null( $a_SR_GuiaRemisionH['PdfZipBase64'] ) ) $o_SR_GuiaRemisionHBN->setPdfZipBase64( $a_SR_GuiaRemisionH['PdfZipBase64'] );
        if ( !is_null( $a_SR_GuiaRemisionH['XmlZipBase64'] ) ) $o_SR_GuiaRemisionHBN->setXmlZipBase64( $a_SR_GuiaRemisionH['XmlZipBase64'] );
        if ( !is_null( $a_SR_GuiaRemisionH['CdrZipBase64'] ) ) $o_SR_GuiaRemisionHBN->setCdrZipBase64( $a_SR_GuiaRemisionH['CdrZipBase64'] );
        if ( !is_null( $a_SR_GuiaRemisionH['EnlaceDelPdf'] ) ) $o_SR_GuiaRemisionHBN->setEnlaceDelPdf( $a_SR_GuiaRemisionH['EnlaceDelPdf'] );
        if ( !is_null( $a_SR_GuiaRemisionH['EnlaceDelXml'] ) ) $o_SR_GuiaRemisionHBN->setEnlaceDelXml( $a_SR_GuiaRemisionH['EnlaceDelXml'] );
        if ( !is_null( $a_SR_GuiaRemisionH['EnlaceDelCdr'] ) ) $o_SR_GuiaRemisionHBN->setEnlaceDelCdr( $a_SR_GuiaRemisionH['EnlaceDelCdr'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ErrorsResponse'] ) ) $o_SR_GuiaRemisionHBN->setErrorsResponse( $a_SR_GuiaRemisionH['ErrorsResponse'] );
        if ( !is_null( $a_SR_GuiaRemisionH['ErrorsCodigo'] ) ) $o_SR_GuiaRemisionHBN->setErrorsCodigo( $a_SR_GuiaRemisionH['ErrorsCodigo'] );
        if ( !is_null( $a_SR_GuiaRemisionH['FechaRegistro'] ) ) $o_SR_GuiaRemisionHBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_GuiaRemisionH['FechaRegistro'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_GuiaRemisionH['UsuarioRegistro'] ) ) $o_SR_GuiaRemisionHBN->setUsuarioRegistro( $a_SR_GuiaRemisionH['UsuarioRegistro'] );
        if ( !is_null( $a_SR_GuiaRemisionH['FechaModificacion'] ) ) $o_SR_GuiaRemisionHBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SR_GuiaRemisionH['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_GuiaRemisionH['UsuarioModificacion'] ) ) $o_SR_GuiaRemisionHBN->setUsuarioModificacion( $a_SR_GuiaRemisionH['UsuarioModificacion'] );
        return $o_SR_GuiaRemisionHBN;
    }
}
?>