<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_GuiaRemisionDet.xml */
/* Generado: 2021-06-26 00:00:02 */

/* Busqueda de registros de la tabla SR_GuiaRemisionDet. */
abstract class BaseSR_GuiaRemisionDetFN extends SR_GuiaRemisionDetBN
{
    /* Declaracion de constantes */
    const GuiaRemisionDetId = "SR_GuiaRemisionDet.GuiaRemisionDetId";
    const GuiaRemisionId = "SR_GuiaRemisionDet.GuiaRemisionId";
    const MovimientoId = "SR_GuiaRemisionDet.MovimientoId";
    const IdItem = "SR_GuiaRemisionDet.IdItem";
    const Descripcion = "SR_GuiaRemisionDet.Descripcion";
    const Secuencia = "SR_GuiaRemisionDet.Secuencia";
    const ProFinalId = "SR_GuiaRemisionDet.ProFinalId";
    const ProFinalDetId = "SR_GuiaRemisionDet.ProFinalDetId";
    const IdUnidad = "SR_GuiaRemisionDet.IdUnidad";
    const Cantidad = "SR_GuiaRemisionDet.Cantidad";
    const PesoUnitario = "SR_GuiaRemisionDet.PesoUnitario";
    const PesoTotal = "SR_GuiaRemisionDet.PesoTotal";
    const CantidadPendienteDevolucion = "SR_GuiaRemisionDet.CantidadPendienteDevolucion";
    const DiasMinimoAlquiler = "SR_GuiaRemisionDet.DiasMinimoAlquiler";
    const PrecioUnitarioAlquilerLocal = "SR_GuiaRemisionDet.PrecioUnitarioAlquilerLocal";
    const PrecioUnitarioAlquilerDolares = "SR_GuiaRemisionDet.PrecioUnitarioAlquilerDolares";
    const PrecioUnitarioVentaLocal = "SR_GuiaRemisionDet.PrecioUnitarioVentaLocal";
    const PrecioUnitarioVentaDolares = "SR_GuiaRemisionDet.PrecioUnitarioVentaDolares";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_GuiaRemisionDet.GuiaRemisionDetId AS GuiaRemisionDetId, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.GuiaRemisionId AS GuiaRemisionId, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.MovimientoId AS MovimientoId, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.IdItem AS IdItem, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.ProFinalId AS ProFinalId, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.ProFinalDetId AS ProFinalDetId, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.PesoUnitario AS PesoUnitario, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.PesoTotal AS PesoTotal, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.CantidadPendienteDevolucion AS CantidadPendienteDevolucion, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.DiasMinimoAlquiler AS DiasMinimoAlquiler, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.PrecioUnitarioAlquilerLocal AS PrecioUnitarioAlquilerLocal, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.PrecioUnitarioAlquilerDolares AS PrecioUnitarioAlquilerDolares, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.PrecioUnitarioVentaLocal AS PrecioUnitarioVentaLocal, ";
        $s_SQLQuery .= "SR_GuiaRemisionDet.PrecioUnitarioVentaDolares AS PrecioUnitarioVentaDolares ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_GuiaRemisionDetBN */
    public function setByBN( SR_GuiaRemisionDetBN $o_SR_GuiaRemisionDetBN )
    {
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getGuiaRemisionDetId() ) )
        {
            $this->setGuiaRemisionDetId( $o_SR_GuiaRemisionDetBN->getGuiaRemisionDetId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getGuiaRemisionId() ) )
        {
            $this->setGuiaRemisionId( $o_SR_GuiaRemisionDetBN->getGuiaRemisionId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_GuiaRemisionDetBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getIdItem() ) )
        {
            $this->setIdItem( $o_SR_GuiaRemisionDetBN->getIdItem() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_SR_GuiaRemisionDetBN->getDescripcion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_SR_GuiaRemisionDetBN->getSecuencia() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getProFinalId() ) )
        {
            $this->setProFinalId( $o_SR_GuiaRemisionDetBN->getProFinalId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getProFinalDetId() ) )
        {
            $this->setProFinalDetId( $o_SR_GuiaRemisionDetBN->getProFinalDetId() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_SR_GuiaRemisionDetBN->getIdUnidad() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getCantidad() ) )
        {
            $this->setCantidad( $o_SR_GuiaRemisionDetBN->getCantidad() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getPesoUnitario() ) )
        {
            $this->setPesoUnitario( $o_SR_GuiaRemisionDetBN->getPesoUnitario() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getPesoTotal() ) )
        {
            $this->setPesoTotal( $o_SR_GuiaRemisionDetBN->getPesoTotal() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getCantidadPendienteDevolucion() ) )
        {
            $this->setCantidadPendienteDevolucion( $o_SR_GuiaRemisionDetBN->getCantidadPendienteDevolucion() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getDiasMinimoAlquiler() ) )
        {
            $this->setDiasMinimoAlquiler( $o_SR_GuiaRemisionDetBN->getDiasMinimoAlquiler() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getPrecioUnitarioAlquilerLocal() ) )
        {
            $this->setPrecioUnitarioAlquilerLocal( $o_SR_GuiaRemisionDetBN->getPrecioUnitarioAlquilerLocal() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getPrecioUnitarioAlquilerDolares() ) )
        {
            $this->setPrecioUnitarioAlquilerDolares( $o_SR_GuiaRemisionDetBN->getPrecioUnitarioAlquilerDolares() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getPrecioUnitarioVentaLocal() ) )
        {
            $this->setPrecioUnitarioVentaLocal( $o_SR_GuiaRemisionDetBN->getPrecioUnitarioVentaLocal() );
        }
        if ( !is_null( $o_SR_GuiaRemisionDetBN->getPrecioUnitarioVentaDolares() ) )
        {
            $this->setPrecioUnitarioVentaDolares( $o_SR_GuiaRemisionDetBN->getPrecioUnitarioVentaDolares() );
        }
    }

    /**
    * @return SR_GuiaRemisionDetBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_GuiaRemisionDetId )
    {
        if( is_null( $i_GuiaRemisionDetId ) ){ $i_GuiaRemisionDetId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_GuiaRemisionDet ";
        $s_SQLQuery .= "WHERE GuiaRemisionDetId = ".$i_GuiaRemisionDetId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_GuiaRemisionDetBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_GuiaRemisionDetBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_GuiaRemisionDetBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getGuiaRemisionDetId() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.GuiaRemisionDetId = ".$this->getGuiaRemisionDetId()." AND ";
        if ( !is_null( $this->getGuiaRemisionId() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.GuiaRemisionId = '".$this->getGuiaRemisionId()."' AND ";
        if ( !is_null( $this->getMovimientoId() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.MovimientoId = ".$this->getMovimientoId()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.Secuencia = '".$this->getSecuencia()."' AND ";
        if ( !is_null( $this->getProFinalId() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.ProFinalId = ".$this->getProFinalId()." AND ";
        if ( !is_null( $this->getProFinalDetId() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.ProFinalDetId = ".$this->getProFinalDetId()." AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.IdUnidad = ".$this->getIdUnidad()." AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getPesoUnitario() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.PesoUnitario = ".$this->getPesoUnitario()." AND ";
        if ( !is_null( $this->getPesoTotal() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.PesoTotal = ".$this->getPesoTotal()." AND ";
        if ( !is_null( $this->getCantidadPendienteDevolucion() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.CantidadPendienteDevolucion = ".$this->getCantidadPendienteDevolucion()." AND ";
        if ( !is_null( $this->getDiasMinimoAlquiler() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.DiasMinimoAlquiler = ".$this->getDiasMinimoAlquiler()." AND ";
        if ( !is_null( $this->getPrecioUnitarioAlquilerLocal() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.PrecioUnitarioAlquilerLocal = ".$this->getPrecioUnitarioAlquilerLocal()." AND ";
        if ( !is_null( $this->getPrecioUnitarioAlquilerDolares() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.PrecioUnitarioAlquilerDolares = ".$this->getPrecioUnitarioAlquilerDolares()." AND ";
        if ( !is_null( $this->getPrecioUnitarioVentaLocal() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.PrecioUnitarioVentaLocal = ".$this->getPrecioUnitarioVentaLocal()." AND ";
        if ( !is_null( $this->getPrecioUnitarioVentaDolares() ) ) $s_SQLQuery .= "SR_GuiaRemisionDet.PrecioUnitarioVentaDolares = ".$this->getPrecioUnitarioVentaDolares()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_GuiaRemisionDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_GuiaRemisionDetBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_GuiaRemisionDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_GuiaRemisionDetBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_GuiaRemisionDetBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_GuiaRemisionDetBN[] = $o_SR_GuiaRemisionDetBN;
            }
        }
        return $a_SR_GuiaRemisionDetBN;
    }

    /* Devuelve un objeto SR_GuiaRemisionDetBN desde un objeto propel */
    public function insertObjectBN( $a_SR_GuiaRemisionDet )
    {
        $o_SR_GuiaRemisionDetBN = new SR_GuiaRemisionDetBN();
        if ( !is_null( $a_SR_GuiaRemisionDet['GuiaRemisionDetId'] ) ) $o_SR_GuiaRemisionDetBN->setGuiaRemisionDetId( ( integer ) $a_SR_GuiaRemisionDet['GuiaRemisionDetId'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['GuiaRemisionId'] ) ) $o_SR_GuiaRemisionDetBN->setGuiaRemisionId( $a_SR_GuiaRemisionDet['GuiaRemisionId'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['MovimientoId'] ) ) $o_SR_GuiaRemisionDetBN->setMovimientoId( ( integer ) $a_SR_GuiaRemisionDet['MovimientoId'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['IdItem'] ) ) $o_SR_GuiaRemisionDetBN->setIdItem( $a_SR_GuiaRemisionDet['IdItem'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['Descripcion'] ) ) $o_SR_GuiaRemisionDetBN->setDescripcion( $a_SR_GuiaRemisionDet['Descripcion'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['Secuencia'] ) ) $o_SR_GuiaRemisionDetBN->setSecuencia( $a_SR_GuiaRemisionDet['Secuencia'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['ProFinalId'] ) ) $o_SR_GuiaRemisionDetBN->setProFinalId( ( integer ) $a_SR_GuiaRemisionDet['ProFinalId'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['ProFinalDetId'] ) ) $o_SR_GuiaRemisionDetBN->setProFinalDetId( ( integer ) $a_SR_GuiaRemisionDet['ProFinalDetId'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['IdUnidad'] ) ) $o_SR_GuiaRemisionDetBN->setIdUnidad( ( integer ) $a_SR_GuiaRemisionDet['IdUnidad'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['Cantidad'] ) ) $o_SR_GuiaRemisionDetBN->setCantidad( ( float ) $a_SR_GuiaRemisionDet['Cantidad'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['PesoUnitario'] ) ) $o_SR_GuiaRemisionDetBN->setPesoUnitario( ( float ) $a_SR_GuiaRemisionDet['PesoUnitario'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['PesoTotal'] ) ) $o_SR_GuiaRemisionDetBN->setPesoTotal( ( float ) $a_SR_GuiaRemisionDet['PesoTotal'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['CantidadPendienteDevolucion'] ) ) $o_SR_GuiaRemisionDetBN->setCantidadPendienteDevolucion( ( float ) $a_SR_GuiaRemisionDet['CantidadPendienteDevolucion'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['DiasMinimoAlquiler'] ) ) $o_SR_GuiaRemisionDetBN->setDiasMinimoAlquiler( ( integer ) $a_SR_GuiaRemisionDet['DiasMinimoAlquiler'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['PrecioUnitarioAlquilerLocal'] ) ) $o_SR_GuiaRemisionDetBN->setPrecioUnitarioAlquilerLocal( ( float ) $a_SR_GuiaRemisionDet['PrecioUnitarioAlquilerLocal'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['PrecioUnitarioAlquilerDolares'] ) ) $o_SR_GuiaRemisionDetBN->setPrecioUnitarioAlquilerDolares( ( float ) $a_SR_GuiaRemisionDet['PrecioUnitarioAlquilerDolares'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['PrecioUnitarioVentaLocal'] ) ) $o_SR_GuiaRemisionDetBN->setPrecioUnitarioVentaLocal( ( float ) $a_SR_GuiaRemisionDet['PrecioUnitarioVentaLocal'] );
        if ( !is_null( $a_SR_GuiaRemisionDet['PrecioUnitarioVentaDolares'] ) ) $o_SR_GuiaRemisionDetBN->setPrecioUnitarioVentaDolares( ( float ) $a_SR_GuiaRemisionDet['PrecioUnitarioVentaDolares'] );
        return $o_SR_GuiaRemisionDetBN;
    }
}
?>