<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_EstadoDevolucion.xml */
/* Generado: 2021-06-26 01:39:40 */

/* Busqueda de registros de la tabla SR_EstadoDevolucion. */
abstract class BaseSR_EstadoDevolucionFN extends SR_EstadoDevolucionBN
{
    /* Declaracion de constantes */
    const EstadoDevolucionId = "SR_EstadoDevolucion.EstadoDevolucionId";
    const Descripcion = "SR_EstadoDevolucion.Descripcion";
    const FlagCobroExtra = "SR_EstadoDevolucion.FlagCobroExtra";
    const FlagSalida = "SR_EstadoDevolucion.FlagSalida";
    const FlagEntrada = "SR_EstadoDevolucion.FlagEntrada";
    const FlagVentaServicio = "SR_EstadoDevolucion.FlagVentaServicio";
    const FlagVentaProducto = "SR_EstadoDevolucion.FlagVentaProducto";
    const Color = "SR_EstadoDevolucion.Color";
    const IdAlmacen = "SR_EstadoDevolucion.IdAlmacen";
    const IdItemServicio = "SR_EstadoDevolucion.IdItemServicio";
    const FechaCreacion = "SR_EstadoDevolucion.FechaCreacion";
    const UsuarioCreacion = "SR_EstadoDevolucion.UsuarioCreacion";
    const FechaModificacion = "SR_EstadoDevolucion.FechaModificacion";
    const UsuarioModificacion = "SR_EstadoDevolucion.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_EstadoDevolucion.EstadoDevolucionId AS EstadoDevolucionId, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.FlagCobroExtra AS FlagCobroExtra, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.FlagSalida AS FlagSalida, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.FlagEntrada AS FlagEntrada, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.FlagVentaServicio AS FlagVentaServicio, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.FlagVentaProducto AS FlagVentaProducto, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.Color AS Color, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.IdItemServicio AS IdItemServicio, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SR_EstadoDevolucion.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_EstadoDevolucionBN */
    public function setByBN( SR_EstadoDevolucionBN $o_SR_EstadoDevolucionBN )
    {
        if ( !is_null( $o_SR_EstadoDevolucionBN->getEstadoDevolucionId() ) )
        {
            $this->setEstadoDevolucionId( $o_SR_EstadoDevolucionBN->getEstadoDevolucionId() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_SR_EstadoDevolucionBN->getDescripcion() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getFlagCobroExtra() ) )
        {
            $this->setFlagCobroExtra( $o_SR_EstadoDevolucionBN->getFlagCobroExtra() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getFlagSalida() ) )
        {
            $this->setFlagSalida( $o_SR_EstadoDevolucionBN->getFlagSalida() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getFlagEntrada() ) )
        {
            $this->setFlagEntrada( $o_SR_EstadoDevolucionBN->getFlagEntrada() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getFlagVentaServicio() ) )
        {
            $this->setFlagVentaServicio( $o_SR_EstadoDevolucionBN->getFlagVentaServicio() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getFlagVentaProducto() ) )
        {
            $this->setFlagVentaProducto( $o_SR_EstadoDevolucionBN->getFlagVentaProducto() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getColor() ) )
        {
            $this->setColor( $o_SR_EstadoDevolucionBN->getColor() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_SR_EstadoDevolucionBN->getIdAlmacen() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getIdItemServicio() ) )
        {
            $this->setIdItemServicio( $o_SR_EstadoDevolucionBN->getIdItemServicio() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SR_EstadoDevolucionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SR_EstadoDevolucionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_EstadoDevolucionBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SR_EstadoDevolucionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_EstadoDevolucionBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SR_EstadoDevolucionBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_EstadoDevolucionId )
    {
        if( is_null( $s_EstadoDevolucionId ) ){ $s_EstadoDevolucionId = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_EstadoDevolucion ";
        $s_SQLQuery .= "WHERE EstadoDevolucionId = '".$s_EstadoDevolucionId."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_EstadoDevolucionBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_EstadoDevolucionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_EstadoDevolucionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getEstadoDevolucionId() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.EstadoDevolucionId = '".$this->getEstadoDevolucionId()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getFlagCobroExtra() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.FlagCobroExtra = '".$this->getFlagCobroExtra()."' AND ";
        if ( !is_null( $this->getFlagSalida() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.FlagSalida = '".$this->getFlagSalida()."' AND ";
        if ( !is_null( $this->getFlagEntrada() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.FlagEntrada = '".$this->getFlagEntrada()."' AND ";
        if ( !is_null( $this->getFlagVentaServicio() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.FlagVentaServicio = '".$this->getFlagVentaServicio()."' AND ";
        if ( !is_null( $this->getFlagVentaProducto() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.FlagVentaProducto = '".$this->getFlagVentaProducto()."' AND ";
        if ( !is_null( $this->getColor() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.Color = '".$this->getColor()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdItemServicio() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.IdItemServicio = '".$this->getIdItemServicio()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SR_EstadoDevolucion.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_EstadoDevolucion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_EstadoDevolucionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_EstadoDevolucion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_EstadoDevolucionBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_EstadoDevolucionBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_EstadoDevolucionBN[] = $o_SR_EstadoDevolucionBN;
            }
        }
        return $a_SR_EstadoDevolucionBN;
    }

    /* Devuelve un objeto SR_EstadoDevolucionBN desde un objeto propel */
    public function insertObjectBN( $a_SR_EstadoDevolucion )
    {
        $o_SR_EstadoDevolucionBN = new SR_EstadoDevolucionBN();
        if ( !is_null( $a_SR_EstadoDevolucion['EstadoDevolucionId'] ) ) $o_SR_EstadoDevolucionBN->setEstadoDevolucionId( $a_SR_EstadoDevolucion['EstadoDevolucionId'] );
        if ( !is_null( $a_SR_EstadoDevolucion['Descripcion'] ) ) $o_SR_EstadoDevolucionBN->setDescripcion( $a_SR_EstadoDevolucion['Descripcion'] );
        if ( !is_null( $a_SR_EstadoDevolucion['FlagCobroExtra'] ) ) $o_SR_EstadoDevolucionBN->setFlagCobroExtra( $a_SR_EstadoDevolucion['FlagCobroExtra'] );
        if ( !is_null( $a_SR_EstadoDevolucion['FlagSalida'] ) ) $o_SR_EstadoDevolucionBN->setFlagSalida( $a_SR_EstadoDevolucion['FlagSalida'] );
        if ( !is_null( $a_SR_EstadoDevolucion['FlagEntrada'] ) ) $o_SR_EstadoDevolucionBN->setFlagEntrada( $a_SR_EstadoDevolucion['FlagEntrada'] );
        if ( !is_null( $a_SR_EstadoDevolucion['FlagVentaServicio'] ) ) $o_SR_EstadoDevolucionBN->setFlagVentaServicio( $a_SR_EstadoDevolucion['FlagVentaServicio'] );
        if ( !is_null( $a_SR_EstadoDevolucion['FlagVentaProducto'] ) ) $o_SR_EstadoDevolucionBN->setFlagVentaProducto( $a_SR_EstadoDevolucion['FlagVentaProducto'] );
        if ( !is_null( $a_SR_EstadoDevolucion['Color'] ) ) $o_SR_EstadoDevolucionBN->setColor( $a_SR_EstadoDevolucion['Color'] );
        if ( !is_null( $a_SR_EstadoDevolucion['IdAlmacen'] ) ) $o_SR_EstadoDevolucionBN->setIdAlmacen( $a_SR_EstadoDevolucion['IdAlmacen'] );
        if ( !is_null( $a_SR_EstadoDevolucion['IdItemServicio'] ) ) $o_SR_EstadoDevolucionBN->setIdItemServicio( $a_SR_EstadoDevolucion['IdItemServicio'] );
        if ( !is_null( $a_SR_EstadoDevolucion['FechaCreacion'] ) ) $o_SR_EstadoDevolucionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SR_EstadoDevolucion['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_EstadoDevolucion['UsuarioCreacion'] ) ) $o_SR_EstadoDevolucionBN->setUsuarioCreacion( $a_SR_EstadoDevolucion['UsuarioCreacion'] );
        if ( !is_null( $a_SR_EstadoDevolucion['FechaModificacion'] ) ) $o_SR_EstadoDevolucionBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SR_EstadoDevolucion['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_EstadoDevolucion['UsuarioModificacion'] ) ) $o_SR_EstadoDevolucionBN->setUsuarioModificacion( $a_SR_EstadoDevolucion['UsuarioModificacion'] );
        return $o_SR_EstadoDevolucionBN;
    }
}
?>