<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionTransaccion.xml */
/* Generado: 2021-06-26 00:00:02 */

/* Busqueda de registros de la tabla SR_DevolucionTransaccion. */
abstract class BaseSR_DevolucionTransaccionFN extends SR_DevolucionTransaccionBN
{
    /* Declaracion de constantes */
    const DevolucionTransId = "SR_DevolucionTransaccion.DevolucionTransId";
    const DevolucionCabId = "SR_DevolucionTransaccion.DevolucionCabId";
    const IdCompania = "SR_DevolucionTransaccion.IdCompania";
    const IdSucursal = "SR_DevolucionTransaccion.IdSucursal";
    const IdProyecto = "SR_DevolucionTransaccion.IdProyecto";
    const OrdenId = "SR_DevolucionTransaccion.OrdenId";
    const EstadoDevolucionId = "SR_DevolucionTransaccion.EstadoDevolucionId";
    const Tipo = "SR_DevolucionTransaccion.Tipo";
    const IdAlmacenOrigen = "SR_DevolucionTransaccion.IdAlmacenOrigen";
    const IdAlmacenDestino = "SR_DevolucionTransaccion.IdAlmacenDestino";
    const IdTipoDocumento = "SR_DevolucionTransaccion.IdTipoDocumento";
    const IdNumeroDocumento = "SR_DevolucionTransaccion.IdNumeroDocumento";
    const IdTransaccion = "SR_DevolucionTransaccion.IdTransaccion";
    const TipoDocumentoFiscal = "SR_DevolucionTransaccion.TipoDocumentoFiscal";
    const SerieDocumentoFiscal = "SR_DevolucionTransaccion.SerieDocumentoFiscal";
    const NumeroDocumentoFiscal = "SR_DevolucionTransaccion.NumeroDocumentoFiscal";
    const FechaCreacion = "SR_DevolucionTransaccion.FechaCreacion";
    const UsuarioCreacion = "SR_DevolucionTransaccion.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_DevolucionTransaccion.DevolucionTransId AS DevolucionTransId, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.DevolucionCabId AS DevolucionCabId, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.OrdenId AS OrdenId, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.EstadoDevolucionId AS EstadoDevolucionId, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.Tipo AS Tipo, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.IdAlmacenOrigen AS IdAlmacenOrigen, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.IdAlmacenDestino AS IdAlmacenDestino, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.IdTransaccion AS IdTransaccion, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.TipoDocumentoFiscal AS TipoDocumentoFiscal, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.SerieDocumentoFiscal AS SerieDocumentoFiscal, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.NumeroDocumentoFiscal AS NumeroDocumentoFiscal, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SR_DevolucionTransaccion.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_DevolucionTransaccionBN */
    public function setByBN( SR_DevolucionTransaccionBN $o_SR_DevolucionTransaccionBN )
    {
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getDevolucionTransId() ) )
        {
            $this->setDevolucionTransId( $o_SR_DevolucionTransaccionBN->getDevolucionTransId() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getDevolucionCabId() ) )
        {
            $this->setDevolucionCabId( $o_SR_DevolucionTransaccionBN->getDevolucionCabId() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SR_DevolucionTransaccionBN->getIdCompania() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SR_DevolucionTransaccionBN->getIdSucursal() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_SR_DevolucionTransaccionBN->getIdProyecto() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_SR_DevolucionTransaccionBN->getOrdenId() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getEstadoDevolucionId() ) )
        {
            $this->setEstadoDevolucionId( $o_SR_DevolucionTransaccionBN->getEstadoDevolucionId() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getTipo() ) )
        {
            $this->setTipo( $o_SR_DevolucionTransaccionBN->getTipo() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getIdAlmacenOrigen() ) )
        {
            $this->setIdAlmacenOrigen( $o_SR_DevolucionTransaccionBN->getIdAlmacenOrigen() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getIdAlmacenDestino() ) )
        {
            $this->setIdAlmacenDestino( $o_SR_DevolucionTransaccionBN->getIdAlmacenDestino() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_SR_DevolucionTransaccionBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_SR_DevolucionTransaccionBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getIdTransaccion() ) )
        {
            $this->setIdTransaccion( $o_SR_DevolucionTransaccionBN->getIdTransaccion() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getTipoDocumentoFiscal() ) )
        {
            $this->setTipoDocumentoFiscal( $o_SR_DevolucionTransaccionBN->getTipoDocumentoFiscal() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getSerieDocumentoFiscal() ) )
        {
            $this->setSerieDocumentoFiscal( $o_SR_DevolucionTransaccionBN->getSerieDocumentoFiscal() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getNumeroDocumentoFiscal() ) )
        {
            $this->setNumeroDocumentoFiscal( $o_SR_DevolucionTransaccionBN->getNumeroDocumentoFiscal() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SR_DevolucionTransaccionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SR_DevolucionTransaccionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SR_DevolucionTransaccionBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return SR_DevolucionTransaccionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_DevolucionTransId )
    {
        if( is_null( $i_DevolucionTransId ) ){ $i_DevolucionTransId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionTransaccion ";
        $s_SQLQuery .= "WHERE DevolucionTransId = ".$i_DevolucionTransId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_DevolucionTransaccionBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_DevolucionTransaccionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_DevolucionTransaccionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getDevolucionTransId() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.DevolucionTransId = ".$this->getDevolucionTransId()." AND ";
        if ( !is_null( $this->getDevolucionCabId() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.DevolucionCabId = ".$this->getDevolucionCabId()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getOrdenId() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.OrdenId = ".$this->getOrdenId()." AND ";
        if ( !is_null( $this->getEstadoDevolucionId() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.EstadoDevolucionId = '".$this->getEstadoDevolucionId()."' AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.Tipo = '".$this->getTipo()."' AND ";
        if ( !is_null( $this->getIdAlmacenOrigen() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.IdAlmacenOrigen = '".$this->getIdAlmacenOrigen()."' AND ";
        if ( !is_null( $this->getIdAlmacenDestino() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.IdAlmacenDestino = '".$this->getIdAlmacenDestino()."' AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getIdTransaccion() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.IdTransaccion = '".$this->getIdTransaccion()."' AND ";
        if ( !is_null( $this->getTipoDocumentoFiscal() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.TipoDocumentoFiscal = '".$this->getTipoDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getSerieDocumentoFiscal() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.SerieDocumentoFiscal = '".$this->getSerieDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getNumeroDocumentoFiscal() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.NumeroDocumentoFiscal = '".$this->getNumeroDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SR_DevolucionTransaccion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_DevolucionTransaccion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_DevolucionTransaccionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionTransaccion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_DevolucionTransaccionBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_DevolucionTransaccionBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_DevolucionTransaccionBN[] = $o_SR_DevolucionTransaccionBN;
            }
        }
        return $a_SR_DevolucionTransaccionBN;
    }

    /* Devuelve un objeto SR_DevolucionTransaccionBN desde un objeto propel */
    public function insertObjectBN( $a_SR_DevolucionTransaccion )
    {
        $o_SR_DevolucionTransaccionBN = new SR_DevolucionTransaccionBN();
        if ( !is_null( $a_SR_DevolucionTransaccion['DevolucionTransId'] ) ) $o_SR_DevolucionTransaccionBN->setDevolucionTransId( ( integer ) $a_SR_DevolucionTransaccion['DevolucionTransId'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['DevolucionCabId'] ) ) $o_SR_DevolucionTransaccionBN->setDevolucionCabId( ( integer ) $a_SR_DevolucionTransaccion['DevolucionCabId'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['IdCompania'] ) ) $o_SR_DevolucionTransaccionBN->setIdCompania( ( integer ) $a_SR_DevolucionTransaccion['IdCompania'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['IdSucursal'] ) ) $o_SR_DevolucionTransaccionBN->setIdSucursal( ( integer ) $a_SR_DevolucionTransaccion['IdSucursal'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['IdProyecto'] ) ) $o_SR_DevolucionTransaccionBN->setIdProyecto( ( integer ) $a_SR_DevolucionTransaccion['IdProyecto'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['OrdenId'] ) ) $o_SR_DevolucionTransaccionBN->setOrdenId( ( integer ) $a_SR_DevolucionTransaccion['OrdenId'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['EstadoDevolucionId'] ) ) $o_SR_DevolucionTransaccionBN->setEstadoDevolucionId( $a_SR_DevolucionTransaccion['EstadoDevolucionId'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['Tipo'] ) ) $o_SR_DevolucionTransaccionBN->setTipo( $a_SR_DevolucionTransaccion['Tipo'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['IdAlmacenOrigen'] ) ) $o_SR_DevolucionTransaccionBN->setIdAlmacenOrigen( $a_SR_DevolucionTransaccion['IdAlmacenOrigen'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['IdAlmacenDestino'] ) ) $o_SR_DevolucionTransaccionBN->setIdAlmacenDestino( $a_SR_DevolucionTransaccion['IdAlmacenDestino'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['IdTipoDocumento'] ) ) $o_SR_DevolucionTransaccionBN->setIdTipoDocumento( $a_SR_DevolucionTransaccion['IdTipoDocumento'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['IdNumeroDocumento'] ) ) $o_SR_DevolucionTransaccionBN->setIdNumeroDocumento( $a_SR_DevolucionTransaccion['IdNumeroDocumento'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['IdTransaccion'] ) ) $o_SR_DevolucionTransaccionBN->setIdTransaccion( $a_SR_DevolucionTransaccion['IdTransaccion'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['TipoDocumentoFiscal'] ) ) $o_SR_DevolucionTransaccionBN->setTipoDocumentoFiscal( $a_SR_DevolucionTransaccion['TipoDocumentoFiscal'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['SerieDocumentoFiscal'] ) ) $o_SR_DevolucionTransaccionBN->setSerieDocumentoFiscal( $a_SR_DevolucionTransaccion['SerieDocumentoFiscal'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['NumeroDocumentoFiscal'] ) ) $o_SR_DevolucionTransaccionBN->setNumeroDocumentoFiscal( $a_SR_DevolucionTransaccion['NumeroDocumentoFiscal'] );
        if ( !is_null( $a_SR_DevolucionTransaccion['FechaCreacion'] ) ) $o_SR_DevolucionTransaccionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SR_DevolucionTransaccion['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_DevolucionTransaccion['UsuarioCreacion'] ) ) $o_SR_DevolucionTransaccionBN->setUsuarioCreacion( $a_SR_DevolucionTransaccion['UsuarioCreacion'] );
        return $o_SR_DevolucionTransaccionBN;
    }
}
?>