<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionDetalle.xml */
/* Generado: 2021-07-06 18:57:55 */

/* Busqueda de registros de la tabla SR_DevolucionDetalle. */
abstract class BaseSR_DevolucionDetalleFN extends SR_DevolucionDetalleBN
{
    /* Declaracion de constantes */
    const DevolucionDetId = "SR_DevolucionDetalle.DevolucionDetId";
    const DevolucionCabId = "SR_DevolucionDetalle.DevolucionCabId";
    const EstadoDevolucionId = "SR_DevolucionDetalle.EstadoDevolucionId";
    const IdItem = "SR_DevolucionDetalle.IdItem";
    const ItemDescripcion = "SR_DevolucionDetalle.ItemDescripcion";
    const CantidadDevolucion = "SR_DevolucionDetalle.CantidadDevolucion";
    const ComentarioDevolucion = "SR_DevolucionDetalle.ComentarioDevolucion";
    const TipoComentDevolucion = "SR_DevolucionDetalle.TipoComentDevolucion";
    const EstadoFacturacion = "SR_DevolucionDetalle.EstadoFacturacion";
    const DevolFactId = "SR_DevolucionDetalle.DevolFactId";
    const PrecioUnitVentaDevolucion = "SR_DevolucionDetalle.PrecioUnitVentaDevolucion";
    const FechaCreacion = "SR_DevolucionDetalle.FechaCreacion";
    const UsuarioCreacion = "SR_DevolucionDetalle.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_DevolucionDetalle.DevolucionDetId AS DevolucionDetId, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.DevolucionCabId AS DevolucionCabId, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.EstadoDevolucionId AS EstadoDevolucionId, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.ItemDescripcion AS ItemDescripcion, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.CantidadDevolucion AS CantidadDevolucion, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.ComentarioDevolucion AS ComentarioDevolucion, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.TipoComentDevolucion AS TipoComentDevolucion, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.EstadoFacturacion AS EstadoFacturacion, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.DevolFactId AS DevolFactId, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.PrecioUnitVentaDevolucion AS PrecioUnitVentaDevolucion, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SR_DevolucionDetalle.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_DevolucionDetalleBN */
    public function setByBN( SR_DevolucionDetalleBN $o_SR_DevolucionDetalleBN )
    {
        if ( !is_null( $o_SR_DevolucionDetalleBN->getDevolucionDetId() ) )
        {
            $this->setDevolucionDetId( $o_SR_DevolucionDetalleBN->getDevolucionDetId() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getDevolucionCabId() ) )
        {
            $this->setDevolucionCabId( $o_SR_DevolucionDetalleBN->getDevolucionCabId() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getEstadoDevolucionId() ) )
        {
            $this->setEstadoDevolucionId( $o_SR_DevolucionDetalleBN->getEstadoDevolucionId() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_SR_DevolucionDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getItemDescripcion() ) )
        {
            $this->setItemDescripcion( $o_SR_DevolucionDetalleBN->getItemDescripcion() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getCantidadDevolucion() ) )
        {
            $this->setCantidadDevolucion( $o_SR_DevolucionDetalleBN->getCantidadDevolucion() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getComentarioDevolucion() ) )
        {
            $this->setComentarioDevolucion( $o_SR_DevolucionDetalleBN->getComentarioDevolucion() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getTipoComentDevolucion() ) )
        {
            $this->setTipoComentDevolucion( $o_SR_DevolucionDetalleBN->getTipoComentDevolucion() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getEstadoFacturacion() ) )
        {
            $this->setEstadoFacturacion( $o_SR_DevolucionDetalleBN->getEstadoFacturacion() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getDevolFactId() ) )
        {
            $this->setDevolFactId( $o_SR_DevolucionDetalleBN->getDevolFactId() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getPrecioUnitVentaDevolucion() ) )
        {
            $this->setPrecioUnitVentaDevolucion( $o_SR_DevolucionDetalleBN->getPrecioUnitVentaDevolucion() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SR_DevolucionDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SR_DevolucionDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SR_DevolucionDetalleBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return SR_DevolucionDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_DevolucionDetId )
    {
        if( is_null( $i_DevolucionDetId ) ){ $i_DevolucionDetId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionDetalle ";
        $s_SQLQuery .= "WHERE DevolucionDetId = ".$i_DevolucionDetId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_DevolucionDetalleBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_DevolucionDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_DevolucionDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getDevolucionDetId() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.DevolucionDetId = ".$this->getDevolucionDetId()." AND ";
        if ( !is_null( $this->getDevolucionCabId() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.DevolucionCabId = ".$this->getDevolucionCabId()." AND ";
        if ( !is_null( $this->getEstadoDevolucionId() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.EstadoDevolucionId = '".$this->getEstadoDevolucionId()."' AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getItemDescripcion() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.ItemDescripcion = '".$this->getItemDescripcion()."' AND ";
        if ( !is_null( $this->getCantidadDevolucion() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.CantidadDevolucion = ".$this->getCantidadDevolucion()." AND ";
        if ( !is_null( $this->getComentarioDevolucion() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.ComentarioDevolucion = '".$this->getComentarioDevolucion()."' AND ";
        if ( !is_null( $this->getTipoComentDevolucion() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.TipoComentDevolucion = '".$this->getTipoComentDevolucion()."' AND ";
        if ( !is_null( $this->getEstadoFacturacion() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.EstadoFacturacion = '".$this->getEstadoFacturacion()."' AND ";
        if ( !is_null( $this->getDevolFactId() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.DevolFactId = ".$this->getDevolFactId()." AND ";
        if ( !is_null( $this->getPrecioUnitVentaDevolucion() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.PrecioUnitVentaDevolucion = ".$this->getPrecioUnitVentaDevolucion()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SR_DevolucionDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_DevolucionDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_DevolucionDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_DevolucionDetalleBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_DevolucionDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_DevolucionDetalleBN[] = $o_SR_DevolucionDetalleBN;
            }
        }
        return $a_SR_DevolucionDetalleBN;
    }

    /* Devuelve un objeto SR_DevolucionDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_SR_DevolucionDetalle )
    {
        $o_SR_DevolucionDetalleBN = new SR_DevolucionDetalleBN();
        if ( !is_null( $a_SR_DevolucionDetalle['DevolucionDetId'] ) ) $o_SR_DevolucionDetalleBN->setDevolucionDetId( ( integer ) $a_SR_DevolucionDetalle['DevolucionDetId'] );
        if ( !is_null( $a_SR_DevolucionDetalle['DevolucionCabId'] ) ) $o_SR_DevolucionDetalleBN->setDevolucionCabId( ( integer ) $a_SR_DevolucionDetalle['DevolucionCabId'] );
        if ( !is_null( $a_SR_DevolucionDetalle['EstadoDevolucionId'] ) ) $o_SR_DevolucionDetalleBN->setEstadoDevolucionId( $a_SR_DevolucionDetalle['EstadoDevolucionId'] );
        if ( !is_null( $a_SR_DevolucionDetalle['IdItem'] ) ) $o_SR_DevolucionDetalleBN->setIdItem( $a_SR_DevolucionDetalle['IdItem'] );
        if ( !is_null( $a_SR_DevolucionDetalle['ItemDescripcion'] ) ) $o_SR_DevolucionDetalleBN->setItemDescripcion( $a_SR_DevolucionDetalle['ItemDescripcion'] );
        if ( !is_null( $a_SR_DevolucionDetalle['CantidadDevolucion'] ) ) $o_SR_DevolucionDetalleBN->setCantidadDevolucion( ( float ) $a_SR_DevolucionDetalle['CantidadDevolucion'] );
        if ( !is_null( $a_SR_DevolucionDetalle['ComentarioDevolucion'] ) ) $o_SR_DevolucionDetalleBN->setComentarioDevolucion( $a_SR_DevolucionDetalle['ComentarioDevolucion'] );
        if ( !is_null( $a_SR_DevolucionDetalle['TipoComentDevolucion'] ) ) $o_SR_DevolucionDetalleBN->setTipoComentDevolucion( $a_SR_DevolucionDetalle['TipoComentDevolucion'] );
        if ( !is_null( $a_SR_DevolucionDetalle['EstadoFacturacion'] ) ) $o_SR_DevolucionDetalleBN->setEstadoFacturacion( $a_SR_DevolucionDetalle['EstadoFacturacion'] );
        if ( !is_null( $a_SR_DevolucionDetalle['DevolFactId'] ) ) $o_SR_DevolucionDetalleBN->setDevolFactId( ( integer ) $a_SR_DevolucionDetalle['DevolFactId'] );
        if ( !is_null( $a_SR_DevolucionDetalle['PrecioUnitVentaDevolucion'] ) ) $o_SR_DevolucionDetalleBN->setPrecioUnitVentaDevolucion( ( float ) $a_SR_DevolucionDetalle['PrecioUnitVentaDevolucion'] );
        if ( !is_null( $a_SR_DevolucionDetalle['FechaCreacion'] ) ) $o_SR_DevolucionDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SR_DevolucionDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_DevolucionDetalle['UsuarioCreacion'] ) ) $o_SR_DevolucionDetalleBN->setUsuarioCreacion( $a_SR_DevolucionDetalle['UsuarioCreacion'] );
        return $o_SR_DevolucionDetalleBN;
    }
}
?>