<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionDetCorte.xml */
/* Generado: 2021-06-26 00:00:01 */

/* Busqueda de registros de la tabla SR_DevolucionDetCorte. */
abstract class BaseSR_DevolucionDetCorteFN extends SR_DevolucionDetCorteBN
{
    /* Declaracion de constantes */
    const DevolDetCorteId = "SR_DevolucionDetCorte.DevolDetCorteId";
    const IdCompania = "SR_DevolucionDetCorte.IdCompania";
    const IdSucursal = "SR_DevolucionDetCorte.IdSucursal";
    const IdProyecto = "SR_DevolucionDetCorte.IdProyecto";
    const EstadoDevolucionId = "SR_DevolucionDetCorte.EstadoDevolucionId";
    const GrupoId = "SR_DevolucionDetCorte.GrupoId";
    const FechaIni = "SR_DevolucionDetCorte.FechaIni";
    const Tipo = "SR_DevolucionDetCorte.Tipo";
    const EstadoDesc = "SR_DevolucionDetCorte.EstadoDesc";
    const Comentario = "SR_DevolucionDetCorte.Comentario";
    const Documento = "SR_DevolucionDetCorte.Documento";
    const IdItem = "SR_DevolucionDetCorte.IdItem";
    const DescripcionItem = "SR_DevolucionDetCorte.DescripcionItem";
    const Cantidad = "SR_DevolucionDetCorte.Cantidad";
    const FechaFin = "SR_DevolucionDetCorte.FechaFin";
    const FechaCorte = "SR_DevolucionDetCorte.FechaCorte";
    const Dias = "SR_DevolucionDetCorte.Dias";
    const PrecioUnitario = "SR_DevolucionDetCorte.PrecioUnitario";
    const MontoTotal = "SR_DevolucionDetCorte.MontoTotal";
    const Estado = "SR_DevolucionDetCorte.Estado";
    const UsuarioCreacion = "SR_DevolucionDetCorte.UsuarioCreacion";
    const FechaCreacion = "SR_DevolucionDetCorte.FechaCreacion";
    const UsuarioModificacion = "SR_DevolucionDetCorte.UsuarioModificacion";
    const FechaModificacion = "SR_DevolucionDetCorte.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_DevolucionDetCorte.DevolDetCorteId AS DevolDetCorteId, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.EstadoDevolucionId AS EstadoDevolucionId, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.GrupoId AS GrupoId, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.FechaIni AS FechaIni, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.Tipo AS Tipo, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.EstadoDesc AS EstadoDesc, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.Documento AS Documento, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.IdItem AS IdItem, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.DescripcionItem AS DescripcionItem, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.FechaFin AS FechaFin, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.FechaCorte AS FechaCorte, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.Dias AS Dias, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.Estado AS Estado, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "SR_DevolucionDetCorte.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_DevolucionDetCorteBN */
    public function setByBN( SR_DevolucionDetCorteBN $o_SR_DevolucionDetCorteBN )
    {
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getDevolDetCorteId() ) )
        {
            $this->setDevolDetCorteId( $o_SR_DevolucionDetCorteBN->getDevolDetCorteId() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SR_DevolucionDetCorteBN->getIdCompania() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SR_DevolucionDetCorteBN->getIdSucursal() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_SR_DevolucionDetCorteBN->getIdProyecto() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getEstadoDevolucionId() ) )
        {
            $this->setEstadoDevolucionId( $o_SR_DevolucionDetCorteBN->getEstadoDevolucionId() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getGrupoId() ) )
        {
            $this->setGrupoId( $o_SR_DevolucionDetCorteBN->getGrupoId() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getFechaIni() ) )
        {
            $this->setFechaIni( $o_SR_DevolucionDetCorteBN->getFechaIni() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getTipo() ) )
        {
            $this->setTipo( $o_SR_DevolucionDetCorteBN->getTipo() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getEstadoDesc() ) )
        {
            $this->setEstadoDesc( $o_SR_DevolucionDetCorteBN->getEstadoDesc() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_DevolucionDetCorteBN->getComentario() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getDocumento() ) )
        {
            $this->setDocumento( $o_SR_DevolucionDetCorteBN->getDocumento() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getIdItem() ) )
        {
            $this->setIdItem( $o_SR_DevolucionDetCorteBN->getIdItem() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getDescripcionItem() ) )
        {
            $this->setDescripcionItem( $o_SR_DevolucionDetCorteBN->getDescripcionItem() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getCantidad() ) )
        {
            $this->setCantidad( $o_SR_DevolucionDetCorteBN->getCantidad() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getFechaFin() ) )
        {
            $this->setFechaFin( $o_SR_DevolucionDetCorteBN->getFechaFin() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getFechaCorte() ) )
        {
            $this->setFechaCorte( $o_SR_DevolucionDetCorteBN->getFechaCorte() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getDias() ) )
        {
            $this->setDias( $o_SR_DevolucionDetCorteBN->getDias() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_SR_DevolucionDetCorteBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_SR_DevolucionDetCorteBN->getMontoTotal() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getEstado() ) )
        {
            $this->setEstado( $o_SR_DevolucionDetCorteBN->getEstado() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SR_DevolucionDetCorteBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SR_DevolucionDetCorteBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_DevolucionDetCorteBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_SR_DevolucionDetCorteBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_DevolucionDetCorteBN->getFechaModificacion() );
        }
    }

    /**
    * @return SR_DevolucionDetCorteBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_DevolDetCorteId )
    {
        if( is_null( $i_DevolDetCorteId ) ){ $i_DevolDetCorteId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionDetCorte ";
        $s_SQLQuery .= "WHERE DevolDetCorteId = ".$i_DevolDetCorteId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_DevolucionDetCorteBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_DevolucionDetCorteBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_DevolucionDetCorteBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getDevolDetCorteId() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.DevolDetCorteId = ".$this->getDevolDetCorteId()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getEstadoDevolucionId() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.EstadoDevolucionId = '".$this->getEstadoDevolucionId()."' AND ";
        if ( !is_null( $this->getGrupoId() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.GrupoId = '".$this->getGrupoId()."' AND ";
        if ( !is_null( $this->getFechaIni() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.FechaIni = '".$this->getFechaIni()."' AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.Tipo = '".$this->getTipo()."' AND ";
        if ( !is_null( $this->getEstadoDesc() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.EstadoDesc = '".$this->getEstadoDesc()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getDocumento() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.Documento = '".$this->getDocumento()."' AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getDescripcionItem() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.DescripcionItem = '".$this->getDescripcionItem()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getFechaFin() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.FechaFin = '".$this->getFechaFin()."' AND ";
        if ( !is_null( $this->getFechaCorte() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.FechaCorte = '".$this->getFechaCorte()."' AND ";
        if ( !is_null( $this->getDias() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.Dias = ".$this->getDias()." AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SR_DevolucionDetCorte.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_DevolucionDetCorte WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_DevolucionDetCorteBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionDetCorte WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_DevolucionDetCorteBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_DevolucionDetCorteBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_DevolucionDetCorteBN[] = $o_SR_DevolucionDetCorteBN;
            }
        }
        return $a_SR_DevolucionDetCorteBN;
    }

    /* Devuelve un objeto SR_DevolucionDetCorteBN desde un objeto propel */
    public function insertObjectBN( $a_SR_DevolucionDetCorte )
    {
        $o_SR_DevolucionDetCorteBN = new SR_DevolucionDetCorteBN();
        if ( !is_null( $a_SR_DevolucionDetCorte['DevolDetCorteId'] ) ) $o_SR_DevolucionDetCorteBN->setDevolDetCorteId( ( integer ) $a_SR_DevolucionDetCorte['DevolDetCorteId'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['IdCompania'] ) ) $o_SR_DevolucionDetCorteBN->setIdCompania( ( integer ) $a_SR_DevolucionDetCorte['IdCompania'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['IdSucursal'] ) ) $o_SR_DevolucionDetCorteBN->setIdSucursal( ( integer ) $a_SR_DevolucionDetCorte['IdSucursal'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['IdProyecto'] ) ) $o_SR_DevolucionDetCorteBN->setIdProyecto( ( integer ) $a_SR_DevolucionDetCorte['IdProyecto'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['EstadoDevolucionId'] ) ) $o_SR_DevolucionDetCorteBN->setEstadoDevolucionId( $a_SR_DevolucionDetCorte['EstadoDevolucionId'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['GrupoId'] ) ) $o_SR_DevolucionDetCorteBN->setGrupoId( $a_SR_DevolucionDetCorte['GrupoId'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['FechaIni'] ) ) $o_SR_DevolucionDetCorteBN->setFechaIni( utilTimestamp::getTimestamp( $a_SR_DevolucionDetCorte['FechaIni'], "Y-m-d" ) );
        if ( !is_null( $a_SR_DevolucionDetCorte['Tipo'] ) ) $o_SR_DevolucionDetCorteBN->setTipo( $a_SR_DevolucionDetCorte['Tipo'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['EstadoDesc'] ) ) $o_SR_DevolucionDetCorteBN->setEstadoDesc( $a_SR_DevolucionDetCorte['EstadoDesc'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['Comentario'] ) ) $o_SR_DevolucionDetCorteBN->setComentario( $a_SR_DevolucionDetCorte['Comentario'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['Documento'] ) ) $o_SR_DevolucionDetCorteBN->setDocumento( $a_SR_DevolucionDetCorte['Documento'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['IdItem'] ) ) $o_SR_DevolucionDetCorteBN->setIdItem( $a_SR_DevolucionDetCorte['IdItem'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['DescripcionItem'] ) ) $o_SR_DevolucionDetCorteBN->setDescripcionItem( $a_SR_DevolucionDetCorte['DescripcionItem'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['Cantidad'] ) ) $o_SR_DevolucionDetCorteBN->setCantidad( ( float ) $a_SR_DevolucionDetCorte['Cantidad'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['FechaFin'] ) ) $o_SR_DevolucionDetCorteBN->setFechaFin( utilTimestamp::getTimestamp( $a_SR_DevolucionDetCorte['FechaFin'], "Y-m-d" ) );
        if ( !is_null( $a_SR_DevolucionDetCorte['FechaCorte'] ) ) $o_SR_DevolucionDetCorteBN->setFechaCorte( utilTimestamp::getTimestamp( $a_SR_DevolucionDetCorte['FechaCorte'], "Y-m-d" ) );
        if ( !is_null( $a_SR_DevolucionDetCorte['Dias'] ) ) $o_SR_DevolucionDetCorteBN->setDias( ( integer ) $a_SR_DevolucionDetCorte['Dias'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['PrecioUnitario'] ) ) $o_SR_DevolucionDetCorteBN->setPrecioUnitario( ( float ) $a_SR_DevolucionDetCorte['PrecioUnitario'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['MontoTotal'] ) ) $o_SR_DevolucionDetCorteBN->setMontoTotal( ( float ) $a_SR_DevolucionDetCorte['MontoTotal'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['Estado'] ) ) $o_SR_DevolucionDetCorteBN->setEstado( $a_SR_DevolucionDetCorte['Estado'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['UsuarioCreacion'] ) ) $o_SR_DevolucionDetCorteBN->setUsuarioCreacion( $a_SR_DevolucionDetCorte['UsuarioCreacion'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['FechaCreacion'] ) ) $o_SR_DevolucionDetCorteBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SR_DevolucionDetCorte['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_DevolucionDetCorte['UsuarioModificacion'] ) ) $o_SR_DevolucionDetCorteBN->setUsuarioModificacion( $a_SR_DevolucionDetCorte['UsuarioModificacion'] );
        if ( !is_null( $a_SR_DevolucionDetCorte['FechaModificacion'] ) ) $o_SR_DevolucionDetCorteBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SR_DevolucionDetCorte['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_SR_DevolucionDetCorteBN;
    }
}
?>