<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionCabecera.xml */
/* Generado: 2021-06-26 00:00:01 */

/* Busqueda de registros de la tabla SR_DevolucionCabecera. */
abstract class BaseSR_DevolucionCabeceraFN extends SR_DevolucionCabeceraBN
{
    /* Declaracion de constantes */
    const DevolucionCabId = "SR_DevolucionCabecera.DevolucionCabId";
    const IdCompania = "SR_DevolucionCabecera.IdCompania";
    const IdSucursal = "SR_DevolucionCabecera.IdSucursal";
    const IdProyecto = "SR_DevolucionCabecera.IdProyecto";
    const OrdenId = "SR_DevolucionCabecera.OrdenId";
    const ParentId = "SR_DevolucionCabecera.ParentId";
    const Tipo = "SR_DevolucionCabecera.Tipo";
    const TransGuiaSerie = "SR_DevolucionCabecera.TransGuiaSerie";
    const TransGuiaNumero = "SR_DevolucionCabecera.TransGuiaNumero";
    const ObraGuiaSerie = "SR_DevolucionCabecera.ObraGuiaSerie";
    const ObraGuiaNumero = "SR_DevolucionCabecera.ObraGuiaNumero";
    const Observaciones = "SR_DevolucionCabecera.Observaciones";
    const FechaInicioAlq = "SR_DevolucionCabecera.FechaInicioAlq";
    const FechaDevolucion = "SR_DevolucionCabecera.FechaDevolucion";
    const Estado = "SR_DevolucionCabecera.Estado";
    const EstadoCorte = "SR_DevolucionCabecera.EstadoCorte";
    const FechaCreacion = "SR_DevolucionCabecera.FechaCreacion";
    const UsuarioCreacion = "SR_DevolucionCabecera.UsuarioCreacion";
    const FechaModificacion = "SR_DevolucionCabecera.FechaModificacion";
    const UsuarioModificacion = "SR_DevolucionCabecera.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_DevolucionCabecera.DevolucionCabId AS DevolucionCabId, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.OrdenId AS OrdenId, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.ParentId AS ParentId, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.Tipo AS Tipo, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.TransGuiaSerie AS TransGuiaSerie, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.TransGuiaNumero AS TransGuiaNumero, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.ObraGuiaSerie AS ObraGuiaSerie, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.ObraGuiaNumero AS ObraGuiaNumero, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.Observaciones AS Observaciones, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.FechaInicioAlq AS FechaInicioAlq, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.FechaDevolucion AS FechaDevolucion, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.Estado AS Estado, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.EstadoCorte AS EstadoCorte, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SR_DevolucionCabecera.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_DevolucionCabeceraBN */
    public function setByBN( SR_DevolucionCabeceraBN $o_SR_DevolucionCabeceraBN )
    {
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getDevolucionCabId() ) )
        {
            $this->setDevolucionCabId( $o_SR_DevolucionCabeceraBN->getDevolucionCabId() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SR_DevolucionCabeceraBN->getIdCompania() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SR_DevolucionCabeceraBN->getIdSucursal() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_SR_DevolucionCabeceraBN->getIdProyecto() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_SR_DevolucionCabeceraBN->getOrdenId() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getParentId() ) )
        {
            $this->setParentId( $o_SR_DevolucionCabeceraBN->getParentId() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getTipo() ) )
        {
            $this->setTipo( $o_SR_DevolucionCabeceraBN->getTipo() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getTransGuiaSerie() ) )
        {
            $this->setTransGuiaSerie( $o_SR_DevolucionCabeceraBN->getTransGuiaSerie() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getTransGuiaNumero() ) )
        {
            $this->setTransGuiaNumero( $o_SR_DevolucionCabeceraBN->getTransGuiaNumero() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getObraGuiaSerie() ) )
        {
            $this->setObraGuiaSerie( $o_SR_DevolucionCabeceraBN->getObraGuiaSerie() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getObraGuiaNumero() ) )
        {
            $this->setObraGuiaNumero( $o_SR_DevolucionCabeceraBN->getObraGuiaNumero() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getObservaciones() ) )
        {
            $this->setObservaciones( $o_SR_DevolucionCabeceraBN->getObservaciones() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getFechaInicioAlq() ) )
        {
            $this->setFechaInicioAlq( $o_SR_DevolucionCabeceraBN->getFechaInicioAlq() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getFechaDevolucion() ) )
        {
            $this->setFechaDevolucion( $o_SR_DevolucionCabeceraBN->getFechaDevolucion() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getEstado() ) )
        {
            $this->setEstado( $o_SR_DevolucionCabeceraBN->getEstado() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getEstadoCorte() ) )
        {
            $this->setEstadoCorte( $o_SR_DevolucionCabeceraBN->getEstadoCorte() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SR_DevolucionCabeceraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SR_DevolucionCabeceraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_DevolucionCabeceraBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SR_DevolucionCabeceraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_DevolucionCabeceraBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SR_DevolucionCabeceraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_DevolucionCabId )
    {
        if( is_null( $i_DevolucionCabId ) ){ $i_DevolucionCabId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionCabecera ";
        $s_SQLQuery .= "WHERE DevolucionCabId = ".$i_DevolucionCabId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_DevolucionCabeceraBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_DevolucionCabeceraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_DevolucionCabeceraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getDevolucionCabId() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.DevolucionCabId = ".$this->getDevolucionCabId()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getOrdenId() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.OrdenId = ".$this->getOrdenId()." AND ";
        if ( !is_null( $this->getParentId() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.ParentId = ".$this->getParentId()." AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.Tipo = '".$this->getTipo()."' AND ";
        if ( !is_null( $this->getTransGuiaSerie() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.TransGuiaSerie = '".$this->getTransGuiaSerie()."' AND ";
        if ( !is_null( $this->getTransGuiaNumero() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.TransGuiaNumero = '".$this->getTransGuiaNumero()."' AND ";
        if ( !is_null( $this->getObraGuiaSerie() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.ObraGuiaSerie = '".$this->getObraGuiaSerie()."' AND ";
        if ( !is_null( $this->getObraGuiaNumero() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.ObraGuiaNumero = '".$this->getObraGuiaNumero()."' AND ";
        if ( !is_null( $this->getObservaciones() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.Observaciones = '".$this->getObservaciones()."' AND ";
        if ( !is_null( $this->getFechaInicioAlq() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.FechaInicioAlq = '".$this->getFechaInicioAlq()."' AND ";
        if ( !is_null( $this->getFechaDevolucion() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.FechaDevolucion = '".$this->getFechaDevolucion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getEstadoCorte() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.EstadoCorte = '".$this->getEstadoCorte()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SR_DevolucionCabecera.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_DevolucionCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_DevolucionCabeceraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_DevolucionCabeceraBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_DevolucionCabeceraBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_DevolucionCabeceraBN[] = $o_SR_DevolucionCabeceraBN;
            }
        }
        return $a_SR_DevolucionCabeceraBN;
    }

    /* Devuelve un objeto SR_DevolucionCabeceraBN desde un objeto propel */
    public function insertObjectBN( $a_SR_DevolucionCabecera )
    {
        $o_SR_DevolucionCabeceraBN = new SR_DevolucionCabeceraBN();
        if ( !is_null( $a_SR_DevolucionCabecera['DevolucionCabId'] ) ) $o_SR_DevolucionCabeceraBN->setDevolucionCabId( ( integer ) $a_SR_DevolucionCabecera['DevolucionCabId'] );
        if ( !is_null( $a_SR_DevolucionCabecera['IdCompania'] ) ) $o_SR_DevolucionCabeceraBN->setIdCompania( ( integer ) $a_SR_DevolucionCabecera['IdCompania'] );
        if ( !is_null( $a_SR_DevolucionCabecera['IdSucursal'] ) ) $o_SR_DevolucionCabeceraBN->setIdSucursal( ( integer ) $a_SR_DevolucionCabecera['IdSucursal'] );
        if ( !is_null( $a_SR_DevolucionCabecera['IdProyecto'] ) ) $o_SR_DevolucionCabeceraBN->setIdProyecto( ( integer ) $a_SR_DevolucionCabecera['IdProyecto'] );
        if ( !is_null( $a_SR_DevolucionCabecera['OrdenId'] ) ) $o_SR_DevolucionCabeceraBN->setOrdenId( ( integer ) $a_SR_DevolucionCabecera['OrdenId'] );
        if ( !is_null( $a_SR_DevolucionCabecera['ParentId'] ) ) $o_SR_DevolucionCabeceraBN->setParentId( ( integer ) $a_SR_DevolucionCabecera['ParentId'] );
        if ( !is_null( $a_SR_DevolucionCabecera['Tipo'] ) ) $o_SR_DevolucionCabeceraBN->setTipo( $a_SR_DevolucionCabecera['Tipo'] );
        if ( !is_null( $a_SR_DevolucionCabecera['TransGuiaSerie'] ) ) $o_SR_DevolucionCabeceraBN->setTransGuiaSerie( $a_SR_DevolucionCabecera['TransGuiaSerie'] );
        if ( !is_null( $a_SR_DevolucionCabecera['TransGuiaNumero'] ) ) $o_SR_DevolucionCabeceraBN->setTransGuiaNumero( $a_SR_DevolucionCabecera['TransGuiaNumero'] );
        if ( !is_null( $a_SR_DevolucionCabecera['ObraGuiaSerie'] ) ) $o_SR_DevolucionCabeceraBN->setObraGuiaSerie( $a_SR_DevolucionCabecera['ObraGuiaSerie'] );
        if ( !is_null( $a_SR_DevolucionCabecera['ObraGuiaNumero'] ) ) $o_SR_DevolucionCabeceraBN->setObraGuiaNumero( $a_SR_DevolucionCabecera['ObraGuiaNumero'] );
        if ( !is_null( $a_SR_DevolucionCabecera['Observaciones'] ) ) $o_SR_DevolucionCabeceraBN->setObservaciones( $a_SR_DevolucionCabecera['Observaciones'] );
        if ( !is_null( $a_SR_DevolucionCabecera['FechaInicioAlq'] ) ) $o_SR_DevolucionCabeceraBN->setFechaInicioAlq( utilTimestamp::getTimestamp( $a_SR_DevolucionCabecera['FechaInicioAlq'], "Y-m-d" ) );
        if ( !is_null( $a_SR_DevolucionCabecera['FechaDevolucion'] ) ) $o_SR_DevolucionCabeceraBN->setFechaDevolucion( utilTimestamp::getTimestamp( $a_SR_DevolucionCabecera['FechaDevolucion'], "Y-m-d" ) );
        if ( !is_null( $a_SR_DevolucionCabecera['Estado'] ) ) $o_SR_DevolucionCabeceraBN->setEstado( $a_SR_DevolucionCabecera['Estado'] );
        if ( !is_null( $a_SR_DevolucionCabecera['EstadoCorte'] ) ) $o_SR_DevolucionCabeceraBN->setEstadoCorte( $a_SR_DevolucionCabecera['EstadoCorte'] );
        if ( !is_null( $a_SR_DevolucionCabecera['FechaCreacion'] ) ) $o_SR_DevolucionCabeceraBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SR_DevolucionCabecera['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_DevolucionCabecera['UsuarioCreacion'] ) ) $o_SR_DevolucionCabeceraBN->setUsuarioCreacion( $a_SR_DevolucionCabecera['UsuarioCreacion'] );
        if ( !is_null( $a_SR_DevolucionCabecera['FechaModificacion'] ) ) $o_SR_DevolucionCabeceraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SR_DevolucionCabecera['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_DevolucionCabecera['UsuarioModificacion'] ) ) $o_SR_DevolucionCabeceraBN->setUsuarioModificacion( $a_SR_DevolucionCabecera['UsuarioModificacion'] );
        return $o_SR_DevolucionCabeceraBN;
    }
}
?>