<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_CotizacionDevolucionCab.xml */
/* Generado: 2021-06-26 00:00:01 */

/* Busqueda de registros de la tabla SR_CotizacionDevolucionCab. */
abstract class BaseSR_CotizacionDevolucionCabFN extends SR_CotizacionDevolucionCabBN
{
    /* Declaracion de constantes */
    const CotiDevolucionId = "SR_CotizacionDevolucionCab.CotiDevolucionId";
    const IdProyecto = "SR_CotizacionDevolucionCab.IdProyecto";
    const NumeroDocumento = "SR_CotizacionDevolucionCab.NumeroDocumento";
    const OrdenId = "SR_CotizacionDevolucionCab.OrdenId";
    const OrdenTipoComercialId = "SR_CotizacionDevolucionCab.OrdenTipoComercialId";
    const OrdenTipoClasificacionId = "SR_CotizacionDevolucionCab.OrdenTipoClasificacionId";
    const IdItem = "SR_CotizacionDevolucionCab.IdItem";
    const IdUnidad = "SR_CotizacionDevolucionCab.IdUnidad";
    const ItemDescripcion = "SR_CotizacionDevolucionCab.ItemDescripcion";
    const ContadorGuia = "SR_CotizacionDevolucionCab.ContadorGuia";
    const CantidadPedida = "SR_CotizacionDevolucionCab.CantidadPedida";
    const CantidadDevuelto = "SR_CotizacionDevolucionCab.CantidadDevuelto";
    const FechaCreacion = "SR_CotizacionDevolucionCab.FechaCreacion";
    const UsuarioCreacion = "SR_CotizacionDevolucionCab.UsuarioCreacion";
    const FechaModificacion = "SR_CotizacionDevolucionCab.FechaModificacion";
    const UsuarioModificacion = "SR_CotizacionDevolucionCab.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_CotizacionDevolucionCab.CotiDevolucionId AS CotiDevolucionId, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.NumeroDocumento AS NumeroDocumento, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.OrdenId AS OrdenId, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.OrdenTipoComercialId AS OrdenTipoComercialId, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.OrdenTipoClasificacionId AS OrdenTipoClasificacionId, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.IdItem AS IdItem, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.ItemDescripcion AS ItemDescripcion, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.ContadorGuia AS ContadorGuia, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.CantidadPedida AS CantidadPedida, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.CantidadDevuelto AS CantidadDevuelto, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SR_CotizacionDevolucionCab.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_CotizacionDevolucionCabBN */
    public function setByBN( SR_CotizacionDevolucionCabBN $o_SR_CotizacionDevolucionCabBN )
    {
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getCotiDevolucionId() ) )
        {
            $this->setCotiDevolucionId( $o_SR_CotizacionDevolucionCabBN->getCotiDevolucionId() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_SR_CotizacionDevolucionCabBN->getIdProyecto() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getNumeroDocumento() ) )
        {
            $this->setNumeroDocumento( $o_SR_CotizacionDevolucionCabBN->getNumeroDocumento() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_SR_CotizacionDevolucionCabBN->getOrdenId() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getOrdenTipoComercialId() ) )
        {
            $this->setOrdenTipoComercialId( $o_SR_CotizacionDevolucionCabBN->getOrdenTipoComercialId() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getOrdenTipoClasificacionId() ) )
        {
            $this->setOrdenTipoClasificacionId( $o_SR_CotizacionDevolucionCabBN->getOrdenTipoClasificacionId() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getIdItem() ) )
        {
            $this->setIdItem( $o_SR_CotizacionDevolucionCabBN->getIdItem() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_SR_CotizacionDevolucionCabBN->getIdUnidad() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getItemDescripcion() ) )
        {
            $this->setItemDescripcion( $o_SR_CotizacionDevolucionCabBN->getItemDescripcion() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getContadorGuia() ) )
        {
            $this->setContadorGuia( $o_SR_CotizacionDevolucionCabBN->getContadorGuia() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getCantidadPedida() ) )
        {
            $this->setCantidadPedida( $o_SR_CotizacionDevolucionCabBN->getCantidadPedida() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getCantidadDevuelto() ) )
        {
            $this->setCantidadDevuelto( $o_SR_CotizacionDevolucionCabBN->getCantidadDevuelto() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SR_CotizacionDevolucionCabBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SR_CotizacionDevolucionCabBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_CotizacionDevolucionCabBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SR_CotizacionDevolucionCabBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_CotizacionDevolucionCabBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SR_CotizacionDevolucionCabBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_CotiDevolucionId )
    {
        if( is_null( $i_CotiDevolucionId ) ){ $i_CotiDevolucionId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_CotizacionDevolucionCab ";
        $s_SQLQuery .= "WHERE CotiDevolucionId = ".$i_CotiDevolucionId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_CotizacionDevolucionCabBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_CotizacionDevolucionCabBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_CotizacionDevolucionCabBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getCotiDevolucionId() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.CotiDevolucionId = ".$this->getCotiDevolucionId()." AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getNumeroDocumento() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.NumeroDocumento = '".$this->getNumeroDocumento()."' AND ";
        if ( !is_null( $this->getOrdenId() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.OrdenId = ".$this->getOrdenId()." AND ";
        if ( !is_null( $this->getOrdenTipoComercialId() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.OrdenTipoComercialId = ".$this->getOrdenTipoComercialId()." AND ";
        if ( !is_null( $this->getOrdenTipoClasificacionId() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.OrdenTipoClasificacionId = ".$this->getOrdenTipoClasificacionId()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.IdUnidad = ".$this->getIdUnidad()." AND ";
        if ( !is_null( $this->getItemDescripcion() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.ItemDescripcion = '".$this->getItemDescripcion()."' AND ";
        if ( !is_null( $this->getContadorGuia() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.ContadorGuia = ".$this->getContadorGuia()." AND ";
        if ( !is_null( $this->getCantidadPedida() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.CantidadPedida = ".$this->getCantidadPedida()." AND ";
        if ( !is_null( $this->getCantidadDevuelto() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.CantidadDevuelto = ".$this->getCantidadDevuelto()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SR_CotizacionDevolucionCab.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_CotizacionDevolucionCab WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_CotizacionDevolucionCabBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_CotizacionDevolucionCab WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_CotizacionDevolucionCabBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_CotizacionDevolucionCabBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_CotizacionDevolucionCabBN[] = $o_SR_CotizacionDevolucionCabBN;
            }
        }
        return $a_SR_CotizacionDevolucionCabBN;
    }

    /* Devuelve un objeto SR_CotizacionDevolucionCabBN desde un objeto propel */
    public function insertObjectBN( $a_SR_CotizacionDevolucionCab )
    {
        $o_SR_CotizacionDevolucionCabBN = new SR_CotizacionDevolucionCabBN();
        if ( !is_null( $a_SR_CotizacionDevolucionCab['CotiDevolucionId'] ) ) $o_SR_CotizacionDevolucionCabBN->setCotiDevolucionId( ( integer ) $a_SR_CotizacionDevolucionCab['CotiDevolucionId'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['IdProyecto'] ) ) $o_SR_CotizacionDevolucionCabBN->setIdProyecto( ( integer ) $a_SR_CotizacionDevolucionCab['IdProyecto'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['NumeroDocumento'] ) ) $o_SR_CotizacionDevolucionCabBN->setNumeroDocumento( $a_SR_CotizacionDevolucionCab['NumeroDocumento'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['OrdenId'] ) ) $o_SR_CotizacionDevolucionCabBN->setOrdenId( ( integer ) $a_SR_CotizacionDevolucionCab['OrdenId'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['OrdenTipoComercialId'] ) ) $o_SR_CotizacionDevolucionCabBN->setOrdenTipoComercialId( ( integer ) $a_SR_CotizacionDevolucionCab['OrdenTipoComercialId'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['OrdenTipoClasificacionId'] ) ) $o_SR_CotizacionDevolucionCabBN->setOrdenTipoClasificacionId( ( integer ) $a_SR_CotizacionDevolucionCab['OrdenTipoClasificacionId'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['IdItem'] ) ) $o_SR_CotizacionDevolucionCabBN->setIdItem( $a_SR_CotizacionDevolucionCab['IdItem'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['IdUnidad'] ) ) $o_SR_CotizacionDevolucionCabBN->setIdUnidad( ( integer ) $a_SR_CotizacionDevolucionCab['IdUnidad'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['ItemDescripcion'] ) ) $o_SR_CotizacionDevolucionCabBN->setItemDescripcion( $a_SR_CotizacionDevolucionCab['ItemDescripcion'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['ContadorGuia'] ) ) $o_SR_CotizacionDevolucionCabBN->setContadorGuia( ( integer ) $a_SR_CotizacionDevolucionCab['ContadorGuia'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['CantidadPedida'] ) ) $o_SR_CotizacionDevolucionCabBN->setCantidadPedida( ( float ) $a_SR_CotizacionDevolucionCab['CantidadPedida'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['CantidadDevuelto'] ) ) $o_SR_CotizacionDevolucionCabBN->setCantidadDevuelto( ( float ) $a_SR_CotizacionDevolucionCab['CantidadDevuelto'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['FechaCreacion'] ) ) $o_SR_CotizacionDevolucionCabBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SR_CotizacionDevolucionCab['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['UsuarioCreacion'] ) ) $o_SR_CotizacionDevolucionCabBN->setUsuarioCreacion( $a_SR_CotizacionDevolucionCab['UsuarioCreacion'] );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['FechaModificacion'] ) ) $o_SR_CotizacionDevolucionCabBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SR_CotizacionDevolucionCab['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_CotizacionDevolucionCab['UsuarioModificacion'] ) ) $o_SR_CotizacionDevolucionCabBN->setUsuarioModificacion( $a_SR_CotizacionDevolucionCab['UsuarioModificacion'] );
        return $o_SR_CotizacionDevolucionCabBN;
    }
}
?>