<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_UsuarioSesion.xml */
/* Generado: 2021-06-26 00:00:00 */

/* Busqueda de registros de la tabla SEG_UsuarioSesion. */
abstract class BaseSEG_UsuarioSesionFN extends SEG_UsuarioSesionBN
{
    /* Declaracion de constantes */
    const Id = "SEG_UsuarioSesion.Id";
    const IP = "SEG_UsuarioSesion.IP";
    const IdRol = "SEG_UsuarioSesion.IdRol";
    const IdUsuario = "SEG_UsuarioSesion.IdUsuario";
    const FechaCreacion = "SEG_UsuarioSesion.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_UsuarioSesion.Id AS Id, ";
        $s_SQLQuery .= "SEG_UsuarioSesion.IP AS IP, ";
        $s_SQLQuery .= "SEG_UsuarioSesion.IdRol AS IdRol, ";
        $s_SQLQuery .= "SEG_UsuarioSesion.IdUsuario AS IdUsuario, ";
        $s_SQLQuery .= "SEG_UsuarioSesion.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_UsuarioSesionBN */
    public function setByBN( SEG_UsuarioSesionBN $o_SEG_UsuarioSesionBN )
    {
        if ( !is_null( $o_SEG_UsuarioSesionBN->getId() ) )
        {
            $this->setId( $o_SEG_UsuarioSesionBN->getId() );
        }
        if ( !is_null( $o_SEG_UsuarioSesionBN->getIP() ) )
        {
            $this->setIP( $o_SEG_UsuarioSesionBN->getIP() );
        }
        if ( !is_null( $o_SEG_UsuarioSesionBN->getIdRol() ) )
        {
            $this->setIdRol( $o_SEG_UsuarioSesionBN->getIdRol() );
        }
        if ( !is_null( $o_SEG_UsuarioSesionBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_SEG_UsuarioSesionBN->getIdUsuario() );
        }
        if ( !is_null( $o_SEG_UsuarioSesionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_UsuarioSesionBN->getFechaCreacion() );
        }
    }

    /**
    * @return SEG_UsuarioSesionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_Id )
    {
        if( is_null( $i_Id ) ){ $i_Id = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_UsuarioSesion ";
        $s_SQLQuery .= "WHERE Id = ".$i_Id." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SEG_UsuarioSesionBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_UsuarioSesionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_UsuarioSesionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getId() ) ) $s_SQLQuery .= "SEG_UsuarioSesion.Id = ".$this->getId()." AND ";
        if ( !is_null( $this->getIP() ) ) $s_SQLQuery .= "SEG_UsuarioSesion.IP = '".$this->getIP()."' AND ";
        if ( !is_null( $this->getIdRol() ) ) $s_SQLQuery .= "SEG_UsuarioSesion.IdRol = '".$this->getIdRol()."' AND ";
        if ( !is_null( $this->getIdUsuario() ) ) $s_SQLQuery .= "SEG_UsuarioSesion.IdUsuario = '".$this->getIdUsuario()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_UsuarioSesion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_UsuarioSesion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_UsuarioSesionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_UsuarioSesion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SEG_UsuarioSesionBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_UsuarioSesionBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_UsuarioSesionBN[] = $o_SEG_UsuarioSesionBN;
            }
        }
        return $a_SEG_UsuarioSesionBN;
    }

    /* Devuelve un objeto SEG_UsuarioSesionBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_UsuarioSesion )
    {
        $o_SEG_UsuarioSesionBN = new SEG_UsuarioSesionBN();
        if ( !is_null( $a_SEG_UsuarioSesion['Id'] ) ) $o_SEG_UsuarioSesionBN->setId( ( integer ) $a_SEG_UsuarioSesion['Id'] );
        if ( !is_null( $a_SEG_UsuarioSesion['IP'] ) ) $o_SEG_UsuarioSesionBN->setIP( $a_SEG_UsuarioSesion['IP'] );
        if ( !is_null( $a_SEG_UsuarioSesion['IdRol'] ) ) $o_SEG_UsuarioSesionBN->setIdRol( $a_SEG_UsuarioSesion['IdRol'] );
        if ( !is_null( $a_SEG_UsuarioSesion['IdUsuario'] ) ) $o_SEG_UsuarioSesionBN->setIdUsuario( $a_SEG_UsuarioSesion['IdUsuario'] );
        if ( !is_null( $a_SEG_UsuarioSesion['FechaCreacion'] ) ) $o_SEG_UsuarioSesionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_UsuarioSesion['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_SEG_UsuarioSesionBN;
    }
}
?>