<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Usuario.xml */
/* Generado: 2022-01-25 15:46:04 */

/* Busqueda de registros de la tabla SEG_Usuario. */
abstract class BaseSEG_UsuarioFN extends SEG_UsuarioBN
{
    /* Declaracion de constantes */
    const IdUsuario = "SEG_Usuario.IdUsuario";
    const IdCompania = "SEG_Usuario.IdCompania";
    const IdRol = "SEG_Usuario.IdRol";
    const UsuarioNombre = "SEG_Usuario.UsuarioNombre";
    const UsuarioPassword = "SEG_Usuario.UsuarioPassword";
    const UsuarioContrasenia = "SEG_Usuario.UsuarioContrasenia";
    const FechaCambioPwd = "SEG_Usuario.FechaCambioPwd";
    const HoraCambioPwd = "SEG_Usuario.HoraCambioPwd";
    const PermisoAdPwd = "SEG_Usuario.PermisoAdPwd";
    const ContadorPwd = "SEG_Usuario.ContadorPwd";
    const EnUso = "SEG_Usuario.EnUso";
    const DeshabilitadoFlg = "SEG_Usuario.DeshabilitadoFlg";
    const LogonFecha = "SEG_Usuario.LogonFecha";
    const LogonHora = "SEG_Usuario.LogonHora";
    const Idioma = "SEG_Usuario.Idioma";
    const InicioFecha = "SEG_Usuario.InicioFecha";
    const FinFecha = "SEG_Usuario.FinFecha";
    const DireccionIP = "SEG_Usuario.DireccionIP";
    const UsuarioImagen = "SEG_Usuario.UsuarioImagen";
    const Correo = "SEG_Usuario.Correo";
    const FechaCreacion = "SEG_Usuario.FechaCreacion";
    const UsuarioCreacion = "SEG_Usuario.UsuarioCreacion";
    const FechaModificacion = "SEG_Usuario.FechaModificacion";
    const UsuarioModificacion = "SEG_Usuario.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_Usuario.IdUsuario AS IdUsuario, ";
        $s_SQLQuery .= "SEG_Usuario.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SEG_Usuario.IdRol AS IdRol, ";
        $s_SQLQuery .= "SEG_Usuario.UsuarioNombre AS UsuarioNombre, ";
        $s_SQLQuery .= "SEG_Usuario.UsuarioPassword AS UsuarioPassword, ";
        $s_SQLQuery .= "SEG_Usuario.UsuarioContrasenia AS UsuarioContrasenia, ";
        $s_SQLQuery .= "SEG_Usuario.FechaCambioPwd AS FechaCambioPwd, ";
        $s_SQLQuery .= "SEG_Usuario.HoraCambioPwd AS HoraCambioPwd, ";
        $s_SQLQuery .= "SEG_Usuario.PermisoAdPwd AS PermisoAdPwd, ";
        $s_SQLQuery .= "SEG_Usuario.ContadorPwd AS ContadorPwd, ";
        $s_SQLQuery .= "SEG_Usuario.EnUso AS EnUso, ";
        $s_SQLQuery .= "SEG_Usuario.DeshabilitadoFlg AS DeshabilitadoFlg, ";
        $s_SQLQuery .= "SEG_Usuario.LogonFecha AS LogonFecha, ";
        $s_SQLQuery .= "SEG_Usuario.LogonHora AS LogonHora, ";
        $s_SQLQuery .= "SEG_Usuario.Idioma AS Idioma, ";
        $s_SQLQuery .= "SEG_Usuario.InicioFecha AS InicioFecha, ";
        $s_SQLQuery .= "SEG_Usuario.FinFecha AS FinFecha, ";
        $s_SQLQuery .= "SEG_Usuario.DireccionIP AS DireccionIP, ";
        $s_SQLQuery .= "SEG_Usuario.UsuarioImagen AS UsuarioImagen, ";
        $s_SQLQuery .= "SEG_Usuario.Correo AS Correo, ";
        $s_SQLQuery .= "SEG_Usuario.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_Usuario.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_Usuario.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_Usuario.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_UsuarioBN */
    public function setByBN( SEG_UsuarioBN $o_SEG_UsuarioBN )
    {
        if ( !is_null( $o_SEG_UsuarioBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_SEG_UsuarioBN->getIdUsuario() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SEG_UsuarioBN->getIdCompania() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getIdRol() ) )
        {
            $this->setIdRol( $o_SEG_UsuarioBN->getIdRol() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getUsuarioNombre() ) )
        {
            $this->setUsuarioNombre( $o_SEG_UsuarioBN->getUsuarioNombre() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getUsuarioPassword() ) )
        {
            $this->setUsuarioPassword( $o_SEG_UsuarioBN->getUsuarioPassword() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getUsuarioContrasenia() ) )
        {
            $this->setUsuarioContrasenia( $o_SEG_UsuarioBN->getUsuarioContrasenia() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getFechaCambioPwd() ) )
        {
            $this->setFechaCambioPwd( $o_SEG_UsuarioBN->getFechaCambioPwd() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getHoraCambioPwd() ) )
        {
            $this->setHoraCambioPwd( $o_SEG_UsuarioBN->getHoraCambioPwd() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getPermisoAdPwd() ) )
        {
            $this->setPermisoAdPwd( $o_SEG_UsuarioBN->getPermisoAdPwd() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getContadorPwd() ) )
        {
            $this->setContadorPwd( $o_SEG_UsuarioBN->getContadorPwd() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getEnUso() ) )
        {
            $this->setEnUso( $o_SEG_UsuarioBN->getEnUso() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getDeshabilitadoFlg() ) )
        {
            $this->setDeshabilitadoFlg( $o_SEG_UsuarioBN->getDeshabilitadoFlg() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getLogonFecha() ) )
        {
            $this->setLogonFecha( $o_SEG_UsuarioBN->getLogonFecha() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getLogonHora() ) )
        {
            $this->setLogonHora( $o_SEG_UsuarioBN->getLogonHora() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getIdioma() ) )
        {
            $this->setIdioma( $o_SEG_UsuarioBN->getIdioma() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getInicioFecha() ) )
        {
            $this->setInicioFecha( $o_SEG_UsuarioBN->getInicioFecha() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getFinFecha() ) )
        {
            $this->setFinFecha( $o_SEG_UsuarioBN->getFinFecha() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getDireccionIP() ) )
        {
            $this->setDireccionIP( $o_SEG_UsuarioBN->getDireccionIP() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getUsuarioImagen() ) )
        {
            $this->setUsuarioImagen( $o_SEG_UsuarioBN->getUsuarioImagen() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getCorreo() ) )
        {
            $this->setCorreo( $o_SEG_UsuarioBN->getCorreo() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_UsuarioBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_UsuarioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_UsuarioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_UsuarioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_UsuarioBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_UsuarioBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdUsuario )
    {
        if( is_null( $s_IdUsuario ) ){ $s_IdUsuario = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Usuario ";
        $s_SQLQuery .= "WHERE IdUsuario = '".$s_IdUsuario."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SEG_UsuarioBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_UsuarioBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_UsuarioBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdUsuario() ) ) $s_SQLQuery .= "SEG_Usuario.IdUsuario = '".$this->getIdUsuario()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SEG_Usuario.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdRol() ) ) $s_SQLQuery .= "SEG_Usuario.IdRol = '".$this->getIdRol()."' AND ";
        if ( !is_null( $this->getUsuarioNombre() ) ) $s_SQLQuery .= "SEG_Usuario.UsuarioNombre = '".$this->getUsuarioNombre()."' AND ";
        if ( !is_null( $this->getUsuarioPassword() ) ) $s_SQLQuery .= "SEG_Usuario.UsuarioPassword = '".$this->getUsuarioPassword()."' AND ";
        if ( !is_null( $this->getUsuarioContrasenia() ) ) $s_SQLQuery .= "SEG_Usuario.UsuarioContrasenia = '".$this->getUsuarioContrasenia()."' AND ";
        if ( !is_null( $this->getFechaCambioPwd() ) ) $s_SQLQuery .= "SEG_Usuario.FechaCambioPwd = '".$this->getFechaCambioPwd()."' AND ";
        if ( !is_null( $this->getHoraCambioPwd() ) ) $s_SQLQuery .= "SEG_Usuario.HoraCambioPwd = '".$this->getHoraCambioPwd()."' AND ";
        if ( !is_null( $this->getPermisoAdPwd() ) ) $s_SQLQuery .= "SEG_Usuario.PermisoAdPwd = ".$this->getPermisoAdPwd()." AND ";
        if ( !is_null( $this->getContadorPwd() ) ) $s_SQLQuery .= "SEG_Usuario.ContadorPwd = ".$this->getContadorPwd()." AND ";
        if ( !is_null( $this->getEnUso() ) ) $s_SQLQuery .= "SEG_Usuario.EnUso = '".$this->getEnUso()."' AND ";
        if ( !is_null( $this->getDeshabilitadoFlg() ) ) $s_SQLQuery .= "SEG_Usuario.DeshabilitadoFlg = '".$this->getDeshabilitadoFlg()."' AND ";
        if ( !is_null( $this->getLogonFecha() ) ) $s_SQLQuery .= "SEG_Usuario.LogonFecha = '".$this->getLogonFecha()."' AND ";
        if ( !is_null( $this->getLogonHora() ) ) $s_SQLQuery .= "SEG_Usuario.LogonHora = '".$this->getLogonHora()."' AND ";
        if ( !is_null( $this->getIdioma() ) ) $s_SQLQuery .= "SEG_Usuario.Idioma = '".$this->getIdioma()."' AND ";
        if ( !is_null( $this->getInicioFecha() ) ) $s_SQLQuery .= "SEG_Usuario.InicioFecha = '".$this->getInicioFecha()."' AND ";
        if ( !is_null( $this->getFinFecha() ) ) $s_SQLQuery .= "SEG_Usuario.FinFecha = '".$this->getFinFecha()."' AND ";
        if ( !is_null( $this->getDireccionIP() ) ) $s_SQLQuery .= "SEG_Usuario.DireccionIP = '".$this->getDireccionIP()."' AND ";
        if ( !is_null( $this->getUsuarioImagen() ) ) $s_SQLQuery .= "SEG_Usuario.UsuarioImagen = '".$this->getUsuarioImagen()."' AND ";
        if ( !is_null( $this->getCorreo() ) ) $s_SQLQuery .= "SEG_Usuario.Correo = '".$this->getCorreo()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_Usuario.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_Usuario.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_Usuario.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_Usuario.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_Usuario WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_UsuarioBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Usuario WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SEG_UsuarioBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_UsuarioBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_UsuarioBN[] = $o_SEG_UsuarioBN;
            }
        }
        return $a_SEG_UsuarioBN;
    }

    /* Devuelve un objeto SEG_UsuarioBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_Usuario )
    {
        $o_SEG_UsuarioBN = new SEG_UsuarioBN();
        if ( !is_null( $a_SEG_Usuario['IdUsuario'] ) ) $o_SEG_UsuarioBN->setIdUsuario( $a_SEG_Usuario['IdUsuario'] );
        if ( !is_null( $a_SEG_Usuario['IdCompania'] ) ) $o_SEG_UsuarioBN->setIdCompania( ( integer ) $a_SEG_Usuario['IdCompania'] );
        if ( !is_null( $a_SEG_Usuario['IdRol'] ) ) $o_SEG_UsuarioBN->setIdRol( $a_SEG_Usuario['IdRol'] );
        if ( !is_null( $a_SEG_Usuario['UsuarioNombre'] ) ) $o_SEG_UsuarioBN->setUsuarioNombre( $a_SEG_Usuario['UsuarioNombre'] );
        if ( !is_null( $a_SEG_Usuario['UsuarioPassword'] ) ) $o_SEG_UsuarioBN->setUsuarioPassword( $a_SEG_Usuario['UsuarioPassword'] );
        if ( !is_null( $a_SEG_Usuario['UsuarioContrasenia'] ) ) $o_SEG_UsuarioBN->setUsuarioContrasenia( $a_SEG_Usuario['UsuarioContrasenia'] );
        if ( !is_null( $a_SEG_Usuario['FechaCambioPwd'] ) ) $o_SEG_UsuarioBN->setFechaCambioPwd( utilTimestamp::getTimestamp( $a_SEG_Usuario['FechaCambioPwd'], "Y-m-d" ) );
        if ( !is_null( $a_SEG_Usuario['HoraCambioPwd'] ) ) $o_SEG_UsuarioBN->setHoraCambioPwd( utilTimestamp::getTimestamp( $a_SEG_Usuario['HoraCambioPwd'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Usuario['PermisoAdPwd'] ) ) $o_SEG_UsuarioBN->setPermisoAdPwd( ( integer ) $a_SEG_Usuario['PermisoAdPwd'] );
        if ( !is_null( $a_SEG_Usuario['ContadorPwd'] ) ) $o_SEG_UsuarioBN->setContadorPwd( ( integer ) $a_SEG_Usuario['ContadorPwd'] );
        if ( !is_null( $a_SEG_Usuario['EnUso'] ) ) $o_SEG_UsuarioBN->setEnUso( $a_SEG_Usuario['EnUso'] );
        if ( !is_null( $a_SEG_Usuario['DeshabilitadoFlg'] ) ) $o_SEG_UsuarioBN->setDeshabilitadoFlg( $a_SEG_Usuario['DeshabilitadoFlg'] );
        if ( !is_null( $a_SEG_Usuario['LogonFecha'] ) ) $o_SEG_UsuarioBN->setLogonFecha( utilTimestamp::getTimestamp( $a_SEG_Usuario['LogonFecha'], "Y-m-d" ) );
        if ( !is_null( $a_SEG_Usuario['LogonHora'] ) ) $o_SEG_UsuarioBN->setLogonHora( utilTimestamp::getTimestamp( $a_SEG_Usuario['LogonHora'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Usuario['Idioma'] ) ) $o_SEG_UsuarioBN->setIdioma( $a_SEG_Usuario['Idioma'] );
        if ( !is_null( $a_SEG_Usuario['InicioFecha'] ) ) $o_SEG_UsuarioBN->setInicioFecha( utilTimestamp::getTimestamp( $a_SEG_Usuario['InicioFecha'], "Y-m-d" ) );
        if ( !is_null( $a_SEG_Usuario['FinFecha'] ) ) $o_SEG_UsuarioBN->setFinFecha( utilTimestamp::getTimestamp( $a_SEG_Usuario['FinFecha'], "Y-m-d" ) );
        if ( !is_null( $a_SEG_Usuario['DireccionIP'] ) ) $o_SEG_UsuarioBN->setDireccionIP( $a_SEG_Usuario['DireccionIP'] );
        if ( !is_null( $a_SEG_Usuario['UsuarioImagen'] ) ) $o_SEG_UsuarioBN->setUsuarioImagen( $a_SEG_Usuario['UsuarioImagen'] );
        if ( !is_null( $a_SEG_Usuario['Correo'] ) ) $o_SEG_UsuarioBN->setCorreo( $a_SEG_Usuario['Correo'] );
        if ( !is_null( $a_SEG_Usuario['FechaCreacion'] ) ) $o_SEG_UsuarioBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_Usuario['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Usuario['UsuarioCreacion'] ) ) $o_SEG_UsuarioBN->setUsuarioCreacion( $a_SEG_Usuario['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_Usuario['FechaModificacion'] ) ) $o_SEG_UsuarioBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_Usuario['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Usuario['UsuarioModificacion'] ) ) $o_SEG_UsuarioBN->setUsuarioModificacion( $a_SEG_Usuario['UsuarioModificacion'] );
        return $o_SEG_UsuarioBN;
    }
}
?>