<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Menu_bk.xml */
/* Generado: 2021-06-25 23:59:58 */

/* Busqueda de registros de la tabla SEG_Menu_bk. */
abstract class BaseSEG_Menu_bkFN extends SEG_Menu_bkBN
{
    /* Declaracion de constantes */
    const IdMenu = "SEG_Menu_bk.IdMenu";
    const IdTareaHijo = "SEG_Menu_bk.IdTareaHijo";
    const Secuencia = "SEG_Menu_bk.Secuencia";
    const BotonTexto = "SEG_Menu_bk.BotonTexto";
    const Estado = "SEG_Menu_bk.Estado";
    const FechaCreacion = "SEG_Menu_bk.FechaCreacion";
    const UsuarioCreacion = "SEG_Menu_bk.UsuarioCreacion";
    const FechaModificacion = "SEG_Menu_bk.FechaModificacion";
    const UsuarioModificacion = "SEG_Menu_bk.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_Menu_bk.IdMenu AS IdMenu, ";
        $s_SQLQuery .= "SEG_Menu_bk.IdTareaHijo AS IdTareaHijo, ";
        $s_SQLQuery .= "SEG_Menu_bk.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "SEG_Menu_bk.BotonTexto AS BotonTexto, ";
        $s_SQLQuery .= "SEG_Menu_bk.Estado AS Estado, ";
        $s_SQLQuery .= "SEG_Menu_bk.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_Menu_bk.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_Menu_bk.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_Menu_bk.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_Menu_bkBN */
    public function setByBN( SEG_Menu_bkBN $o_SEG_Menu_bkBN )
    {
        if ( !is_null( $o_SEG_Menu_bkBN->getIdMenu() ) )
        {
            $this->setIdMenu( $o_SEG_Menu_bkBN->getIdMenu() );
        }
        if ( !is_null( $o_SEG_Menu_bkBN->getIdTareaHijo() ) )
        {
            $this->setIdTareaHijo( $o_SEG_Menu_bkBN->getIdTareaHijo() );
        }
        if ( !is_null( $o_SEG_Menu_bkBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_SEG_Menu_bkBN->getSecuencia() );
        }
        if ( !is_null( $o_SEG_Menu_bkBN->getBotonTexto() ) )
        {
            $this->setBotonTexto( $o_SEG_Menu_bkBN->getBotonTexto() );
        }
        if ( !is_null( $o_SEG_Menu_bkBN->getEstado() ) )
        {
            $this->setEstado( $o_SEG_Menu_bkBN->getEstado() );
        }
        if ( !is_null( $o_SEG_Menu_bkBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_Menu_bkBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_Menu_bkBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_Menu_bkBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_Menu_bkBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_Menu_bkBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_Menu_bkBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_Menu_bkBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_Menu_bkBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdMenu, $s_IdTareaHijo )
    {
        if( is_null( $s_IdMenu ) ){ $s_IdMenu = '-1'; } 
        if( is_null( $s_IdTareaHijo ) ){ $s_IdTareaHijo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Menu_bk ";
        $s_SQLQuery .= "WHERE IdMenu = '".$s_IdMenu."' ";
        $s_SQLQuery .= "AND IdTareaHijo = '".$s_IdTareaHijo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SEG_Menu_bkBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_Menu_bkBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_Menu_bkBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdMenu() ) ) $s_SQLQuery .= "SEG_Menu_bk.IdMenu = '".$this->getIdMenu()."' AND ";
        if ( !is_null( $this->getIdTareaHijo() ) ) $s_SQLQuery .= "SEG_Menu_bk.IdTareaHijo = '".$this->getIdTareaHijo()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "SEG_Menu_bk.Secuencia = '".$this->getSecuencia()."' AND ";
        if ( !is_null( $this->getBotonTexto() ) ) $s_SQLQuery .= "SEG_Menu_bk.BotonTexto = '".$this->getBotonTexto()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SEG_Menu_bk.Estado = ".$this->getEstado()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_Menu_bk.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_Menu_bk.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_Menu_bk.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_Menu_bk.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_Menu_bk WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_Menu_bkBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Menu_bk WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SEG_Menu_bkBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_Menu_bkBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_Menu_bkBN[] = $o_SEG_Menu_bkBN;
            }
        }
        return $a_SEG_Menu_bkBN;
    }

    /* Devuelve un objeto SEG_Menu_bkBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_Menu_bk )
    {
        $o_SEG_Menu_bkBN = new SEG_Menu_bkBN();
        if ( !is_null( $a_SEG_Menu_bk['IdMenu'] ) ) $o_SEG_Menu_bkBN->setIdMenu( $a_SEG_Menu_bk['IdMenu'] );
        if ( !is_null( $a_SEG_Menu_bk['IdTareaHijo'] ) ) $o_SEG_Menu_bkBN->setIdTareaHijo( $a_SEG_Menu_bk['IdTareaHijo'] );
        if ( !is_null( $a_SEG_Menu_bk['Secuencia'] ) ) $o_SEG_Menu_bkBN->setSecuencia( $a_SEG_Menu_bk['Secuencia'] );
        if ( !is_null( $a_SEG_Menu_bk['BotonTexto'] ) ) $o_SEG_Menu_bkBN->setBotonTexto( $a_SEG_Menu_bk['BotonTexto'] );
        if ( !is_null( $a_SEG_Menu_bk['Estado'] ) ) $o_SEG_Menu_bkBN->setEstado( ( integer ) $a_SEG_Menu_bk['Estado'] );
        if ( !is_null( $a_SEG_Menu_bk['FechaCreacion'] ) ) $o_SEG_Menu_bkBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_Menu_bk['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Menu_bk['UsuarioCreacion'] ) ) $o_SEG_Menu_bkBN->setUsuarioCreacion( $a_SEG_Menu_bk['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_Menu_bk['FechaModificacion'] ) ) $o_SEG_Menu_bkBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_Menu_bk['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Menu_bk['UsuarioModificacion'] ) ) $o_SEG_Menu_bkBN->setUsuarioModificacion( $a_SEG_Menu_bk['UsuarioModificacion'] );
        return $o_SEG_Menu_bkBN;
    }
}
?>