<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_TipoGrupo.xml */
/* Generado: 2021-06-25 23:59:58 */

/* Busqueda de registros de la tabla PR_TipoGrupo. */
abstract class BasePR_TipoGrupoFN extends PR_TipoGrupoBN
{
    /* Declaracion de constantes */
    const IdPrTipoId = "PR_TipoGrupo.IdPrTipoId";
    const Nombre = "PR_TipoGrupo.Nombre";
    const PrefijoTipo = "PR_TipoGrupo.PrefijoTipo";
    const Secuencia = "PR_TipoGrupo.Secuencia";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PR_TipoGrupo.IdPrTipoId AS IdPrTipoId, ";
        $s_SQLQuery .= "PR_TipoGrupo.Nombre AS Nombre, ";
        $s_SQLQuery .= "PR_TipoGrupo.PrefijoTipo AS PrefijoTipo, ";
        $s_SQLQuery .= "PR_TipoGrupo.Secuencia AS Secuencia ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PR_TipoGrupoBN */
    public function setByBN( PR_TipoGrupoBN $o_PR_TipoGrupoBN )
    {
        if ( !is_null( $o_PR_TipoGrupoBN->getIdPrTipoId() ) )
        {
            $this->setIdPrTipoId( $o_PR_TipoGrupoBN->getIdPrTipoId() );
        }
        if ( !is_null( $o_PR_TipoGrupoBN->getNombre() ) )
        {
            $this->setNombre( $o_PR_TipoGrupoBN->getNombre() );
        }
        if ( !is_null( $o_PR_TipoGrupoBN->getPrefijoTipo() ) )
        {
            $this->setPrefijoTipo( $o_PR_TipoGrupoBN->getPrefijoTipo() );
        }
        if ( !is_null( $o_PR_TipoGrupoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_PR_TipoGrupoBN->getSecuencia() );
        }
    }

    /**
    * @return PR_TipoGrupoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdPrTipoId )
    {
        if( is_null( $s_IdPrTipoId ) ){ $s_IdPrTipoId = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PR_TipoGrupo ";
        $s_SQLQuery .= "WHERE IdPrTipoId = '".$s_IdPrTipoId."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PR_TipoGrupoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PR_TipoGrupoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PR_TipoGrupoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPrTipoId() ) ) $s_SQLQuery .= "PR_TipoGrupo.IdPrTipoId = '".$this->getIdPrTipoId()."' AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "PR_TipoGrupo.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getPrefijoTipo() ) ) $s_SQLQuery .= "PR_TipoGrupo.PrefijoTipo = '".$this->getPrefijoTipo()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "PR_TipoGrupo.Secuencia = '".$this->getSecuencia()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PR_TipoGrupo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PR_TipoGrupoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PR_TipoGrupo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PR_TipoGrupoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PR_TipoGrupoBN = $this->insertObjectBN( $a_SQLRow );
                $a_PR_TipoGrupoBN[] = $o_PR_TipoGrupoBN;
            }
        }
        return $a_PR_TipoGrupoBN;
    }

    /* Devuelve un objeto PR_TipoGrupoBN desde un objeto propel */
    public function insertObjectBN( $a_PR_TipoGrupo )
    {
        $o_PR_TipoGrupoBN = new PR_TipoGrupoBN();
        if ( !is_null( $a_PR_TipoGrupo['IdPrTipoId'] ) ) $o_PR_TipoGrupoBN->setIdPrTipoId( $a_PR_TipoGrupo['IdPrTipoId'] );
        if ( !is_null( $a_PR_TipoGrupo['Nombre'] ) ) $o_PR_TipoGrupoBN->setNombre( $a_PR_TipoGrupo['Nombre'] );
        if ( !is_null( $a_PR_TipoGrupo['PrefijoTipo'] ) ) $o_PR_TipoGrupoBN->setPrefijoTipo( $a_PR_TipoGrupo['PrefijoTipo'] );
        if ( !is_null( $a_PR_TipoGrupo['Secuencia'] ) ) $o_PR_TipoGrupoBN->setSecuencia( $a_PR_TipoGrupo['Secuencia'] );
        return $o_PR_TipoGrupoBN;
    }
}
?>