<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_ListaItem.xml */
/* Generado: 2021-06-25 23:59:58 */

/* Busqueda de registros de la tabla PR_ListaItem. */
abstract class BasePR_ListaItemFN extends PR_ListaItemBN
{
    /* Declaracion de constantes */
    const IdPrListaItem = "PR_ListaItem.IdPrListaItem";
    const IdPrGrupo = "PR_ListaItem.IdPrGrupo";
    const TipoPrecio = "PR_ListaItem.TipoPrecio";
    const IdItem = "PR_ListaItem.IdItem";
    const PrecioVenta = "PR_ListaItem.PrecioVenta";
    const PrecioDscto = "PR_ListaItem.PrecioDscto";
    const BufferDscto = "PR_ListaItem.BufferDscto";
    const UsuarioCreacion = "PR_ListaItem.UsuarioCreacion";
    const FechaCreacion = "PR_ListaItem.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PR_ListaItem.IdPrListaItem AS IdPrListaItem, ";
        $s_SQLQuery .= "PR_ListaItem.IdPrGrupo AS IdPrGrupo, ";
        $s_SQLQuery .= "PR_ListaItem.TipoPrecio AS TipoPrecio, ";
        $s_SQLQuery .= "PR_ListaItem.IdItem AS IdItem, ";
        $s_SQLQuery .= "PR_ListaItem.PrecioVenta AS PrecioVenta, ";
        $s_SQLQuery .= "PR_ListaItem.PrecioDscto AS PrecioDscto, ";
        $s_SQLQuery .= "PR_ListaItem.BufferDscto AS BufferDscto, ";
        $s_SQLQuery .= "PR_ListaItem.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "PR_ListaItem.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PR_ListaItemBN */
    public function setByBN( PR_ListaItemBN $o_PR_ListaItemBN )
    {
        if ( !is_null( $o_PR_ListaItemBN->getIdPrListaItem() ) )
        {
            $this->setIdPrListaItem( $o_PR_ListaItemBN->getIdPrListaItem() );
        }
        if ( !is_null( $o_PR_ListaItemBN->getIdPrGrupo() ) )
        {
            $this->setIdPrGrupo( $o_PR_ListaItemBN->getIdPrGrupo() );
        }
        if ( !is_null( $o_PR_ListaItemBN->getTipoPrecio() ) )
        {
            $this->setTipoPrecio( $o_PR_ListaItemBN->getTipoPrecio() );
        }
        if ( !is_null( $o_PR_ListaItemBN->getIdItem() ) )
        {
            $this->setIdItem( $o_PR_ListaItemBN->getIdItem() );
        }
        if ( !is_null( $o_PR_ListaItemBN->getPrecioVenta() ) )
        {
            $this->setPrecioVenta( $o_PR_ListaItemBN->getPrecioVenta() );
        }
        if ( !is_null( $o_PR_ListaItemBN->getPrecioDscto() ) )
        {
            $this->setPrecioDscto( $o_PR_ListaItemBN->getPrecioDscto() );
        }
        if ( !is_null( $o_PR_ListaItemBN->getBufferDscto() ) )
        {
            $this->setBufferDscto( $o_PR_ListaItemBN->getBufferDscto() );
        }
        if ( !is_null( $o_PR_ListaItemBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PR_ListaItemBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PR_ListaItemBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PR_ListaItemBN->getFechaCreacion() );
        }
    }

    /**
    * @return PR_ListaItemBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdPrListaItem )
    {
        if( is_null( $i_IdPrListaItem ) ){ $i_IdPrListaItem = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PR_ListaItem ";
        $s_SQLQuery .= "WHERE IdPrListaItem = ".$i_IdPrListaItem." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PR_ListaItemBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PR_ListaItemBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PR_ListaItemBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPrListaItem() ) ) $s_SQLQuery .= "PR_ListaItem.IdPrListaItem = ".$this->getIdPrListaItem()." AND ";
        if ( !is_null( $this->getIdPrGrupo() ) ) $s_SQLQuery .= "PR_ListaItem.IdPrGrupo = '".$this->getIdPrGrupo()."' AND ";
        if ( !is_null( $this->getTipoPrecio() ) ) $s_SQLQuery .= "PR_ListaItem.TipoPrecio = ".$this->getTipoPrecio()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "PR_ListaItem.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getPrecioVenta() ) ) $s_SQLQuery .= "PR_ListaItem.PrecioVenta = ".$this->getPrecioVenta()." AND ";
        if ( !is_null( $this->getPrecioDscto() ) ) $s_SQLQuery .= "PR_ListaItem.PrecioDscto = ".$this->getPrecioDscto()." AND ";
        if ( !is_null( $this->getBufferDscto() ) ) $s_SQLQuery .= "PR_ListaItem.BufferDscto = ".$this->getBufferDscto()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "PR_ListaItem.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "PR_ListaItem.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PR_ListaItem WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PR_ListaItemBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PR_ListaItem WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PR_ListaItemBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PR_ListaItemBN = $this->insertObjectBN( $a_SQLRow );
                $a_PR_ListaItemBN[] = $o_PR_ListaItemBN;
            }
        }
        return $a_PR_ListaItemBN;
    }

    /* Devuelve un objeto PR_ListaItemBN desde un objeto propel */
    public function insertObjectBN( $a_PR_ListaItem )
    {
        $o_PR_ListaItemBN = new PR_ListaItemBN();
        if ( !is_null( $a_PR_ListaItem['IdPrListaItem'] ) ) $o_PR_ListaItemBN->setIdPrListaItem( ( integer ) $a_PR_ListaItem['IdPrListaItem'] );
        if ( !is_null( $a_PR_ListaItem['IdPrGrupo'] ) ) $o_PR_ListaItemBN->setIdPrGrupo( $a_PR_ListaItem['IdPrGrupo'] );
        if ( !is_null( $a_PR_ListaItem['TipoPrecio'] ) ) $o_PR_ListaItemBN->setTipoPrecio( ( integer ) $a_PR_ListaItem['TipoPrecio'] );
        if ( !is_null( $a_PR_ListaItem['IdItem'] ) ) $o_PR_ListaItemBN->setIdItem( $a_PR_ListaItem['IdItem'] );
        if ( !is_null( $a_PR_ListaItem['PrecioVenta'] ) ) $o_PR_ListaItemBN->setPrecioVenta( ( float ) $a_PR_ListaItem['PrecioVenta'] );
        if ( !is_null( $a_PR_ListaItem['PrecioDscto'] ) ) $o_PR_ListaItemBN->setPrecioDscto( ( float ) $a_PR_ListaItem['PrecioDscto'] );
        if ( !is_null( $a_PR_ListaItem['BufferDscto'] ) ) $o_PR_ListaItemBN->setBufferDscto( ( float ) $a_PR_ListaItem['BufferDscto'] );
        if ( !is_null( $a_PR_ListaItem['UsuarioCreacion'] ) ) $o_PR_ListaItemBN->setUsuarioCreacion( $a_PR_ListaItem['UsuarioCreacion'] );
        if ( !is_null( $a_PR_ListaItem['FechaCreacion'] ) ) $o_PR_ListaItemBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_PR_ListaItem['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_PR_ListaItemBN;
    }
}
?>