<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_Grupo.xml */
/* Generado: 2021-06-25 23:59:58 */

/* Busqueda de registros de la tabla PR_Grupo. */
abstract class BasePR_GrupoFN extends PR_GrupoBN
{
    /* Declaracion de constantes */
    const IdPrGrupo = "PR_Grupo.IdPrGrupo";
    const IdCompania = "PR_Grupo.IdCompania";
    const IdSucursal = "PR_Grupo.IdSucursal";
    const IdPrTipoId = "PR_Grupo.IdPrTipoId";
    const FechaInicio = "PR_Grupo.FechaInicio";
    const FechaExpiracion = "PR_Grupo.FechaExpiracion";
    const DescripcionPromo = "PR_Grupo.DescripcionPromo";
    const Estado = "PR_Grupo.Estado";
    const IdLinea = "PR_Grupo.IdLinea";
    const IdFamilia = "PR_Grupo.IdFamilia";
    const Valor = "PR_Grupo.Valor";
    const UsuarioCreacion = "PR_Grupo.UsuarioCreacion";
    const FechaCreacion = "PR_Grupo.FechaCreacion";
    const UsuarioModificacion = "PR_Grupo.UsuarioModificacion";
    const FechaModificacion = "PR_Grupo.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PR_Grupo.IdPrGrupo AS IdPrGrupo, ";
        $s_SQLQuery .= "PR_Grupo.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "PR_Grupo.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "PR_Grupo.IdPrTipoId AS IdPrTipoId, ";
        $s_SQLQuery .= "PR_Grupo.FechaInicio AS FechaInicio, ";
        $s_SQLQuery .= "PR_Grupo.FechaExpiracion AS FechaExpiracion, ";
        $s_SQLQuery .= "PR_Grupo.DescripcionPromo AS DescripcionPromo, ";
        $s_SQLQuery .= "PR_Grupo.Estado AS Estado, ";
        $s_SQLQuery .= "PR_Grupo.IdLinea AS IdLinea, ";
        $s_SQLQuery .= "PR_Grupo.IdFamilia AS IdFamilia, ";
        $s_SQLQuery .= "PR_Grupo.Valor AS Valor, ";
        $s_SQLQuery .= "PR_Grupo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "PR_Grupo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "PR_Grupo.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PR_Grupo.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PR_GrupoBN */
    public function setByBN( PR_GrupoBN $o_PR_GrupoBN )
    {
        if ( !is_null( $o_PR_GrupoBN->getIdPrGrupo() ) )
        {
            $this->setIdPrGrupo( $o_PR_GrupoBN->getIdPrGrupo() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_PR_GrupoBN->getIdCompania() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_PR_GrupoBN->getIdSucursal() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdPrTipoId() ) )
        {
            $this->setIdPrTipoId( $o_PR_GrupoBN->getIdPrTipoId() );
        }
        if ( !is_null( $o_PR_GrupoBN->getFechaInicio() ) )
        {
            $this->setFechaInicio( $o_PR_GrupoBN->getFechaInicio() );
        }
        if ( !is_null( $o_PR_GrupoBN->getFechaExpiracion() ) )
        {
            $this->setFechaExpiracion( $o_PR_GrupoBN->getFechaExpiracion() );
        }
        if ( !is_null( $o_PR_GrupoBN->getDescripcionPromo() ) )
        {
            $this->setDescripcionPromo( $o_PR_GrupoBN->getDescripcionPromo() );
        }
        if ( !is_null( $o_PR_GrupoBN->getEstado() ) )
        {
            $this->setEstado( $o_PR_GrupoBN->getEstado() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_PR_GrupoBN->getIdLinea() );
        }
        if ( !is_null( $o_PR_GrupoBN->getIdFamilia() ) )
        {
            $this->setIdFamilia( $o_PR_GrupoBN->getIdFamilia() );
        }
        if ( !is_null( $o_PR_GrupoBN->getValor() ) )
        {
            $this->setValor( $o_PR_GrupoBN->getValor() );
        }
        if ( !is_null( $o_PR_GrupoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PR_GrupoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PR_GrupoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PR_GrupoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_PR_GrupoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PR_GrupoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PR_GrupoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PR_GrupoBN->getFechaModificacion() );
        }
    }

    /**
    * @return PR_GrupoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdPrGrupo )
    {
        if( is_null( $s_IdPrGrupo ) ){ $s_IdPrGrupo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PR_Grupo ";
        $s_SQLQuery .= "WHERE IdPrGrupo = '".$s_IdPrGrupo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PR_GrupoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PR_GrupoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PR_GrupoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPrGrupo() ) ) $s_SQLQuery .= "PR_Grupo.IdPrGrupo = '".$this->getIdPrGrupo()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "PR_Grupo.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "PR_Grupo.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdPrTipoId() ) ) $s_SQLQuery .= "PR_Grupo.IdPrTipoId = '".$this->getIdPrTipoId()."' AND ";
        if ( !is_null( $this->getFechaInicio() ) ) $s_SQLQuery .= "PR_Grupo.FechaInicio = '".$this->getFechaInicio()."' AND ";
        if ( !is_null( $this->getFechaExpiracion() ) ) $s_SQLQuery .= "PR_Grupo.FechaExpiracion = '".$this->getFechaExpiracion()."' AND ";
        if ( !is_null( $this->getDescripcionPromo() ) ) $s_SQLQuery .= "PR_Grupo.DescripcionPromo = '".$this->getDescripcionPromo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PR_Grupo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getIdLinea() ) ) $s_SQLQuery .= "PR_Grupo.IdLinea = ".$this->getIdLinea()." AND ";
        if ( !is_null( $this->getIdFamilia() ) ) $s_SQLQuery .= "PR_Grupo.IdFamilia = ".$this->getIdFamilia()." AND ";
        if ( !is_null( $this->getValor() ) ) $s_SQLQuery .= "PR_Grupo.Valor = '".$this->getValor()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "PR_Grupo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "PR_Grupo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PR_Grupo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PR_Grupo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PR_Grupo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PR_GrupoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PR_Grupo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PR_GrupoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PR_GrupoBN = $this->insertObjectBN( $a_SQLRow );
                $a_PR_GrupoBN[] = $o_PR_GrupoBN;
            }
        }
        return $a_PR_GrupoBN;
    }

    /* Devuelve un objeto PR_GrupoBN desde un objeto propel */
    public function insertObjectBN( $a_PR_Grupo )
    {
        $o_PR_GrupoBN = new PR_GrupoBN();
        if ( !is_null( $a_PR_Grupo['IdPrGrupo'] ) ) $o_PR_GrupoBN->setIdPrGrupo( $a_PR_Grupo['IdPrGrupo'] );
        if ( !is_null( $a_PR_Grupo['IdCompania'] ) ) $o_PR_GrupoBN->setIdCompania( ( integer ) $a_PR_Grupo['IdCompania'] );
        if ( !is_null( $a_PR_Grupo['IdSucursal'] ) ) $o_PR_GrupoBN->setIdSucursal( ( integer ) $a_PR_Grupo['IdSucursal'] );
        if ( !is_null( $a_PR_Grupo['IdPrTipoId'] ) ) $o_PR_GrupoBN->setIdPrTipoId( $a_PR_Grupo['IdPrTipoId'] );
        if ( !is_null( $a_PR_Grupo['FechaInicio'] ) ) $o_PR_GrupoBN->setFechaInicio( utilTimestamp::getTimestamp( $a_PR_Grupo['FechaInicio'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PR_Grupo['FechaExpiracion'] ) ) $o_PR_GrupoBN->setFechaExpiracion( utilTimestamp::getTimestamp( $a_PR_Grupo['FechaExpiracion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PR_Grupo['DescripcionPromo'] ) ) $o_PR_GrupoBN->setDescripcionPromo( $a_PR_Grupo['DescripcionPromo'] );
        if ( !is_null( $a_PR_Grupo['Estado'] ) ) $o_PR_GrupoBN->setEstado( $a_PR_Grupo['Estado'] );
        if ( !is_null( $a_PR_Grupo['IdLinea'] ) ) $o_PR_GrupoBN->setIdLinea( ( integer ) $a_PR_Grupo['IdLinea'] );
        if ( !is_null( $a_PR_Grupo['IdFamilia'] ) ) $o_PR_GrupoBN->setIdFamilia( ( integer ) $a_PR_Grupo['IdFamilia'] );
        if ( !is_null( $a_PR_Grupo['Valor'] ) ) $o_PR_GrupoBN->setValor( $a_PR_Grupo['Valor'] );
        if ( !is_null( $a_PR_Grupo['UsuarioCreacion'] ) ) $o_PR_GrupoBN->setUsuarioCreacion( $a_PR_Grupo['UsuarioCreacion'] );
        if ( !is_null( $a_PR_Grupo['FechaCreacion'] ) ) $o_PR_GrupoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_PR_Grupo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PR_Grupo['UsuarioModificacion'] ) ) $o_PR_GrupoBN->setUsuarioModificacion( $a_PR_Grupo['UsuarioModificacion'] );
        if ( !is_null( $a_PR_Grupo['FechaModificacion'] ) ) $o_PR_GrupoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PR_Grupo['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_PR_GrupoBN;
    }
}
?>