<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_OrdenCab.xml */
/* Generado: 2021-06-25 23:59:57 */

/* Busqueda de registros de la tabla PRD_OrdenCab. */
abstract class BasePRD_OrdenCabFN extends PRD_OrdenCabBN
{
    /* Declaracion de constantes */
    const IdOrdenCab = "PRD_OrdenCab.IdOrdenCab";
    const IdCompania = "PRD_OrdenCab.IdCompania";
    const IdSucursal = "PRD_OrdenCab.IdSucursal";
    const FechaOrden = "PRD_OrdenCab.FechaOrden";
    const TipoOrden = "PRD_OrdenCab.TipoOrden";
    const IdAlmacen = "PRD_OrdenCab.IdAlmacen";
    const IdProyecto = "PRD_OrdenCab.IdProyecto";
    const ProyectoDesc = "PRD_OrdenCab.ProyectoDesc";
    const ProFinalId = "PRD_OrdenCab.ProFinalId";
    const IdDocRef = "PRD_OrdenCab.IdDocRef";
    const DocNumRef = "PRD_OrdenCab.DocNumRef";
    const IdAlmacenRef = "PRD_OrdenCab.IdAlmacenRef";
    const Comentario = "PRD_OrdenCab.Comentario";
    const Estado = "PRD_OrdenCab.Estado";
    const IdTipoDocumentoSal = "PRD_OrdenCab.IdTipoDocumentoSal";
    const IdNumeroDocumentoSal = "PRD_OrdenCab.IdNumeroDocumentoSal";
    const IdTransaccionSal = "PRD_OrdenCab.IdTransaccionSal";
    const IdTipoDocumentoIng = "PRD_OrdenCab.IdTipoDocumentoIng";
    const IdNumeroDocumentoIng = "PRD_OrdenCab.IdNumeroDocumentoIng";
    const IdTransaccionIng = "PRD_OrdenCab.IdTransaccionIng";
    const IdTipoDocumentoTrf = "PRD_OrdenCab.IdTipoDocumentoTrf";
    const IdNumeroDocumentoTrf = "PRD_OrdenCab.IdNumeroDocumentoTrf";
    const IdTransaccionTrf = "PRD_OrdenCab.IdTransaccionTrf";
    const UsuarioCreacion = "PRD_OrdenCab.UsuarioCreacion";
    const FechaCreacion = "PRD_OrdenCab.FechaCreacion";
    const UsuarioModificacion = "PRD_OrdenCab.UsuarioModificacion";
    const FechaModificacion = "PRD_OrdenCab.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PRD_OrdenCab.IdOrdenCab AS IdOrdenCab, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "PRD_OrdenCab.FechaOrden AS FechaOrden, ";
        $s_SQLQuery .= "PRD_OrdenCab.TipoOrden AS TipoOrden, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "PRD_OrdenCab.ProyectoDesc AS ProyectoDesc, ";
        $s_SQLQuery .= "PRD_OrdenCab.ProFinalId AS ProFinalId, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdDocRef AS IdDocRef, ";
        $s_SQLQuery .= "PRD_OrdenCab.DocNumRef AS DocNumRef, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdAlmacenRef AS IdAlmacenRef, ";
        $s_SQLQuery .= "PRD_OrdenCab.Comentario AS Comentario, ";
        $s_SQLQuery .= "PRD_OrdenCab.Estado AS Estado, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdTipoDocumentoSal AS IdTipoDocumentoSal, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdNumeroDocumentoSal AS IdNumeroDocumentoSal, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdTransaccionSal AS IdTransaccionSal, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdTipoDocumentoIng AS IdTipoDocumentoIng, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdNumeroDocumentoIng AS IdNumeroDocumentoIng, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdTransaccionIng AS IdTransaccionIng, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdTipoDocumentoTrf AS IdTipoDocumentoTrf, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdNumeroDocumentoTrf AS IdNumeroDocumentoTrf, ";
        $s_SQLQuery .= "PRD_OrdenCab.IdTransaccionTrf AS IdTransaccionTrf, ";
        $s_SQLQuery .= "PRD_OrdenCab.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "PRD_OrdenCab.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "PRD_OrdenCab.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PRD_OrdenCab.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PRD_OrdenCabBN */
    public function setByBN( PRD_OrdenCabBN $o_PRD_OrdenCabBN )
    {
        if ( !is_null( $o_PRD_OrdenCabBN->getIdOrdenCab() ) )
        {
            $this->setIdOrdenCab( $o_PRD_OrdenCabBN->getIdOrdenCab() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_PRD_OrdenCabBN->getIdCompania() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_PRD_OrdenCabBN->getIdSucursal() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getFechaOrden() ) )
        {
            $this->setFechaOrden( $o_PRD_OrdenCabBN->getFechaOrden() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getTipoOrden() ) )
        {
            $this->setTipoOrden( $o_PRD_OrdenCabBN->getTipoOrden() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_PRD_OrdenCabBN->getIdAlmacen() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_PRD_OrdenCabBN->getIdProyecto() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getProyectoDesc() ) )
        {
            $this->setProyectoDesc( $o_PRD_OrdenCabBN->getProyectoDesc() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getProFinalId() ) )
        {
            $this->setProFinalId( $o_PRD_OrdenCabBN->getProFinalId() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdDocRef() ) )
        {
            $this->setIdDocRef( $o_PRD_OrdenCabBN->getIdDocRef() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getDocNumRef() ) )
        {
            $this->setDocNumRef( $o_PRD_OrdenCabBN->getDocNumRef() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdAlmacenRef() ) )
        {
            $this->setIdAlmacenRef( $o_PRD_OrdenCabBN->getIdAlmacenRef() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getComentario() ) )
        {
            $this->setComentario( $o_PRD_OrdenCabBN->getComentario() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getEstado() ) )
        {
            $this->setEstado( $o_PRD_OrdenCabBN->getEstado() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdTipoDocumentoSal() ) )
        {
            $this->setIdTipoDocumentoSal( $o_PRD_OrdenCabBN->getIdTipoDocumentoSal() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdNumeroDocumentoSal() ) )
        {
            $this->setIdNumeroDocumentoSal( $o_PRD_OrdenCabBN->getIdNumeroDocumentoSal() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdTransaccionSal() ) )
        {
            $this->setIdTransaccionSal( $o_PRD_OrdenCabBN->getIdTransaccionSal() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdTipoDocumentoIng() ) )
        {
            $this->setIdTipoDocumentoIng( $o_PRD_OrdenCabBN->getIdTipoDocumentoIng() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdNumeroDocumentoIng() ) )
        {
            $this->setIdNumeroDocumentoIng( $o_PRD_OrdenCabBN->getIdNumeroDocumentoIng() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdTransaccionIng() ) )
        {
            $this->setIdTransaccionIng( $o_PRD_OrdenCabBN->getIdTransaccionIng() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdTipoDocumentoTrf() ) )
        {
            $this->setIdTipoDocumentoTrf( $o_PRD_OrdenCabBN->getIdTipoDocumentoTrf() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdNumeroDocumentoTrf() ) )
        {
            $this->setIdNumeroDocumentoTrf( $o_PRD_OrdenCabBN->getIdNumeroDocumentoTrf() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getIdTransaccionTrf() ) )
        {
            $this->setIdTransaccionTrf( $o_PRD_OrdenCabBN->getIdTransaccionTrf() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PRD_OrdenCabBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PRD_OrdenCabBN->getFechaCreacion() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRD_OrdenCabBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRD_OrdenCabBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRD_OrdenCabBN->getFechaModificacion() );
        }
    }

    /**
    * @return PRD_OrdenCabBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdOrdenCab )
    {
        if( is_null( $i_IdOrdenCab ) ){ $i_IdOrdenCab = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_OrdenCab ";
        $s_SQLQuery .= "WHERE IdOrdenCab = ".$i_IdOrdenCab." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PRD_OrdenCabBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PRD_OrdenCabBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PRD_OrdenCabBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdOrdenCab() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdOrdenCab = ".$this->getIdOrdenCab()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getFechaOrden() ) ) $s_SQLQuery .= "PRD_OrdenCab.FechaOrden = '".$this->getFechaOrden()."' AND ";
        if ( !is_null( $this->getTipoOrden() ) ) $s_SQLQuery .= "PRD_OrdenCab.TipoOrden = '".$this->getTipoOrden()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getProyectoDesc() ) ) $s_SQLQuery .= "PRD_OrdenCab.ProyectoDesc = '".$this->getProyectoDesc()."' AND ";
        if ( !is_null( $this->getProFinalId() ) ) $s_SQLQuery .= "PRD_OrdenCab.ProFinalId = ".$this->getProFinalId()." AND ";
        if ( !is_null( $this->getIdDocRef() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdDocRef = ".$this->getIdDocRef()." AND ";
        if ( !is_null( $this->getDocNumRef() ) ) $s_SQLQuery .= "PRD_OrdenCab.DocNumRef = '".$this->getDocNumRef()."' AND ";
        if ( !is_null( $this->getIdAlmacenRef() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdAlmacenRef = '".$this->getIdAlmacenRef()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "PRD_OrdenCab.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PRD_OrdenCab.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getIdTipoDocumentoSal() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdTipoDocumentoSal = '".$this->getIdTipoDocumentoSal()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumentoSal() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdNumeroDocumentoSal = '".$this->getIdNumeroDocumentoSal()."' AND ";
        if ( !is_null( $this->getIdTransaccionSal() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdTransaccionSal = '".$this->getIdTransaccionSal()."' AND ";
        if ( !is_null( $this->getIdTipoDocumentoIng() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdTipoDocumentoIng = '".$this->getIdTipoDocumentoIng()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumentoIng() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdNumeroDocumentoIng = '".$this->getIdNumeroDocumentoIng()."' AND ";
        if ( !is_null( $this->getIdTransaccionIng() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdTransaccionIng = '".$this->getIdTransaccionIng()."' AND ";
        if ( !is_null( $this->getIdTipoDocumentoTrf() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdTipoDocumentoTrf = '".$this->getIdTipoDocumentoTrf()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumentoTrf() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdNumeroDocumentoTrf = '".$this->getIdNumeroDocumentoTrf()."' AND ";
        if ( !is_null( $this->getIdTransaccionTrf() ) ) $s_SQLQuery .= "PRD_OrdenCab.IdTransaccionTrf = '".$this->getIdTransaccionTrf()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "PRD_OrdenCab.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "PRD_OrdenCab.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PRD_OrdenCab.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PRD_OrdenCab.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PRD_OrdenCab WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PRD_OrdenCabBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_OrdenCab WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PRD_OrdenCabBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PRD_OrdenCabBN = $this->insertObjectBN( $a_SQLRow );
                $a_PRD_OrdenCabBN[] = $o_PRD_OrdenCabBN;
            }
        }
        return $a_PRD_OrdenCabBN;
    }

    /* Devuelve un objeto PRD_OrdenCabBN desde un objeto propel */
    public function insertObjectBN( $a_PRD_OrdenCab )
    {
        $o_PRD_OrdenCabBN = new PRD_OrdenCabBN();
        if ( !is_null( $a_PRD_OrdenCab['IdOrdenCab'] ) ) $o_PRD_OrdenCabBN->setIdOrdenCab( ( integer ) $a_PRD_OrdenCab['IdOrdenCab'] );
        if ( !is_null( $a_PRD_OrdenCab['IdCompania'] ) ) $o_PRD_OrdenCabBN->setIdCompania( ( integer ) $a_PRD_OrdenCab['IdCompania'] );
        if ( !is_null( $a_PRD_OrdenCab['IdSucursal'] ) ) $o_PRD_OrdenCabBN->setIdSucursal( ( integer ) $a_PRD_OrdenCab['IdSucursal'] );
        if ( !is_null( $a_PRD_OrdenCab['FechaOrden'] ) ) $o_PRD_OrdenCabBN->setFechaOrden( utilTimestamp::getTimestamp( $a_PRD_OrdenCab['FechaOrden'], "Y-m-d" ) );
        if ( !is_null( $a_PRD_OrdenCab['TipoOrden'] ) ) $o_PRD_OrdenCabBN->setTipoOrden( $a_PRD_OrdenCab['TipoOrden'] );
        if ( !is_null( $a_PRD_OrdenCab['IdAlmacen'] ) ) $o_PRD_OrdenCabBN->setIdAlmacen( $a_PRD_OrdenCab['IdAlmacen'] );
        if ( !is_null( $a_PRD_OrdenCab['IdProyecto'] ) ) $o_PRD_OrdenCabBN->setIdProyecto( ( integer ) $a_PRD_OrdenCab['IdProyecto'] );
        if ( !is_null( $a_PRD_OrdenCab['ProyectoDesc'] ) ) $o_PRD_OrdenCabBN->setProyectoDesc( $a_PRD_OrdenCab['ProyectoDesc'] );
        if ( !is_null( $a_PRD_OrdenCab['ProFinalId'] ) ) $o_PRD_OrdenCabBN->setProFinalId( ( integer ) $a_PRD_OrdenCab['ProFinalId'] );
        if ( !is_null( $a_PRD_OrdenCab['IdDocRef'] ) ) $o_PRD_OrdenCabBN->setIdDocRef( ( integer ) $a_PRD_OrdenCab['IdDocRef'] );
        if ( !is_null( $a_PRD_OrdenCab['DocNumRef'] ) ) $o_PRD_OrdenCabBN->setDocNumRef( $a_PRD_OrdenCab['DocNumRef'] );
        if ( !is_null( $a_PRD_OrdenCab['IdAlmacenRef'] ) ) $o_PRD_OrdenCabBN->setIdAlmacenRef( $a_PRD_OrdenCab['IdAlmacenRef'] );
        if ( !is_null( $a_PRD_OrdenCab['Comentario'] ) ) $o_PRD_OrdenCabBN->setComentario( $a_PRD_OrdenCab['Comentario'] );
        if ( !is_null( $a_PRD_OrdenCab['Estado'] ) ) $o_PRD_OrdenCabBN->setEstado( $a_PRD_OrdenCab['Estado'] );
        if ( !is_null( $a_PRD_OrdenCab['IdTipoDocumentoSal'] ) ) $o_PRD_OrdenCabBN->setIdTipoDocumentoSal( $a_PRD_OrdenCab['IdTipoDocumentoSal'] );
        if ( !is_null( $a_PRD_OrdenCab['IdNumeroDocumentoSal'] ) ) $o_PRD_OrdenCabBN->setIdNumeroDocumentoSal( $a_PRD_OrdenCab['IdNumeroDocumentoSal'] );
        if ( !is_null( $a_PRD_OrdenCab['IdTransaccionSal'] ) ) $o_PRD_OrdenCabBN->setIdTransaccionSal( $a_PRD_OrdenCab['IdTransaccionSal'] );
        if ( !is_null( $a_PRD_OrdenCab['IdTipoDocumentoIng'] ) ) $o_PRD_OrdenCabBN->setIdTipoDocumentoIng( $a_PRD_OrdenCab['IdTipoDocumentoIng'] );
        if ( !is_null( $a_PRD_OrdenCab['IdNumeroDocumentoIng'] ) ) $o_PRD_OrdenCabBN->setIdNumeroDocumentoIng( $a_PRD_OrdenCab['IdNumeroDocumentoIng'] );
        if ( !is_null( $a_PRD_OrdenCab['IdTransaccionIng'] ) ) $o_PRD_OrdenCabBN->setIdTransaccionIng( $a_PRD_OrdenCab['IdTransaccionIng'] );
        if ( !is_null( $a_PRD_OrdenCab['IdTipoDocumentoTrf'] ) ) $o_PRD_OrdenCabBN->setIdTipoDocumentoTrf( $a_PRD_OrdenCab['IdTipoDocumentoTrf'] );
        if ( !is_null( $a_PRD_OrdenCab['IdNumeroDocumentoTrf'] ) ) $o_PRD_OrdenCabBN->setIdNumeroDocumentoTrf( $a_PRD_OrdenCab['IdNumeroDocumentoTrf'] );
        if ( !is_null( $a_PRD_OrdenCab['IdTransaccionTrf'] ) ) $o_PRD_OrdenCabBN->setIdTransaccionTrf( $a_PRD_OrdenCab['IdTransaccionTrf'] );
        if ( !is_null( $a_PRD_OrdenCab['UsuarioCreacion'] ) ) $o_PRD_OrdenCabBN->setUsuarioCreacion( $a_PRD_OrdenCab['UsuarioCreacion'] );
        if ( !is_null( $a_PRD_OrdenCab['FechaCreacion'] ) ) $o_PRD_OrdenCabBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_PRD_OrdenCab['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PRD_OrdenCab['UsuarioModificacion'] ) ) $o_PRD_OrdenCabBN->setUsuarioModificacion( $a_PRD_OrdenCab['UsuarioModificacion'] );
        if ( !is_null( $a_PRD_OrdenCab['FechaModificacion'] ) ) $o_PRD_OrdenCabBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PRD_OrdenCab['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_PRD_OrdenCabBN;
    }
}
?>