<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_ManoObra.xml */
/* Generado: 2021-06-25 23:59:56 */

/* Busqueda de registros de la tabla PRD_ManoObra. */
abstract class BasePRD_ManoObraFN extends PRD_ManoObraBN
{
    /* Declaracion de constantes */
    const IdManoObra = "PRD_ManoObra.IdManoObra";
    const Descripcion = "PRD_ManoObra.Descripcion";
    const Estado = "PRD_ManoObra.Estado";
    const UsuarioRegistro = "PRD_ManoObra.UsuarioRegistro";
    const FechaRegistro = "PRD_ManoObra.FechaRegistro";
    const UsuarioModificacion = "PRD_ManoObra.UsuarioModificacion";
    const FechaModificacion = "PRD_ManoObra.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PRD_ManoObra.IdManoObra AS IdManoObra, ";
        $s_SQLQuery .= "PRD_ManoObra.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "PRD_ManoObra.Estado AS Estado, ";
        $s_SQLQuery .= "PRD_ManoObra.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "PRD_ManoObra.FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "PRD_ManoObra.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PRD_ManoObra.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PRD_ManoObraBN */
    public function setByBN( PRD_ManoObraBN $o_PRD_ManoObraBN )
    {
        if ( !is_null( $o_PRD_ManoObraBN->getIdManoObra() ) )
        {
            $this->setIdManoObra( $o_PRD_ManoObraBN->getIdManoObra() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PRD_ManoObraBN->getDescripcion() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getEstado() ) )
        {
            $this->setEstado( $o_PRD_ManoObraBN->getEstado() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_PRD_ManoObraBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_PRD_ManoObraBN->getFechaRegistro() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRD_ManoObraBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRD_ManoObraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRD_ManoObraBN->getFechaModificacion() );
        }
    }

    /**
    * @return PRD_ManoObraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdManoObra )
    {
        if( is_null( $i_IdManoObra ) ){ $i_IdManoObra = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_ManoObra ";
        $s_SQLQuery .= "WHERE IdManoObra = ".$i_IdManoObra." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PRD_ManoObraBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PRD_ManoObraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PRD_ManoObraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdManoObra() ) ) $s_SQLQuery .= "PRD_ManoObra.IdManoObra = ".$this->getIdManoObra()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "PRD_ManoObra.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PRD_ManoObra.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "PRD_ManoObra.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "PRD_ManoObra.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PRD_ManoObra.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PRD_ManoObra.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PRD_ManoObra WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PRD_ManoObraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_ManoObra WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PRD_ManoObraBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PRD_ManoObraBN = $this->insertObjectBN( $a_SQLRow );
                $a_PRD_ManoObraBN[] = $o_PRD_ManoObraBN;
            }
        }
        return $a_PRD_ManoObraBN;
    }

    /* Devuelve un objeto PRD_ManoObraBN desde un objeto propel */
    public function insertObjectBN( $a_PRD_ManoObra )
    {
        $o_PRD_ManoObraBN = new PRD_ManoObraBN();
        if ( !is_null( $a_PRD_ManoObra['IdManoObra'] ) ) $o_PRD_ManoObraBN->setIdManoObra( ( integer ) $a_PRD_ManoObra['IdManoObra'] );
        if ( !is_null( $a_PRD_ManoObra['Descripcion'] ) ) $o_PRD_ManoObraBN->setDescripcion( $a_PRD_ManoObra['Descripcion'] );
        if ( !is_null( $a_PRD_ManoObra['Estado'] ) ) $o_PRD_ManoObraBN->setEstado( $a_PRD_ManoObra['Estado'] );
        if ( !is_null( $a_PRD_ManoObra['UsuarioRegistro'] ) ) $o_PRD_ManoObraBN->setUsuarioRegistro( $a_PRD_ManoObra['UsuarioRegistro'] );
        if ( !is_null( $a_PRD_ManoObra['FechaRegistro'] ) ) $o_PRD_ManoObraBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_PRD_ManoObra['FechaRegistro'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PRD_ManoObra['UsuarioModificacion'] ) ) $o_PRD_ManoObraBN->setUsuarioModificacion( $a_PRD_ManoObra['UsuarioModificacion'] );
        if ( !is_null( $a_PRD_ManoObra['FechaModificacion'] ) ) $o_PRD_ManoObraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PRD_ManoObra['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_PRD_ManoObraBN;
    }
}
?>