<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_EquipoHerramienta.xml */
/* Generado: 2021-06-25 23:59:56 */

/* Busqueda de registros de la tabla PRD_EquipoHerramienta. */
abstract class BasePRD_EquipoHerramientaFN extends PRD_EquipoHerramientaBN
{
    /* Declaracion de constantes */
    const IdEquiHerr = "PRD_EquipoHerramienta.IdEquiHerr";
    const Descripcion = "PRD_EquipoHerramienta.Descripcion";
    const Estado = "PRD_EquipoHerramienta.Estado";
    const UsuarioRegistro = "PRD_EquipoHerramienta.UsuarioRegistro";
    const FechaRegistro = "PRD_EquipoHerramienta.FechaRegistro";
    const UsuarioModificacion = "PRD_EquipoHerramienta.UsuarioModificacion";
    const FechaModificacion = "PRD_EquipoHerramienta.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PRD_EquipoHerramienta.IdEquiHerr AS IdEquiHerr, ";
        $s_SQLQuery .= "PRD_EquipoHerramienta.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "PRD_EquipoHerramienta.Estado AS Estado, ";
        $s_SQLQuery .= "PRD_EquipoHerramienta.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "PRD_EquipoHerramienta.FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "PRD_EquipoHerramienta.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PRD_EquipoHerramienta.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PRD_EquipoHerramientaBN */
    public function setByBN( PRD_EquipoHerramientaBN $o_PRD_EquipoHerramientaBN )
    {
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getIdEquiHerr() ) )
        {
            $this->setIdEquiHerr( $o_PRD_EquipoHerramientaBN->getIdEquiHerr() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PRD_EquipoHerramientaBN->getDescripcion() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getEstado() ) )
        {
            $this->setEstado( $o_PRD_EquipoHerramientaBN->getEstado() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_PRD_EquipoHerramientaBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_PRD_EquipoHerramientaBN->getFechaRegistro() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRD_EquipoHerramientaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRD_EquipoHerramientaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRD_EquipoHerramientaBN->getFechaModificacion() );
        }
    }

    /**
    * @return PRD_EquipoHerramientaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdEquiHerr )
    {
        if( is_null( $i_IdEquiHerr ) ){ $i_IdEquiHerr = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_EquipoHerramienta ";
        $s_SQLQuery .= "WHERE IdEquiHerr = ".$i_IdEquiHerr." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PRD_EquipoHerramientaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PRD_EquipoHerramientaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PRD_EquipoHerramientaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdEquiHerr() ) ) $s_SQLQuery .= "PRD_EquipoHerramienta.IdEquiHerr = ".$this->getIdEquiHerr()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "PRD_EquipoHerramienta.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PRD_EquipoHerramienta.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "PRD_EquipoHerramienta.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "PRD_EquipoHerramienta.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PRD_EquipoHerramienta.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PRD_EquipoHerramienta.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PRD_EquipoHerramienta WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PRD_EquipoHerramientaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_EquipoHerramienta WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PRD_EquipoHerramientaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PRD_EquipoHerramientaBN = $this->insertObjectBN( $a_SQLRow );
                $a_PRD_EquipoHerramientaBN[] = $o_PRD_EquipoHerramientaBN;
            }
        }
        return $a_PRD_EquipoHerramientaBN;
    }

    /* Devuelve un objeto PRD_EquipoHerramientaBN desde un objeto propel */
    public function insertObjectBN( $a_PRD_EquipoHerramienta )
    {
        $o_PRD_EquipoHerramientaBN = new PRD_EquipoHerramientaBN();
        if ( !is_null( $a_PRD_EquipoHerramienta['IdEquiHerr'] ) ) $o_PRD_EquipoHerramientaBN->setIdEquiHerr( ( integer ) $a_PRD_EquipoHerramienta['IdEquiHerr'] );
        if ( !is_null( $a_PRD_EquipoHerramienta['Descripcion'] ) ) $o_PRD_EquipoHerramientaBN->setDescripcion( $a_PRD_EquipoHerramienta['Descripcion'] );
        if ( !is_null( $a_PRD_EquipoHerramienta['Estado'] ) ) $o_PRD_EquipoHerramientaBN->setEstado( $a_PRD_EquipoHerramienta['Estado'] );
        if ( !is_null( $a_PRD_EquipoHerramienta['UsuarioRegistro'] ) ) $o_PRD_EquipoHerramientaBN->setUsuarioRegistro( $a_PRD_EquipoHerramienta['UsuarioRegistro'] );
        if ( !is_null( $a_PRD_EquipoHerramienta['FechaRegistro'] ) ) $o_PRD_EquipoHerramientaBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_PRD_EquipoHerramienta['FechaRegistro'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PRD_EquipoHerramienta['UsuarioModificacion'] ) ) $o_PRD_EquipoHerramientaBN->setUsuarioModificacion( $a_PRD_EquipoHerramienta['UsuarioModificacion'] );
        if ( !is_null( $a_PRD_EquipoHerramienta['FechaModificacion'] ) ) $o_PRD_EquipoHerramientaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PRD_EquipoHerramienta['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_PRD_EquipoHerramientaBN;
    }
}
?>