<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_MarcacionTipo.xml */
/* Generado: 2021-06-25 23:59:56 */

/* Busqueda de registros de la tabla PLA_MarcacionTipo. */
abstract class BasePLA_MarcacionTipoFN extends PLA_MarcacionTipoBN
{
    /* Declaracion de constantes */
    const IdTipo = "PLA_MarcacionTipo.IdTipo";
    const IdRegistro = "PLA_MarcacionTipo.IdRegistro";
    const Descripcion = "PLA_MarcacionTipo.Descripcion";
    const Secuencia = "PLA_MarcacionTipo.Secuencia";
    const Estado = "PLA_MarcacionTipo.Estado";
    const TieneDescuentoFlag = "PLA_MarcacionTipo.TieneDescuentoFlag";
    const TieneDiaSiguienteFlag = "PLA_MarcacionTipo.TieneDiaSiguienteFlag";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PLA_MarcacionTipo.IdTipo AS IdTipo, ";
        $s_SQLQuery .= "PLA_MarcacionTipo.IdRegistro AS IdRegistro, ";
        $s_SQLQuery .= "PLA_MarcacionTipo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "PLA_MarcacionTipo.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "PLA_MarcacionTipo.Estado AS Estado, ";
        $s_SQLQuery .= "PLA_MarcacionTipo.TieneDescuentoFlag AS TieneDescuentoFlag, ";
        $s_SQLQuery .= "PLA_MarcacionTipo.TieneDiaSiguienteFlag AS TieneDiaSiguienteFlag ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PLA_MarcacionTipoBN */
    public function setByBN( PLA_MarcacionTipoBN $o_PLA_MarcacionTipoBN )
    {
        if ( !is_null( $o_PLA_MarcacionTipoBN->getIdTipo() ) )
        {
            $this->setIdTipo( $o_PLA_MarcacionTipoBN->getIdTipo() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getIdRegistro() ) )
        {
            $this->setIdRegistro( $o_PLA_MarcacionTipoBN->getIdRegistro() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PLA_MarcacionTipoBN->getDescripcion() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_PLA_MarcacionTipoBN->getSecuencia() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getEstado() ) )
        {
            $this->setEstado( $o_PLA_MarcacionTipoBN->getEstado() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getTieneDescuentoFlag() ) )
        {
            $this->setTieneDescuentoFlag( $o_PLA_MarcacionTipoBN->getTieneDescuentoFlag() );
        }
        if ( !is_null( $o_PLA_MarcacionTipoBN->getTieneDiaSiguienteFlag() ) )
        {
            $this->setTieneDiaSiguienteFlag( $o_PLA_MarcacionTipoBN->getTieneDiaSiguienteFlag() );
        }
    }

    /**
    * @return PLA_MarcacionTipoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdTipo, $s_IdRegistro )
    {
        if( is_null( $s_IdTipo ) ){ $s_IdTipo = '-1'; } 
        if( is_null( $s_IdRegistro ) ){ $s_IdRegistro = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_MarcacionTipo ";
        $s_SQLQuery .= "WHERE IdTipo = '".$s_IdTipo."' ";
        $s_SQLQuery .= "AND IdRegistro = '".$s_IdRegistro."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PLA_MarcacionTipoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PLA_MarcacionTipoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PLA_MarcacionTipoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipo() ) ) $s_SQLQuery .= "PLA_MarcacionTipo.IdTipo = '".$this->getIdTipo()."' AND ";
        if ( !is_null( $this->getIdRegistro() ) ) $s_SQLQuery .= "PLA_MarcacionTipo.IdRegistro = '".$this->getIdRegistro()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "PLA_MarcacionTipo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "PLA_MarcacionTipo.Secuencia = ".$this->getSecuencia()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PLA_MarcacionTipo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getTieneDescuentoFlag() ) ) $s_SQLQuery .= "PLA_MarcacionTipo.TieneDescuentoFlag = ".$this->getTieneDescuentoFlag()." AND ";
        if ( !is_null( $this->getTieneDiaSiguienteFlag() ) ) $s_SQLQuery .= "PLA_MarcacionTipo.TieneDiaSiguienteFlag = ".$this->getTieneDiaSiguienteFlag()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PLA_MarcacionTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PLA_MarcacionTipoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_MarcacionTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PLA_MarcacionTipoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PLA_MarcacionTipoBN = $this->insertObjectBN( $a_SQLRow );
                $a_PLA_MarcacionTipoBN[] = $o_PLA_MarcacionTipoBN;
            }
        }
        return $a_PLA_MarcacionTipoBN;
    }

    /* Devuelve un objeto PLA_MarcacionTipoBN desde un objeto propel */
    public function insertObjectBN( $a_PLA_MarcacionTipo )
    {
        $o_PLA_MarcacionTipoBN = new PLA_MarcacionTipoBN();
        if ( !is_null( $a_PLA_MarcacionTipo['IdTipo'] ) ) $o_PLA_MarcacionTipoBN->setIdTipo( $a_PLA_MarcacionTipo['IdTipo'] );
        if ( !is_null( $a_PLA_MarcacionTipo['IdRegistro'] ) ) $o_PLA_MarcacionTipoBN->setIdRegistro( $a_PLA_MarcacionTipo['IdRegistro'] );
        if ( !is_null( $a_PLA_MarcacionTipo['Descripcion'] ) ) $o_PLA_MarcacionTipoBN->setDescripcion( $a_PLA_MarcacionTipo['Descripcion'] );
        if ( !is_null( $a_PLA_MarcacionTipo['Secuencia'] ) ) $o_PLA_MarcacionTipoBN->setSecuencia( ( integer ) $a_PLA_MarcacionTipo['Secuencia'] );
        if ( !is_null( $a_PLA_MarcacionTipo['Estado'] ) ) $o_PLA_MarcacionTipoBN->setEstado( $a_PLA_MarcacionTipo['Estado'] );
        if ( !is_null( $a_PLA_MarcacionTipo['TieneDescuentoFlag'] ) ) $o_PLA_MarcacionTipoBN->setTieneDescuentoFlag( ( integer ) $a_PLA_MarcacionTipo['TieneDescuentoFlag'] );
        if ( !is_null( $a_PLA_MarcacionTipo['TieneDiaSiguienteFlag'] ) ) $o_PLA_MarcacionTipoBN->setTieneDiaSiguienteFlag( ( integer ) $a_PLA_MarcacionTipo['TieneDiaSiguienteFlag'] );
        return $o_PLA_MarcacionTipoBN;
    }
}
?>