<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_MarcacionEmpleado.xml */
/* Generado: 2021-06-25 23:59:55 */

/* Busqueda de registros de la tabla PLA_MarcacionEmpleado. */
abstract class BasePLA_MarcacionEmpleadoFN extends PLA_MarcacionEmpleadoBN
{
    /* Declaracion de constantes */
    const IdDiaSem = "PLA_MarcacionEmpleado.IdDiaSem";
    const IdTipo = "PLA_MarcacionEmpleado.IdTipo";
    const IdRegistro = "PLA_MarcacionEmpleado.IdRegistro";
    const IdPersona = "PLA_MarcacionEmpleado.IdPersona";
    const HoraMinutoDesde = "PLA_MarcacionEmpleado.HoraMinutoDesde";
    const HoraMinutoHasta = "PLA_MarcacionEmpleado.HoraMinutoHasta";
    const DiaSiguienteFlag = "PLA_MarcacionEmpleado.DiaSiguienteFlag";
    const Estado = "PLA_MarcacionEmpleado.Estado";
    const Eliminado = "PLA_MarcacionEmpleado.Eliminado";
    const UsuarioCreacion = "PLA_MarcacionEmpleado.UsuarioCreacion";
    const FechaCreacion = "PLA_MarcacionEmpleado.FechaCreacion";
    const UsuarioModificacion = "PLA_MarcacionEmpleado.UsuarioModificacion";
    const FechaModificacion = "PLA_MarcacionEmpleado.FechaModificacion";
    const UsuarioEliminado = "PLA_MarcacionEmpleado.UsuarioEliminado";
    const FechaEliminado = "PLA_MarcacionEmpleado.FechaEliminado";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PLA_MarcacionEmpleado.IdDiaSem AS IdDiaSem, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.IdTipo AS IdTipo, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.IdRegistro AS IdRegistro, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.HoraMinutoDesde AS HoraMinutoDesde, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.HoraMinutoHasta AS HoraMinutoHasta, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.DiaSiguienteFlag AS DiaSiguienteFlag, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.Estado AS Estado, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.Eliminado AS Eliminado, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.UsuarioEliminado AS UsuarioEliminado, ";
        $s_SQLQuery .= "PLA_MarcacionEmpleado.FechaEliminado AS FechaEliminado ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PLA_MarcacionEmpleadoBN */
    public function setByBN( PLA_MarcacionEmpleadoBN $o_PLA_MarcacionEmpleadoBN )
    {
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getIdDiaSem() ) )
        {
            $this->setIdDiaSem( $o_PLA_MarcacionEmpleadoBN->getIdDiaSem() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getIdTipo() ) )
        {
            $this->setIdTipo( $o_PLA_MarcacionEmpleadoBN->getIdTipo() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getIdRegistro() ) )
        {
            $this->setIdRegistro( $o_PLA_MarcacionEmpleadoBN->getIdRegistro() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_PLA_MarcacionEmpleadoBN->getIdPersona() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getHoraMinutoDesde() ) )
        {
            $this->setHoraMinutoDesde( $o_PLA_MarcacionEmpleadoBN->getHoraMinutoDesde() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getHoraMinutoHasta() ) )
        {
            $this->setHoraMinutoHasta( $o_PLA_MarcacionEmpleadoBN->getHoraMinutoHasta() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getDiaSiguienteFlag() ) )
        {
            $this->setDiaSiguienteFlag( $o_PLA_MarcacionEmpleadoBN->getDiaSiguienteFlag() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getEstado() ) )
        {
            $this->setEstado( $o_PLA_MarcacionEmpleadoBN->getEstado() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getEliminado() ) )
        {
            $this->setEliminado( $o_PLA_MarcacionEmpleadoBN->getEliminado() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PLA_MarcacionEmpleadoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PLA_MarcacionEmpleadoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PLA_MarcacionEmpleadoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PLA_MarcacionEmpleadoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getUsuarioEliminado() ) )
        {
            $this->setUsuarioEliminado( $o_PLA_MarcacionEmpleadoBN->getUsuarioEliminado() );
        }
        if ( !is_null( $o_PLA_MarcacionEmpleadoBN->getFechaEliminado() ) )
        {
            $this->setFechaEliminado( $o_PLA_MarcacionEmpleadoBN->getFechaEliminado() );
        }
    }

    /**
    * @return PLA_MarcacionEmpleadoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdDiaSem, $s_IdTipo, $s_IdRegistro, $i_IdPersona )
    {
        if( is_null( $i_IdDiaSem ) ){ $i_IdDiaSem = -1; } 
        if( is_null( $s_IdTipo ) ){ $s_IdTipo = '-1'; } 
        if( is_null( $s_IdRegistro ) ){ $s_IdRegistro = '-1'; } 
        if( is_null( $i_IdPersona ) ){ $i_IdPersona = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_MarcacionEmpleado ";
        $s_SQLQuery .= "WHERE IdDiaSem = ".$i_IdDiaSem." ";
        $s_SQLQuery .= "AND IdTipo = '".$s_IdTipo."' ";
        $s_SQLQuery .= "AND IdRegistro = '".$s_IdRegistro."' ";
        $s_SQLQuery .= "AND IdPersona = ".$i_IdPersona." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PLA_MarcacionEmpleadoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PLA_MarcacionEmpleadoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PLA_MarcacionEmpleadoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdDiaSem() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.IdDiaSem = ".$this->getIdDiaSem()." AND ";
        if ( !is_null( $this->getIdTipo() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.IdTipo = '".$this->getIdTipo()."' AND ";
        if ( !is_null( $this->getIdRegistro() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.IdRegistro = '".$this->getIdRegistro()."' AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getHoraMinutoDesde() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.HoraMinutoDesde = '".$this->getHoraMinutoDesde()."' AND ";
        if ( !is_null( $this->getHoraMinutoHasta() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.HoraMinutoHasta = '".$this->getHoraMinutoHasta()."' AND ";
        if ( !is_null( $this->getDiaSiguienteFlag() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.DiaSiguienteFlag = ".$this->getDiaSiguienteFlag()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getEliminado() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.Eliminado = ".$this->getEliminado()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioEliminado() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.UsuarioEliminado = '".$this->getUsuarioEliminado()."' AND ";
        if ( !is_null( $this->getFechaEliminado() ) ) $s_SQLQuery .= "PLA_MarcacionEmpleado.FechaEliminado = '".$this->getFechaEliminado()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PLA_MarcacionEmpleado WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PLA_MarcacionEmpleadoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_MarcacionEmpleado WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PLA_MarcacionEmpleadoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PLA_MarcacionEmpleadoBN = $this->insertObjectBN( $a_SQLRow );
                $a_PLA_MarcacionEmpleadoBN[] = $o_PLA_MarcacionEmpleadoBN;
            }
        }
        return $a_PLA_MarcacionEmpleadoBN;
    }

    /* Devuelve un objeto PLA_MarcacionEmpleadoBN desde un objeto propel */
    public function insertObjectBN( $a_PLA_MarcacionEmpleado )
    {
        $o_PLA_MarcacionEmpleadoBN = new PLA_MarcacionEmpleadoBN();
        if ( !is_null( $a_PLA_MarcacionEmpleado['IdDiaSem'] ) ) $o_PLA_MarcacionEmpleadoBN->setIdDiaSem( ( integer ) $a_PLA_MarcacionEmpleado['IdDiaSem'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['IdTipo'] ) ) $o_PLA_MarcacionEmpleadoBN->setIdTipo( $a_PLA_MarcacionEmpleado['IdTipo'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['IdRegistro'] ) ) $o_PLA_MarcacionEmpleadoBN->setIdRegistro( $a_PLA_MarcacionEmpleado['IdRegistro'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['IdPersona'] ) ) $o_PLA_MarcacionEmpleadoBN->setIdPersona( ( integer ) $a_PLA_MarcacionEmpleado['IdPersona'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['HoraMinutoDesde'] ) ) $o_PLA_MarcacionEmpleadoBN->setHoraMinutoDesde( $a_PLA_MarcacionEmpleado['HoraMinutoDesde'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['HoraMinutoHasta'] ) ) $o_PLA_MarcacionEmpleadoBN->setHoraMinutoHasta( $a_PLA_MarcacionEmpleado['HoraMinutoHasta'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['DiaSiguienteFlag'] ) ) $o_PLA_MarcacionEmpleadoBN->setDiaSiguienteFlag( ( integer ) $a_PLA_MarcacionEmpleado['DiaSiguienteFlag'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['Estado'] ) ) $o_PLA_MarcacionEmpleadoBN->setEstado( $a_PLA_MarcacionEmpleado['Estado'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['Eliminado'] ) ) $o_PLA_MarcacionEmpleadoBN->setEliminado( ( integer ) $a_PLA_MarcacionEmpleado['Eliminado'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['UsuarioCreacion'] ) ) $o_PLA_MarcacionEmpleadoBN->setUsuarioCreacion( $a_PLA_MarcacionEmpleado['UsuarioCreacion'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['FechaCreacion'] ) ) $o_PLA_MarcacionEmpleadoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_PLA_MarcacionEmpleado['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PLA_MarcacionEmpleado['UsuarioModificacion'] ) ) $o_PLA_MarcacionEmpleadoBN->setUsuarioModificacion( $a_PLA_MarcacionEmpleado['UsuarioModificacion'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['FechaModificacion'] ) ) $o_PLA_MarcacionEmpleadoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PLA_MarcacionEmpleado['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PLA_MarcacionEmpleado['UsuarioEliminado'] ) ) $o_PLA_MarcacionEmpleadoBN->setUsuarioEliminado( $a_PLA_MarcacionEmpleado['UsuarioEliminado'] );
        if ( !is_null( $a_PLA_MarcacionEmpleado['FechaEliminado'] ) ) $o_PLA_MarcacionEmpleadoBN->setFechaEliminado( utilTimestamp::getTimestamp( $a_PLA_MarcacionEmpleado['FechaEliminado'], "Y-m-d H:i:s" ) );
        return $o_PLA_MarcacionEmpleadoBN;
    }
}
?>