<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_EmpleadoCargo.xml */
/* Generado: 2021-06-25 23:59:55 */

/* Busqueda de registros de la tabla PLA_EmpleadoCargo. */
abstract class BasePLA_EmpleadoCargoFN extends PLA_EmpleadoCargoBN
{
    /* Declaracion de constantes */
    const IdCargo = "PLA_EmpleadoCargo.IdCargo";
    const Descripcion = "PLA_EmpleadoCargo.Descripcion";
    const Estado = "PLA_EmpleadoCargo.Estado";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PLA_EmpleadoCargo.IdCargo AS IdCargo, ";
        $s_SQLQuery .= "PLA_EmpleadoCargo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "PLA_EmpleadoCargo.Estado AS Estado ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PLA_EmpleadoCargoBN */
    public function setByBN( PLA_EmpleadoCargoBN $o_PLA_EmpleadoCargoBN )
    {
        if ( !is_null( $o_PLA_EmpleadoCargoBN->getIdCargo() ) )
        {
            $this->setIdCargo( $o_PLA_EmpleadoCargoBN->getIdCargo() );
        }
        if ( !is_null( $o_PLA_EmpleadoCargoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PLA_EmpleadoCargoBN->getDescripcion() );
        }
        if ( !is_null( $o_PLA_EmpleadoCargoBN->getEstado() ) )
        {
            $this->setEstado( $o_PLA_EmpleadoCargoBN->getEstado() );
        }
    }

    /**
    * @return PLA_EmpleadoCargoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCargo )
    {
        if( is_null( $i_IdCargo ) ){ $i_IdCargo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_EmpleadoCargo ";
        $s_SQLQuery .= "WHERE IdCargo = ".$i_IdCargo." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PLA_EmpleadoCargoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PLA_EmpleadoCargoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PLA_EmpleadoCargoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCargo() ) ) $s_SQLQuery .= "PLA_EmpleadoCargo.IdCargo = ".$this->getIdCargo()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "PLA_EmpleadoCargo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PLA_EmpleadoCargo.Estado = '".$this->getEstado()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PLA_EmpleadoCargo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PLA_EmpleadoCargoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_EmpleadoCargo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PLA_EmpleadoCargoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PLA_EmpleadoCargoBN = $this->insertObjectBN( $a_SQLRow );
                $a_PLA_EmpleadoCargoBN[] = $o_PLA_EmpleadoCargoBN;
            }
        }
        return $a_PLA_EmpleadoCargoBN;
    }

    /* Devuelve un objeto PLA_EmpleadoCargoBN desde un objeto propel */
    public function insertObjectBN( $a_PLA_EmpleadoCargo )
    {
        $o_PLA_EmpleadoCargoBN = new PLA_EmpleadoCargoBN();
        if ( !is_null( $a_PLA_EmpleadoCargo['IdCargo'] ) ) $o_PLA_EmpleadoCargoBN->setIdCargo( ( integer ) $a_PLA_EmpleadoCargo['IdCargo'] );
        if ( !is_null( $a_PLA_EmpleadoCargo['Descripcion'] ) ) $o_PLA_EmpleadoCargoBN->setDescripcion( $a_PLA_EmpleadoCargo['Descripcion'] );
        if ( !is_null( $a_PLA_EmpleadoCargo['Estado'] ) ) $o_PLA_EmpleadoCargoBN->setEstado( $a_PLA_EmpleadoCargo['Estado'] );
        return $o_PLA_EmpleadoCargoBN;
    }
}
?>