<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_Asistencia.xml */
/* Generado: 2021-06-25 23:59:55 */

/* Busqueda de registros de la tabla PLA_Asistencia. */
abstract class BasePLA_AsistenciaFN extends PLA_AsistenciaBN
{
    /* Declaracion de constantes */
    const IdAsistencia = "PLA_Asistencia.IdAsistencia";
    const IdDiaSem = "PLA_Asistencia.IdDiaSem";
    const IdRegistro = "PLA_Asistencia.IdRegistro";
    const IdTipo = "PLA_Asistencia.IdTipo";
    const IdPersona = "PLA_Asistencia.IdPersona";
    const Fecha = "PLA_Asistencia.Fecha";
    const TipoDocumento = "PLA_Asistencia.TipoDocumento";
    const NumeroDocumento = "PLA_Asistencia.NumeroDocumento";
    const HoraMinuto = "PLA_Asistencia.HoraMinuto";
    const HoraMinutoPactado = "PLA_Asistencia.HoraMinutoPactado";
    const MontoDescuento = "PLA_Asistencia.MontoDescuento";
    const IdAsistenciaRef = "PLA_Asistencia.IdAsistenciaRef";
    const DiaSiguienteFlag = "PLA_Asistencia.DiaSiguienteFlag";
    const UsuarioCreacion = "PLA_Asistencia.UsuarioCreacion";
    const FechaCreacion = "PLA_Asistencia.FechaCreacion";
    const UsuarioModificacion = "PLA_Asistencia.UsuarioModificacion";
    const FechaModificacion = "PLA_Asistencia.FechaModificacion";
    const Eliminado = "PLA_Asistencia.Eliminado";
    const MotivoEliminado = "PLA_Asistencia.MotivoEliminado";
    const FechaEliminado = "PLA_Asistencia.FechaEliminado";
    const UsuarioEliminado = "PLA_Asistencia.UsuarioEliminado";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PLA_Asistencia.IdAsistencia AS IdAsistencia, ";
        $s_SQLQuery .= "PLA_Asistencia.IdDiaSem AS IdDiaSem, ";
        $s_SQLQuery .= "PLA_Asistencia.IdRegistro AS IdRegistro, ";
        $s_SQLQuery .= "PLA_Asistencia.IdTipo AS IdTipo, ";
        $s_SQLQuery .= "PLA_Asistencia.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "PLA_Asistencia.Fecha AS Fecha, ";
        $s_SQLQuery .= "PLA_Asistencia.TipoDocumento AS TipoDocumento, ";
        $s_SQLQuery .= "PLA_Asistencia.NumeroDocumento AS NumeroDocumento, ";
        $s_SQLQuery .= "PLA_Asistencia.HoraMinuto AS HoraMinuto, ";
        $s_SQLQuery .= "PLA_Asistencia.HoraMinutoPactado AS HoraMinutoPactado, ";
        $s_SQLQuery .= "PLA_Asistencia.MontoDescuento AS MontoDescuento, ";
        $s_SQLQuery .= "PLA_Asistencia.IdAsistenciaRef AS IdAsistenciaRef, ";
        $s_SQLQuery .= "PLA_Asistencia.DiaSiguienteFlag AS DiaSiguienteFlag, ";
        $s_SQLQuery .= "PLA_Asistencia.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "PLA_Asistencia.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "PLA_Asistencia.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PLA_Asistencia.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "PLA_Asistencia.Eliminado AS Eliminado, ";
        $s_SQLQuery .= "PLA_Asistencia.MotivoEliminado AS MotivoEliminado, ";
        $s_SQLQuery .= "PLA_Asistencia.FechaEliminado AS FechaEliminado, ";
        $s_SQLQuery .= "PLA_Asistencia.UsuarioEliminado AS UsuarioEliminado ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PLA_AsistenciaBN */
    public function setByBN( PLA_AsistenciaBN $o_PLA_AsistenciaBN )
    {
        if ( !is_null( $o_PLA_AsistenciaBN->getIdAsistencia() ) )
        {
            $this->setIdAsistencia( $o_PLA_AsistenciaBN->getIdAsistencia() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getIdDiaSem() ) )
        {
            $this->setIdDiaSem( $o_PLA_AsistenciaBN->getIdDiaSem() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getIdRegistro() ) )
        {
            $this->setIdRegistro( $o_PLA_AsistenciaBN->getIdRegistro() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getIdTipo() ) )
        {
            $this->setIdTipo( $o_PLA_AsistenciaBN->getIdTipo() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_PLA_AsistenciaBN->getIdPersona() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getFecha() ) )
        {
            $this->setFecha( $o_PLA_AsistenciaBN->getFecha() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getTipoDocumento() ) )
        {
            $this->setTipoDocumento( $o_PLA_AsistenciaBN->getTipoDocumento() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getNumeroDocumento() ) )
        {
            $this->setNumeroDocumento( $o_PLA_AsistenciaBN->getNumeroDocumento() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getHoraMinuto() ) )
        {
            $this->setHoraMinuto( $o_PLA_AsistenciaBN->getHoraMinuto() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getHoraMinutoPactado() ) )
        {
            $this->setHoraMinutoPactado( $o_PLA_AsistenciaBN->getHoraMinutoPactado() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getMontoDescuento() ) )
        {
            $this->setMontoDescuento( $o_PLA_AsistenciaBN->getMontoDescuento() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getIdAsistenciaRef() ) )
        {
            $this->setIdAsistenciaRef( $o_PLA_AsistenciaBN->getIdAsistenciaRef() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getDiaSiguienteFlag() ) )
        {
            $this->setDiaSiguienteFlag( $o_PLA_AsistenciaBN->getDiaSiguienteFlag() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PLA_AsistenciaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PLA_AsistenciaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PLA_AsistenciaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PLA_AsistenciaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getEliminado() ) )
        {
            $this->setEliminado( $o_PLA_AsistenciaBN->getEliminado() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getMotivoEliminado() ) )
        {
            $this->setMotivoEliminado( $o_PLA_AsistenciaBN->getMotivoEliminado() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getFechaEliminado() ) )
        {
            $this->setFechaEliminado( $o_PLA_AsistenciaBN->getFechaEliminado() );
        }
        if ( !is_null( $o_PLA_AsistenciaBN->getUsuarioEliminado() ) )
        {
            $this->setUsuarioEliminado( $o_PLA_AsistenciaBN->getUsuarioEliminado() );
        }
    }

    /**
    * @return PLA_AsistenciaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdAsistencia )
    {
        if( is_null( $i_IdAsistencia ) ){ $i_IdAsistencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_Asistencia ";
        $s_SQLQuery .= "WHERE IdAsistencia = ".$i_IdAsistencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_PLA_AsistenciaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PLA_AsistenciaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PLA_AsistenciaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdAsistencia() ) ) $s_SQLQuery .= "PLA_Asistencia.IdAsistencia = ".$this->getIdAsistencia()." AND ";
        if ( !is_null( $this->getIdDiaSem() ) ) $s_SQLQuery .= "PLA_Asistencia.IdDiaSem = ".$this->getIdDiaSem()." AND ";
        if ( !is_null( $this->getIdRegistro() ) ) $s_SQLQuery .= "PLA_Asistencia.IdRegistro = '".$this->getIdRegistro()."' AND ";
        if ( !is_null( $this->getIdTipo() ) ) $s_SQLQuery .= "PLA_Asistencia.IdTipo = '".$this->getIdTipo()."' AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "PLA_Asistencia.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getFecha() ) ) $s_SQLQuery .= "PLA_Asistencia.Fecha = '".$this->getFecha()."' AND ";
        if ( !is_null( $this->getTipoDocumento() ) ) $s_SQLQuery .= "PLA_Asistencia.TipoDocumento = '".$this->getTipoDocumento()."' AND ";
        if ( !is_null( $this->getNumeroDocumento() ) ) $s_SQLQuery .= "PLA_Asistencia.NumeroDocumento = '".$this->getNumeroDocumento()."' AND ";
        if ( !is_null( $this->getHoraMinuto() ) ) $s_SQLQuery .= "PLA_Asistencia.HoraMinuto = '".$this->getHoraMinuto()."' AND ";
        if ( !is_null( $this->getHoraMinutoPactado() ) ) $s_SQLQuery .= "PLA_Asistencia.HoraMinutoPactado = '".$this->getHoraMinutoPactado()."' AND ";
        if ( !is_null( $this->getMontoDescuento() ) ) $s_SQLQuery .= "PLA_Asistencia.MontoDescuento = ".$this->getMontoDescuento()." AND ";
        if ( !is_null( $this->getIdAsistenciaRef() ) ) $s_SQLQuery .= "PLA_Asistencia.IdAsistenciaRef = ".$this->getIdAsistenciaRef()." AND ";
        if ( !is_null( $this->getDiaSiguienteFlag() ) ) $s_SQLQuery .= "PLA_Asistencia.DiaSiguienteFlag = ".$this->getDiaSiguienteFlag()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "PLA_Asistencia.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "PLA_Asistencia.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PLA_Asistencia.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PLA_Asistencia.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getEliminado() ) ) $s_SQLQuery .= "PLA_Asistencia.Eliminado = ".$this->getEliminado()." AND ";
        if ( !is_null( $this->getMotivoEliminado() ) ) $s_SQLQuery .= "PLA_Asistencia.MotivoEliminado = '".$this->getMotivoEliminado()."' AND ";
        if ( !is_null( $this->getFechaEliminado() ) ) $s_SQLQuery .= "PLA_Asistencia.FechaEliminado = '".$this->getFechaEliminado()."' AND ";
        if ( !is_null( $this->getUsuarioEliminado() ) ) $s_SQLQuery .= "PLA_Asistencia.UsuarioEliminado = '".$this->getUsuarioEliminado()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PLA_Asistencia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PLA_AsistenciaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_Asistencia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_PLA_AsistenciaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PLA_AsistenciaBN = $this->insertObjectBN( $a_SQLRow );
                $a_PLA_AsistenciaBN[] = $o_PLA_AsistenciaBN;
            }
        }
        return $a_PLA_AsistenciaBN;
    }

    /* Devuelve un objeto PLA_AsistenciaBN desde un objeto propel */
    public function insertObjectBN( $a_PLA_Asistencia )
    {
        $o_PLA_AsistenciaBN = new PLA_AsistenciaBN();
        if ( !is_null( $a_PLA_Asistencia['IdAsistencia'] ) ) $o_PLA_AsistenciaBN->setIdAsistencia( ( integer ) $a_PLA_Asistencia['IdAsistencia'] );
        if ( !is_null( $a_PLA_Asistencia['IdDiaSem'] ) ) $o_PLA_AsistenciaBN->setIdDiaSem( ( integer ) $a_PLA_Asistencia['IdDiaSem'] );
        if ( !is_null( $a_PLA_Asistencia['IdRegistro'] ) ) $o_PLA_AsistenciaBN->setIdRegistro( $a_PLA_Asistencia['IdRegistro'] );
        if ( !is_null( $a_PLA_Asistencia['IdTipo'] ) ) $o_PLA_AsistenciaBN->setIdTipo( $a_PLA_Asistencia['IdTipo'] );
        if ( !is_null( $a_PLA_Asistencia['IdPersona'] ) ) $o_PLA_AsistenciaBN->setIdPersona( ( integer ) $a_PLA_Asistencia['IdPersona'] );
        if ( !is_null( $a_PLA_Asistencia['Fecha'] ) ) $o_PLA_AsistenciaBN->setFecha( utilTimestamp::getTimestamp( $a_PLA_Asistencia['Fecha'], "Y-m-d" ) );
        if ( !is_null( $a_PLA_Asistencia['TipoDocumento'] ) ) $o_PLA_AsistenciaBN->setTipoDocumento( $a_PLA_Asistencia['TipoDocumento'] );
        if ( !is_null( $a_PLA_Asistencia['NumeroDocumento'] ) ) $o_PLA_AsistenciaBN->setNumeroDocumento( $a_PLA_Asistencia['NumeroDocumento'] );
        if ( !is_null( $a_PLA_Asistencia['HoraMinuto'] ) ) $o_PLA_AsistenciaBN->setHoraMinuto( utilTimestamp::getTimestamp( $a_PLA_Asistencia['HoraMinuto'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PLA_Asistencia['HoraMinutoPactado'] ) ) $o_PLA_AsistenciaBN->setHoraMinutoPactado( utilTimestamp::getTimestamp( $a_PLA_Asistencia['HoraMinutoPactado'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PLA_Asistencia['MontoDescuento'] ) ) $o_PLA_AsistenciaBN->setMontoDescuento( ( float ) $a_PLA_Asistencia['MontoDescuento'] );
        if ( !is_null( $a_PLA_Asistencia['IdAsistenciaRef'] ) ) $o_PLA_AsistenciaBN->setIdAsistenciaRef( ( integer ) $a_PLA_Asistencia['IdAsistenciaRef'] );
        if ( !is_null( $a_PLA_Asistencia['DiaSiguienteFlag'] ) ) $o_PLA_AsistenciaBN->setDiaSiguienteFlag( ( integer ) $a_PLA_Asistencia['DiaSiguienteFlag'] );
        if ( !is_null( $a_PLA_Asistencia['UsuarioCreacion'] ) ) $o_PLA_AsistenciaBN->setUsuarioCreacion( $a_PLA_Asistencia['UsuarioCreacion'] );
        if ( !is_null( $a_PLA_Asistencia['FechaCreacion'] ) ) $o_PLA_AsistenciaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_PLA_Asistencia['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PLA_Asistencia['UsuarioModificacion'] ) ) $o_PLA_AsistenciaBN->setUsuarioModificacion( $a_PLA_Asistencia['UsuarioModificacion'] );
        if ( !is_null( $a_PLA_Asistencia['FechaModificacion'] ) ) $o_PLA_AsistenciaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PLA_Asistencia['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PLA_Asistencia['Eliminado'] ) ) $o_PLA_AsistenciaBN->setEliminado( ( integer ) $a_PLA_Asistencia['Eliminado'] );
        if ( !is_null( $a_PLA_Asistencia['MotivoEliminado'] ) ) $o_PLA_AsistenciaBN->setMotivoEliminado( $a_PLA_Asistencia['MotivoEliminado'] );
        if ( !is_null( $a_PLA_Asistencia['FechaEliminado'] ) ) $o_PLA_AsistenciaBN->setFechaEliminado( utilTimestamp::getTimestamp( $a_PLA_Asistencia['FechaEliminado'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PLA_Asistencia['UsuarioEliminado'] ) ) $o_PLA_AsistenciaBN->setUsuarioEliminado( $a_PLA_Asistencia['UsuarioEliminado'] );
        return $o_PLA_AsistenciaBN;
    }
}
?>