<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ValidezOf.xml */
/* Generado: 2021-09-07 05:02:21 */

/* Busqueda de registros de la tabla MST_ValidezOf. */
abstract class BaseMST_ValidezOfFN extends MST_ValidezOfBN
{
    /* Declaracion de constantes */
    const ValidezId = "MST_ValidezOf.ValidezId";
    const Descripcion = "MST_ValidezOf.Descripcion";
    const CantHoras = "MST_ValidezOf.CantHoras";
    const Estado = "MST_ValidezOf.Estado";
    const UsuarioCreacion = "MST_ValidezOf.UsuarioCreacion";
    const FechaCreacion = "MST_ValidezOf.FechaCreacion";
    const UsuarioModificacion = "MST_ValidezOf.UsuarioModificacion";
    const FechaModificacion = "MST_ValidezOf.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ValidezOf.ValidezId AS ValidezId, ";
        $s_SQLQuery .= "MST_ValidezOf.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_ValidezOf.CantHoras AS CantHoras, ";
        $s_SQLQuery .= "MST_ValidezOf.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ValidezOf.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ValidezOf.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ValidezOf.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_ValidezOf.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ValidezOfBN */
    public function setByBN( MST_ValidezOfBN $o_MST_ValidezOfBN )
    {
        if ( !is_null( $o_MST_ValidezOfBN->getValidezId() ) )
        {
            $this->setValidezId( $o_MST_ValidezOfBN->getValidezId() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ValidezOfBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getCantHoras() ) )
        {
            $this->setCantHoras( $o_MST_ValidezOfBN->getCantHoras() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ValidezOfBN->getEstado() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ValidezOfBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ValidezOfBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ValidezOfBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ValidezOfBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ValidezOfBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_ValidezOfBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_ValidezId )
    {
        if( is_null( $i_ValidezId ) ){ $i_ValidezId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ValidezOf ";
        $s_SQLQuery .= "WHERE ValidezId = ".$i_ValidezId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_ValidezOfBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ValidezOfBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ValidezOfBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getValidezId() ) ) $s_SQLQuery .= "MST_ValidezOf.ValidezId = ".$this->getValidezId()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_ValidezOf.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCantHoras() ) ) $s_SQLQuery .= "MST_ValidezOf.CantHoras = ".$this->getCantHoras()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ValidezOf.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ValidezOf.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ValidezOf.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ValidezOf.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ValidezOf.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ValidezOf WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ValidezOfBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ValidezOf WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_ValidezOfBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ValidezOfBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ValidezOfBN[] = $o_MST_ValidezOfBN;
            }
        }
        return $a_MST_ValidezOfBN;
    }

    /* Devuelve un objeto MST_ValidezOfBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ValidezOf )
    {
        $o_MST_ValidezOfBN = new MST_ValidezOfBN();
        if ( !is_null( $a_MST_ValidezOf['ValidezId'] ) ) $o_MST_ValidezOfBN->setValidezId( ( integer ) $a_MST_ValidezOf['ValidezId'] );
        if ( !is_null( $a_MST_ValidezOf['Descripcion'] ) ) $o_MST_ValidezOfBN->setDescripcion( $a_MST_ValidezOf['Descripcion'] );
        if ( !is_null( $a_MST_ValidezOf['CantHoras'] ) ) $o_MST_ValidezOfBN->setCantHoras( ( integer ) $a_MST_ValidezOf['CantHoras'] );
        if ( !is_null( $a_MST_ValidezOf['Estado'] ) ) $o_MST_ValidezOfBN->setEstado( $a_MST_ValidezOf['Estado'] );
        if ( !is_null( $a_MST_ValidezOf['UsuarioCreacion'] ) ) $o_MST_ValidezOfBN->setUsuarioCreacion( $a_MST_ValidezOf['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ValidezOf['FechaCreacion'] ) ) $o_MST_ValidezOfBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ValidezOf['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ValidezOf['UsuarioModificacion'] ) ) $o_MST_ValidezOfBN->setUsuarioModificacion( $a_MST_ValidezOf['UsuarioModificacion'] );
        if ( !is_null( $a_MST_ValidezOf['FechaModificacion'] ) ) $o_MST_ValidezOfBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ValidezOf['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_ValidezOfBN;
    }
}
?>