<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_UnidadConversionMast.xml */
/* Generado: 2021-06-25 23:59:55 */

/* Busqueda de registros de la tabla MST_UnidadConversionMast. */
abstract class BaseMST_UnidadConversionMastFN extends MST_UnidadConversionMastBN
{
    /* Declaracion de constantes */
    const IdUnidad = "MST_UnidadConversionMast.IdUnidad";
    const IdUnidadEquivalente = "MST_UnidadConversionMast.IdUnidadEquivalente";
    const CantidadEquivalente = "MST_UnidadConversionMast.CantidadEquivalente";
    const Secuencia = "MST_UnidadConversionMast.Secuencia";
    const Estado = "MST_UnidadConversionMast.Estado";
    const FechaCreacion = "MST_UnidadConversionMast.FechaCreacion";
    const UsuarioCreacion = "MST_UnidadConversionMast.UsuarioCreacion";
    const FechaModificacion = "MST_UnidadConversionMast.FechaModificacion";
    const UsuarioModificacion = "MST_UnidadConversionMast.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_UnidadConversionMast.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "MST_UnidadConversionMast.IdUnidadEquivalente AS IdUnidadEquivalente, ";
        $s_SQLQuery .= "MST_UnidadConversionMast.CantidadEquivalente AS CantidadEquivalente, ";
        $s_SQLQuery .= "MST_UnidadConversionMast.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "MST_UnidadConversionMast.Estado AS Estado, ";
        $s_SQLQuery .= "MST_UnidadConversionMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_UnidadConversionMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_UnidadConversionMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_UnidadConversionMast.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_UnidadConversionMastBN */
    public function setByBN( MST_UnidadConversionMastBN $o_MST_UnidadConversionMastBN )
    {
        if ( !is_null( $o_MST_UnidadConversionMastBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_MST_UnidadConversionMastBN->getIdUnidad() );
        }
        if ( !is_null( $o_MST_UnidadConversionMastBN->getIdUnidadEquivalente() ) )
        {
            $this->setIdUnidadEquivalente( $o_MST_UnidadConversionMastBN->getIdUnidadEquivalente() );
        }
        if ( !is_null( $o_MST_UnidadConversionMastBN->getCantidadEquivalente() ) )
        {
            $this->setCantidadEquivalente( $o_MST_UnidadConversionMastBN->getCantidadEquivalente() );
        }
        if ( !is_null( $o_MST_UnidadConversionMastBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_MST_UnidadConversionMastBN->getSecuencia() );
        }
        if ( !is_null( $o_MST_UnidadConversionMastBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_UnidadConversionMastBN->getEstado() );
        }
        if ( !is_null( $o_MST_UnidadConversionMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_UnidadConversionMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_UnidadConversionMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_UnidadConversionMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_UnidadConversionMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_UnidadConversionMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_UnidadConversionMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_UnidadConversionMastBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_UnidadConversionMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdUnidad, $s_IdUnidadEquivalente )
    {
        if( is_null( $s_IdUnidad ) ){ $s_IdUnidad = '-1'; } 
        if( is_null( $s_IdUnidadEquivalente ) ){ $s_IdUnidadEquivalente = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_UnidadConversionMast ";
        $s_SQLQuery .= "WHERE IdUnidad = '".$s_IdUnidad."' ";
        $s_SQLQuery .= "AND IdUnidadEquivalente = '".$s_IdUnidadEquivalente."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_UnidadConversionMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_UnidadConversionMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_UnidadConversionMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.IdUnidad = '".$this->getIdUnidad()."' AND ";
        if ( !is_null( $this->getIdUnidadEquivalente() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.IdUnidadEquivalente = '".$this->getIdUnidadEquivalente()."' AND ";
        if ( !is_null( $this->getCantidadEquivalente() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.CantidadEquivalente = ".$this->getCantidadEquivalente()." AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.Secuencia = ".$this->getSecuencia()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_UnidadConversionMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_UnidadConversionMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_UnidadConversionMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_UnidadConversionMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_UnidadConversionMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_UnidadConversionMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_UnidadConversionMastBN[] = $o_MST_UnidadConversionMastBN;
            }
        }
        return $a_MST_UnidadConversionMastBN;
    }

    /* Devuelve un objeto MST_UnidadConversionMastBN desde un objeto propel */
    public function insertObjectBN( $a_MST_UnidadConversionMast )
    {
        $o_MST_UnidadConversionMastBN = new MST_UnidadConversionMastBN();
        if ( !is_null( $a_MST_UnidadConversionMast['IdUnidad'] ) ) $o_MST_UnidadConversionMastBN->setIdUnidad( $a_MST_UnidadConversionMast['IdUnidad'] );
        if ( !is_null( $a_MST_UnidadConversionMast['IdUnidadEquivalente'] ) ) $o_MST_UnidadConversionMastBN->setIdUnidadEquivalente( $a_MST_UnidadConversionMast['IdUnidadEquivalente'] );
        if ( !is_null( $a_MST_UnidadConversionMast['CantidadEquivalente'] ) ) $o_MST_UnidadConversionMastBN->setCantidadEquivalente( ( float ) $a_MST_UnidadConversionMast['CantidadEquivalente'] );
        if ( !is_null( $a_MST_UnidadConversionMast['Secuencia'] ) ) $o_MST_UnidadConversionMastBN->setSecuencia( ( integer ) $a_MST_UnidadConversionMast['Secuencia'] );
        if ( !is_null( $a_MST_UnidadConversionMast['Estado'] ) ) $o_MST_UnidadConversionMastBN->setEstado( $a_MST_UnidadConversionMast['Estado'] );
        if ( !is_null( $a_MST_UnidadConversionMast['FechaCreacion'] ) ) $o_MST_UnidadConversionMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_UnidadConversionMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_UnidadConversionMast['UsuarioCreacion'] ) ) $o_MST_UnidadConversionMastBN->setUsuarioCreacion( $a_MST_UnidadConversionMast['UsuarioCreacion'] );
        if ( !is_null( $a_MST_UnidadConversionMast['FechaModificacion'] ) ) $o_MST_UnidadConversionMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_UnidadConversionMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_UnidadConversionMast['UsuarioModificacion'] ) ) $o_MST_UnidadConversionMastBN->setUsuarioModificacion( $a_MST_UnidadConversionMast['UsuarioModificacion'] );
        return $o_MST_UnidadConversionMastBN;
    }
}
?>