<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Ubigeo.xml */
/* Generado: 2021-06-25 23:59:54 */

/* Busqueda de registros de la tabla MST_Ubigeo. */
abstract class BaseMST_UbigeoFN extends MST_UbigeoBN
{
    /* Declaracion de constantes */
    const IdUbigeo = "MST_Ubigeo.IdUbigeo";
    const Descripcion = "MST_Ubigeo.Descripcion";
    const Tipo = "MST_Ubigeo.Tipo";
    const Codigo = "MST_Ubigeo.Codigo";
    const Pertenece = "MST_Ubigeo.Pertenece";
    const Estado = "MST_Ubigeo.Estado";
    const FechaCreacion = "MST_Ubigeo.FechaCreacion";
    const UsuarioCreacion = "MST_Ubigeo.UsuarioCreacion";
    const FechaModificacion = "MST_Ubigeo.FechaModificacion";
    const UsuarioModificacion = "MST_Ubigeo.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Ubigeo.IdUbigeo AS IdUbigeo, ";
        $s_SQLQuery .= "MST_Ubigeo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Ubigeo.Tipo AS Tipo, ";
        $s_SQLQuery .= "MST_Ubigeo.Codigo AS Codigo, ";
        $s_SQLQuery .= "MST_Ubigeo.Pertenece AS Pertenece, ";
        $s_SQLQuery .= "MST_Ubigeo.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Ubigeo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Ubigeo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Ubigeo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_Ubigeo.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_UbigeoBN */
    public function setByBN( MST_UbigeoBN $o_MST_UbigeoBN )
    {
        if ( !is_null( $o_MST_UbigeoBN->getIdUbigeo() ) )
        {
            $this->setIdUbigeo( $o_MST_UbigeoBN->getIdUbigeo() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_UbigeoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getTipo() ) )
        {
            $this->setTipo( $o_MST_UbigeoBN->getTipo() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_UbigeoBN->getCodigo() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getPertenece() ) )
        {
            $this->setPertenece( $o_MST_UbigeoBN->getPertenece() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_UbigeoBN->getEstado() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_UbigeoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_UbigeoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_UbigeoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_UbigeoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_UbigeoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_UbigeoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdUbigeo )
    {
        if( is_null( $s_IdUbigeo ) ){ $s_IdUbigeo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Ubigeo ";
        $s_SQLQuery .= "WHERE IdUbigeo = '".$s_IdUbigeo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_UbigeoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_UbigeoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_UbigeoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdUbigeo() ) ) $s_SQLQuery .= "MST_Ubigeo.IdUbigeo = '".$this->getIdUbigeo()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Ubigeo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "MST_Ubigeo.Tipo = '".$this->getTipo()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "MST_Ubigeo.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getPertenece() ) ) $s_SQLQuery .= "MST_Ubigeo.Pertenece = '".$this->getPertenece()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Ubigeo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Ubigeo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Ubigeo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Ubigeo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Ubigeo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Ubigeo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_UbigeoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Ubigeo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_UbigeoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_UbigeoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_UbigeoBN[] = $o_MST_UbigeoBN;
            }
        }
        return $a_MST_UbigeoBN;
    }

    /* Devuelve un objeto MST_UbigeoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Ubigeo )
    {
        $o_MST_UbigeoBN = new MST_UbigeoBN();
        if ( !is_null( $a_MST_Ubigeo['IdUbigeo'] ) ) $o_MST_UbigeoBN->setIdUbigeo( $a_MST_Ubigeo['IdUbigeo'] );
        if ( !is_null( $a_MST_Ubigeo['Descripcion'] ) ) $o_MST_UbigeoBN->setDescripcion( $a_MST_Ubigeo['Descripcion'] );
        if ( !is_null( $a_MST_Ubigeo['Tipo'] ) ) $o_MST_UbigeoBN->setTipo( $a_MST_Ubigeo['Tipo'] );
        if ( !is_null( $a_MST_Ubigeo['Codigo'] ) ) $o_MST_UbigeoBN->setCodigo( $a_MST_Ubigeo['Codigo'] );
        if ( !is_null( $a_MST_Ubigeo['Pertenece'] ) ) $o_MST_UbigeoBN->setPertenece( $a_MST_Ubigeo['Pertenece'] );
        if ( !is_null( $a_MST_Ubigeo['Estado'] ) ) $o_MST_UbigeoBN->setEstado( $a_MST_Ubigeo['Estado'] );
        if ( !is_null( $a_MST_Ubigeo['FechaCreacion'] ) ) $o_MST_UbigeoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Ubigeo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Ubigeo['UsuarioCreacion'] ) ) $o_MST_UbigeoBN->setUsuarioCreacion( $a_MST_Ubigeo['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Ubigeo['FechaModificacion'] ) ) $o_MST_UbigeoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Ubigeo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Ubigeo['UsuarioModificacion'] ) ) $o_MST_UbigeoBN->setUsuarioModificacion( $a_MST_Ubigeo['UsuarioModificacion'] );
        return $o_MST_UbigeoBN;
    }
}
?>