<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Turno.xml */
/* Generado: 2021-11-09 06:44:44 */

/* Busqueda de registros de la tabla MST_Turno. */
abstract class BaseMST_TurnoFN extends MST_TurnoBN
{
    /* Declaracion de constantes */
    const IdTurno = "MST_Turno.IdTurno";
    const IdGrupoTurno = "MST_Turno.IdGrupoTurno";
    const IdTipoTurno = "MST_Turno.IdTipoTurno";
    const Descripcion = "MST_Turno.Descripcion";
    const HoraInicio = "MST_Turno.HoraInicio";
    const HoraFinal = "MST_Turno.HoraFinal";
    const Estado = "MST_Turno.Estado";
    const FechaCreacion = "MST_Turno.FechaCreacion";
    const UsuarioCreacion = "MST_Turno.UsuarioCreacion";
    const FechaModificacion = "MST_Turno.FechaModificacion";
    const UsuarioModificacion = "MST_Turno.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Turno.IdTurno AS IdTurno, ";
        $s_SQLQuery .= "MST_Turno.IdGrupoTurno AS IdGrupoTurno, ";
        $s_SQLQuery .= "MST_Turno.IdTipoTurno AS IdTipoTurno, ";
        $s_SQLQuery .= "MST_Turno.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Turno.HoraInicio AS HoraInicio, ";
        $s_SQLQuery .= "MST_Turno.HoraFinal AS HoraFinal, ";
        $s_SQLQuery .= "MST_Turno.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Turno.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Turno.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Turno.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_Turno.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TurnoBN */
    public function setByBN( MST_TurnoBN $o_MST_TurnoBN )
    {
        if ( !is_null( $o_MST_TurnoBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_MST_TurnoBN->getIdTurno() );
        }
        if ( !is_null( $o_MST_TurnoBN->getIdGrupoTurno() ) )
        {
            $this->setIdGrupoTurno( $o_MST_TurnoBN->getIdGrupoTurno() );
        }
        if ( !is_null( $o_MST_TurnoBN->getIdTipoTurno() ) )
        {
            $this->setIdTipoTurno( $o_MST_TurnoBN->getIdTipoTurno() );
        }
        if ( !is_null( $o_MST_TurnoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TurnoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TurnoBN->getHoraInicio() ) )
        {
            $this->setHoraInicio( $o_MST_TurnoBN->getHoraInicio() );
        }
        if ( !is_null( $o_MST_TurnoBN->getHoraFinal() ) )
        {
            $this->setHoraFinal( $o_MST_TurnoBN->getHoraFinal() );
        }
        if ( !is_null( $o_MST_TurnoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TurnoBN->getEstado() );
        }
        if ( !is_null( $o_MST_TurnoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TurnoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TurnoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TurnoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TurnoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TurnoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_TurnoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TurnoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_TurnoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTurno )
    {
        if( is_null( $i_IdTurno ) ){ $i_IdTurno = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Turno ";
        $s_SQLQuery .= "WHERE IdTurno = ".$i_IdTurno." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_TurnoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TurnoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TurnoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTurno() ) ) $s_SQLQuery .= "MST_Turno.IdTurno = ".$this->getIdTurno()." AND ";
        if ( !is_null( $this->getIdGrupoTurno() ) ) $s_SQLQuery .= "MST_Turno.IdGrupoTurno = ".$this->getIdGrupoTurno()." AND ";
        if ( !is_null( $this->getIdTipoTurno() ) ) $s_SQLQuery .= "MST_Turno.IdTipoTurno = ".$this->getIdTipoTurno()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Turno.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getHoraInicio() ) ) $s_SQLQuery .= "MST_Turno.HoraInicio = '".$this->getHoraInicio()."' AND ";
        if ( !is_null( $this->getHoraFinal() ) ) $s_SQLQuery .= "MST_Turno.HoraFinal = '".$this->getHoraFinal()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Turno.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Turno.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Turno.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Turno.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Turno.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Turno WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TurnoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Turno WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_TurnoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TurnoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TurnoBN[] = $o_MST_TurnoBN;
            }
        }
        return $a_MST_TurnoBN;
    }

    /* Devuelve un objeto MST_TurnoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Turno )
    {
        $o_MST_TurnoBN = new MST_TurnoBN();
        if ( !is_null( $a_MST_Turno['IdTurno'] ) ) $o_MST_TurnoBN->setIdTurno( ( integer ) $a_MST_Turno['IdTurno'] );
        if ( !is_null( $a_MST_Turno['IdGrupoTurno'] ) ) $o_MST_TurnoBN->setIdGrupoTurno( ( integer ) $a_MST_Turno['IdGrupoTurno'] );
        if ( !is_null( $a_MST_Turno['IdTipoTurno'] ) ) $o_MST_TurnoBN->setIdTipoTurno( ( integer ) $a_MST_Turno['IdTipoTurno'] );
        if ( !is_null( $a_MST_Turno['Descripcion'] ) ) $o_MST_TurnoBN->setDescripcion( $a_MST_Turno['Descripcion'] );
        if ( !is_null( $a_MST_Turno['HoraInicio'] ) ) $o_MST_TurnoBN->setHoraInicio( $a_MST_Turno['HoraInicio'] );
        if ( !is_null( $a_MST_Turno['HoraFinal'] ) ) $o_MST_TurnoBN->setHoraFinal( $a_MST_Turno['HoraFinal'] );
        if ( !is_null( $a_MST_Turno['Estado'] ) ) $o_MST_TurnoBN->setEstado( $a_MST_Turno['Estado'] );
        if ( !is_null( $a_MST_Turno['FechaCreacion'] ) ) $o_MST_TurnoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Turno['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Turno['UsuarioCreacion'] ) ) $o_MST_TurnoBN->setUsuarioCreacion( $a_MST_Turno['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Turno['FechaModificacion'] ) ) $o_MST_TurnoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Turno['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Turno['UsuarioModificacion'] ) ) $o_MST_TurnoBN->setUsuarioModificacion( $a_MST_Turno['UsuarioModificacion'] );
        return $o_MST_TurnoBN;
    }
}
?>