<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoUbicacion.xml */
/* Generado: 2021-06-25 23:59:54 */

/* Busqueda de registros de la tabla MST_TipoUbicacion. */
abstract class BaseMST_TipoUbicacionFN extends MST_TipoUbicacionBN
{
    /* Declaracion de constantes */
    const IdTipoUbicacion = "MST_TipoUbicacion.IdTipoUbicacion";
    const Nombre = "MST_TipoUbicacion.Nombre";
    const Nivel = "MST_TipoUbicacion.Nivel";
    const ImagenUbicacion = "MST_TipoUbicacion.ImagenUbicacion";
    const Estado = "MST_TipoUbicacion.Estado";
    const FechaCreacion = "MST_TipoUbicacion.FechaCreacion";
    const UsuarioCreacion = "MST_TipoUbicacion.UsuarioCreacion";
    const FechaModificacion = "MST_TipoUbicacion.FechaModificacion";
    const UsuarioModificacion = "MST_TipoUbicacion.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_TipoUbicacion.IdTipoUbicacion AS IdTipoUbicacion, ";
        $s_SQLQuery .= "MST_TipoUbicacion.Nombre AS Nombre, ";
        $s_SQLQuery .= "MST_TipoUbicacion.Nivel AS Nivel, ";
        $s_SQLQuery .= "MST_TipoUbicacion.ImagenUbicacion AS ImagenUbicacion, ";
        $s_SQLQuery .= "MST_TipoUbicacion.Estado AS Estado, ";
        $s_SQLQuery .= "MST_TipoUbicacion.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_TipoUbicacion.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_TipoUbicacion.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_TipoUbicacion.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TipoUbicacionBN */
    public function setByBN( MST_TipoUbicacionBN $o_MST_TipoUbicacionBN )
    {
        if ( !is_null( $o_MST_TipoUbicacionBN->getIdTipoUbicacion() ) )
        {
            $this->setIdTipoUbicacion( $o_MST_TipoUbicacionBN->getIdTipoUbicacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_TipoUbicacionBN->getNombre() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getNivel() ) )
        {
            $this->setNivel( $o_MST_TipoUbicacionBN->getNivel() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getImagenUbicacion() ) )
        {
            $this->setImagenUbicacion( $o_MST_TipoUbicacionBN->getImagenUbicacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TipoUbicacionBN->getEstado() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TipoUbicacionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TipoUbicacionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TipoUbicacionBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_TipoUbicacionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TipoUbicacionBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_TipoUbicacionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTipoUbicacion )
    {
        if( is_null( $i_IdTipoUbicacion ) ){ $i_IdTipoUbicacion = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoUbicacion ";
        $s_SQLQuery .= "WHERE IdTipoUbicacion = ".$i_IdTipoUbicacion." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_TipoUbicacionBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TipoUbicacionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TipoUbicacionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipoUbicacion() ) ) $s_SQLQuery .= "MST_TipoUbicacion.IdTipoUbicacion = ".$this->getIdTipoUbicacion()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "MST_TipoUbicacion.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getNivel() ) ) $s_SQLQuery .= "MST_TipoUbicacion.Nivel = ".$this->getNivel()." AND ";
        if ( !is_null( $this->getImagenUbicacion() ) ) $s_SQLQuery .= "MST_TipoUbicacion.ImagenUbicacion = '".$this->getImagenUbicacion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_TipoUbicacion.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_TipoUbicacion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_TipoUbicacion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_TipoUbicacion.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_TipoUbicacion.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_TipoUbicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TipoUbicacionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoUbicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_TipoUbicacionBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TipoUbicacionBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TipoUbicacionBN[] = $o_MST_TipoUbicacionBN;
            }
        }
        return $a_MST_TipoUbicacionBN;
    }

    /* Devuelve un objeto MST_TipoUbicacionBN desde un objeto propel */
    public function insertObjectBN( $a_MST_TipoUbicacion )
    {
        $o_MST_TipoUbicacionBN = new MST_TipoUbicacionBN();
        if ( !is_null( $a_MST_TipoUbicacion['IdTipoUbicacion'] ) ) $o_MST_TipoUbicacionBN->setIdTipoUbicacion( ( integer ) $a_MST_TipoUbicacion['IdTipoUbicacion'] );
        if ( !is_null( $a_MST_TipoUbicacion['Nombre'] ) ) $o_MST_TipoUbicacionBN->setNombre( $a_MST_TipoUbicacion['Nombre'] );
        if ( !is_null( $a_MST_TipoUbicacion['Nivel'] ) ) $o_MST_TipoUbicacionBN->setNivel( ( integer ) $a_MST_TipoUbicacion['Nivel'] );
        if ( !is_null( $a_MST_TipoUbicacion['ImagenUbicacion'] ) ) $o_MST_TipoUbicacionBN->setImagenUbicacion( $a_MST_TipoUbicacion['ImagenUbicacion'] );
        if ( !is_null( $a_MST_TipoUbicacion['Estado'] ) ) $o_MST_TipoUbicacionBN->setEstado( $a_MST_TipoUbicacion['Estado'] );
        if ( !is_null( $a_MST_TipoUbicacion['FechaCreacion'] ) ) $o_MST_TipoUbicacionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_TipoUbicacion['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_TipoUbicacion['UsuarioCreacion'] ) ) $o_MST_TipoUbicacionBN->setUsuarioCreacion( $a_MST_TipoUbicacion['UsuarioCreacion'] );
        if ( !is_null( $a_MST_TipoUbicacion['FechaModificacion'] ) ) $o_MST_TipoUbicacionBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_TipoUbicacion['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_TipoUbicacion['UsuarioModificacion'] ) ) $o_MST_TipoUbicacionBN->setUsuarioModificacion( $a_MST_TipoUbicacion['UsuarioModificacion'] );
        return $o_MST_TipoUbicacionBN;
    }
}
?>