<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoPrecio.xml */
/* Generado: 2021-06-25 23:59:54 */

/* Busqueda de registros de la tabla MST_TipoPrecio. */
abstract class BaseMST_TipoPrecioFN extends MST_TipoPrecioBN
{
    /* Declaracion de constantes */
    const IdTipoPrecio = "MST_TipoPrecio.IdTipoPrecio";
    const Nombre = "MST_TipoPrecio.Nombre";
    const Descripcion = "MST_TipoPrecio.Descripcion";
    const Estado = "MST_TipoPrecio.Estado";
    const FechaCreacion = "MST_TipoPrecio.FechaCreacion";
    const UsuarioCreacion = "MST_TipoPrecio.UsuarioCreacion";
    const FechaModificacion = "MST_TipoPrecio.FechaModificacion";
    const UsuarioModificacion = "MST_TipoPrecio.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_TipoPrecio.IdTipoPrecio AS IdTipoPrecio, ";
        $s_SQLQuery .= "MST_TipoPrecio.Nombre AS Nombre, ";
        $s_SQLQuery .= "MST_TipoPrecio.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_TipoPrecio.Estado AS Estado, ";
        $s_SQLQuery .= "MST_TipoPrecio.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_TipoPrecio.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_TipoPrecio.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_TipoPrecio.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TipoPrecioBN */
    public function setByBN( MST_TipoPrecioBN $o_MST_TipoPrecioBN )
    {
        if ( !is_null( $o_MST_TipoPrecioBN->getIdTipoPrecio() ) )
        {
            $this->setIdTipoPrecio( $o_MST_TipoPrecioBN->getIdTipoPrecio() );
        }
        if ( !is_null( $o_MST_TipoPrecioBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_TipoPrecioBN->getNombre() );
        }
        if ( !is_null( $o_MST_TipoPrecioBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TipoPrecioBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TipoPrecioBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TipoPrecioBN->getEstado() );
        }
        if ( !is_null( $o_MST_TipoPrecioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TipoPrecioBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TipoPrecioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TipoPrecioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TipoPrecioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TipoPrecioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_TipoPrecioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TipoPrecioBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_TipoPrecioBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTipoPrecio )
    {
        if( is_null( $i_IdTipoPrecio ) ){ $i_IdTipoPrecio = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoPrecio ";
        $s_SQLQuery .= "WHERE IdTipoPrecio = ".$i_IdTipoPrecio." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_TipoPrecioBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TipoPrecioBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TipoPrecioBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipoPrecio() ) ) $s_SQLQuery .= "MST_TipoPrecio.IdTipoPrecio = ".$this->getIdTipoPrecio()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "MST_TipoPrecio.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_TipoPrecio.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_TipoPrecio.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_TipoPrecio.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_TipoPrecio.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_TipoPrecio.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_TipoPrecio.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_TipoPrecio WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TipoPrecioBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoPrecio WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_TipoPrecioBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TipoPrecioBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TipoPrecioBN[] = $o_MST_TipoPrecioBN;
            }
        }
        return $a_MST_TipoPrecioBN;
    }

    /* Devuelve un objeto MST_TipoPrecioBN desde un objeto propel */
    public function insertObjectBN( $a_MST_TipoPrecio )
    {
        $o_MST_TipoPrecioBN = new MST_TipoPrecioBN();
        if ( !is_null( $a_MST_TipoPrecio['IdTipoPrecio'] ) ) $o_MST_TipoPrecioBN->setIdTipoPrecio( ( integer ) $a_MST_TipoPrecio['IdTipoPrecio'] );
        if ( !is_null( $a_MST_TipoPrecio['Nombre'] ) ) $o_MST_TipoPrecioBN->setNombre( $a_MST_TipoPrecio['Nombre'] );
        if ( !is_null( $a_MST_TipoPrecio['Descripcion'] ) ) $o_MST_TipoPrecioBN->setDescripcion( $a_MST_TipoPrecio['Descripcion'] );
        if ( !is_null( $a_MST_TipoPrecio['Estado'] ) ) $o_MST_TipoPrecioBN->setEstado( $a_MST_TipoPrecio['Estado'] );
        if ( !is_null( $a_MST_TipoPrecio['FechaCreacion'] ) ) $o_MST_TipoPrecioBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_TipoPrecio['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_TipoPrecio['UsuarioCreacion'] ) ) $o_MST_TipoPrecioBN->setUsuarioCreacion( $a_MST_TipoPrecio['UsuarioCreacion'] );
        if ( !is_null( $a_MST_TipoPrecio['FechaModificacion'] ) ) $o_MST_TipoPrecioBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_TipoPrecio['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_TipoPrecio['UsuarioModificacion'] ) ) $o_MST_TipoPrecioBN->setUsuarioModificacion( $a_MST_TipoPrecio['UsuarioModificacion'] );
        return $o_MST_TipoPrecioBN;
    }
}
?>