<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoOperacionMast.xml */
/* Generado: 2021-06-25 23:59:53 */

/* Busqueda de registros de la tabla MST_TipoOperacionMast. */
abstract class BaseMST_TipoOperacionMastFN extends MST_TipoOperacionMastBN
{
    /* Declaracion de constantes */
    const IdOperacion = "MST_TipoOperacionMast.IdOperacion";
    const Descripcion = "MST_TipoOperacionMast.Descripcion";
    const Estado = "MST_TipoOperacionMast.Estado";
    const FechaCreacion = "MST_TipoOperacionMast.FechaCreacion";
    const UsuarioCreacion = "MST_TipoOperacionMast.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_TipoOperacionMast.IdOperacion AS IdOperacion, ";
        $s_SQLQuery .= "MST_TipoOperacionMast.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_TipoOperacionMast.Estado AS Estado, ";
        $s_SQLQuery .= "MST_TipoOperacionMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_TipoOperacionMast.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TipoOperacionMastBN */
    public function setByBN( MST_TipoOperacionMastBN $o_MST_TipoOperacionMastBN )
    {
        if ( !is_null( $o_MST_TipoOperacionMastBN->getIdOperacion() ) )
        {
            $this->setIdOperacion( $o_MST_TipoOperacionMastBN->getIdOperacion() );
        }
        if ( !is_null( $o_MST_TipoOperacionMastBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TipoOperacionMastBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TipoOperacionMastBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TipoOperacionMastBN->getEstado() );
        }
        if ( !is_null( $o_MST_TipoOperacionMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TipoOperacionMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TipoOperacionMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TipoOperacionMastBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return MST_TipoOperacionMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdOperacion )
    {
        if( is_null( $s_IdOperacion ) ){ $s_IdOperacion = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoOperacionMast ";
        $s_SQLQuery .= "WHERE IdOperacion = '".$s_IdOperacion."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_TipoOperacionMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TipoOperacionMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TipoOperacionMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdOperacion() ) ) $s_SQLQuery .= "MST_TipoOperacionMast.IdOperacion = '".$this->getIdOperacion()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_TipoOperacionMast.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_TipoOperacionMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_TipoOperacionMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_TipoOperacionMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_TipoOperacionMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TipoOperacionMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoOperacionMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_TipoOperacionMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TipoOperacionMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TipoOperacionMastBN[] = $o_MST_TipoOperacionMastBN;
            }
        }
        return $a_MST_TipoOperacionMastBN;
    }

    /* Devuelve un objeto MST_TipoOperacionMastBN desde un objeto propel */
    public function insertObjectBN( $a_MST_TipoOperacionMast )
    {
        $o_MST_TipoOperacionMastBN = new MST_TipoOperacionMastBN();
        if ( !is_null( $a_MST_TipoOperacionMast['IdOperacion'] ) ) $o_MST_TipoOperacionMastBN->setIdOperacion( $a_MST_TipoOperacionMast['IdOperacion'] );
        if ( !is_null( $a_MST_TipoOperacionMast['Descripcion'] ) ) $o_MST_TipoOperacionMastBN->setDescripcion( $a_MST_TipoOperacionMast['Descripcion'] );
        if ( !is_null( $a_MST_TipoOperacionMast['Estado'] ) ) $o_MST_TipoOperacionMastBN->setEstado( $a_MST_TipoOperacionMast['Estado'] );
        if ( !is_null( $a_MST_TipoOperacionMast['FechaCreacion'] ) ) $o_MST_TipoOperacionMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_TipoOperacionMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_TipoOperacionMast['UsuarioCreacion'] ) ) $o_MST_TipoOperacionMastBN->setUsuarioCreacion( $a_MST_TipoOperacionMast['UsuarioCreacion'] );
        return $o_MST_TipoOperacionMastBN;
    }
}
?>