<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Tiempo.xml */
/* Generado: 2021-06-25 23:59:53 */

/* Busqueda de registros de la tabla MST_Tiempo. */
abstract class BaseMST_TiempoFN extends MST_TiempoBN
{
    /* Declaracion de constantes */
    const IdTiempo = "MST_Tiempo.IdTiempo";
    const Descripcion = "MST_Tiempo.Descripcion";
    const Estado = "MST_Tiempo.Estado";
    const FechaCreacion = "MST_Tiempo.FechaCreacion";
    const UsuarioCreacion = "MST_Tiempo.UsuarioCreacion";
    const FechaModificacion = "MST_Tiempo.FechaModificacion";
    const UsuarioModificacion = "MST_Tiempo.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Tiempo.IdTiempo AS IdTiempo, ";
        $s_SQLQuery .= "MST_Tiempo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Tiempo.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Tiempo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Tiempo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Tiempo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_Tiempo.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TiempoBN */
    public function setByBN( MST_TiempoBN $o_MST_TiempoBN )
    {
        if ( !is_null( $o_MST_TiempoBN->getIdTiempo() ) )
        {
            $this->setIdTiempo( $o_MST_TiempoBN->getIdTiempo() );
        }
        if ( !is_null( $o_MST_TiempoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TiempoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_TiempoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_TiempoBN->getEstado() );
        }
        if ( !is_null( $o_MST_TiempoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_TiempoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_TiempoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_TiempoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_TiempoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_TiempoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_TiempoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_TiempoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_TiempoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTiempo )
    {
        if( is_null( $i_IdTiempo ) ){ $i_IdTiempo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Tiempo ";
        $s_SQLQuery .= "WHERE IdTiempo = ".$i_IdTiempo." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_TiempoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TiempoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TiempoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTiempo() ) ) $s_SQLQuery .= "MST_Tiempo.IdTiempo = ".$this->getIdTiempo()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Tiempo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Tiempo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Tiempo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Tiempo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Tiempo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Tiempo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Tiempo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TiempoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Tiempo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_TiempoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TiempoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TiempoBN[] = $o_MST_TiempoBN;
            }
        }
        return $a_MST_TiempoBN;
    }

    /* Devuelve un objeto MST_TiempoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Tiempo )
    {
        $o_MST_TiempoBN = new MST_TiempoBN();
        if ( !is_null( $a_MST_Tiempo['IdTiempo'] ) ) $o_MST_TiempoBN->setIdTiempo( ( integer ) $a_MST_Tiempo['IdTiempo'] );
        if ( !is_null( $a_MST_Tiempo['Descripcion'] ) ) $o_MST_TiempoBN->setDescripcion( $a_MST_Tiempo['Descripcion'] );
        if ( !is_null( $a_MST_Tiempo['Estado'] ) ) $o_MST_TiempoBN->setEstado( $a_MST_Tiempo['Estado'] );
        if ( !is_null( $a_MST_Tiempo['FechaCreacion'] ) ) $o_MST_TiempoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Tiempo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Tiempo['UsuarioCreacion'] ) ) $o_MST_TiempoBN->setUsuarioCreacion( $a_MST_Tiempo['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Tiempo['FechaModificacion'] ) ) $o_MST_TiempoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Tiempo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Tiempo['UsuarioModificacion'] ) ) $o_MST_TiempoBN->setUsuarioModificacion( $a_MST_Tiempo['UsuarioModificacion'] );
        return $o_MST_TiempoBN;
    }
}
?>