<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_StockReposicionDetalleLog.xml */
/* Generado: 2021-06-25 23:59:53 */

/* Busqueda de registros de la tabla MST_StockReposicionDetalleLog. */
abstract class BaseMST_StockReposicionDetalleLogFN extends MST_StockReposicionDetalleLogBN
{
    /* Declaracion de constantes */
    const IdSRDLog = "MST_StockReposicionDetalleLog.IdSRDLog";
    const IdCompania = "MST_StockReposicionDetalleLog.IdCompania";
    const IdSucursal = "MST_StockReposicionDetalleLog.IdSucursal";
    const IdAlmacen = "MST_StockReposicionDetalleLog.IdAlmacen";
    const IdPersona = "MST_StockReposicionDetalleLog.IdPersona";
    const IdItem = "MST_StockReposicionDetalleLog.IdItem";
    const Estado = "MST_StockReposicionDetalleLog.Estado";
    const StockMinimo = "MST_StockReposicionDetalleLog.StockMinimo";
    const StockMaximo = "MST_StockReposicionDetalleLog.StockMaximo";
    const StockActual = "MST_StockReposicionDetalleLog.StockActual";
    const FechaCreacion = "MST_StockReposicionDetalleLog.FechaCreacion";
    const UsuarioCreacion = "MST_StockReposicionDetalleLog.UsuarioCreacion";
    const FechaModificacion = "MST_StockReposicionDetalleLog.FechaModificacion";
    const UsuarioModificcion = "MST_StockReposicionDetalleLog.UsuarioModificcion";
    const FechaLog = "MST_StockReposicionDetalleLog.FechaLog";
    const UsuarioLog = "MST_StockReposicionDetalleLog.UsuarioLog";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_StockReposicionDetalleLog.IdSRDLog AS IdSRDLog, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdItem AS IdItem, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.Estado AS Estado, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.StockMinimo AS StockMinimo, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.StockMaximo AS StockMaximo, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.StockActual AS StockActual, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.UsuarioModificcion AS UsuarioModificcion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.FechaLog AS FechaLog, ";
        $s_SQLQuery .= "MST_StockReposicionDetalleLog.UsuarioLog AS UsuarioLog ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_StockReposicionDetalleLogBN */
    public function setByBN( MST_StockReposicionDetalleLogBN $o_MST_StockReposicionDetalleLogBN )
    {
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getIdSRDLog() ) )
        {
            $this->setIdSRDLog( $o_MST_StockReposicionDetalleLogBN->getIdSRDLog() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_StockReposicionDetalleLogBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_StockReposicionDetalleLogBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_MST_StockReposicionDetalleLogBN->getIdAlmacen() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_MST_StockReposicionDetalleLogBN->getIdPersona() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_StockReposicionDetalleLogBN->getIdItem() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_StockReposicionDetalleLogBN->getEstado() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getStockMinimo() ) )
        {
            $this->setStockMinimo( $o_MST_StockReposicionDetalleLogBN->getStockMinimo() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getStockMaximo() ) )
        {
            $this->setStockMaximo( $o_MST_StockReposicionDetalleLogBN->getStockMaximo() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getStockActual() ) )
        {
            $this->setStockActual( $o_MST_StockReposicionDetalleLogBN->getStockActual() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_StockReposicionDetalleLogBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_StockReposicionDetalleLogBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_StockReposicionDetalleLogBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getUsuarioModificcion() ) )
        {
            $this->setUsuarioModificcion( $o_MST_StockReposicionDetalleLogBN->getUsuarioModificcion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getFechaLog() ) )
        {
            $this->setFechaLog( $o_MST_StockReposicionDetalleLogBN->getFechaLog() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleLogBN->getUsuarioLog() ) )
        {
            $this->setUsuarioLog( $o_MST_StockReposicionDetalleLogBN->getUsuarioLog() );
        }
    }

    /**
    * @return MST_StockReposicionDetalleLogBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdSRDLog )
    {
        if( is_null( $i_IdSRDLog ) ){ $i_IdSRDLog = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_StockReposicionDetalleLog ";
        $s_SQLQuery .= "WHERE IdSRDLog = ".$i_IdSRDLog." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_StockReposicionDetalleLogBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_StockReposicionDetalleLogBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_StockReposicionDetalleLogBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdSRDLog() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdSRDLog = ".$this->getIdSRDLog()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getStockMinimo() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.StockMinimo = ".$this->getStockMinimo()." AND ";
        if ( !is_null( $this->getStockMaximo() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.StockMaximo = ".$this->getStockMaximo()." AND ";
        if ( !is_null( $this->getStockActual() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.StockActual = ".$this->getStockActual()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificcion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.UsuarioModificcion = '".$this->getUsuarioModificcion()."' AND ";
        if ( !is_null( $this->getFechaLog() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.FechaLog = '".$this->getFechaLog()."' AND ";
        if ( !is_null( $this->getUsuarioLog() ) ) $s_SQLQuery .= "MST_StockReposicionDetalleLog.UsuarioLog = '".$this->getUsuarioLog()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_StockReposicionDetalleLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_StockReposicionDetalleLogBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_StockReposicionDetalleLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_StockReposicionDetalleLogBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_StockReposicionDetalleLogBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_StockReposicionDetalleLogBN[] = $o_MST_StockReposicionDetalleLogBN;
            }
        }
        return $a_MST_StockReposicionDetalleLogBN;
    }

    /* Devuelve un objeto MST_StockReposicionDetalleLogBN desde un objeto propel */
    public function insertObjectBN( $a_MST_StockReposicionDetalleLog )
    {
        $o_MST_StockReposicionDetalleLogBN = new MST_StockReposicionDetalleLogBN();
        if ( !is_null( $a_MST_StockReposicionDetalleLog['IdSRDLog'] ) ) $o_MST_StockReposicionDetalleLogBN->setIdSRDLog( ( integer ) $a_MST_StockReposicionDetalleLog['IdSRDLog'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['IdCompania'] ) ) $o_MST_StockReposicionDetalleLogBN->setIdCompania( ( integer ) $a_MST_StockReposicionDetalleLog['IdCompania'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['IdSucursal'] ) ) $o_MST_StockReposicionDetalleLogBN->setIdSucursal( ( integer ) $a_MST_StockReposicionDetalleLog['IdSucursal'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['IdAlmacen'] ) ) $o_MST_StockReposicionDetalleLogBN->setIdAlmacen( $a_MST_StockReposicionDetalleLog['IdAlmacen'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['IdPersona'] ) ) $o_MST_StockReposicionDetalleLogBN->setIdPersona( ( integer ) $a_MST_StockReposicionDetalleLog['IdPersona'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['IdItem'] ) ) $o_MST_StockReposicionDetalleLogBN->setIdItem( $a_MST_StockReposicionDetalleLog['IdItem'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['Estado'] ) ) $o_MST_StockReposicionDetalleLogBN->setEstado( $a_MST_StockReposicionDetalleLog['Estado'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['StockMinimo'] ) ) $o_MST_StockReposicionDetalleLogBN->setStockMinimo( ( float ) $a_MST_StockReposicionDetalleLog['StockMinimo'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['StockMaximo'] ) ) $o_MST_StockReposicionDetalleLogBN->setStockMaximo( ( float ) $a_MST_StockReposicionDetalleLog['StockMaximo'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['StockActual'] ) ) $o_MST_StockReposicionDetalleLogBN->setStockActual( ( float ) $a_MST_StockReposicionDetalleLog['StockActual'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['FechaCreacion'] ) ) $o_MST_StockReposicionDetalleLogBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_StockReposicionDetalleLog['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['UsuarioCreacion'] ) ) $o_MST_StockReposicionDetalleLogBN->setUsuarioCreacion( $a_MST_StockReposicionDetalleLog['UsuarioCreacion'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['FechaModificacion'] ) ) $o_MST_StockReposicionDetalleLogBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_StockReposicionDetalleLog['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['UsuarioModificcion'] ) ) $o_MST_StockReposicionDetalleLogBN->setUsuarioModificcion( $a_MST_StockReposicionDetalleLog['UsuarioModificcion'] );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['FechaLog'] ) ) $o_MST_StockReposicionDetalleLogBN->setFechaLog( utilTimestamp::getTimestamp( $a_MST_StockReposicionDetalleLog['FechaLog'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionDetalleLog['UsuarioLog'] ) ) $o_MST_StockReposicionDetalleLogBN->setUsuarioLog( $a_MST_StockReposicionDetalleLog['UsuarioLog'] );
        return $o_MST_StockReposicionDetalleLogBN;
    }
}
?>