<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_StockReposicionDetalle.xml */
/* Generado: 2021-06-25 23:59:53 */

/* Busqueda de registros de la tabla MST_StockReposicionDetalle. */
abstract class BaseMST_StockReposicionDetalleFN extends MST_StockReposicionDetalleBN
{
    /* Declaracion de constantes */
    const IdCompania = "MST_StockReposicionDetalle.IdCompania";
    const IdSucursal = "MST_StockReposicionDetalle.IdSucursal";
    const IdAlmacen = "MST_StockReposicionDetalle.IdAlmacen";
    const IdPersona = "MST_StockReposicionDetalle.IdPersona";
    const IdItem = "MST_StockReposicionDetalle.IdItem";
    const Estado = "MST_StockReposicionDetalle.Estado";
    const StockMinimo = "MST_StockReposicionDetalle.StockMinimo";
    const StockMaximo = "MST_StockReposicionDetalle.StockMaximo";
    const StockActual = "MST_StockReposicionDetalle.StockActual";
    const FechaCreacion = "MST_StockReposicionDetalle.FechaCreacion";
    const UsuarioCreacion = "MST_StockReposicionDetalle.UsuarioCreacion";
    const FechaModificacion = "MST_StockReposicionDetalle.FechaModificacion";
    const UsuarioModificacion = "MST_StockReposicionDetalle.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_StockReposicionDetalle.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.StockMinimo AS StockMinimo, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.StockMaximo AS StockMaximo, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.StockActual AS StockActual, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_StockReposicionDetalle.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_StockReposicionDetalleBN */
    public function setByBN( MST_StockReposicionDetalleBN $o_MST_StockReposicionDetalleBN )
    {
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_StockReposicionDetalleBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_StockReposicionDetalleBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_MST_StockReposicionDetalleBN->getIdAlmacen() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_MST_StockReposicionDetalleBN->getIdPersona() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_StockReposicionDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_StockReposicionDetalleBN->getEstado() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getStockMinimo() ) )
        {
            $this->setStockMinimo( $o_MST_StockReposicionDetalleBN->getStockMinimo() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getStockMaximo() ) )
        {
            $this->setStockMaximo( $o_MST_StockReposicionDetalleBN->getStockMaximo() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getStockActual() ) )
        {
            $this->setStockActual( $o_MST_StockReposicionDetalleBN->getStockActual() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_StockReposicionDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_StockReposicionDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_StockReposicionDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_StockReposicionDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_StockReposicionDetalleBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_StockReposicionDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $i_IdSucursal, $s_IdAlmacen, $i_IdPersona, $s_IdItem )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $i_IdSucursal ) ){ $i_IdSucursal = -1; } 
        if( is_null( $s_IdAlmacen ) ){ $s_IdAlmacen = '-1'; } 
        if( is_null( $i_IdPersona ) ){ $i_IdPersona = -1; } 
        if( is_null( $s_IdItem ) ){ $s_IdItem = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_StockReposicionDetalle ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdSucursal = ".$i_IdSucursal." ";
        $s_SQLQuery .= "AND IdAlmacen = '".$s_IdAlmacen."' ";
        $s_SQLQuery .= "AND IdPersona = ".$i_IdPersona." ";
        $s_SQLQuery .= "AND IdItem = '".$s_IdItem."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_StockReposicionDetalleBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_StockReposicionDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_StockReposicionDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getStockMinimo() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.StockMinimo = ".$this->getStockMinimo()." AND ";
        if ( !is_null( $this->getStockMaximo() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.StockMaximo = ".$this->getStockMaximo()." AND ";
        if ( !is_null( $this->getStockActual() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.StockActual = ".$this->getStockActual()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_StockReposicionDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_StockReposicionDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_StockReposicionDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_StockReposicionDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_StockReposicionDetalleBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_StockReposicionDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_StockReposicionDetalleBN[] = $o_MST_StockReposicionDetalleBN;
            }
        }
        return $a_MST_StockReposicionDetalleBN;
    }

    /* Devuelve un objeto MST_StockReposicionDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_MST_StockReposicionDetalle )
    {
        $o_MST_StockReposicionDetalleBN = new MST_StockReposicionDetalleBN();
        if ( !is_null( $a_MST_StockReposicionDetalle['IdCompania'] ) ) $o_MST_StockReposicionDetalleBN->setIdCompania( ( integer ) $a_MST_StockReposicionDetalle['IdCompania'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['IdSucursal'] ) ) $o_MST_StockReposicionDetalleBN->setIdSucursal( ( integer ) $a_MST_StockReposicionDetalle['IdSucursal'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['IdAlmacen'] ) ) $o_MST_StockReposicionDetalleBN->setIdAlmacen( $a_MST_StockReposicionDetalle['IdAlmacen'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['IdPersona'] ) ) $o_MST_StockReposicionDetalleBN->setIdPersona( ( integer ) $a_MST_StockReposicionDetalle['IdPersona'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['IdItem'] ) ) $o_MST_StockReposicionDetalleBN->setIdItem( $a_MST_StockReposicionDetalle['IdItem'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['Estado'] ) ) $o_MST_StockReposicionDetalleBN->setEstado( $a_MST_StockReposicionDetalle['Estado'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['StockMinimo'] ) ) $o_MST_StockReposicionDetalleBN->setStockMinimo( ( float ) $a_MST_StockReposicionDetalle['StockMinimo'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['StockMaximo'] ) ) $o_MST_StockReposicionDetalleBN->setStockMaximo( ( float ) $a_MST_StockReposicionDetalle['StockMaximo'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['StockActual'] ) ) $o_MST_StockReposicionDetalleBN->setStockActual( ( float ) $a_MST_StockReposicionDetalle['StockActual'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['FechaCreacion'] ) ) $o_MST_StockReposicionDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_StockReposicionDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionDetalle['UsuarioCreacion'] ) ) $o_MST_StockReposicionDetalleBN->setUsuarioCreacion( $a_MST_StockReposicionDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_MST_StockReposicionDetalle['FechaModificacion'] ) ) $o_MST_StockReposicionDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_StockReposicionDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionDetalle['UsuarioModificacion'] ) ) $o_MST_StockReposicionDetalleBN->setUsuarioModificacion( $a_MST_StockReposicionDetalle['UsuarioModificacion'] );
        return $o_MST_StockReposicionDetalleBN;
    }
}
?>