<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_StockReposicionCabecera.xml */
/* Generado: 2021-06-25 23:59:53 */

/* Busqueda de registros de la tabla MST_StockReposicionCabecera. */
abstract class BaseMST_StockReposicionCabeceraFN extends MST_StockReposicionCabeceraBN
{
    /* Declaracion de constantes */
    const IdCompania = "MST_StockReposicionCabecera.IdCompania";
    const IdSucursal = "MST_StockReposicionCabecera.IdSucursal";
    const IdAlmacen = "MST_StockReposicionCabecera.IdAlmacen";
    const IdPersona = "MST_StockReposicionCabecera.IdPersona";
    const IdLinea = "MST_StockReposicionCabecera.IdLinea";
    const IdFamilia = "MST_StockReposicionCabecera.IdFamilia";
    const Estado = "MST_StockReposicionCabecera.Estado";
    const UsuarioCreacion = "MST_StockReposicionCabecera.UsuarioCreacion";
    const FechaCreacion = "MST_StockReposicionCabecera.FechaCreacion";
    const FechaModificacion = "MST_StockReposicionCabecera.FechaModificacion";
    const UsuarioModificacion = "MST_StockReposicionCabecera.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_StockReposicionCabecera.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.IdLinea AS IdLinea, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.IdFamilia AS IdFamilia, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.Estado AS Estado, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_StockReposicionCabecera.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_StockReposicionCabeceraBN */
    public function setByBN( MST_StockReposicionCabeceraBN $o_MST_StockReposicionCabeceraBN )
    {
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_StockReposicionCabeceraBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_StockReposicionCabeceraBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_MST_StockReposicionCabeceraBN->getIdAlmacen() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_MST_StockReposicionCabeceraBN->getIdPersona() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_MST_StockReposicionCabeceraBN->getIdLinea() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getIdFamilia() ) )
        {
            $this->setIdFamilia( $o_MST_StockReposicionCabeceraBN->getIdFamilia() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_StockReposicionCabeceraBN->getEstado() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_StockReposicionCabeceraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_StockReposicionCabeceraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_StockReposicionCabeceraBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_StockReposicionCabeceraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_StockReposicionCabeceraBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_StockReposicionCabeceraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $i_IdSucursal, $s_IdAlmacen, $i_IdPersona )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $i_IdSucursal ) ){ $i_IdSucursal = -1; } 
        if( is_null( $s_IdAlmacen ) ){ $s_IdAlmacen = '-1'; } 
        if( is_null( $i_IdPersona ) ){ $i_IdPersona = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_StockReposicionCabecera ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdSucursal = ".$i_IdSucursal." ";
        $s_SQLQuery .= "AND IdAlmacen = '".$s_IdAlmacen."' ";
        $s_SQLQuery .= "AND IdPersona = ".$i_IdPersona." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_StockReposicionCabeceraBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_StockReposicionCabeceraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_StockReposicionCabeceraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getIdLinea() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.IdLinea = ".$this->getIdLinea()." AND ";
        if ( !is_null( $this->getIdFamilia() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.IdFamilia = ".$this->getIdFamilia()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_StockReposicionCabecera.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_StockReposicionCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_StockReposicionCabeceraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_StockReposicionCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_StockReposicionCabeceraBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_StockReposicionCabeceraBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_StockReposicionCabeceraBN[] = $o_MST_StockReposicionCabeceraBN;
            }
        }
        return $a_MST_StockReposicionCabeceraBN;
    }

    /* Devuelve un objeto MST_StockReposicionCabeceraBN desde un objeto propel */
    public function insertObjectBN( $a_MST_StockReposicionCabecera )
    {
        $o_MST_StockReposicionCabeceraBN = new MST_StockReposicionCabeceraBN();
        if ( !is_null( $a_MST_StockReposicionCabecera['IdCompania'] ) ) $o_MST_StockReposicionCabeceraBN->setIdCompania( ( integer ) $a_MST_StockReposicionCabecera['IdCompania'] );
        if ( !is_null( $a_MST_StockReposicionCabecera['IdSucursal'] ) ) $o_MST_StockReposicionCabeceraBN->setIdSucursal( ( integer ) $a_MST_StockReposicionCabecera['IdSucursal'] );
        if ( !is_null( $a_MST_StockReposicionCabecera['IdAlmacen'] ) ) $o_MST_StockReposicionCabeceraBN->setIdAlmacen( $a_MST_StockReposicionCabecera['IdAlmacen'] );
        if ( !is_null( $a_MST_StockReposicionCabecera['IdPersona'] ) ) $o_MST_StockReposicionCabeceraBN->setIdPersona( ( integer ) $a_MST_StockReposicionCabecera['IdPersona'] );
        if ( !is_null( $a_MST_StockReposicionCabecera['IdLinea'] ) ) $o_MST_StockReposicionCabeceraBN->setIdLinea( ( integer ) $a_MST_StockReposicionCabecera['IdLinea'] );
        if ( !is_null( $a_MST_StockReposicionCabecera['IdFamilia'] ) ) $o_MST_StockReposicionCabeceraBN->setIdFamilia( ( integer ) $a_MST_StockReposicionCabecera['IdFamilia'] );
        if ( !is_null( $a_MST_StockReposicionCabecera['Estado'] ) ) $o_MST_StockReposicionCabeceraBN->setEstado( $a_MST_StockReposicionCabecera['Estado'] );
        if ( !is_null( $a_MST_StockReposicionCabecera['UsuarioCreacion'] ) ) $o_MST_StockReposicionCabeceraBN->setUsuarioCreacion( $a_MST_StockReposicionCabecera['UsuarioCreacion'] );
        if ( !is_null( $a_MST_StockReposicionCabecera['FechaCreacion'] ) ) $o_MST_StockReposicionCabeceraBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_StockReposicionCabecera['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionCabecera['FechaModificacion'] ) ) $o_MST_StockReposicionCabeceraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_StockReposicionCabecera['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_StockReposicionCabecera['UsuarioModificacion'] ) ) $o_MST_StockReposicionCabeceraBN->setUsuarioModificacion( $a_MST_StockReposicionCabecera['UsuarioModificacion'] );
        return $o_MST_StockReposicionCabeceraBN;
    }
}
?>