<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_RangoDetalle.xml */
/* Generado: 2021-06-25 23:59:52 */

/* Busqueda de registros de la tabla MST_RangoDetalle. */
abstract class BaseMST_RangoDetalleFN extends MST_RangoDetalleBN
{
    /* Declaracion de constantes */
    const IdRangoDetalle = "MST_RangoDetalle.IdRangoDetalle";
    const IdRango = "MST_RangoDetalle.IdRango";
    const Minimo = "MST_RangoDetalle.Minimo";
    const Maximo = "MST_RangoDetalle.Maximo";
    const Estado = "MST_RangoDetalle.Estado";
    const FechaCreacion = "MST_RangoDetalle.FechaCreacion";
    const UsuarioCreacion = "MST_RangoDetalle.UsuarioCreacion";
    const FechaModificacion = "MST_RangoDetalle.FechaModificacion";
    const UsuarioModificacion = "MST_RangoDetalle.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_RangoDetalle.IdRangoDetalle AS IdRangoDetalle, ";
        $s_SQLQuery .= "MST_RangoDetalle.IdRango AS IdRango, ";
        $s_SQLQuery .= "MST_RangoDetalle.Minimo AS Minimo, ";
        $s_SQLQuery .= "MST_RangoDetalle.Maximo AS Maximo, ";
        $s_SQLQuery .= "MST_RangoDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "MST_RangoDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_RangoDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_RangoDetalle.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_RangoDetalle.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_RangoDetalleBN */
    public function setByBN( MST_RangoDetalleBN $o_MST_RangoDetalleBN )
    {
        if ( !is_null( $o_MST_RangoDetalleBN->getIdRangoDetalle() ) )
        {
            $this->setIdRangoDetalle( $o_MST_RangoDetalleBN->getIdRangoDetalle() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getIdRango() ) )
        {
            $this->setIdRango( $o_MST_RangoDetalleBN->getIdRango() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getMinimo() ) )
        {
            $this->setMinimo( $o_MST_RangoDetalleBN->getMinimo() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getMaximo() ) )
        {
            $this->setMaximo( $o_MST_RangoDetalleBN->getMaximo() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_RangoDetalleBN->getEstado() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_RangoDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_RangoDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_RangoDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_RangoDetalleBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_RangoDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdRangoDetalle )
    {
        if( is_null( $i_IdRangoDetalle ) ){ $i_IdRangoDetalle = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_RangoDetalle ";
        $s_SQLQuery .= "WHERE IdRangoDetalle = ".$i_IdRangoDetalle." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_RangoDetalleBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_RangoDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_RangoDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRangoDetalle() ) ) $s_SQLQuery .= "MST_RangoDetalle.IdRangoDetalle = ".$this->getIdRangoDetalle()." AND ";
        if ( !is_null( $this->getIdRango() ) ) $s_SQLQuery .= "MST_RangoDetalle.IdRango = ".$this->getIdRango()." AND ";
        if ( !is_null( $this->getMinimo() ) ) $s_SQLQuery .= "MST_RangoDetalle.Minimo = ".$this->getMinimo()." AND ";
        if ( !is_null( $this->getMaximo() ) ) $s_SQLQuery .= "MST_RangoDetalle.Maximo = ".$this->getMaximo()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_RangoDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_RangoDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_RangoDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_RangoDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_RangoDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_RangoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_RangoDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_RangoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_RangoDetalleBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_RangoDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_RangoDetalleBN[] = $o_MST_RangoDetalleBN;
            }
        }
        return $a_MST_RangoDetalleBN;
    }

    /* Devuelve un objeto MST_RangoDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_MST_RangoDetalle )
    {
        $o_MST_RangoDetalleBN = new MST_RangoDetalleBN();
        if ( !is_null( $a_MST_RangoDetalle['IdRangoDetalle'] ) ) $o_MST_RangoDetalleBN->setIdRangoDetalle( ( integer ) $a_MST_RangoDetalle['IdRangoDetalle'] );
        if ( !is_null( $a_MST_RangoDetalle['IdRango'] ) ) $o_MST_RangoDetalleBN->setIdRango( ( integer ) $a_MST_RangoDetalle['IdRango'] );
        if ( !is_null( $a_MST_RangoDetalle['Minimo'] ) ) $o_MST_RangoDetalleBN->setMinimo( ( float ) $a_MST_RangoDetalle['Minimo'] );
        if ( !is_null( $a_MST_RangoDetalle['Maximo'] ) ) $o_MST_RangoDetalleBN->setMaximo( ( float ) $a_MST_RangoDetalle['Maximo'] );
        if ( !is_null( $a_MST_RangoDetalle['Estado'] ) ) $o_MST_RangoDetalleBN->setEstado( $a_MST_RangoDetalle['Estado'] );
        if ( !is_null( $a_MST_RangoDetalle['FechaCreacion'] ) ) $o_MST_RangoDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_RangoDetalle['FechaCreacion'], "Y-m-d" ) );
        if ( !is_null( $a_MST_RangoDetalle['UsuarioCreacion'] ) ) $o_MST_RangoDetalleBN->setUsuarioCreacion( $a_MST_RangoDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_MST_RangoDetalle['FechaModificacion'] ) ) $o_MST_RangoDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_RangoDetalle['FechaModificacion'], "Y-m-d" ) );
        if ( !is_null( $a_MST_RangoDetalle['UsuarioModificacion'] ) ) $o_MST_RangoDetalleBN->setUsuarioModificacion( $a_MST_RangoDetalle['UsuarioModificacion'] );
        return $o_MST_RangoDetalleBN;
    }
}
?>