<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_PisosMast.xml */
/* Generado: 2021-06-25 23:59:52 */

/* Busqueda de registros de la tabla MST_PisosMast. */
abstract class BaseMST_PisosMastFN extends MST_PisosMastBN
{
    /* Declaracion de constantes */
    const IdPisos = "MST_PisosMast.IdPisos";
    const IdCompania = "MST_PisosMast.IdCompania";
    const IdSucursal = "MST_PisosMast.IdSucursal";
    const Nombre = "MST_PisosMast.Nombre";
    const Estado = "MST_PisosMast.Estado";
    const FechaCreacion = "MST_PisosMast.FechaCreacion";
    const UsuarioCreacion = "MST_PisosMast.UsuarioCreacion";
    const FechaModificacion = "MST_PisosMast.FechaModificacion";
    const UsuarioModificacion = "MST_PisosMast.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_PisosMast.IdPisos AS IdPisos, ";
        $s_SQLQuery .= "MST_PisosMast.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_PisosMast.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_PisosMast.Nombre AS Nombre, ";
        $s_SQLQuery .= "MST_PisosMast.Estado AS Estado, ";
        $s_SQLQuery .= "MST_PisosMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_PisosMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_PisosMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_PisosMast.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_PisosMastBN */
    public function setByBN( MST_PisosMastBN $o_MST_PisosMastBN )
    {
        if ( !is_null( $o_MST_PisosMastBN->getIdPisos() ) )
        {
            $this->setIdPisos( $o_MST_PisosMastBN->getIdPisos() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_PisosMastBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_PisosMastBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_PisosMastBN->getNombre() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_PisosMastBN->getEstado() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_PisosMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_PisosMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_PisosMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_PisosMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_PisosMastBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_PisosMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdPisos )
    {
        if( is_null( $i_IdPisos ) ){ $i_IdPisos = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_PisosMast ";
        $s_SQLQuery .= "WHERE IdPisos = ".$i_IdPisos." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_PisosMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_PisosMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_PisosMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPisos() ) ) $s_SQLQuery .= "MST_PisosMast.IdPisos = ".$this->getIdPisos()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_PisosMast.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_PisosMast.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "MST_PisosMast.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_PisosMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_PisosMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_PisosMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_PisosMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_PisosMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_PisosMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_PisosMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_PisosMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_PisosMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_PisosMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_PisosMastBN[] = $o_MST_PisosMastBN;
            }
        }
        return $a_MST_PisosMastBN;
    }

    /* Devuelve un objeto MST_PisosMastBN desde un objeto propel */
    public function insertObjectBN( $a_MST_PisosMast )
    {
        $o_MST_PisosMastBN = new MST_PisosMastBN();
        if ( !is_null( $a_MST_PisosMast['IdPisos'] ) ) $o_MST_PisosMastBN->setIdPisos( ( integer ) $a_MST_PisosMast['IdPisos'] );
        if ( !is_null( $a_MST_PisosMast['IdCompania'] ) ) $o_MST_PisosMastBN->setIdCompania( ( integer ) $a_MST_PisosMast['IdCompania'] );
        if ( !is_null( $a_MST_PisosMast['IdSucursal'] ) ) $o_MST_PisosMastBN->setIdSucursal( ( integer ) $a_MST_PisosMast['IdSucursal'] );
        if ( !is_null( $a_MST_PisosMast['Nombre'] ) ) $o_MST_PisosMastBN->setNombre( $a_MST_PisosMast['Nombre'] );
        if ( !is_null( $a_MST_PisosMast['Estado'] ) ) $o_MST_PisosMastBN->setEstado( $a_MST_PisosMast['Estado'] );
        if ( !is_null( $a_MST_PisosMast['FechaCreacion'] ) ) $o_MST_PisosMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_PisosMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_PisosMast['UsuarioCreacion'] ) ) $o_MST_PisosMastBN->setUsuarioCreacion( $a_MST_PisosMast['UsuarioCreacion'] );
        if ( !is_null( $a_MST_PisosMast['FechaModificacion'] ) ) $o_MST_PisosMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_PisosMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_PisosMast['UsuarioModificacion'] ) ) $o_MST_PisosMastBN->setUsuarioModificacion( $a_MST_PisosMast['UsuarioModificacion'] );
        return $o_MST_PisosMastBN;
    }
}
?>