<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_PersonaMast.xml */
/* Generado: 2021-10-06 07:34:51 */

/* Busqueda de registros de la tabla MST_PersonaMast. */
abstract class BaseMST_PersonaMastFN extends MST_PersonaMastBN
{
    /* Declaracion de constantes */
    const IdPersona = "MST_PersonaMast.IdPersona";
    const IdCompania = "MST_PersonaMast.IdCompania";
    const ApellidoPaterno = "MST_PersonaMast.ApellidoPaterno";
    const ApellidoMaterno = "MST_PersonaMast.ApellidoMaterno";
    const Nombres = "MST_PersonaMast.Nombres";
    const NombreCompleto = "MST_PersonaMast.NombreCompleto";
    const NombreComercial = "MST_PersonaMast.NombreComercial";
    const Contacto = "MST_PersonaMast.Contacto";
    const TipoDocumento = "MST_PersonaMast.TipoDocumento";
    const Documento = "MST_PersonaMast.Documento";
    const CodigoBarras = "MST_PersonaMast.CodigoBarras";
    const EsCliente = "MST_PersonaMast.EsCliente";
    const EsProveedor = "MST_PersonaMast.EsProveedor";
    const EsEmpleado = "MST_PersonaMast.EsEmpleado";
    const EsOtro = "MST_PersonaMast.EsOtro";
    const TipoPersona = "MST_PersonaMast.TipoPersona";
    const FechaNacimiento = "MST_PersonaMast.FechaNacimiento";
    const CiudadNacimiento = "MST_PersonaMast.CiudadNacimiento";
    const Sexo = "MST_PersonaMast.Sexo";
    const Nacionalidad = "MST_PersonaMast.Nacionalidad";
    const PaisId = "MST_PersonaMast.PaisId";
    const PaisDesc = "MST_PersonaMast.PaisDesc";
    const EstadoCivil = "MST_PersonaMast.EstadoCivil";
    const NivelInstruccion = "MST_PersonaMast.NivelInstruccion";
    const Direccion = "MST_PersonaMast.Direccion";
    const CodigoPostal = "MST_PersonaMast.CodigoPostal";
    const Provincia = "MST_PersonaMast.Provincia";
    const Departamento = "MST_PersonaMast.Departamento";
    const Distrito = "MST_PersonaMast.Distrito";
    const Telefono = "MST_PersonaMast.Telefono";
    const Celular = "MST_PersonaMast.Celular";
    const Email = "MST_PersonaMast.Email";
    const DireccionWeb = "MST_PersonaMast.DireccionWeb";
    const Fax = "MST_PersonaMast.Fax";
    const DocumentoIdentidad = "MST_PersonaMast.DocumentoIdentidad";
    const CarnetExtranjeria = "MST_PersonaMast.CarnetExtranjeria";
    const DocumentoMilitarFA = "MST_PersonaMast.DocumentoMilitarFA";
    const TipoBrevete = "MST_PersonaMast.TipoBrevete";
    const Brevete = "MST_PersonaMast.Brevete";
    const Pasaporte = "MST_PersonaMast.Pasaporte";
    const EsAgenteRetenedor = "MST_PersonaMast.EsAgenteRetenedor";
    const IdRetencion = "MST_PersonaMast.IdRetencion";
    const Estado = "MST_PersonaMast.Estado";
    const UsuarioModificacion = "MST_PersonaMast.UsuarioModificacion";
    const FechaModificacion = "MST_PersonaMast.FechaModificacion";
    const UsuarioCreacion = "MST_PersonaMast.UsuarioCreacion";
    const FechaCreacion = "MST_PersonaMast.FechaCreacion";
    const IdUsuario = "MST_PersonaMast.IdUsuario";
    const ProveedorGuiasFlag = "MST_PersonaMast.ProveedorGuiasFlag";
    const EmpleadoVendedorFlag = "MST_PersonaMast.EmpleadoVendedorFlag";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_PersonaMast.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "MST_PersonaMast.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_PersonaMast.ApellidoPaterno AS ApellidoPaterno, ";
        $s_SQLQuery .= "MST_PersonaMast.ApellidoMaterno AS ApellidoMaterno, ";
        $s_SQLQuery .= "MST_PersonaMast.Nombres AS Nombres, ";
        $s_SQLQuery .= "MST_PersonaMast.NombreCompleto AS NombreCompleto, ";
        $s_SQLQuery .= "MST_PersonaMast.NombreComercial AS NombreComercial, ";
        $s_SQLQuery .= "MST_PersonaMast.Contacto AS Contacto, ";
        $s_SQLQuery .= "MST_PersonaMast.TipoDocumento AS TipoDocumento, ";
        $s_SQLQuery .= "MST_PersonaMast.Documento AS Documento, ";
        $s_SQLQuery .= "MST_PersonaMast.CodigoBarras AS CodigoBarras, ";
        $s_SQLQuery .= "MST_PersonaMast.EsCliente AS EsCliente, ";
        $s_SQLQuery .= "MST_PersonaMast.EsProveedor AS EsProveedor, ";
        $s_SQLQuery .= "MST_PersonaMast.EsEmpleado AS EsEmpleado, ";
        $s_SQLQuery .= "MST_PersonaMast.EsOtro AS EsOtro, ";
        $s_SQLQuery .= "MST_PersonaMast.TipoPersona AS TipoPersona, ";
        $s_SQLQuery .= "MST_PersonaMast.FechaNacimiento AS FechaNacimiento, ";
        $s_SQLQuery .= "MST_PersonaMast.CiudadNacimiento AS CiudadNacimiento, ";
        $s_SQLQuery .= "MST_PersonaMast.Sexo AS Sexo, ";
        $s_SQLQuery .= "MST_PersonaMast.Nacionalidad AS Nacionalidad, ";
        $s_SQLQuery .= "MST_PersonaMast.PaisId AS PaisId, ";
        $s_SQLQuery .= "MST_PersonaMast.PaisDesc AS PaisDesc, ";
        $s_SQLQuery .= "MST_PersonaMast.EstadoCivil AS EstadoCivil, ";
        $s_SQLQuery .= "MST_PersonaMast.NivelInstruccion AS NivelInstruccion, ";
        $s_SQLQuery .= "MST_PersonaMast.Direccion AS Direccion, ";
        $s_SQLQuery .= "MST_PersonaMast.CodigoPostal AS CodigoPostal, ";
        $s_SQLQuery .= "MST_PersonaMast.Provincia AS Provincia, ";
        $s_SQLQuery .= "MST_PersonaMast.Departamento AS Departamento, ";
        $s_SQLQuery .= "MST_PersonaMast.Distrito AS Distrito, ";
        $s_SQLQuery .= "MST_PersonaMast.Telefono AS Telefono, ";
        $s_SQLQuery .= "MST_PersonaMast.Celular AS Celular, ";
        $s_SQLQuery .= "MST_PersonaMast.Email AS Email, ";
        $s_SQLQuery .= "MST_PersonaMast.DireccionWeb AS DireccionWeb, ";
        $s_SQLQuery .= "MST_PersonaMast.Fax AS Fax, ";
        $s_SQLQuery .= "MST_PersonaMast.DocumentoIdentidad AS DocumentoIdentidad, ";
        $s_SQLQuery .= "MST_PersonaMast.CarnetExtranjeria AS CarnetExtranjeria, ";
        $s_SQLQuery .= "MST_PersonaMast.DocumentoMilitarFA AS DocumentoMilitarFA, ";
        $s_SQLQuery .= "MST_PersonaMast.TipoBrevete AS TipoBrevete, ";
        $s_SQLQuery .= "MST_PersonaMast.Brevete AS Brevete, ";
        $s_SQLQuery .= "MST_PersonaMast.Pasaporte AS Pasaporte, ";
        $s_SQLQuery .= "MST_PersonaMast.EsAgenteRetenedor AS EsAgenteRetenedor, ";
        $s_SQLQuery .= "MST_PersonaMast.IdRetencion AS IdRetencion, ";
        $s_SQLQuery .= "MST_PersonaMast.Estado AS Estado, ";
        $s_SQLQuery .= "MST_PersonaMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_PersonaMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_PersonaMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_PersonaMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_PersonaMast.IdUsuario AS IdUsuario, ";
        $s_SQLQuery .= "MST_PersonaMast.ProveedorGuiasFlag AS ProveedorGuiasFlag, ";
        $s_SQLQuery .= "MST_PersonaMast.EmpleadoVendedorFlag AS EmpleadoVendedorFlag ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_PersonaMastBN */
    public function setByBN( MST_PersonaMastBN $o_MST_PersonaMastBN )
    {
        if ( !is_null( $o_MST_PersonaMastBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_MST_PersonaMastBN->getIdPersona() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_PersonaMastBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getApellidoPaterno() ) )
        {
            $this->setApellidoPaterno( $o_MST_PersonaMastBN->getApellidoPaterno() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getApellidoMaterno() ) )
        {
            $this->setApellidoMaterno( $o_MST_PersonaMastBN->getApellidoMaterno() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getNombres() ) )
        {
            $this->setNombres( $o_MST_PersonaMastBN->getNombres() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getNombreCompleto() ) )
        {
            $this->setNombreCompleto( $o_MST_PersonaMastBN->getNombreCompleto() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getNombreComercial() ) )
        {
            $this->setNombreComercial( $o_MST_PersonaMastBN->getNombreComercial() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getContacto() ) )
        {
            $this->setContacto( $o_MST_PersonaMastBN->getContacto() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getTipoDocumento() ) )
        {
            $this->setTipoDocumento( $o_MST_PersonaMastBN->getTipoDocumento() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getDocumento() ) )
        {
            $this->setDocumento( $o_MST_PersonaMastBN->getDocumento() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getCodigoBarras() ) )
        {
            $this->setCodigoBarras( $o_MST_PersonaMastBN->getCodigoBarras() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEsCliente() ) )
        {
            $this->setEsCliente( $o_MST_PersonaMastBN->getEsCliente() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEsProveedor() ) )
        {
            $this->setEsProveedor( $o_MST_PersonaMastBN->getEsProveedor() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEsEmpleado() ) )
        {
            $this->setEsEmpleado( $o_MST_PersonaMastBN->getEsEmpleado() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEsOtro() ) )
        {
            $this->setEsOtro( $o_MST_PersonaMastBN->getEsOtro() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getTipoPersona() ) )
        {
            $this->setTipoPersona( $o_MST_PersonaMastBN->getTipoPersona() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getFechaNacimiento() ) )
        {
            $this->setFechaNacimiento( $o_MST_PersonaMastBN->getFechaNacimiento() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getCiudadNacimiento() ) )
        {
            $this->setCiudadNacimiento( $o_MST_PersonaMastBN->getCiudadNacimiento() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getSexo() ) )
        {
            $this->setSexo( $o_MST_PersonaMastBN->getSexo() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getNacionalidad() ) )
        {
            $this->setNacionalidad( $o_MST_PersonaMastBN->getNacionalidad() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getPaisId() ) )
        {
            $this->setPaisId( $o_MST_PersonaMastBN->getPaisId() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getPaisDesc() ) )
        {
            $this->setPaisDesc( $o_MST_PersonaMastBN->getPaisDesc() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEstadoCivil() ) )
        {
            $this->setEstadoCivil( $o_MST_PersonaMastBN->getEstadoCivil() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getNivelInstruccion() ) )
        {
            $this->setNivelInstruccion( $o_MST_PersonaMastBN->getNivelInstruccion() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getDireccion() ) )
        {
            $this->setDireccion( $o_MST_PersonaMastBN->getDireccion() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getCodigoPostal() ) )
        {
            $this->setCodigoPostal( $o_MST_PersonaMastBN->getCodigoPostal() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getProvincia() ) )
        {
            $this->setProvincia( $o_MST_PersonaMastBN->getProvincia() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getDepartamento() ) )
        {
            $this->setDepartamento( $o_MST_PersonaMastBN->getDepartamento() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getDistrito() ) )
        {
            $this->setDistrito( $o_MST_PersonaMastBN->getDistrito() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getTelefono() ) )
        {
            $this->setTelefono( $o_MST_PersonaMastBN->getTelefono() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getCelular() ) )
        {
            $this->setCelular( $o_MST_PersonaMastBN->getCelular() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEmail() ) )
        {
            $this->setEmail( $o_MST_PersonaMastBN->getEmail() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getDireccionWeb() ) )
        {
            $this->setDireccionWeb( $o_MST_PersonaMastBN->getDireccionWeb() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getFax() ) )
        {
            $this->setFax( $o_MST_PersonaMastBN->getFax() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getDocumentoIdentidad() ) )
        {
            $this->setDocumentoIdentidad( $o_MST_PersonaMastBN->getDocumentoIdentidad() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getCarnetExtranjeria() ) )
        {
            $this->setCarnetExtranjeria( $o_MST_PersonaMastBN->getCarnetExtranjeria() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getDocumentoMilitarFA() ) )
        {
            $this->setDocumentoMilitarFA( $o_MST_PersonaMastBN->getDocumentoMilitarFA() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getTipoBrevete() ) )
        {
            $this->setTipoBrevete( $o_MST_PersonaMastBN->getTipoBrevete() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getBrevete() ) )
        {
            $this->setBrevete( $o_MST_PersonaMastBN->getBrevete() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getPasaporte() ) )
        {
            $this->setPasaporte( $o_MST_PersonaMastBN->getPasaporte() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEsAgenteRetenedor() ) )
        {
            $this->setEsAgenteRetenedor( $o_MST_PersonaMastBN->getEsAgenteRetenedor() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getIdRetencion() ) )
        {
            $this->setIdRetencion( $o_MST_PersonaMastBN->getIdRetencion() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_PersonaMastBN->getEstado() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_PersonaMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_PersonaMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_PersonaMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_PersonaMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_MST_PersonaMastBN->getIdUsuario() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getProveedorGuiasFlag() ) )
        {
            $this->setProveedorGuiasFlag( $o_MST_PersonaMastBN->getProveedorGuiasFlag() );
        }
        if ( !is_null( $o_MST_PersonaMastBN->getEmpleadoVendedorFlag() ) )
        {
            $this->setEmpleadoVendedorFlag( $o_MST_PersonaMastBN->getEmpleadoVendedorFlag() );
        }
    }

    /**
    * @return MST_PersonaMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdPersona )
    {
        if( is_null( $i_IdPersona ) ){ $i_IdPersona = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_PersonaMast ";
        $s_SQLQuery .= "WHERE IdPersona = ".$i_IdPersona." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_PersonaMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_PersonaMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_PersonaMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "MST_PersonaMast.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_PersonaMast.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getApellidoPaterno() ) ) $s_SQLQuery .= "MST_PersonaMast.ApellidoPaterno = '".$this->getApellidoPaterno()."' AND ";
        if ( !is_null( $this->getApellidoMaterno() ) ) $s_SQLQuery .= "MST_PersonaMast.ApellidoMaterno = '".$this->getApellidoMaterno()."' AND ";
        if ( !is_null( $this->getNombres() ) ) $s_SQLQuery .= "MST_PersonaMast.Nombres = '".$this->getNombres()."' AND ";
        if ( !is_null( $this->getNombreCompleto() ) ) $s_SQLQuery .= "MST_PersonaMast.NombreCompleto = '".$this->getNombreCompleto()."' AND ";
        if ( !is_null( $this->getNombreComercial() ) ) $s_SQLQuery .= "MST_PersonaMast.NombreComercial = '".$this->getNombreComercial()."' AND ";
        if ( !is_null( $this->getContacto() ) ) $s_SQLQuery .= "MST_PersonaMast.Contacto = '".$this->getContacto()."' AND ";
        if ( !is_null( $this->getTipoDocumento() ) ) $s_SQLQuery .= "MST_PersonaMast.TipoDocumento = '".$this->getTipoDocumento()."' AND ";
        if ( !is_null( $this->getDocumento() ) ) $s_SQLQuery .= "MST_PersonaMast.Documento = '".$this->getDocumento()."' AND ";
        if ( !is_null( $this->getCodigoBarras() ) ) $s_SQLQuery .= "MST_PersonaMast.CodigoBarras = '".$this->getCodigoBarras()."' AND ";
        if ( !is_null( $this->getEsCliente() ) ) $s_SQLQuery .= "MST_PersonaMast.EsCliente = '".$this->getEsCliente()."' AND ";
        if ( !is_null( $this->getEsProveedor() ) ) $s_SQLQuery .= "MST_PersonaMast.EsProveedor = '".$this->getEsProveedor()."' AND ";
        if ( !is_null( $this->getEsEmpleado() ) ) $s_SQLQuery .= "MST_PersonaMast.EsEmpleado = '".$this->getEsEmpleado()."' AND ";
        if ( !is_null( $this->getEsOtro() ) ) $s_SQLQuery .= "MST_PersonaMast.EsOtro = '".$this->getEsOtro()."' AND ";
        if ( !is_null( $this->getTipoPersona() ) ) $s_SQLQuery .= "MST_PersonaMast.TipoPersona = '".$this->getTipoPersona()."' AND ";
        if ( !is_null( $this->getFechaNacimiento() ) ) $s_SQLQuery .= "MST_PersonaMast.FechaNacimiento = '".$this->getFechaNacimiento()."' AND ";
        if ( !is_null( $this->getCiudadNacimiento() ) ) $s_SQLQuery .= "MST_PersonaMast.CiudadNacimiento = '".$this->getCiudadNacimiento()."' AND ";
        if ( !is_null( $this->getSexo() ) ) $s_SQLQuery .= "MST_PersonaMast.Sexo = '".$this->getSexo()."' AND ";
        if ( !is_null( $this->getNacionalidad() ) ) $s_SQLQuery .= "MST_PersonaMast.Nacionalidad = '".$this->getNacionalidad()."' AND ";
        if ( !is_null( $this->getPaisId() ) ) $s_SQLQuery .= "MST_PersonaMast.PaisId = '".$this->getPaisId()."' AND ";
        if ( !is_null( $this->getPaisDesc() ) ) $s_SQLQuery .= "MST_PersonaMast.PaisDesc = '".$this->getPaisDesc()."' AND ";
        if ( !is_null( $this->getEstadoCivil() ) ) $s_SQLQuery .= "MST_PersonaMast.EstadoCivil = '".$this->getEstadoCivil()."' AND ";
        if ( !is_null( $this->getNivelInstruccion() ) ) $s_SQLQuery .= "MST_PersonaMast.NivelInstruccion = '".$this->getNivelInstruccion()."' AND ";
        if ( !is_null( $this->getDireccion() ) ) $s_SQLQuery .= "MST_PersonaMast.Direccion = '".$this->getDireccion()."' AND ";
        if ( !is_null( $this->getCodigoPostal() ) ) $s_SQLQuery .= "MST_PersonaMast.CodigoPostal = '".$this->getCodigoPostal()."' AND ";
        if ( !is_null( $this->getProvincia() ) ) $s_SQLQuery .= "MST_PersonaMast.Provincia = '".$this->getProvincia()."' AND ";
        if ( !is_null( $this->getDepartamento() ) ) $s_SQLQuery .= "MST_PersonaMast.Departamento = '".$this->getDepartamento()."' AND ";
        if ( !is_null( $this->getDistrito() ) ) $s_SQLQuery .= "MST_PersonaMast.Distrito = '".$this->getDistrito()."' AND ";
        if ( !is_null( $this->getTelefono() ) ) $s_SQLQuery .= "MST_PersonaMast.Telefono = '".$this->getTelefono()."' AND ";
        if ( !is_null( $this->getCelular() ) ) $s_SQLQuery .= "MST_PersonaMast.Celular = '".$this->getCelular()."' AND ";
        if ( !is_null( $this->getEmail() ) ) $s_SQLQuery .= "MST_PersonaMast.Email = '".$this->getEmail()."' AND ";
        if ( !is_null( $this->getDireccionWeb() ) ) $s_SQLQuery .= "MST_PersonaMast.DireccionWeb = '".$this->getDireccionWeb()."' AND ";
        if ( !is_null( $this->getFax() ) ) $s_SQLQuery .= "MST_PersonaMast.Fax = '".$this->getFax()."' AND ";
        if ( !is_null( $this->getDocumentoIdentidad() ) ) $s_SQLQuery .= "MST_PersonaMast.DocumentoIdentidad = '".$this->getDocumentoIdentidad()."' AND ";
        if ( !is_null( $this->getCarnetExtranjeria() ) ) $s_SQLQuery .= "MST_PersonaMast.CarnetExtranjeria = '".$this->getCarnetExtranjeria()."' AND ";
        if ( !is_null( $this->getDocumentoMilitarFA() ) ) $s_SQLQuery .= "MST_PersonaMast.DocumentoMilitarFA = '".$this->getDocumentoMilitarFA()."' AND ";
        if ( !is_null( $this->getTipoBrevete() ) ) $s_SQLQuery .= "MST_PersonaMast.TipoBrevete = '".$this->getTipoBrevete()."' AND ";
        if ( !is_null( $this->getBrevete() ) ) $s_SQLQuery .= "MST_PersonaMast.Brevete = '".$this->getBrevete()."' AND ";
        if ( !is_null( $this->getPasaporte() ) ) $s_SQLQuery .= "MST_PersonaMast.Pasaporte = '".$this->getPasaporte()."' AND ";
        if ( !is_null( $this->getEsAgenteRetenedor() ) ) $s_SQLQuery .= "MST_PersonaMast.EsAgenteRetenedor = ".$this->getEsAgenteRetenedor()." AND ";
        if ( !is_null( $this->getIdRetencion() ) ) $s_SQLQuery .= "MST_PersonaMast.IdRetencion = ".$this->getIdRetencion()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_PersonaMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_PersonaMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_PersonaMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_PersonaMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_PersonaMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getIdUsuario() ) ) $s_SQLQuery .= "MST_PersonaMast.IdUsuario = '".$this->getIdUsuario()."' AND ";
        if ( !is_null( $this->getProveedorGuiasFlag() ) ) $s_SQLQuery .= "MST_PersonaMast.ProveedorGuiasFlag = '".$this->getProveedorGuiasFlag()."' AND ";
        if ( !is_null( $this->getEmpleadoVendedorFlag() ) ) $s_SQLQuery .= "MST_PersonaMast.EmpleadoVendedorFlag = '".$this->getEmpleadoVendedorFlag()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_PersonaMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_PersonaMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_PersonaMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_PersonaMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_PersonaMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_PersonaMastBN[] = $o_MST_PersonaMastBN;
            }
        }
        return $a_MST_PersonaMastBN;
    }

    /* Devuelve un objeto MST_PersonaMastBN desde un objeto propel */
    public function insertObjectBN( $a_MST_PersonaMast )
    {
        $o_MST_PersonaMastBN = new MST_PersonaMastBN();
        if ( !is_null( $a_MST_PersonaMast['IdPersona'] ) ) $o_MST_PersonaMastBN->setIdPersona( ( integer ) $a_MST_PersonaMast['IdPersona'] );
        if ( !is_null( $a_MST_PersonaMast['IdCompania'] ) ) $o_MST_PersonaMastBN->setIdCompania( ( integer ) $a_MST_PersonaMast['IdCompania'] );
        if ( !is_null( $a_MST_PersonaMast['ApellidoPaterno'] ) ) $o_MST_PersonaMastBN->setApellidoPaterno( $a_MST_PersonaMast['ApellidoPaterno'] );
        if ( !is_null( $a_MST_PersonaMast['ApellidoMaterno'] ) ) $o_MST_PersonaMastBN->setApellidoMaterno( $a_MST_PersonaMast['ApellidoMaterno'] );
        if ( !is_null( $a_MST_PersonaMast['Nombres'] ) ) $o_MST_PersonaMastBN->setNombres( $a_MST_PersonaMast['Nombres'] );
        if ( !is_null( $a_MST_PersonaMast['NombreCompleto'] ) ) $o_MST_PersonaMastBN->setNombreCompleto( $a_MST_PersonaMast['NombreCompleto'] );
        if ( !is_null( $a_MST_PersonaMast['NombreComercial'] ) ) $o_MST_PersonaMastBN->setNombreComercial( $a_MST_PersonaMast['NombreComercial'] );
        if ( !is_null( $a_MST_PersonaMast['Contacto'] ) ) $o_MST_PersonaMastBN->setContacto( $a_MST_PersonaMast['Contacto'] );
        if ( !is_null( $a_MST_PersonaMast['TipoDocumento'] ) ) $o_MST_PersonaMastBN->setTipoDocumento( $a_MST_PersonaMast['TipoDocumento'] );
        if ( !is_null( $a_MST_PersonaMast['Documento'] ) ) $o_MST_PersonaMastBN->setDocumento( $a_MST_PersonaMast['Documento'] );
        if ( !is_null( $a_MST_PersonaMast['CodigoBarras'] ) ) $o_MST_PersonaMastBN->setCodigoBarras( $a_MST_PersonaMast['CodigoBarras'] );
        if ( !is_null( $a_MST_PersonaMast['EsCliente'] ) ) $o_MST_PersonaMastBN->setEsCliente( $a_MST_PersonaMast['EsCliente'] );
        if ( !is_null( $a_MST_PersonaMast['EsProveedor'] ) ) $o_MST_PersonaMastBN->setEsProveedor( $a_MST_PersonaMast['EsProveedor'] );
        if ( !is_null( $a_MST_PersonaMast['EsEmpleado'] ) ) $o_MST_PersonaMastBN->setEsEmpleado( $a_MST_PersonaMast['EsEmpleado'] );
        if ( !is_null( $a_MST_PersonaMast['EsOtro'] ) ) $o_MST_PersonaMastBN->setEsOtro( $a_MST_PersonaMast['EsOtro'] );
        if ( !is_null( $a_MST_PersonaMast['TipoPersona'] ) ) $o_MST_PersonaMastBN->setTipoPersona( $a_MST_PersonaMast['TipoPersona'] );
        if ( !is_null( $a_MST_PersonaMast['FechaNacimiento'] ) ) $o_MST_PersonaMastBN->setFechaNacimiento( utilTimestamp::getTimestamp( $a_MST_PersonaMast['FechaNacimiento'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_PersonaMast['CiudadNacimiento'] ) ) $o_MST_PersonaMastBN->setCiudadNacimiento( $a_MST_PersonaMast['CiudadNacimiento'] );
        if ( !is_null( $a_MST_PersonaMast['Sexo'] ) ) $o_MST_PersonaMastBN->setSexo( $a_MST_PersonaMast['Sexo'] );
        if ( !is_null( $a_MST_PersonaMast['Nacionalidad'] ) ) $o_MST_PersonaMastBN->setNacionalidad( $a_MST_PersonaMast['Nacionalidad'] );
        if ( !is_null( $a_MST_PersonaMast['PaisId'] ) ) $o_MST_PersonaMastBN->setPaisId( $a_MST_PersonaMast['PaisId'] );
        if ( !is_null( $a_MST_PersonaMast['PaisDesc'] ) ) $o_MST_PersonaMastBN->setPaisDesc( $a_MST_PersonaMast['PaisDesc'] );
        if ( !is_null( $a_MST_PersonaMast['EstadoCivil'] ) ) $o_MST_PersonaMastBN->setEstadoCivil( $a_MST_PersonaMast['EstadoCivil'] );
        if ( !is_null( $a_MST_PersonaMast['NivelInstruccion'] ) ) $o_MST_PersonaMastBN->setNivelInstruccion( $a_MST_PersonaMast['NivelInstruccion'] );
        if ( !is_null( $a_MST_PersonaMast['Direccion'] ) ) $o_MST_PersonaMastBN->setDireccion( $a_MST_PersonaMast['Direccion'] );
        if ( !is_null( $a_MST_PersonaMast['CodigoPostal'] ) ) $o_MST_PersonaMastBN->setCodigoPostal( $a_MST_PersonaMast['CodigoPostal'] );
        if ( !is_null( $a_MST_PersonaMast['Provincia'] ) ) $o_MST_PersonaMastBN->setProvincia( $a_MST_PersonaMast['Provincia'] );
        if ( !is_null( $a_MST_PersonaMast['Departamento'] ) ) $o_MST_PersonaMastBN->setDepartamento( $a_MST_PersonaMast['Departamento'] );
        if ( !is_null( $a_MST_PersonaMast['Distrito'] ) ) $o_MST_PersonaMastBN->setDistrito( $a_MST_PersonaMast['Distrito'] );
        if ( !is_null( $a_MST_PersonaMast['Telefono'] ) ) $o_MST_PersonaMastBN->setTelefono( $a_MST_PersonaMast['Telefono'] );
        if ( !is_null( $a_MST_PersonaMast['Celular'] ) ) $o_MST_PersonaMastBN->setCelular( $a_MST_PersonaMast['Celular'] );
        if ( !is_null( $a_MST_PersonaMast['Email'] ) ) $o_MST_PersonaMastBN->setEmail( $a_MST_PersonaMast['Email'] );
        if ( !is_null( $a_MST_PersonaMast['DireccionWeb'] ) ) $o_MST_PersonaMastBN->setDireccionWeb( $a_MST_PersonaMast['DireccionWeb'] );
        if ( !is_null( $a_MST_PersonaMast['Fax'] ) ) $o_MST_PersonaMastBN->setFax( $a_MST_PersonaMast['Fax'] );
        if ( !is_null( $a_MST_PersonaMast['DocumentoIdentidad'] ) ) $o_MST_PersonaMastBN->setDocumentoIdentidad( $a_MST_PersonaMast['DocumentoIdentidad'] );
        if ( !is_null( $a_MST_PersonaMast['CarnetExtranjeria'] ) ) $o_MST_PersonaMastBN->setCarnetExtranjeria( $a_MST_PersonaMast['CarnetExtranjeria'] );
        if ( !is_null( $a_MST_PersonaMast['DocumentoMilitarFA'] ) ) $o_MST_PersonaMastBN->setDocumentoMilitarFA( $a_MST_PersonaMast['DocumentoMilitarFA'] );
        if ( !is_null( $a_MST_PersonaMast['TipoBrevete'] ) ) $o_MST_PersonaMastBN->setTipoBrevete( $a_MST_PersonaMast['TipoBrevete'] );
        if ( !is_null( $a_MST_PersonaMast['Brevete'] ) ) $o_MST_PersonaMastBN->setBrevete( $a_MST_PersonaMast['Brevete'] );
        if ( !is_null( $a_MST_PersonaMast['Pasaporte'] ) ) $o_MST_PersonaMastBN->setPasaporte( $a_MST_PersonaMast['Pasaporte'] );
        if ( !is_null( $a_MST_PersonaMast['EsAgenteRetenedor'] ) ) $o_MST_PersonaMastBN->setEsAgenteRetenedor( ( integer ) $a_MST_PersonaMast['EsAgenteRetenedor'] );
        if ( !is_null( $a_MST_PersonaMast['IdRetencion'] ) ) $o_MST_PersonaMastBN->setIdRetencion( ( integer ) $a_MST_PersonaMast['IdRetencion'] );
        if ( !is_null( $a_MST_PersonaMast['Estado'] ) ) $o_MST_PersonaMastBN->setEstado( $a_MST_PersonaMast['Estado'] );
        if ( !is_null( $a_MST_PersonaMast['UsuarioModificacion'] ) ) $o_MST_PersonaMastBN->setUsuarioModificacion( $a_MST_PersonaMast['UsuarioModificacion'] );
        if ( !is_null( $a_MST_PersonaMast['FechaModificacion'] ) ) $o_MST_PersonaMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_PersonaMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_PersonaMast['UsuarioCreacion'] ) ) $o_MST_PersonaMastBN->setUsuarioCreacion( $a_MST_PersonaMast['UsuarioCreacion'] );
        if ( !is_null( $a_MST_PersonaMast['FechaCreacion'] ) ) $o_MST_PersonaMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_PersonaMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_PersonaMast['IdUsuario'] ) ) $o_MST_PersonaMastBN->setIdUsuario( $a_MST_PersonaMast['IdUsuario'] );
        if ( !is_null( $a_MST_PersonaMast['ProveedorGuiasFlag'] ) ) $o_MST_PersonaMastBN->setProveedorGuiasFlag( $a_MST_PersonaMast['ProveedorGuiasFlag'] );
        if ( !is_null( $a_MST_PersonaMast['EmpleadoVendedorFlag'] ) ) $o_MST_PersonaMastBN->setEmpleadoVendedorFlag( $a_MST_PersonaMast['EmpleadoVendedorFlag'] );
        return $o_MST_PersonaMastBN;
    }
}
?>