<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_PersonaEmpleado.xml */
/* Generado: 2021-06-25 23:59:52 */

/* Busqueda de registros de la tabla MST_PersonaEmpleado. */
abstract class BaseMST_PersonaEmpleadoFN extends MST_PersonaEmpleadoBN
{
    /* Declaracion de constantes */
    const IdPersona = "MST_PersonaEmpleado.IdPersona";
    const IdCompania = "MST_PersonaEmpleado.IdCompania";
    const IdSede = "MST_PersonaEmpleado.IdSede";
    const IdCargo = "MST_PersonaEmpleado.IdCargo";
    const EmpleadoNombres = "MST_PersonaEmpleado.EmpleadoNombres";
    const EmpleadoApellidoPaterno = "MST_PersonaEmpleado.EmpleadoApellidoPaterno";
    const EmpleadoApellidoMaterno = "MST_PersonaEmpleado.EmpleadoApellidoMaterno";
    const TipoDocumento = "MST_PersonaEmpleado.TipoDocumento";
    const NumeroDocumento = "MST_PersonaEmpleado.NumeroDocumento";
    const Sueldo = "MST_PersonaEmpleado.Sueldo";
    const FechaInicio = "MST_PersonaEmpleado.FechaInicio";
    const FechaCese = "MST_PersonaEmpleado.FechaCese";
    const FlagEstadoAsistencia = "MST_PersonaEmpleado.FlagEstadoAsistencia";
    const FechaCreacion = "MST_PersonaEmpleado.FechaCreacion";
    const UsuarioCreacion = "MST_PersonaEmpleado.UsuarioCreacion";
    const UsuarioModificacion = "MST_PersonaEmpleado.UsuarioModificacion";
    const FechaModificacion = "MST_PersonaEmpleado.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_PersonaEmpleado.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.IdSede AS IdSede, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.IdCargo AS IdCargo, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.EmpleadoNombres AS EmpleadoNombres, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.EmpleadoApellidoPaterno AS EmpleadoApellidoPaterno, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.EmpleadoApellidoMaterno AS EmpleadoApellidoMaterno, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.TipoDocumento AS TipoDocumento, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.NumeroDocumento AS NumeroDocumento, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.Sueldo AS Sueldo, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.FechaInicio AS FechaInicio, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.FechaCese AS FechaCese, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.FlagEstadoAsistencia AS FlagEstadoAsistencia, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_PersonaEmpleado.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_PersonaEmpleadoBN */
    public function setByBN( MST_PersonaEmpleadoBN $o_MST_PersonaEmpleadoBN )
    {
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_MST_PersonaEmpleadoBN->getIdPersona() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_PersonaEmpleadoBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getIdSede() ) )
        {
            $this->setIdSede( $o_MST_PersonaEmpleadoBN->getIdSede() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getIdCargo() ) )
        {
            $this->setIdCargo( $o_MST_PersonaEmpleadoBN->getIdCargo() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getEmpleadoNombres() ) )
        {
            $this->setEmpleadoNombres( $o_MST_PersonaEmpleadoBN->getEmpleadoNombres() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoPaterno() ) )
        {
            $this->setEmpleadoApellidoPaterno( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoPaterno() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoMaterno() ) )
        {
            $this->setEmpleadoApellidoMaterno( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoMaterno() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getTipoDocumento() ) )
        {
            $this->setTipoDocumento( $o_MST_PersonaEmpleadoBN->getTipoDocumento() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getNumeroDocumento() ) )
        {
            $this->setNumeroDocumento( $o_MST_PersonaEmpleadoBN->getNumeroDocumento() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getSueldo() ) )
        {
            $this->setSueldo( $o_MST_PersonaEmpleadoBN->getSueldo() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getFechaInicio() ) )
        {
            $this->setFechaInicio( $o_MST_PersonaEmpleadoBN->getFechaInicio() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getFechaCese() ) )
        {
            $this->setFechaCese( $o_MST_PersonaEmpleadoBN->getFechaCese() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getFlagEstadoAsistencia() ) )
        {
            $this->setFlagEstadoAsistencia( $o_MST_PersonaEmpleadoBN->getFlagEstadoAsistencia() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_PersonaEmpleadoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_PersonaEmpleadoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_PersonaEmpleadoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_PersonaEmpleadoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_PersonaEmpleadoBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_PersonaEmpleadoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdPersona )
    {
        if( is_null( $i_IdPersona ) ){ $i_IdPersona = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_PersonaEmpleado ";
        $s_SQLQuery .= "WHERE IdPersona = ".$i_IdPersona." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_PersonaEmpleadoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_PersonaEmpleadoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_PersonaEmpleadoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSede() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.IdSede = ".$this->getIdSede()." AND ";
        if ( !is_null( $this->getIdCargo() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.IdCargo = ".$this->getIdCargo()." AND ";
        if ( !is_null( $this->getEmpleadoNombres() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.EmpleadoNombres = '".$this->getEmpleadoNombres()."' AND ";
        if ( !is_null( $this->getEmpleadoApellidoPaterno() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.EmpleadoApellidoPaterno = '".$this->getEmpleadoApellidoPaterno()."' AND ";
        if ( !is_null( $this->getEmpleadoApellidoMaterno() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.EmpleadoApellidoMaterno = '".$this->getEmpleadoApellidoMaterno()."' AND ";
        if ( !is_null( $this->getTipoDocumento() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.TipoDocumento = '".$this->getTipoDocumento()."' AND ";
        if ( !is_null( $this->getNumeroDocumento() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.NumeroDocumento = '".$this->getNumeroDocumento()."' AND ";
        if ( !is_null( $this->getSueldo() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.Sueldo = ".$this->getSueldo()." AND ";
        if ( !is_null( $this->getFechaInicio() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.FechaInicio = '".$this->getFechaInicio()."' AND ";
        if ( !is_null( $this->getFechaCese() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.FechaCese = '".$this->getFechaCese()."' AND ";
        if ( !is_null( $this->getFlagEstadoAsistencia() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.FlagEstadoAsistencia = '".$this->getFlagEstadoAsistencia()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_PersonaEmpleado.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_PersonaEmpleado WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_PersonaEmpleadoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_PersonaEmpleado WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_PersonaEmpleadoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_PersonaEmpleadoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_PersonaEmpleadoBN[] = $o_MST_PersonaEmpleadoBN;
            }
        }
        return $a_MST_PersonaEmpleadoBN;
    }

    /* Devuelve un objeto MST_PersonaEmpleadoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_PersonaEmpleado )
    {
        $o_MST_PersonaEmpleadoBN = new MST_PersonaEmpleadoBN();
        if ( !is_null( $a_MST_PersonaEmpleado['IdPersona'] ) ) $o_MST_PersonaEmpleadoBN->setIdPersona( ( integer ) $a_MST_PersonaEmpleado['IdPersona'] );
        if ( !is_null( $a_MST_PersonaEmpleado['IdCompania'] ) ) $o_MST_PersonaEmpleadoBN->setIdCompania( ( integer ) $a_MST_PersonaEmpleado['IdCompania'] );
        if ( !is_null( $a_MST_PersonaEmpleado['IdSede'] ) ) $o_MST_PersonaEmpleadoBN->setIdSede( ( integer ) $a_MST_PersonaEmpleado['IdSede'] );
        if ( !is_null( $a_MST_PersonaEmpleado['IdCargo'] ) ) $o_MST_PersonaEmpleadoBN->setIdCargo( ( integer ) $a_MST_PersonaEmpleado['IdCargo'] );
        if ( !is_null( $a_MST_PersonaEmpleado['EmpleadoNombres'] ) ) $o_MST_PersonaEmpleadoBN->setEmpleadoNombres( $a_MST_PersonaEmpleado['EmpleadoNombres'] );
        if ( !is_null( $a_MST_PersonaEmpleado['EmpleadoApellidoPaterno'] ) ) $o_MST_PersonaEmpleadoBN->setEmpleadoApellidoPaterno( $a_MST_PersonaEmpleado['EmpleadoApellidoPaterno'] );
        if ( !is_null( $a_MST_PersonaEmpleado['EmpleadoApellidoMaterno'] ) ) $o_MST_PersonaEmpleadoBN->setEmpleadoApellidoMaterno( $a_MST_PersonaEmpleado['EmpleadoApellidoMaterno'] );
        if ( !is_null( $a_MST_PersonaEmpleado['TipoDocumento'] ) ) $o_MST_PersonaEmpleadoBN->setTipoDocumento( $a_MST_PersonaEmpleado['TipoDocumento'] );
        if ( !is_null( $a_MST_PersonaEmpleado['NumeroDocumento'] ) ) $o_MST_PersonaEmpleadoBN->setNumeroDocumento( $a_MST_PersonaEmpleado['NumeroDocumento'] );
        if ( !is_null( $a_MST_PersonaEmpleado['Sueldo'] ) ) $o_MST_PersonaEmpleadoBN->setSueldo( ( float ) $a_MST_PersonaEmpleado['Sueldo'] );
        if ( !is_null( $a_MST_PersonaEmpleado['FechaInicio'] ) ) $o_MST_PersonaEmpleadoBN->setFechaInicio( utilTimestamp::getTimestamp( $a_MST_PersonaEmpleado['FechaInicio'], "Y-m-d" ) );
        if ( !is_null( $a_MST_PersonaEmpleado['FechaCese'] ) ) $o_MST_PersonaEmpleadoBN->setFechaCese( utilTimestamp::getTimestamp( $a_MST_PersonaEmpleado['FechaCese'], "Y-m-d" ) );
        if ( !is_null( $a_MST_PersonaEmpleado['FlagEstadoAsistencia'] ) ) $o_MST_PersonaEmpleadoBN->setFlagEstadoAsistencia( $a_MST_PersonaEmpleado['FlagEstadoAsistencia'] );
        if ( !is_null( $a_MST_PersonaEmpleado['FechaCreacion'] ) ) $o_MST_PersonaEmpleadoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_PersonaEmpleado['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_PersonaEmpleado['UsuarioCreacion'] ) ) $o_MST_PersonaEmpleadoBN->setUsuarioCreacion( $a_MST_PersonaEmpleado['UsuarioCreacion'] );
        if ( !is_null( $a_MST_PersonaEmpleado['UsuarioModificacion'] ) ) $o_MST_PersonaEmpleadoBN->setUsuarioModificacion( $a_MST_PersonaEmpleado['UsuarioModificacion'] );
        if ( !is_null( $a_MST_PersonaEmpleado['FechaModificacion'] ) ) $o_MST_PersonaEmpleadoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_PersonaEmpleado['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_PersonaEmpleadoBN;
    }
}
?>