<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ListaPrecioDetalleLog.xml */
/* Generado: 2021-06-25 23:59:51 */

/* Busqueda de registros de la tabla MST_ListaPrecioDetalleLog. */
abstract class BaseMST_ListaPrecioDetalleLogFN extends MST_ListaPrecioDetalleLogBN
{
    /* Declaracion de constantes */
    const IdLPDLog = "MST_ListaPrecioDetalleLog.IdLPDLog";
    const IdCompania = "MST_ListaPrecioDetalleLog.IdCompania";
    const IdSucursal = "MST_ListaPrecioDetalleLog.IdSucursal";
    const IdItem = "MST_ListaPrecioDetalleLog.IdItem";
    const IdTipoPrecio = "MST_ListaPrecioDetalleLog.IdTipoPrecio";
    const FechaInicio = "MST_ListaPrecioDetalleLog.FechaInicio";
    const FechaFin = "MST_ListaPrecioDetalleLog.FechaFin";
    const Estado = "MST_ListaPrecioDetalleLog.Estado";
    const PrecioCosto = "MST_ListaPrecioDetalleLog.PrecioCosto";
    const PorcentajeUtilidad = "MST_ListaPrecioDetalleLog.PorcentajeUtilidad";
    const PrecioVenta = "MST_ListaPrecioDetalleLog.PrecioVenta";
    const MontoDescuento = "MST_ListaPrecioDetalleLog.MontoDescuento";
    const PorcentajeDescuento = "MST_ListaPrecioDetalleLog.PorcentajeDescuento";
    const DescuentoFlag = "MST_ListaPrecioDetalleLog.DescuentoFlag";
    const FechaCreacion = "MST_ListaPrecioDetalleLog.FechaCreacion";
    const UsuarioCreacion = "MST_ListaPrecioDetalleLog.UsuarioCreacion";
    const FechaModificacion = "MST_ListaPrecioDetalleLog.FechaModificacion";
    const FechaLog = "MST_ListaPrecioDetalleLog.FechaLog";
    const UsuarioLog = "MST_ListaPrecioDetalleLog.UsuarioLog";
    const UsuarioModificacion = "MST_ListaPrecioDetalleLog.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ListaPrecioDetalleLog.IdLPDLog AS IdLPDLog, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdItem AS IdItem, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdTipoPrecio AS IdTipoPrecio, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaInicio AS FechaInicio, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaFin AS FechaFin, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.PrecioCosto AS PrecioCosto, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.PorcentajeUtilidad AS PorcentajeUtilidad, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.PrecioVenta AS PrecioVenta, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.MontoDescuento AS MontoDescuento, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.PorcentajeDescuento AS PorcentajeDescuento, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.DescuentoFlag AS DescuentoFlag, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaLog AS FechaLog, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.UsuarioLog AS UsuarioLog, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalleLog.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ListaPrecioDetalleLogBN */
    public function setByBN( MST_ListaPrecioDetalleLogBN $o_MST_ListaPrecioDetalleLogBN )
    {
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getIdLPDLog() ) )
        {
            $this->setIdLPDLog( $o_MST_ListaPrecioDetalleLogBN->getIdLPDLog() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_ListaPrecioDetalleLogBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_ListaPrecioDetalleLogBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_ListaPrecioDetalleLogBN->getIdItem() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getIdTipoPrecio() ) )
        {
            $this->setIdTipoPrecio( $o_MST_ListaPrecioDetalleLogBN->getIdTipoPrecio() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getFechaInicio() ) )
        {
            $this->setFechaInicio( $o_MST_ListaPrecioDetalleLogBN->getFechaInicio() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getFechaFin() ) )
        {
            $this->setFechaFin( $o_MST_ListaPrecioDetalleLogBN->getFechaFin() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ListaPrecioDetalleLogBN->getEstado() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getPrecioCosto() ) )
        {
            $this->setPrecioCosto( $o_MST_ListaPrecioDetalleLogBN->getPrecioCosto() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getPorcentajeUtilidad() ) )
        {
            $this->setPorcentajeUtilidad( $o_MST_ListaPrecioDetalleLogBN->getPorcentajeUtilidad() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getPrecioVenta() ) )
        {
            $this->setPrecioVenta( $o_MST_ListaPrecioDetalleLogBN->getPrecioVenta() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getMontoDescuento() ) )
        {
            $this->setMontoDescuento( $o_MST_ListaPrecioDetalleLogBN->getMontoDescuento() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getPorcentajeDescuento() ) )
        {
            $this->setPorcentajeDescuento( $o_MST_ListaPrecioDetalleLogBN->getPorcentajeDescuento() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getDescuentoFlag() ) )
        {
            $this->setDescuentoFlag( $o_MST_ListaPrecioDetalleLogBN->getDescuentoFlag() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ListaPrecioDetalleLogBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ListaPrecioDetalleLogBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ListaPrecioDetalleLogBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getFechaLog() ) )
        {
            $this->setFechaLog( $o_MST_ListaPrecioDetalleLogBN->getFechaLog() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getUsuarioLog() ) )
        {
            $this->setUsuarioLog( $o_MST_ListaPrecioDetalleLogBN->getUsuarioLog() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleLogBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ListaPrecioDetalleLogBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_ListaPrecioDetalleLogBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdLPDLog )
    {
        if( is_null( $i_IdLPDLog ) ){ $i_IdLPDLog = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ListaPrecioDetalleLog ";
        $s_SQLQuery .= "WHERE IdLPDLog = ".$i_IdLPDLog." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_ListaPrecioDetalleLogBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ListaPrecioDetalleLogBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ListaPrecioDetalleLogBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdLPDLog() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdLPDLog = ".$this->getIdLPDLog()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdTipoPrecio() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.IdTipoPrecio = '".$this->getIdTipoPrecio()."' AND ";
        if ( !is_null( $this->getFechaInicio() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaInicio = '".$this->getFechaInicio()."' AND ";
        if ( !is_null( $this->getFechaFin() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaFin = '".$this->getFechaFin()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getPrecioCosto() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.PrecioCosto = ".$this->getPrecioCosto()." AND ";
        if ( !is_null( $this->getPorcentajeUtilidad() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.PorcentajeUtilidad = ".$this->getPorcentajeUtilidad()." AND ";
        if ( !is_null( $this->getPrecioVenta() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.PrecioVenta = ".$this->getPrecioVenta()." AND ";
        if ( !is_null( $this->getMontoDescuento() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.MontoDescuento = ".$this->getMontoDescuento()." AND ";
        if ( !is_null( $this->getPorcentajeDescuento() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.PorcentajeDescuento = ".$this->getPorcentajeDescuento()." AND ";
        if ( !is_null( $this->getDescuentoFlag() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.DescuentoFlag = '".$this->getDescuentoFlag()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getFechaLog() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.FechaLog = '".$this->getFechaLog()."' AND ";
        if ( !is_null( $this->getUsuarioLog() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.UsuarioLog = '".$this->getUsuarioLog()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalleLog.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ListaPrecioDetalleLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ListaPrecioDetalleLogBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ListaPrecioDetalleLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_ListaPrecioDetalleLogBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ListaPrecioDetalleLogBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ListaPrecioDetalleLogBN[] = $o_MST_ListaPrecioDetalleLogBN;
            }
        }
        return $a_MST_ListaPrecioDetalleLogBN;
    }

    /* Devuelve un objeto MST_ListaPrecioDetalleLogBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ListaPrecioDetalleLog )
    {
        $o_MST_ListaPrecioDetalleLogBN = new MST_ListaPrecioDetalleLogBN();
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['IdLPDLog'] ) ) $o_MST_ListaPrecioDetalleLogBN->setIdLPDLog( ( integer ) $a_MST_ListaPrecioDetalleLog['IdLPDLog'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['IdCompania'] ) ) $o_MST_ListaPrecioDetalleLogBN->setIdCompania( ( integer ) $a_MST_ListaPrecioDetalleLog['IdCompania'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['IdSucursal'] ) ) $o_MST_ListaPrecioDetalleLogBN->setIdSucursal( ( integer ) $a_MST_ListaPrecioDetalleLog['IdSucursal'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['IdItem'] ) ) $o_MST_ListaPrecioDetalleLogBN->setIdItem( $a_MST_ListaPrecioDetalleLog['IdItem'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['IdTipoPrecio'] ) ) $o_MST_ListaPrecioDetalleLogBN->setIdTipoPrecio( $a_MST_ListaPrecioDetalleLog['IdTipoPrecio'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['FechaInicio'] ) ) $o_MST_ListaPrecioDetalleLogBN->setFechaInicio( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalleLog['FechaInicio'], "Y-m-d" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['FechaFin'] ) ) $o_MST_ListaPrecioDetalleLogBN->setFechaFin( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalleLog['FechaFin'], "Y-m-d" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['Estado'] ) ) $o_MST_ListaPrecioDetalleLogBN->setEstado( $a_MST_ListaPrecioDetalleLog['Estado'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['PrecioCosto'] ) ) $o_MST_ListaPrecioDetalleLogBN->setPrecioCosto( ( float ) $a_MST_ListaPrecioDetalleLog['PrecioCosto'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['PorcentajeUtilidad'] ) ) $o_MST_ListaPrecioDetalleLogBN->setPorcentajeUtilidad( ( float ) $a_MST_ListaPrecioDetalleLog['PorcentajeUtilidad'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['PrecioVenta'] ) ) $o_MST_ListaPrecioDetalleLogBN->setPrecioVenta( ( float ) $a_MST_ListaPrecioDetalleLog['PrecioVenta'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['MontoDescuento'] ) ) $o_MST_ListaPrecioDetalleLogBN->setMontoDescuento( ( float ) $a_MST_ListaPrecioDetalleLog['MontoDescuento'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['PorcentajeDescuento'] ) ) $o_MST_ListaPrecioDetalleLogBN->setPorcentajeDescuento( ( float ) $a_MST_ListaPrecioDetalleLog['PorcentajeDescuento'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['DescuentoFlag'] ) ) $o_MST_ListaPrecioDetalleLogBN->setDescuentoFlag( $a_MST_ListaPrecioDetalleLog['DescuentoFlag'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['FechaCreacion'] ) ) $o_MST_ListaPrecioDetalleLogBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalleLog['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['UsuarioCreacion'] ) ) $o_MST_ListaPrecioDetalleLogBN->setUsuarioCreacion( $a_MST_ListaPrecioDetalleLog['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['FechaModificacion'] ) ) $o_MST_ListaPrecioDetalleLogBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalleLog['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['FechaLog'] ) ) $o_MST_ListaPrecioDetalleLogBN->setFechaLog( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalleLog['FechaLog'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['UsuarioLog'] ) ) $o_MST_ListaPrecioDetalleLogBN->setUsuarioLog( $a_MST_ListaPrecioDetalleLog['UsuarioLog'] );
        if ( !is_null( $a_MST_ListaPrecioDetalleLog['UsuarioModificacion'] ) ) $o_MST_ListaPrecioDetalleLogBN->setUsuarioModificacion( $a_MST_ListaPrecioDetalleLog['UsuarioModificacion'] );
        return $o_MST_ListaPrecioDetalleLogBN;
    }
}
?>