<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ListaPrecioDetalle.xml */
/* Generado: 2021-12-19 18:48:56 */

/* Busqueda de registros de la tabla MST_ListaPrecioDetalle. */
abstract class BaseMST_ListaPrecioDetalleFN extends MST_ListaPrecioDetalleBN
{
    /* Declaracion de constantes */
    const IdListaPreciDet = "MST_ListaPrecioDetalle.IdListaPreciDet";
    const IdListaPreciCab = "MST_ListaPrecioDetalle.IdListaPreciCab";
    const IdCompania = "MST_ListaPrecioDetalle.IdCompania";
    const IdSucursal = "MST_ListaPrecioDetalle.IdSucursal";
    const IdItem = "MST_ListaPrecioDetalle.IdItem";
    const IdTipoLista = "MST_ListaPrecioDetalle.IdTipoLista";
    const IdRango = "MST_ListaPrecioDetalle.IdRango";
    const IdRangoDetalle = "MST_ListaPrecioDetalle.IdRangoDetalle";
    const IdTipoPrecio = "MST_ListaPrecioDetalle.IdTipoPrecio";
    const FechaInicio = "MST_ListaPrecioDetalle.FechaInicio";
    const FechaFin = "MST_ListaPrecioDetalle.FechaFin";
    const Estado = "MST_ListaPrecioDetalle.Estado";
    const PrecioCosto = "MST_ListaPrecioDetalle.PrecioCosto";
    const PrecioCostoIGV = "MST_ListaPrecioDetalle.PrecioCostoIGV";
    const PorcentajeUtilidad = "MST_ListaPrecioDetalle.PorcentajeUtilidad";
    const AfectoIGV = "MST_ListaPrecioDetalle.AfectoIGV";
    const PrecioVenta = "MST_ListaPrecioDetalle.PrecioVenta";
    const MontoIGV = "MST_ListaPrecioDetalle.MontoIGV";
    const PrecioVentaIGV = "MST_ListaPrecioDetalle.PrecioVentaIGV";
    const MontoDescuento = "MST_ListaPrecioDetalle.MontoDescuento";
    const PorcentajeDescuento = "MST_ListaPrecioDetalle.PorcentajeDescuento";
    const DescuentoFlag = "MST_ListaPrecioDetalle.DescuentoFlag";
    const FechaCreacion = "MST_ListaPrecioDetalle.FechaCreacion";
    const UsuarioCreacion = "MST_ListaPrecioDetalle.UsuarioCreacion";
    const FechaModificacion = "MST_ListaPrecioDetalle.FechaModificacion";
    const UsuarioModificacion = "MST_ListaPrecioDetalle.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ListaPrecioDetalle.IdListaPreciDet AS IdListaPreciDet, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.IdListaPreciCab AS IdListaPreciCab, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.IdTipoLista AS IdTipoLista, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.IdRango AS IdRango, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.IdRangoDetalle AS IdRangoDetalle, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.IdTipoPrecio AS IdTipoPrecio, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.FechaInicio AS FechaInicio, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.FechaFin AS FechaFin, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.PrecioCosto AS PrecioCosto, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.PrecioCostoIGV AS PrecioCostoIGV, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.PorcentajeUtilidad AS PorcentajeUtilidad, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.AfectoIGV AS AfectoIGV, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.PrecioVenta AS PrecioVenta, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.MontoIGV AS MontoIGV, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.PrecioVentaIGV AS PrecioVentaIGV, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.MontoDescuento AS MontoDescuento, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.PorcentajeDescuento AS PorcentajeDescuento, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.DescuentoFlag AS DescuentoFlag, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_ListaPrecioDetalle.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ListaPrecioDetalleBN */
    public function setByBN( MST_ListaPrecioDetalleBN $o_MST_ListaPrecioDetalleBN )
    {
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdListaPreciDet() ) )
        {
            $this->setIdListaPreciDet( $o_MST_ListaPrecioDetalleBN->getIdListaPreciDet() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdListaPreciCab() ) )
        {
            $this->setIdListaPreciCab( $o_MST_ListaPrecioDetalleBN->getIdListaPreciCab() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_ListaPrecioDetalleBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_ListaPrecioDetalleBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_MST_ListaPrecioDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdTipoLista() ) )
        {
            $this->setIdTipoLista( $o_MST_ListaPrecioDetalleBN->getIdTipoLista() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdRango() ) )
        {
            $this->setIdRango( $o_MST_ListaPrecioDetalleBN->getIdRango() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdRangoDetalle() ) )
        {
            $this->setIdRangoDetalle( $o_MST_ListaPrecioDetalleBN->getIdRangoDetalle() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getIdTipoPrecio() ) )
        {
            $this->setIdTipoPrecio( $o_MST_ListaPrecioDetalleBN->getIdTipoPrecio() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getFechaInicio() ) )
        {
            $this->setFechaInicio( $o_MST_ListaPrecioDetalleBN->getFechaInicio() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getFechaFin() ) )
        {
            $this->setFechaFin( $o_MST_ListaPrecioDetalleBN->getFechaFin() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ListaPrecioDetalleBN->getEstado() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getPrecioCosto() ) )
        {
            $this->setPrecioCosto( $o_MST_ListaPrecioDetalleBN->getPrecioCosto() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV() ) )
        {
            $this->setPrecioCostoIGV( $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getPorcentajeUtilidad() ) )
        {
            $this->setPorcentajeUtilidad( $o_MST_ListaPrecioDetalleBN->getPorcentajeUtilidad() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getAfectoIGV() ) )
        {
            $this->setAfectoIGV( $o_MST_ListaPrecioDetalleBN->getAfectoIGV() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() ) )
        {
            $this->setPrecioVenta( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getMontoIGV() ) )
        {
            $this->setMontoIGV( $o_MST_ListaPrecioDetalleBN->getMontoIGV() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV() ) )
        {
            $this->setPrecioVentaIGV( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getMontoDescuento() ) )
        {
            $this->setMontoDescuento( $o_MST_ListaPrecioDetalleBN->getMontoDescuento() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getPorcentajeDescuento() ) )
        {
            $this->setPorcentajeDescuento( $o_MST_ListaPrecioDetalleBN->getPorcentajeDescuento() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getDescuentoFlag() ) )
        {
            $this->setDescuentoFlag( $o_MST_ListaPrecioDetalleBN->getDescuentoFlag() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ListaPrecioDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ListaPrecioDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ListaPrecioDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ListaPrecioDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ListaPrecioDetalleBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_ListaPrecioDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdListaPreciDet )
    {
        if( is_null( $i_IdListaPreciDet ) ){ $i_IdListaPreciDet = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ListaPrecioDetalle ";
        $s_SQLQuery .= "WHERE IdListaPreciDet = ".$i_IdListaPreciDet." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_ListaPrecioDetalleBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ListaPrecioDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ListaPrecioDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdListaPreciDet() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdListaPreciDet = ".$this->getIdListaPreciDet()." AND ";
        if ( !is_null( $this->getIdListaPreciCab() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdListaPreciCab = ".$this->getIdListaPreciCab()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdTipoLista() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdTipoLista = ".$this->getIdTipoLista()." AND ";
        if ( !is_null( $this->getIdRango() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdRango = ".$this->getIdRango()." AND ";
        if ( !is_null( $this->getIdRangoDetalle() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdRangoDetalle = ".$this->getIdRangoDetalle()." AND ";
        if ( !is_null( $this->getIdTipoPrecio() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.IdTipoPrecio = '".$this->getIdTipoPrecio()."' AND ";
        if ( !is_null( $this->getFechaInicio() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.FechaInicio = '".$this->getFechaInicio()."' AND ";
        if ( !is_null( $this->getFechaFin() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.FechaFin = '".$this->getFechaFin()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getPrecioCosto() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.PrecioCosto = ".$this->getPrecioCosto()." AND ";
        if ( !is_null( $this->getPrecioCostoIGV() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.PrecioCostoIGV = ".$this->getPrecioCostoIGV()." AND ";
        if ( !is_null( $this->getPorcentajeUtilidad() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.PorcentajeUtilidad = ".$this->getPorcentajeUtilidad()." AND ";
        if ( !is_null( $this->getAfectoIGV() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.AfectoIGV = ".$this->getAfectoIGV()." AND ";
        if ( !is_null( $this->getPrecioVenta() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.PrecioVenta = ".$this->getPrecioVenta()." AND ";
        if ( !is_null( $this->getMontoIGV() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.MontoIGV = ".$this->getMontoIGV()." AND ";
        if ( !is_null( $this->getPrecioVentaIGV() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.PrecioVentaIGV = ".$this->getPrecioVentaIGV()." AND ";
        if ( !is_null( $this->getMontoDescuento() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.MontoDescuento = ".$this->getMontoDescuento()." AND ";
        if ( !is_null( $this->getPorcentajeDescuento() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.PorcentajeDescuento = ".$this->getPorcentajeDescuento()." AND ";
        if ( !is_null( $this->getDescuentoFlag() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.DescuentoFlag = '".$this->getDescuentoFlag()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ListaPrecioDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ListaPrecioDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ListaPrecioDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ListaPrecioDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_ListaPrecioDetalleBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ListaPrecioDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ListaPrecioDetalleBN[] = $o_MST_ListaPrecioDetalleBN;
            }
        }
        return $a_MST_ListaPrecioDetalleBN;
    }

    /* Devuelve un objeto MST_ListaPrecioDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ListaPrecioDetalle )
    {
        $o_MST_ListaPrecioDetalleBN = new MST_ListaPrecioDetalleBN();
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdListaPreciDet'] ) ) $o_MST_ListaPrecioDetalleBN->setIdListaPreciDet( ( integer ) $a_MST_ListaPrecioDetalle['IdListaPreciDet'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdListaPreciCab'] ) ) $o_MST_ListaPrecioDetalleBN->setIdListaPreciCab( ( integer ) $a_MST_ListaPrecioDetalle['IdListaPreciCab'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdCompania'] ) ) $o_MST_ListaPrecioDetalleBN->setIdCompania( ( integer ) $a_MST_ListaPrecioDetalle['IdCompania'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdSucursal'] ) ) $o_MST_ListaPrecioDetalleBN->setIdSucursal( ( integer ) $a_MST_ListaPrecioDetalle['IdSucursal'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdItem'] ) ) $o_MST_ListaPrecioDetalleBN->setIdItem( $a_MST_ListaPrecioDetalle['IdItem'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdTipoLista'] ) ) $o_MST_ListaPrecioDetalleBN->setIdTipoLista( ( integer ) $a_MST_ListaPrecioDetalle['IdTipoLista'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdRango'] ) ) $o_MST_ListaPrecioDetalleBN->setIdRango( ( integer ) $a_MST_ListaPrecioDetalle['IdRango'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdRangoDetalle'] ) ) $o_MST_ListaPrecioDetalleBN->setIdRangoDetalle( ( integer ) $a_MST_ListaPrecioDetalle['IdRangoDetalle'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['IdTipoPrecio'] ) ) $o_MST_ListaPrecioDetalleBN->setIdTipoPrecio( $a_MST_ListaPrecioDetalle['IdTipoPrecio'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['FechaInicio'] ) ) $o_MST_ListaPrecioDetalleBN->setFechaInicio( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalle['FechaInicio'], "Y-m-d" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalle['FechaFin'] ) ) $o_MST_ListaPrecioDetalleBN->setFechaFin( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalle['FechaFin'], "Y-m-d" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalle['Estado'] ) ) $o_MST_ListaPrecioDetalleBN->setEstado( $a_MST_ListaPrecioDetalle['Estado'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['PrecioCosto'] ) ) $o_MST_ListaPrecioDetalleBN->setPrecioCosto( ( float ) $a_MST_ListaPrecioDetalle['PrecioCosto'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['PrecioCostoIGV'] ) ) $o_MST_ListaPrecioDetalleBN->setPrecioCostoIGV( ( float ) $a_MST_ListaPrecioDetalle['PrecioCostoIGV'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['PorcentajeUtilidad'] ) ) $o_MST_ListaPrecioDetalleBN->setPorcentajeUtilidad( ( float ) $a_MST_ListaPrecioDetalle['PorcentajeUtilidad'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['AfectoIGV'] ) ) $o_MST_ListaPrecioDetalleBN->setAfectoIGV( ( integer ) $a_MST_ListaPrecioDetalle['AfectoIGV'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['PrecioVenta'] ) ) $o_MST_ListaPrecioDetalleBN->setPrecioVenta( ( float ) $a_MST_ListaPrecioDetalle['PrecioVenta'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['MontoIGV'] ) ) $o_MST_ListaPrecioDetalleBN->setMontoIGV( ( float ) $a_MST_ListaPrecioDetalle['MontoIGV'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['PrecioVentaIGV'] ) ) $o_MST_ListaPrecioDetalleBN->setPrecioVentaIGV( ( float ) $a_MST_ListaPrecioDetalle['PrecioVentaIGV'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['MontoDescuento'] ) ) $o_MST_ListaPrecioDetalleBN->setMontoDescuento( ( float ) $a_MST_ListaPrecioDetalle['MontoDescuento'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['PorcentajeDescuento'] ) ) $o_MST_ListaPrecioDetalleBN->setPorcentajeDescuento( ( float ) $a_MST_ListaPrecioDetalle['PorcentajeDescuento'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['DescuentoFlag'] ) ) $o_MST_ListaPrecioDetalleBN->setDescuentoFlag( $a_MST_ListaPrecioDetalle['DescuentoFlag'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['FechaCreacion'] ) ) $o_MST_ListaPrecioDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalle['UsuarioCreacion'] ) ) $o_MST_ListaPrecioDetalleBN->setUsuarioCreacion( $a_MST_ListaPrecioDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ListaPrecioDetalle['FechaModificacion'] ) ) $o_MST_ListaPrecioDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ListaPrecioDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ListaPrecioDetalle['UsuarioModificacion'] ) ) $o_MST_ListaPrecioDetalleBN->setUsuarioModificacion( $a_MST_ListaPrecioDetalle['UsuarioModificacion'] );
        return $o_MST_ListaPrecioDetalleBN;
    }
}
?>