<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemProcedencia.xml */
/* Generado: 2021-06-25 23:59:50 */

/* Busqueda de registros de la tabla MST_ItemProcedencia. */
abstract class BaseMST_ItemProcedenciaFN extends MST_ItemProcedenciaBN
{
    /* Declaracion de constantes */
    const IdProcedencia = "MST_ItemProcedencia.IdProcedencia";
    const Descripcion = "MST_ItemProcedencia.Descripcion";
    const Estado = "MST_ItemProcedencia.Estado";
    const FechaCreacion = "MST_ItemProcedencia.FechaCreacion";
    const UsuarioCreacion = "MST_ItemProcedencia.UsuarioCreacion";
    const FechaModificacion = "MST_ItemProcedencia.FechaModificacion";
    const UsuarioModificacion = "MST_ItemProcedencia.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ItemProcedencia.IdProcedencia AS IdProcedencia, ";
        $s_SQLQuery .= "MST_ItemProcedencia.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_ItemProcedencia.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ItemProcedencia.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ItemProcedencia.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ItemProcedencia.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_ItemProcedencia.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ItemProcedenciaBN */
    public function setByBN( MST_ItemProcedenciaBN $o_MST_ItemProcedenciaBN )
    {
        if ( !is_null( $o_MST_ItemProcedenciaBN->getIdProcedencia() ) )
        {
            $this->setIdProcedencia( $o_MST_ItemProcedenciaBN->getIdProcedencia() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ItemProcedenciaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ItemProcedenciaBN->getEstado() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ItemProcedenciaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ItemProcedenciaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ItemProcedenciaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ItemProcedenciaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ItemProcedenciaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_ItemProcedenciaBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdProcedencia )
    {
        if( is_null( $s_IdProcedencia ) ){ $s_IdProcedencia = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ItemProcedencia ";
        $s_SQLQuery .= "WHERE IdProcedencia = '".$s_IdProcedencia."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_ItemProcedenciaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ItemProcedenciaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ItemProcedenciaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdProcedencia() ) ) $s_SQLQuery .= "MST_ItemProcedencia.IdProcedencia = '".$this->getIdProcedencia()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_ItemProcedencia.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ItemProcedencia.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ItemProcedencia.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ItemProcedencia.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ItemProcedencia.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ItemProcedencia.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ItemProcedencia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ItemProcedenciaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ItemProcedencia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_ItemProcedenciaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ItemProcedenciaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ItemProcedenciaBN[] = $o_MST_ItemProcedenciaBN;
            }
        }
        return $a_MST_ItemProcedenciaBN;
    }

    /* Devuelve un objeto MST_ItemProcedenciaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ItemProcedencia )
    {
        $o_MST_ItemProcedenciaBN = new MST_ItemProcedenciaBN();
        if ( !is_null( $a_MST_ItemProcedencia['IdProcedencia'] ) ) $o_MST_ItemProcedenciaBN->setIdProcedencia( $a_MST_ItemProcedencia['IdProcedencia'] );
        if ( !is_null( $a_MST_ItemProcedencia['Descripcion'] ) ) $o_MST_ItemProcedenciaBN->setDescripcion( $a_MST_ItemProcedencia['Descripcion'] );
        if ( !is_null( $a_MST_ItemProcedencia['Estado'] ) ) $o_MST_ItemProcedenciaBN->setEstado( $a_MST_ItemProcedencia['Estado'] );
        if ( !is_null( $a_MST_ItemProcedencia['FechaCreacion'] ) ) $o_MST_ItemProcedenciaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ItemProcedencia['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ItemProcedencia['UsuarioCreacion'] ) ) $o_MST_ItemProcedenciaBN->setUsuarioCreacion( $a_MST_ItemProcedencia['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ItemProcedencia['FechaModificacion'] ) ) $o_MST_ItemProcedenciaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ItemProcedencia['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ItemProcedencia['UsuarioModificacion'] ) ) $o_MST_ItemProcedenciaBN->setUsuarioModificacion( $a_MST_ItemProcedencia['UsuarioModificacion'] );
        return $o_MST_ItemProcedenciaBN;
    }
}
?>