<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemFiscal.xml */
/* Generado: 2021-06-25 23:59:50 */

/* Busqueda de registros de la tabla MST_ItemFiscal. */
abstract class BaseMST_ItemFiscalFN extends MST_ItemFiscalBN
{
    /* Declaracion de constantes */
    const IdItemFiscal = "MST_ItemFiscal.IdItemFiscal";
    const Descripcion = "MST_ItemFiscal.Descripcion";
    const CodigoFiscal = "MST_ItemFiscal.CodigoFiscal";
    const Estado = "MST_ItemFiscal.Estado";
    const FechaCreacion = "MST_ItemFiscal.FechaCreacion";
    const UsuarioCreacion = "MST_ItemFiscal.UsuarioCreacion";
    const UsuarioModificacion = "MST_ItemFiscal.UsuarioModificacion";
    const FechaModificacion = "MST_ItemFiscal.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ItemFiscal.IdItemFiscal AS IdItemFiscal, ";
        $s_SQLQuery .= "MST_ItemFiscal.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_ItemFiscal.CodigoFiscal AS CodigoFiscal, ";
        $s_SQLQuery .= "MST_ItemFiscal.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ItemFiscal.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ItemFiscal.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ItemFiscal.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_ItemFiscal.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ItemFiscalBN */
    public function setByBN( MST_ItemFiscalBN $o_MST_ItemFiscalBN )
    {
        if ( !is_null( $o_MST_ItemFiscalBN->getIdItemFiscal() ) )
        {
            $this->setIdItemFiscal( $o_MST_ItemFiscalBN->getIdItemFiscal() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ItemFiscalBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getCodigoFiscal() ) )
        {
            $this->setCodigoFiscal( $o_MST_ItemFiscalBN->getCodigoFiscal() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ItemFiscalBN->getEstado() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ItemFiscalBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ItemFiscalBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ItemFiscalBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ItemFiscalBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ItemFiscalBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_ItemFiscalBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdItemFiscal )
    {
        if( is_null( $i_IdItemFiscal ) ){ $i_IdItemFiscal = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ItemFiscal ";
        $s_SQLQuery .= "WHERE IdItemFiscal = ".$i_IdItemFiscal." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_ItemFiscalBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ItemFiscalBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ItemFiscalBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdItemFiscal() ) ) $s_SQLQuery .= "MST_ItemFiscal.IdItemFiscal = ".$this->getIdItemFiscal()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_ItemFiscal.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigoFiscal() ) ) $s_SQLQuery .= "MST_ItemFiscal.CodigoFiscal = '".$this->getCodigoFiscal()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ItemFiscal.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ItemFiscal.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ItemFiscal.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ItemFiscal.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ItemFiscal.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ItemFiscal WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ItemFiscalBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ItemFiscal WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_ItemFiscalBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ItemFiscalBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ItemFiscalBN[] = $o_MST_ItemFiscalBN;
            }
        }
        return $a_MST_ItemFiscalBN;
    }

    /* Devuelve un objeto MST_ItemFiscalBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ItemFiscal )
    {
        $o_MST_ItemFiscalBN = new MST_ItemFiscalBN();
        if ( !is_null( $a_MST_ItemFiscal['IdItemFiscal'] ) ) $o_MST_ItemFiscalBN->setIdItemFiscal( ( integer ) $a_MST_ItemFiscal['IdItemFiscal'] );
        if ( !is_null( $a_MST_ItemFiscal['Descripcion'] ) ) $o_MST_ItemFiscalBN->setDescripcion( $a_MST_ItemFiscal['Descripcion'] );
        if ( !is_null( $a_MST_ItemFiscal['CodigoFiscal'] ) ) $o_MST_ItemFiscalBN->setCodigoFiscal( $a_MST_ItemFiscal['CodigoFiscal'] );
        if ( !is_null( $a_MST_ItemFiscal['Estado'] ) ) $o_MST_ItemFiscalBN->setEstado( $a_MST_ItemFiscal['Estado'] );
        if ( !is_null( $a_MST_ItemFiscal['FechaCreacion'] ) ) $o_MST_ItemFiscalBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ItemFiscal['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ItemFiscal['UsuarioCreacion'] ) ) $o_MST_ItemFiscalBN->setUsuarioCreacion( $a_MST_ItemFiscal['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ItemFiscal['UsuarioModificacion'] ) ) $o_MST_ItemFiscalBN->setUsuarioModificacion( $a_MST_ItemFiscal['UsuarioModificacion'] );
        if ( !is_null( $a_MST_ItemFiscal['FechaModificacion'] ) ) $o_MST_ItemFiscalBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ItemFiscal['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_ItemFiscalBN;
    }
}
?>