<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Division.xml */
/* Generado: 2021-06-25 23:59:50 */

/* Busqueda de registros de la tabla MST_Division. */
abstract class BaseMST_DivisionFN extends MST_DivisionBN
{
    /* Declaracion de constantes */
    const DivisionId = "MST_Division.DivisionId";
    const DivisionDescripcion = "MST_Division.DivisionDescripcion";
    const DivisionEstado = "MST_Division.DivisionEstado";
    const UsuarioCreacion = "MST_Division.UsuarioCreacion";
    const FechaCreacion = "MST_Division.FechaCreacion";
    const UsuarioModificacion = "MST_Division.UsuarioModificacion";
    const FechaModificacion = "MST_Division.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Division.DivisionId AS DivisionId, ";
        $s_SQLQuery .= "MST_Division.DivisionDescripcion AS DivisionDescripcion, ";
        $s_SQLQuery .= "MST_Division.DivisionEstado AS DivisionEstado, ";
        $s_SQLQuery .= "MST_Division.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Division.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Division.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_Division.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_DivisionBN */
    public function setByBN( MST_DivisionBN $o_MST_DivisionBN )
    {
        if ( !is_null( $o_MST_DivisionBN->getDivisionId() ) )
        {
            $this->setDivisionId( $o_MST_DivisionBN->getDivisionId() );
        }
        if ( !is_null( $o_MST_DivisionBN->getDivisionDescripcion() ) )
        {
            $this->setDivisionDescripcion( $o_MST_DivisionBN->getDivisionDescripcion() );
        }
        if ( !is_null( $o_MST_DivisionBN->getDivisionEstado() ) )
        {
            $this->setDivisionEstado( $o_MST_DivisionBN->getDivisionEstado() );
        }
        if ( !is_null( $o_MST_DivisionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_DivisionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_DivisionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_DivisionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_DivisionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_DivisionBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_DivisionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_DivisionBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_DivisionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_DivisionId )
    {
        if( is_null( $i_DivisionId ) ){ $i_DivisionId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Division ";
        $s_SQLQuery .= "WHERE DivisionId = ".$i_DivisionId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_DivisionBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_DivisionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_DivisionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getDivisionId() ) ) $s_SQLQuery .= "MST_Division.DivisionId = ".$this->getDivisionId()." AND ";
        if ( !is_null( $this->getDivisionDescripcion() ) ) $s_SQLQuery .= "MST_Division.DivisionDescripcion = '".$this->getDivisionDescripcion()."' AND ";
        if ( !is_null( $this->getDivisionEstado() ) ) $s_SQLQuery .= "MST_Division.DivisionEstado = '".$this->getDivisionEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Division.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Division.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Division.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Division.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Division WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_DivisionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Division WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_DivisionBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_DivisionBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_DivisionBN[] = $o_MST_DivisionBN;
            }
        }
        return $a_MST_DivisionBN;
    }

    /* Devuelve un objeto MST_DivisionBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Division )
    {
        $o_MST_DivisionBN = new MST_DivisionBN();
        if ( !is_null( $a_MST_Division['DivisionId'] ) ) $o_MST_DivisionBN->setDivisionId( ( integer ) $a_MST_Division['DivisionId'] );
        if ( !is_null( $a_MST_Division['DivisionDescripcion'] ) ) $o_MST_DivisionBN->setDivisionDescripcion( $a_MST_Division['DivisionDescripcion'] );
        if ( !is_null( $a_MST_Division['DivisionEstado'] ) ) $o_MST_DivisionBN->setDivisionEstado( $a_MST_Division['DivisionEstado'] );
        if ( !is_null( $a_MST_Division['UsuarioCreacion'] ) ) $o_MST_DivisionBN->setUsuarioCreacion( $a_MST_Division['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Division['FechaCreacion'] ) ) $o_MST_DivisionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Division['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Division['UsuarioModificacion'] ) ) $o_MST_DivisionBN->setUsuarioModificacion( $a_MST_Division['UsuarioModificacion'] );
        if ( !is_null( $a_MST_Division['FechaModificacion'] ) ) $o_MST_DivisionBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Division['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_DivisionBN;
    }
}
?>