<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_DiaSemana.xml */
/* Generado: 2021-06-25 23:59:50 */

/* Busqueda de registros de la tabla MST_DiaSemana. */
abstract class BaseMST_DiaSemanaFN extends MST_DiaSemanaBN
{
    /* Declaracion de constantes */
    const IdDiaSem = "MST_DiaSemana.IdDiaSem";
    const Prefijo = "MST_DiaSemana.Prefijo";
    const Nombre = "MST_DiaSemana.Nombre";
    const DiaNumero = "MST_DiaSemana.DiaNumero";
    const EsFeriadoFlag = "MST_DiaSemana.EsFeriadoFlag";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_DiaSemana.IdDiaSem AS IdDiaSem, ";
        $s_SQLQuery .= "MST_DiaSemana.Prefijo AS Prefijo, ";
        $s_SQLQuery .= "MST_DiaSemana.Nombre AS Nombre, ";
        $s_SQLQuery .= "MST_DiaSemana.DiaNumero AS DiaNumero, ";
        $s_SQLQuery .= "MST_DiaSemana.EsFeriadoFlag AS EsFeriadoFlag ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_DiaSemanaBN */
    public function setByBN( MST_DiaSemanaBN $o_MST_DiaSemanaBN )
    {
        if ( !is_null( $o_MST_DiaSemanaBN->getIdDiaSem() ) )
        {
            $this->setIdDiaSem( $o_MST_DiaSemanaBN->getIdDiaSem() );
        }
        if ( !is_null( $o_MST_DiaSemanaBN->getPrefijo() ) )
        {
            $this->setPrefijo( $o_MST_DiaSemanaBN->getPrefijo() );
        }
        if ( !is_null( $o_MST_DiaSemanaBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_DiaSemanaBN->getNombre() );
        }
        if ( !is_null( $o_MST_DiaSemanaBN->getDiaNumero() ) )
        {
            $this->setDiaNumero( $o_MST_DiaSemanaBN->getDiaNumero() );
        }
        if ( !is_null( $o_MST_DiaSemanaBN->getEsFeriadoFlag() ) )
        {
            $this->setEsFeriadoFlag( $o_MST_DiaSemanaBN->getEsFeriadoFlag() );
        }
    }

    /**
    * @return MST_DiaSemanaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdDiaSem )
    {
        if( is_null( $i_IdDiaSem ) ){ $i_IdDiaSem = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_DiaSemana ";
        $s_SQLQuery .= "WHERE IdDiaSem = ".$i_IdDiaSem." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_DiaSemanaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_DiaSemanaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_DiaSemanaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdDiaSem() ) ) $s_SQLQuery .= "MST_DiaSemana.IdDiaSem = ".$this->getIdDiaSem()." AND ";
        if ( !is_null( $this->getPrefijo() ) ) $s_SQLQuery .= "MST_DiaSemana.Prefijo = '".$this->getPrefijo()."' AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "MST_DiaSemana.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getDiaNumero() ) ) $s_SQLQuery .= "MST_DiaSemana.DiaNumero = ".$this->getDiaNumero()." AND ";
        if ( !is_null( $this->getEsFeriadoFlag() ) ) $s_SQLQuery .= "MST_DiaSemana.EsFeriadoFlag = '".$this->getEsFeriadoFlag()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_DiaSemana WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_DiaSemanaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_DiaSemana WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_DiaSemanaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_DiaSemanaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_DiaSemanaBN[] = $o_MST_DiaSemanaBN;
            }
        }
        return $a_MST_DiaSemanaBN;
    }

    /* Devuelve un objeto MST_DiaSemanaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_DiaSemana )
    {
        $o_MST_DiaSemanaBN = new MST_DiaSemanaBN();
        if ( !is_null( $a_MST_DiaSemana['IdDiaSem'] ) ) $o_MST_DiaSemanaBN->setIdDiaSem( ( integer ) $a_MST_DiaSemana['IdDiaSem'] );
        if ( !is_null( $a_MST_DiaSemana['Prefijo'] ) ) $o_MST_DiaSemanaBN->setPrefijo( $a_MST_DiaSemana['Prefijo'] );
        if ( !is_null( $a_MST_DiaSemana['Nombre'] ) ) $o_MST_DiaSemanaBN->setNombre( $a_MST_DiaSemana['Nombre'] );
        if ( !is_null( $a_MST_DiaSemana['DiaNumero'] ) ) $o_MST_DiaSemanaBN->setDiaNumero( ( integer ) $a_MST_DiaSemana['DiaNumero'] );
        if ( !is_null( $a_MST_DiaSemana['EsFeriadoFlag'] ) ) $o_MST_DiaSemanaBN->setEsFeriadoFlag( $a_MST_DiaSemana['EsFeriadoFlag'] );
        return $o_MST_DiaSemanaBN;
    }
}
?>