<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_CuentaBancaria.xml */
/* Generado: 2021-06-25 23:59:49 */

/* Busqueda de registros de la tabla MST_CuentaBancaria. */
abstract class BaseMST_CuentaBancariaFN extends MST_CuentaBancariaBN
{
    /* Declaracion de constantes */
    const IdCuenta = "MST_CuentaBancaria.IdCuenta";
    const IdBanco = "MST_CuentaBancaria.IdBanco";
    const NumeroCuenta = "MST_CuentaBancaria.NumeroCuenta";
    const NumeroCuentaCCI = "MST_CuentaBancaria.NumeroCuentaCCI";
    const IdMoneda = "MST_CuentaBancaria.IdMoneda";
    const NombreMoneda = "MST_CuentaBancaria.NombreMoneda";
    const FlagDetraccion = "MST_CuentaBancaria.FlagDetraccion";
    const IdUbigeo = "MST_CuentaBancaria.IdUbigeo";
    const NombreSucursal = "MST_CuentaBancaria.NombreSucursal";
    const DescripcionCuenta = "MST_CuentaBancaria.DescripcionCuenta";
    const NumeroCuentaCorto = "MST_CuentaBancaria.NumeroCuentaCorto";
    const CodigoSunat = "MST_CuentaBancaria.CodigoSunat";
    const FlagMostrarCuenta = "MST_CuentaBancaria.FlagMostrarCuenta";
    const Estado = "MST_CuentaBancaria.Estado";
    const FechaCreacion = "MST_CuentaBancaria.FechaCreacion";
    const UsuarioCreacion = "MST_CuentaBancaria.UsuarioCreacion";
    const FechaModificacion = "MST_CuentaBancaria.FechaModificacion";
    const UsuarioModificacion = "MST_CuentaBancaria.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_CuentaBancaria.IdCuenta AS IdCuenta, ";
        $s_SQLQuery .= "MST_CuentaBancaria.IdBanco AS IdBanco, ";
        $s_SQLQuery .= "MST_CuentaBancaria.NumeroCuenta AS NumeroCuenta, ";
        $s_SQLQuery .= "MST_CuentaBancaria.NumeroCuentaCCI AS NumeroCuentaCCI, ";
        $s_SQLQuery .= "MST_CuentaBancaria.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "MST_CuentaBancaria.NombreMoneda AS NombreMoneda, ";
        $s_SQLQuery .= "MST_CuentaBancaria.FlagDetraccion AS FlagDetraccion, ";
        $s_SQLQuery .= "MST_CuentaBancaria.IdUbigeo AS IdUbigeo, ";
        $s_SQLQuery .= "MST_CuentaBancaria.NombreSucursal AS NombreSucursal, ";
        $s_SQLQuery .= "MST_CuentaBancaria.DescripcionCuenta AS DescripcionCuenta, ";
        $s_SQLQuery .= "MST_CuentaBancaria.NumeroCuentaCorto AS NumeroCuentaCorto, ";
        $s_SQLQuery .= "MST_CuentaBancaria.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "MST_CuentaBancaria.FlagMostrarCuenta AS FlagMostrarCuenta, ";
        $s_SQLQuery .= "MST_CuentaBancaria.Estado AS Estado, ";
        $s_SQLQuery .= "MST_CuentaBancaria.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_CuentaBancaria.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_CuentaBancaria.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_CuentaBancaria.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_CuentaBancariaBN */
    public function setByBN( MST_CuentaBancariaBN $o_MST_CuentaBancariaBN )
    {
        if ( !is_null( $o_MST_CuentaBancariaBN->getIdCuenta() ) )
        {
            $this->setIdCuenta( $o_MST_CuentaBancariaBN->getIdCuenta() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getIdBanco() ) )
        {
            $this->setIdBanco( $o_MST_CuentaBancariaBN->getIdBanco() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getNumeroCuenta() ) )
        {
            $this->setNumeroCuenta( $o_MST_CuentaBancariaBN->getNumeroCuenta() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getNumeroCuentaCCI() ) )
        {
            $this->setNumeroCuentaCCI( $o_MST_CuentaBancariaBN->getNumeroCuentaCCI() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_MST_CuentaBancariaBN->getIdMoneda() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getNombreMoneda() ) )
        {
            $this->setNombreMoneda( $o_MST_CuentaBancariaBN->getNombreMoneda() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getFlagDetraccion() ) )
        {
            $this->setFlagDetraccion( $o_MST_CuentaBancariaBN->getFlagDetraccion() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getIdUbigeo() ) )
        {
            $this->setIdUbigeo( $o_MST_CuentaBancariaBN->getIdUbigeo() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getNombreSucursal() ) )
        {
            $this->setNombreSucursal( $o_MST_CuentaBancariaBN->getNombreSucursal() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getDescripcionCuenta() ) )
        {
            $this->setDescripcionCuenta( $o_MST_CuentaBancariaBN->getDescripcionCuenta() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getNumeroCuentaCorto() ) )
        {
            $this->setNumeroCuentaCorto( $o_MST_CuentaBancariaBN->getNumeroCuentaCorto() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_MST_CuentaBancariaBN->getCodigoSunat() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getFlagMostrarCuenta() ) )
        {
            $this->setFlagMostrarCuenta( $o_MST_CuentaBancariaBN->getFlagMostrarCuenta() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_CuentaBancariaBN->getEstado() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_CuentaBancariaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_CuentaBancariaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_CuentaBancariaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_CuentaBancariaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_CuentaBancariaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_CuentaBancariaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCuenta )
    {
        if( is_null( $i_IdCuenta ) ){ $i_IdCuenta = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CuentaBancaria ";
        $s_SQLQuery .= "WHERE IdCuenta = ".$i_IdCuenta." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_CuentaBancariaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_CuentaBancariaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_CuentaBancariaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCuenta() ) ) $s_SQLQuery .= "MST_CuentaBancaria.IdCuenta = ".$this->getIdCuenta()." AND ";
        if ( !is_null( $this->getIdBanco() ) ) $s_SQLQuery .= "MST_CuentaBancaria.IdBanco = ".$this->getIdBanco()." AND ";
        if ( !is_null( $this->getNumeroCuenta() ) ) $s_SQLQuery .= "MST_CuentaBancaria.NumeroCuenta = '".$this->getNumeroCuenta()."' AND ";
        if ( !is_null( $this->getNumeroCuentaCCI() ) ) $s_SQLQuery .= "MST_CuentaBancaria.NumeroCuentaCCI = '".$this->getNumeroCuentaCCI()."' AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "MST_CuentaBancaria.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getNombreMoneda() ) ) $s_SQLQuery .= "MST_CuentaBancaria.NombreMoneda = '".$this->getNombreMoneda()."' AND ";
        if ( !is_null( $this->getFlagDetraccion() ) ) $s_SQLQuery .= "MST_CuentaBancaria.FlagDetraccion = ".$this->getFlagDetraccion()." AND ";
        if ( !is_null( $this->getIdUbigeo() ) ) $s_SQLQuery .= "MST_CuentaBancaria.IdUbigeo = '".$this->getIdUbigeo()."' AND ";
        if ( !is_null( $this->getNombreSucursal() ) ) $s_SQLQuery .= "MST_CuentaBancaria.NombreSucursal = '".$this->getNombreSucursal()."' AND ";
        if ( !is_null( $this->getDescripcionCuenta() ) ) $s_SQLQuery .= "MST_CuentaBancaria.DescripcionCuenta = '".$this->getDescripcionCuenta()."' AND ";
        if ( !is_null( $this->getNumeroCuentaCorto() ) ) $s_SQLQuery .= "MST_CuentaBancaria.NumeroCuentaCorto = '".$this->getNumeroCuentaCorto()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "MST_CuentaBancaria.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getFlagMostrarCuenta() ) ) $s_SQLQuery .= "MST_CuentaBancaria.FlagMostrarCuenta = ".$this->getFlagMostrarCuenta()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_CuentaBancaria.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_CuentaBancaria.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_CuentaBancaria.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_CuentaBancaria.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_CuentaBancaria.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_CuentaBancaria WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_CuentaBancariaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CuentaBancaria WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_CuentaBancariaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_CuentaBancariaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_CuentaBancariaBN[] = $o_MST_CuentaBancariaBN;
            }
        }
        return $a_MST_CuentaBancariaBN;
    }

    /* Devuelve un objeto MST_CuentaBancariaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_CuentaBancaria )
    {
        $o_MST_CuentaBancariaBN = new MST_CuentaBancariaBN();
        if ( !is_null( $a_MST_CuentaBancaria['IdCuenta'] ) ) $o_MST_CuentaBancariaBN->setIdCuenta( ( integer ) $a_MST_CuentaBancaria['IdCuenta'] );
        if ( !is_null( $a_MST_CuentaBancaria['IdBanco'] ) ) $o_MST_CuentaBancariaBN->setIdBanco( ( integer ) $a_MST_CuentaBancaria['IdBanco'] );
        if ( !is_null( $a_MST_CuentaBancaria['NumeroCuenta'] ) ) $o_MST_CuentaBancariaBN->setNumeroCuenta( $a_MST_CuentaBancaria['NumeroCuenta'] );
        if ( !is_null( $a_MST_CuentaBancaria['NumeroCuentaCCI'] ) ) $o_MST_CuentaBancariaBN->setNumeroCuentaCCI( $a_MST_CuentaBancaria['NumeroCuentaCCI'] );
        if ( !is_null( $a_MST_CuentaBancaria['IdMoneda'] ) ) $o_MST_CuentaBancariaBN->setIdMoneda( $a_MST_CuentaBancaria['IdMoneda'] );
        if ( !is_null( $a_MST_CuentaBancaria['NombreMoneda'] ) ) $o_MST_CuentaBancariaBN->setNombreMoneda( $a_MST_CuentaBancaria['NombreMoneda'] );
        if ( !is_null( $a_MST_CuentaBancaria['FlagDetraccion'] ) ) $o_MST_CuentaBancariaBN->setFlagDetraccion( ( integer ) $a_MST_CuentaBancaria['FlagDetraccion'] );
        if ( !is_null( $a_MST_CuentaBancaria['IdUbigeo'] ) ) $o_MST_CuentaBancariaBN->setIdUbigeo( $a_MST_CuentaBancaria['IdUbigeo'] );
        if ( !is_null( $a_MST_CuentaBancaria['NombreSucursal'] ) ) $o_MST_CuentaBancariaBN->setNombreSucursal( $a_MST_CuentaBancaria['NombreSucursal'] );
        if ( !is_null( $a_MST_CuentaBancaria['DescripcionCuenta'] ) ) $o_MST_CuentaBancariaBN->setDescripcionCuenta( $a_MST_CuentaBancaria['DescripcionCuenta'] );
        if ( !is_null( $a_MST_CuentaBancaria['NumeroCuentaCorto'] ) ) $o_MST_CuentaBancariaBN->setNumeroCuentaCorto( $a_MST_CuentaBancaria['NumeroCuentaCorto'] );
        if ( !is_null( $a_MST_CuentaBancaria['CodigoSunat'] ) ) $o_MST_CuentaBancariaBN->setCodigoSunat( $a_MST_CuentaBancaria['CodigoSunat'] );
        if ( !is_null( $a_MST_CuentaBancaria['FlagMostrarCuenta'] ) ) $o_MST_CuentaBancariaBN->setFlagMostrarCuenta( ( integer ) $a_MST_CuentaBancaria['FlagMostrarCuenta'] );
        if ( !is_null( $a_MST_CuentaBancaria['Estado'] ) ) $o_MST_CuentaBancariaBN->setEstado( $a_MST_CuentaBancaria['Estado'] );
        if ( !is_null( $a_MST_CuentaBancaria['FechaCreacion'] ) ) $o_MST_CuentaBancariaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_CuentaBancaria['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_CuentaBancaria['UsuarioCreacion'] ) ) $o_MST_CuentaBancariaBN->setUsuarioCreacion( $a_MST_CuentaBancaria['UsuarioCreacion'] );
        if ( !is_null( $a_MST_CuentaBancaria['FechaModificacion'] ) ) $o_MST_CuentaBancariaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_CuentaBancaria['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_CuentaBancaria['UsuarioModificacion'] ) ) $o_MST_CuentaBancariaBN->setUsuarioModificacion( $a_MST_CuentaBancaria['UsuarioModificacion'] );
        return $o_MST_CuentaBancariaBN;
    }
}
?>