<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Color.xml */
/* Generado: 2024-07-06 04:27:46 */

/* Busqueda de registros de la tabla MST_Color. */
abstract class BaseMST_ColorFN extends MST_ColorBN
{
    /* Declaracion de constantes */
    const IdColor = "MST_Color.IdColor";
    const IdProveedor = "MST_Color.IdProveedor";
    const Codigo = "MST_Color.Codigo";
    const Descripcion = "MST_Color.Descripcion";
    const Estado = "MST_Color.Estado";
    const UsuarioCreacion = "MST_Color.UsuarioCreacion";
    const FechaCreacion = "MST_Color.FechaCreacion";
    const UsuarioModificacion = "MST_Color.UsuarioModificacion";
    const FechaModificacion = "MST_Color.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Color.IdColor AS IdColor, ";
        $s_SQLQuery .= "MST_Color.IdProveedor AS IdProveedor, ";
        $s_SQLQuery .= "MST_Color.Codigo AS Codigo, ";
        $s_SQLQuery .= "MST_Color.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Color.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Color.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Color.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Color.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_Color.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ColorBN */
    public function setByBN( MST_ColorBN $o_MST_ColorBN )
    {
        if ( !is_null( $o_MST_ColorBN->getIdColor() ) )
        {
            $this->setIdColor( $o_MST_ColorBN->getIdColor() );
        }
        if ( !is_null( $o_MST_ColorBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_ColorBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_ColorBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_ColorBN->getCodigo() );
        }
        if ( !is_null( $o_MST_ColorBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ColorBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ColorBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ColorBN->getEstado() );
        }
        if ( !is_null( $o_MST_ColorBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ColorBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ColorBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ColorBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ColorBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ColorBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ColorBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ColorBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_ColorBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdColor )
    {
        if( is_null( $i_IdColor ) ){ $i_IdColor = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Color ";
        $s_SQLQuery .= "WHERE IdColor = ".$i_IdColor." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_ColorBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ColorBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ColorBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdColor() ) ) $s_SQLQuery .= "MST_Color.IdColor = ".$this->getIdColor()." AND ";
        if ( !is_null( $this->getIdProveedor() ) ) $s_SQLQuery .= "MST_Color.IdProveedor = ".$this->getIdProveedor()." AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "MST_Color.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Color.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Color.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Color.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Color.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Color.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Color.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Color WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ColorBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Color WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_ColorBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ColorBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ColorBN[] = $o_MST_ColorBN;
            }
        }
        return $a_MST_ColorBN;
    }

    /* Devuelve un objeto MST_ColorBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Color )
    {
        $o_MST_ColorBN = new MST_ColorBN();
        if ( !is_null( $a_MST_Color['IdColor'] ) ) $o_MST_ColorBN->setIdColor( ( integer ) $a_MST_Color['IdColor'] );
        if ( !is_null( $a_MST_Color['IdProveedor'] ) ) $o_MST_ColorBN->setIdProveedor( ( integer ) $a_MST_Color['IdProveedor'] );
        if ( !is_null( $a_MST_Color['Codigo'] ) ) $o_MST_ColorBN->setCodigo( $a_MST_Color['Codigo'] );
        if ( !is_null( $a_MST_Color['Descripcion'] ) ) $o_MST_ColorBN->setDescripcion( $a_MST_Color['Descripcion'] );
        if ( !is_null( $a_MST_Color['Estado'] ) ) $o_MST_ColorBN->setEstado( $a_MST_Color['Estado'] );
        if ( !is_null( $a_MST_Color['UsuarioCreacion'] ) ) $o_MST_ColorBN->setUsuarioCreacion( $a_MST_Color['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Color['FechaCreacion'] ) ) $o_MST_ColorBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Color['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Color['UsuarioModificacion'] ) ) $o_MST_ColorBN->setUsuarioModificacion( $a_MST_Color['UsuarioModificacion'] );
        if ( !is_null( $a_MST_Color['FechaModificacion'] ) ) $o_MST_ColorBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Color['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_ColorBN;
    }
}
?>