<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ClaseSubFamilia.xml */
/* Generado: 2021-11-19 07:55:32 */

/* Busqueda de registros de la tabla MST_ClaseSubFamilia. */
abstract class BaseMST_ClaseSubFamiliaFN extends MST_ClaseSubFamiliaBN
{
    /* Declaracion de constantes */
    const IdSubFamilia = "MST_ClaseSubFamilia.IdSubFamilia";
    const IdLinea = "MST_ClaseSubFamilia.IdLinea";
    const IdFamilia = "MST_ClaseSubFamilia.IdFamilia";
    const Descripcion = "MST_ClaseSubFamilia.Descripcion";
    const UrlAmigable = "MST_ClaseSubFamilia.UrlAmigable";
    const Codigo = "MST_ClaseSubFamilia.Codigo";
    const EsParaAlquiler = "MST_ClaseSubFamilia.EsParaAlquiler";
    const EsParaVenta = "MST_ClaseSubFamilia.EsParaVenta";
    const IdRangoAlquiler = "MST_ClaseSubFamilia.IdRangoAlquiler";
    const IdRangoVenta = "MST_ClaseSubFamilia.IdRangoVenta";
    const TieneDescuentoAdelanto = "MST_ClaseSubFamilia.TieneDescuentoAdelanto";
    const TieneDescuentoContado = "MST_ClaseSubFamilia.TieneDescuentoContado";
    const IdRangoDescuentoContado = "MST_ClaseSubFamilia.IdRangoDescuentoContado";
    const IdRengoDescuentoAdelanto = "MST_ClaseSubFamilia.IdRengoDescuentoAdelanto";
    const Estado = "MST_ClaseSubFamilia.Estado";
    const NombreArchivo = "MST_ClaseSubFamilia.NombreArchivo";
    const UbicacionURL = "MST_ClaseSubFamilia.UbicacionURL";
    const UbicacionFisica = "MST_ClaseSubFamilia.UbicacionFisica";
    const FechaCreacion = "MST_ClaseSubFamilia.FechaCreacion";
    const UsuarioCreacion = "MST_ClaseSubFamilia.UsuarioCreacion";
    const FechaModificacion = "MST_ClaseSubFamilia.FechaModificacion";
    const UsuarioModificacion = "MST_ClaseSubFamilia.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_ClaseSubFamilia.IdSubFamilia AS IdSubFamilia, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.IdLinea AS IdLinea, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.IdFamilia AS IdFamilia, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.UrlAmigable AS UrlAmigable, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.Codigo AS Codigo, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.EsParaAlquiler AS EsParaAlquiler, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.EsParaVenta AS EsParaVenta, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.IdRangoAlquiler AS IdRangoAlquiler, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.IdRangoVenta AS IdRangoVenta, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.TieneDescuentoAdelanto AS TieneDescuentoAdelanto, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.TieneDescuentoContado AS TieneDescuentoContado, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.IdRangoDescuentoContado AS IdRangoDescuentoContado, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.IdRengoDescuentoAdelanto AS IdRengoDescuentoAdelanto, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.Estado AS Estado, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.NombreArchivo AS NombreArchivo, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.UbicacionURL AS UbicacionURL, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.UbicacionFisica AS UbicacionFisica, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_ClaseSubFamilia.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_ClaseSubFamiliaBN */
    public function setByBN( MST_ClaseSubFamiliaBN $o_MST_ClaseSubFamiliaBN )
    {
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getIdSubFamilia() ) )
        {
            $this->setIdSubFamilia( $o_MST_ClaseSubFamiliaBN->getIdSubFamilia() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_MST_ClaseSubFamiliaBN->getIdLinea() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getIdFamilia() ) )
        {
            $this->setIdFamilia( $o_MST_ClaseSubFamiliaBN->getIdFamilia() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ClaseSubFamiliaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getUrlAmigable() ) )
        {
            $this->setUrlAmigable( $o_MST_ClaseSubFamiliaBN->getUrlAmigable() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_ClaseSubFamiliaBN->getCodigo() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getEsParaAlquiler() ) )
        {
            $this->setEsParaAlquiler( $o_MST_ClaseSubFamiliaBN->getEsParaAlquiler() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getEsParaVenta() ) )
        {
            $this->setEsParaVenta( $o_MST_ClaseSubFamiliaBN->getEsParaVenta() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getIdRangoAlquiler() ) )
        {
            $this->setIdRangoAlquiler( $o_MST_ClaseSubFamiliaBN->getIdRangoAlquiler() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getIdRangoVenta() ) )
        {
            $this->setIdRangoVenta( $o_MST_ClaseSubFamiliaBN->getIdRangoVenta() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getTieneDescuentoAdelanto() ) )
        {
            $this->setTieneDescuentoAdelanto( $o_MST_ClaseSubFamiliaBN->getTieneDescuentoAdelanto() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getTieneDescuentoContado() ) )
        {
            $this->setTieneDescuentoContado( $o_MST_ClaseSubFamiliaBN->getTieneDescuentoContado() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getIdRangoDescuentoContado() ) )
        {
            $this->setIdRangoDescuentoContado( $o_MST_ClaseSubFamiliaBN->getIdRangoDescuentoContado() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getIdRengoDescuentoAdelanto() ) )
        {
            $this->setIdRengoDescuentoAdelanto( $o_MST_ClaseSubFamiliaBN->getIdRengoDescuentoAdelanto() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ClaseSubFamiliaBN->getEstado() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getNombreArchivo() ) )
        {
            $this->setNombreArchivo( $o_MST_ClaseSubFamiliaBN->getNombreArchivo() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getUbicacionURL() ) )
        {
            $this->setUbicacionURL( $o_MST_ClaseSubFamiliaBN->getUbicacionURL() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getUbicacionFisica() ) )
        {
            $this->setUbicacionFisica( $o_MST_ClaseSubFamiliaBN->getUbicacionFisica() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ClaseSubFamiliaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ClaseSubFamiliaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ClaseSubFamiliaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_ClaseSubFamiliaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ClaseSubFamiliaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_ClaseSubFamiliaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdSubFamilia )
    {
        if( is_null( $i_IdSubFamilia ) ){ $i_IdSubFamilia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ClaseSubFamilia ";
        $s_SQLQuery .= "WHERE IdSubFamilia = ".$i_IdSubFamilia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_ClaseSubFamiliaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_ClaseSubFamiliaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_ClaseSubFamiliaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdSubFamilia() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.IdSubFamilia = ".$this->getIdSubFamilia()." AND ";
        if ( !is_null( $this->getIdLinea() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.IdLinea = ".$this->getIdLinea()." AND ";
        if ( !is_null( $this->getIdFamilia() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.IdFamilia = ".$this->getIdFamilia()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getUrlAmigable() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.UrlAmigable = '".$this->getUrlAmigable()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getEsParaAlquiler() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.EsParaAlquiler = '".$this->getEsParaAlquiler()."' AND ";
        if ( !is_null( $this->getEsParaVenta() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.EsParaVenta = '".$this->getEsParaVenta()."' AND ";
        if ( !is_null( $this->getIdRangoAlquiler() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.IdRangoAlquiler = ".$this->getIdRangoAlquiler()." AND ";
        if ( !is_null( $this->getIdRangoVenta() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.IdRangoVenta = ".$this->getIdRangoVenta()." AND ";
        if ( !is_null( $this->getTieneDescuentoAdelanto() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.TieneDescuentoAdelanto = '".$this->getTieneDescuentoAdelanto()."' AND ";
        if ( !is_null( $this->getTieneDescuentoContado() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.TieneDescuentoContado = '".$this->getTieneDescuentoContado()."' AND ";
        if ( !is_null( $this->getIdRangoDescuentoContado() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.IdRangoDescuentoContado = ".$this->getIdRangoDescuentoContado()." AND ";
        if ( !is_null( $this->getIdRengoDescuentoAdelanto() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.IdRengoDescuentoAdelanto = ".$this->getIdRengoDescuentoAdelanto()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getNombreArchivo() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.NombreArchivo = '".$this->getNombreArchivo()."' AND ";
        if ( !is_null( $this->getUbicacionURL() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.UbicacionURL = '".$this->getUbicacionURL()."' AND ";
        if ( !is_null( $this->getUbicacionFisica() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.UbicacionFisica = '".$this->getUbicacionFisica()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_ClaseSubFamilia.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_ClaseSubFamilia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_ClaseSubFamiliaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_ClaseSubFamilia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_ClaseSubFamiliaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_ClaseSubFamiliaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_ClaseSubFamiliaBN[] = $o_MST_ClaseSubFamiliaBN;
            }
        }
        return $a_MST_ClaseSubFamiliaBN;
    }

    /* Devuelve un objeto MST_ClaseSubFamiliaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_ClaseSubFamilia )
    {
        $o_MST_ClaseSubFamiliaBN = new MST_ClaseSubFamiliaBN();
        if ( !is_null( $a_MST_ClaseSubFamilia['IdSubFamilia'] ) ) $o_MST_ClaseSubFamiliaBN->setIdSubFamilia( ( integer ) $a_MST_ClaseSubFamilia['IdSubFamilia'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['IdLinea'] ) ) $o_MST_ClaseSubFamiliaBN->setIdLinea( ( integer ) $a_MST_ClaseSubFamilia['IdLinea'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['IdFamilia'] ) ) $o_MST_ClaseSubFamiliaBN->setIdFamilia( ( integer ) $a_MST_ClaseSubFamilia['IdFamilia'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['Descripcion'] ) ) $o_MST_ClaseSubFamiliaBN->setDescripcion( $a_MST_ClaseSubFamilia['Descripcion'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['UrlAmigable'] ) ) $o_MST_ClaseSubFamiliaBN->setUrlAmigable( $a_MST_ClaseSubFamilia['UrlAmigable'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['Codigo'] ) ) $o_MST_ClaseSubFamiliaBN->setCodigo( $a_MST_ClaseSubFamilia['Codigo'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['EsParaAlquiler'] ) ) $o_MST_ClaseSubFamiliaBN->setEsParaAlquiler( $a_MST_ClaseSubFamilia['EsParaAlquiler'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['EsParaVenta'] ) ) $o_MST_ClaseSubFamiliaBN->setEsParaVenta( $a_MST_ClaseSubFamilia['EsParaVenta'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['IdRangoAlquiler'] ) ) $o_MST_ClaseSubFamiliaBN->setIdRangoAlquiler( ( integer ) $a_MST_ClaseSubFamilia['IdRangoAlquiler'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['IdRangoVenta'] ) ) $o_MST_ClaseSubFamiliaBN->setIdRangoVenta( ( integer ) $a_MST_ClaseSubFamilia['IdRangoVenta'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['TieneDescuentoAdelanto'] ) ) $o_MST_ClaseSubFamiliaBN->setTieneDescuentoAdelanto( $a_MST_ClaseSubFamilia['TieneDescuentoAdelanto'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['TieneDescuentoContado'] ) ) $o_MST_ClaseSubFamiliaBN->setTieneDescuentoContado( $a_MST_ClaseSubFamilia['TieneDescuentoContado'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['IdRangoDescuentoContado'] ) ) $o_MST_ClaseSubFamiliaBN->setIdRangoDescuentoContado( ( integer ) $a_MST_ClaseSubFamilia['IdRangoDescuentoContado'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['IdRengoDescuentoAdelanto'] ) ) $o_MST_ClaseSubFamiliaBN->setIdRengoDescuentoAdelanto( ( integer ) $a_MST_ClaseSubFamilia['IdRengoDescuentoAdelanto'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['Estado'] ) ) $o_MST_ClaseSubFamiliaBN->setEstado( $a_MST_ClaseSubFamilia['Estado'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['NombreArchivo'] ) ) $o_MST_ClaseSubFamiliaBN->setNombreArchivo( $a_MST_ClaseSubFamilia['NombreArchivo'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['UbicacionURL'] ) ) $o_MST_ClaseSubFamiliaBN->setUbicacionURL( $a_MST_ClaseSubFamilia['UbicacionURL'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['UbicacionFisica'] ) ) $o_MST_ClaseSubFamiliaBN->setUbicacionFisica( $a_MST_ClaseSubFamilia['UbicacionFisica'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['FechaCreacion'] ) ) $o_MST_ClaseSubFamiliaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_ClaseSubFamilia['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ClaseSubFamilia['UsuarioCreacion'] ) ) $o_MST_ClaseSubFamiliaBN->setUsuarioCreacion( $a_MST_ClaseSubFamilia['UsuarioCreacion'] );
        if ( !is_null( $a_MST_ClaseSubFamilia['FechaModificacion'] ) ) $o_MST_ClaseSubFamiliaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_ClaseSubFamilia['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_ClaseSubFamilia['UsuarioModificacion'] ) ) $o_MST_ClaseSubFamiliaBN->setUsuarioModificacion( $a_MST_ClaseSubFamilia['UsuarioModificacion'] );
        return $o_MST_ClaseSubFamiliaBN;
    }
}
?>