<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_CategoriaTallaRelacion.xml */
/* Generado: 2024-07-07 08:03:57 */

/* Busqueda de registros de la tabla MST_CategoriaTallaRelacion. */
abstract class BaseMST_CategoriaTallaRelacionFN extends MST_CategoriaTallaRelacionBN
{
    /* Declaracion de constantes */
    const IdCatTalla = "MST_CategoriaTallaRelacion.IdCatTalla";
    const IdTalla = "MST_CategoriaTallaRelacion.IdTalla";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_CategoriaTallaRelacion.IdCatTalla AS IdCatTalla, ";
        $s_SQLQuery .= "MST_CategoriaTallaRelacion.IdTalla AS IdTalla ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_CategoriaTallaRelacionBN */
    public function setByBN( MST_CategoriaTallaRelacionBN $o_MST_CategoriaTallaRelacionBN )
    {
        if ( !is_null( $o_MST_CategoriaTallaRelacionBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_CategoriaTallaRelacionBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_CategoriaTallaRelacionBN->getIdTalla() ) )
        {
            $this->setIdTalla( $o_MST_CategoriaTallaRelacionBN->getIdTalla() );
        }
    }

    /**
    * @return MST_CategoriaTallaRelacionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCatTalla, $i_IdTalla )
    {
        if( is_null( $i_IdCatTalla ) ){ $i_IdCatTalla = -1; } 
        if( is_null( $i_IdTalla ) ){ $i_IdTalla = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CategoriaTallaRelacion ";
        $s_SQLQuery .= "WHERE IdCatTalla = ".$i_IdCatTalla." ";
        $s_SQLQuery .= "AND IdTalla = ".$i_IdTalla." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_CategoriaTallaRelacionBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_CategoriaTallaRelacionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_CategoriaTallaRelacionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCatTalla() ) ) $s_SQLQuery .= "MST_CategoriaTallaRelacion.IdCatTalla = ".$this->getIdCatTalla()." AND ";
        if ( !is_null( $this->getIdTalla() ) ) $s_SQLQuery .= "MST_CategoriaTallaRelacion.IdTalla = ".$this->getIdTalla()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_CategoriaTallaRelacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_CategoriaTallaRelacionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CategoriaTallaRelacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_CategoriaTallaRelacionBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_CategoriaTallaRelacionBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_CategoriaTallaRelacionBN[] = $o_MST_CategoriaTallaRelacionBN;
            }
        }
        return $a_MST_CategoriaTallaRelacionBN;
    }

    /* Devuelve un objeto MST_CategoriaTallaRelacionBN desde un objeto propel */
    public function insertObjectBN( $a_MST_CategoriaTallaRelacion )
    {
        $o_MST_CategoriaTallaRelacionBN = new MST_CategoriaTallaRelacionBN();
        if ( !is_null( $a_MST_CategoriaTallaRelacion['IdCatTalla'] ) ) $o_MST_CategoriaTallaRelacionBN->setIdCatTalla( ( integer ) $a_MST_CategoriaTallaRelacion['IdCatTalla'] );
        if ( !is_null( $a_MST_CategoriaTallaRelacion['IdTalla'] ) ) $o_MST_CategoriaTallaRelacionBN->setIdTalla( ( integer ) $a_MST_CategoriaTallaRelacion['IdTalla'] );
        return $o_MST_CategoriaTallaRelacionBN;
    }
}
?>