<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_CategoriaTalla.xml */
/* Generado: 2024-07-07 08:03:42 */

/* Busqueda de registros de la tabla MST_CategoriaTalla. */
abstract class BaseMST_CategoriaTallaFN extends MST_CategoriaTallaBN
{
    /* Declaracion de constantes */
    const IdCatTalla = "MST_CategoriaTalla.IdCatTalla";
    const IdProveedor = "MST_CategoriaTalla.IdProveedor";
    const Descripcion = "MST_CategoriaTalla.Descripcion";
    const Estado = "MST_CategoriaTalla.Estado";
    const UsuarioCreacion = "MST_CategoriaTalla.UsuarioCreacion";
    const FechaCreacion = "MST_CategoriaTalla.FechaCreacion";
    const UsuarioModificacion = "MST_CategoriaTalla.UsuarioModificacion";
    const FechaModificacion = "MST_CategoriaTalla.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_CategoriaTalla.IdCatTalla AS IdCatTalla, ";
        $s_SQLQuery .= "MST_CategoriaTalla.IdProveedor AS IdProveedor, ";
        $s_SQLQuery .= "MST_CategoriaTalla.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_CategoriaTalla.Estado AS Estado, ";
        $s_SQLQuery .= "MST_CategoriaTalla.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_CategoriaTalla.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_CategoriaTalla.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "MST_CategoriaTalla.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_CategoriaTallaBN */
    public function setByBN( MST_CategoriaTallaBN $o_MST_CategoriaTallaBN )
    {
        if ( !is_null( $o_MST_CategoriaTallaBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_CategoriaTallaBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_CategoriaTallaBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_CategoriaTallaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_CategoriaTallaBN->getEstado() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_CategoriaTallaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_CategoriaTallaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_CategoriaTallaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_CategoriaTallaBN->getFechaModificacion() );
        }
    }

    /**
    * @return MST_CategoriaTallaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCatTalla )
    {
        if( is_null( $i_IdCatTalla ) ){ $i_IdCatTalla = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CategoriaTalla ";
        $s_SQLQuery .= "WHERE IdCatTalla = ".$i_IdCatTalla." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_CategoriaTallaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_CategoriaTallaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_CategoriaTallaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCatTalla() ) ) $s_SQLQuery .= "MST_CategoriaTalla.IdCatTalla = ".$this->getIdCatTalla()." AND ";
        if ( !is_null( $this->getIdProveedor() ) ) $s_SQLQuery .= "MST_CategoriaTalla.IdProveedor = ".$this->getIdProveedor()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_CategoriaTalla.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_CategoriaTalla.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_CategoriaTalla.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_CategoriaTalla.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_CategoriaTalla.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_CategoriaTalla.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_CategoriaTalla WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_CategoriaTallaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CategoriaTalla WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_CategoriaTallaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_CategoriaTallaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_CategoriaTallaBN[] = $o_MST_CategoriaTallaBN;
            }
        }
        return $a_MST_CategoriaTallaBN;
    }

    /* Devuelve un objeto MST_CategoriaTallaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_CategoriaTalla )
    {
        $o_MST_CategoriaTallaBN = new MST_CategoriaTallaBN();
        if ( !is_null( $a_MST_CategoriaTalla['IdCatTalla'] ) ) $o_MST_CategoriaTallaBN->setIdCatTalla( ( integer ) $a_MST_CategoriaTalla['IdCatTalla'] );
        if ( !is_null( $a_MST_CategoriaTalla['IdProveedor'] ) ) $o_MST_CategoriaTallaBN->setIdProveedor( ( integer ) $a_MST_CategoriaTalla['IdProveedor'] );
        if ( !is_null( $a_MST_CategoriaTalla['Descripcion'] ) ) $o_MST_CategoriaTallaBN->setDescripcion( $a_MST_CategoriaTalla['Descripcion'] );
        if ( !is_null( $a_MST_CategoriaTalla['Estado'] ) ) $o_MST_CategoriaTallaBN->setEstado( $a_MST_CategoriaTalla['Estado'] );
        if ( !is_null( $a_MST_CategoriaTalla['UsuarioCreacion'] ) ) $o_MST_CategoriaTallaBN->setUsuarioCreacion( $a_MST_CategoriaTalla['UsuarioCreacion'] );
        if ( !is_null( $a_MST_CategoriaTalla['FechaCreacion'] ) ) $o_MST_CategoriaTallaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_CategoriaTalla['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_CategoriaTalla['UsuarioModificacion'] ) ) $o_MST_CategoriaTallaBN->setUsuarioModificacion( $a_MST_CategoriaTalla['UsuarioModificacion'] );
        if ( !is_null( $a_MST_CategoriaTalla['FechaModificacion'] ) ) $o_MST_CategoriaTallaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_CategoriaTalla['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_MST_CategoriaTallaBN;
    }
}
?>